# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSchedulingPolicyResult',
    'AwaitableGetSchedulingPolicyResult',
    'get_scheduling_policy',
    'get_scheduling_policy_output',
]

@pulumi.output_type
class GetSchedulingPolicyResult:
    """
    A collection of values returned by getSchedulingPolicy.
    """
    def __init__(__self__, cadence=None, cadence_start_months=None, compartment_id=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, lifecycle_details=None, scheduling_policy_id=None, state=None, time_created=None, time_next_window_starts=None, time_updated=None):
        if cadence and not isinstance(cadence, str):
            raise TypeError("Expected argument 'cadence' to be a str")
        pulumi.set(__self__, "cadence", cadence)
        if cadence_start_months and not isinstance(cadence_start_months, list):
            raise TypeError("Expected argument 'cadence_start_months' to be a list")
        pulumi.set(__self__, "cadence_start_months", cadence_start_months)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if scheduling_policy_id and not isinstance(scheduling_policy_id, str):
            raise TypeError("Expected argument 'scheduling_policy_id' to be a str")
        pulumi.set(__self__, "scheduling_policy_id", scheduling_policy_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_next_window_starts and not isinstance(time_next_window_starts, str):
            raise TypeError("Expected argument 'time_next_window_starts' to be a str")
        pulumi.set(__self__, "time_next_window_starts", time_next_window_starts)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter
    def cadence(self) -> _builtins.str:
        """
        The cadence period.
        """
        return pulumi.get(self, "cadence")

    @_builtins.property
    @pulumi.getter(name="cadenceStartMonths")
    def cadence_start_months(self) -> Sequence['outputs.GetSchedulingPolicyCadenceStartMonthResult']:
        """
        Start of the month to be followed during the cadence period.
        """
        return pulumi.get(self, "cadence_start_months")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The user-friendly name for the Scheduling Policy. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Scheduling Policy.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="schedulingPolicyId")
    def scheduling_policy_id(self) -> _builtins.str:
        return pulumi.get(self, "scheduling_policy_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the Scheduling Policy. Valid states are CREATING, NEEDS_ATTENTION, ACTIVE, UPDATING, FAILED, DELETING and DELETED.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the Scheduling Policy was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeNextWindowStarts")
    def time_next_window_starts(self) -> _builtins.str:
        """
        The date and time of the next scheduling window associated with the schedulingPolicy is planned to start.
        """
        return pulumi.get(self, "time_next_window_starts")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The last date and time that the Scheduling Policy was updated.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetSchedulingPolicyResult(GetSchedulingPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSchedulingPolicyResult(
            cadence=self.cadence,
            cadence_start_months=self.cadence_start_months,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            scheduling_policy_id=self.scheduling_policy_id,
            state=self.state,
            time_created=self.time_created,
            time_next_window_starts=self.time_next_window_starts,
            time_updated=self.time_updated)


def get_scheduling_policy(scheduling_policy_id: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSchedulingPolicyResult:
    """
    This data source provides details about a specific Scheduling Policy resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified Scheduling Policy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_scheduling_policy = oci.Database.get_scheduling_policy(scheduling_policy_id=test_scheduling_policy_oci_database_scheduling_policy["id"])
    ```


    :param _builtins.str scheduling_policy_id: The Scheduling Policy [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['schedulingPolicyId'] = scheduling_policy_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getSchedulingPolicy:getSchedulingPolicy', __args__, opts=opts, typ=GetSchedulingPolicyResult).value

    return AwaitableGetSchedulingPolicyResult(
        cadence=pulumi.get(__ret__, 'cadence'),
        cadence_start_months=pulumi.get(__ret__, 'cadence_start_months'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        scheduling_policy_id=pulumi.get(__ret__, 'scheduling_policy_id'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_next_window_starts=pulumi.get(__ret__, 'time_next_window_starts'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_scheduling_policy_output(scheduling_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSchedulingPolicyResult]:
    """
    This data source provides details about a specific Scheduling Policy resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified Scheduling Policy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_scheduling_policy = oci.Database.get_scheduling_policy(scheduling_policy_id=test_scheduling_policy_oci_database_scheduling_policy["id"])
    ```


    :param _builtins.str scheduling_policy_id: The Scheduling Policy [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['schedulingPolicyId'] = scheduling_policy_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getSchedulingPolicy:getSchedulingPolicy', __args__, opts=opts, typ=GetSchedulingPolicyResult)
    return __ret__.apply(lambda __response__: GetSchedulingPolicyResult(
        cadence=pulumi.get(__response__, 'cadence'),
        cadence_start_months=pulumi.get(__response__, 'cadence_start_months'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        scheduling_policy_id=pulumi.get(__response__, 'scheduling_policy_id'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_next_window_starts=pulumi.get(__response__, 'time_next_window_starts'),
        time_updated=pulumi.get(__response__, 'time_updated')))
