# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VmClusterArgs', 'VmCluster']

@pulumi.input_type
class VmClusterArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 cpu_core_count: pulumi.Input[_builtins.int],
                 display_name: pulumi.Input[_builtins.str],
                 exadata_infrastructure_id: pulumi.Input[_builtins.str],
                 gi_version: pulumi.Input[_builtins.str],
                 ssh_public_keys: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 vm_cluster_network_id: pulumi.Input[_builtins.str],
                 cloud_automation_update_details: Optional[pulumi.Input['VmClusterCloudAutomationUpdateDetailsArgs']] = None,
                 data_collection_options: Optional[pulumi.Input['VmClusterDataCollectionOptionsArgs']] = None,
                 data_storage_size_in_gb: Optional[pulumi.Input[_builtins.float]] = None,
                 data_storage_size_in_tbs: Optional[pulumi.Input[_builtins.float]] = None,
                 db_node_storage_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 db_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 exascale_db_storage_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 file_system_configuration_details: Optional[pulumi.Input[Sequence[pulumi.Input['VmClusterFileSystemConfigurationDetailArgs']]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_local_backup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_sparse_diskgroup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 license_model: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 ocpu_count: Optional[pulumi.Input[_builtins.float]] = None,
                 system_version: Optional[pulumi.Input[_builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_cluster_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a VmCluster resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[_builtins.str] display_name: The user-friendly name for the VM cluster. The name does not need to be unique.
        :param pulumi.Input[_builtins.str] exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        :param pulumi.Input[_builtins.str] gi_version: The Oracle Grid Infrastructure software version for the VM cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ssh_public_keys: (Updatable) The public key portion of one or more key pairs used for SSH access to the VM cluster.
        :param pulumi.Input[_builtins.str] vm_cluster_network_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster network.
        :param pulumi.Input['VmClusterCloudAutomationUpdateDetailsArgs'] cloud_automation_update_details: (Updatable) Specifies the properties necessary for cloud automation updates. This includes modifying the apply update time preference, enabling or disabling early adoption, and enabling, modifying, or disabling the update freeze period.
        :param pulumi.Input['VmClusterDataCollectionOptionsArgs'] data_collection_options: (Updatable) Indicates user preferences for the various diagnostic collection options for the VM cluster/Cloud VM cluster/VMBM DBCS.
        :param pulumi.Input[_builtins.float] data_storage_size_in_gb: (Updatable) The data disk group size to be allocated in GBs.
        :param pulumi.Input[_builtins.float] data_storage_size_in_tbs: (Updatable) The data disk group size to be allocated in TBs.
        :param pulumi.Input[_builtins.int] db_node_storage_size_in_gbs: (Updatable) The local node storage to be allocated in GBs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] db_servers: The list of Db server.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[_builtins.str] exascale_db_storage_vault_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Database Storage Vault.
        :param pulumi.Input[Sequence[pulumi.Input['VmClusterFileSystemConfigurationDetailArgs']]] file_system_configuration_details: (Updatable) Details of the file system configuration of the VM cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_local_backup_enabled: If true, database backup on local Exadata storage is configured for the VM cluster. If false, database backup on local Exadata storage is not available in the VM cluster.
        :param pulumi.Input[_builtins.bool] is_sparse_diskgroup_enabled: If true, the sparse disk group is configured for the VM cluster. If false, the sparse disk group is not created.
        :param pulumi.Input[_builtins.str] license_model: (Updatable) The Oracle license model that applies to the VM cluster. The default is BRING_YOUR_OWN_LICENSE.
        :param pulumi.Input[_builtins.int] memory_size_in_gbs: (Updatable) The memory to be allocated in GBs.
        :param pulumi.Input[_builtins.str] system_version: Operating system version of the image.
        :param pulumi.Input[_builtins.str] time_zone: The time zone to use for the VM cluster. For details, see [DB System Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        :param pulumi.Input[_builtins.str] vm_cluster_type: The vmcluster type for the VM cluster/Cloud VM cluster.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "exadata_infrastructure_id", exadata_infrastructure_id)
        pulumi.set(__self__, "gi_version", gi_version)
        pulumi.set(__self__, "ssh_public_keys", ssh_public_keys)
        pulumi.set(__self__, "vm_cluster_network_id", vm_cluster_network_id)
        if cloud_automation_update_details is not None:
            pulumi.set(__self__, "cloud_automation_update_details", cloud_automation_update_details)
        if data_collection_options is not None:
            pulumi.set(__self__, "data_collection_options", data_collection_options)
        if data_storage_size_in_gb is not None:
            pulumi.set(__self__, "data_storage_size_in_gb", data_storage_size_in_gb)
        if data_storage_size_in_tbs is not None:
            pulumi.set(__self__, "data_storage_size_in_tbs", data_storage_size_in_tbs)
        if db_node_storage_size_in_gbs is not None:
            pulumi.set(__self__, "db_node_storage_size_in_gbs", db_node_storage_size_in_gbs)
        if db_servers is not None:
            pulumi.set(__self__, "db_servers", db_servers)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if exascale_db_storage_vault_id is not None:
            pulumi.set(__self__, "exascale_db_storage_vault_id", exascale_db_storage_vault_id)
        if file_system_configuration_details is not None:
            pulumi.set(__self__, "file_system_configuration_details", file_system_configuration_details)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_local_backup_enabled is not None:
            pulumi.set(__self__, "is_local_backup_enabled", is_local_backup_enabled)
        if is_sparse_diskgroup_enabled is not None:
            pulumi.set(__self__, "is_sparse_diskgroup_enabled", is_sparse_diskgroup_enabled)
        if license_model is not None:
            pulumi.set(__self__, "license_model", license_model)
        if memory_size_in_gbs is not None:
            pulumi.set(__self__, "memory_size_in_gbs", memory_size_in_gbs)
        if ocpu_count is not None:
            pulumi.set(__self__, "ocpu_count", ocpu_count)
        if system_version is not None:
            pulumi.set(__self__, "system_version", system_version)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if vm_cluster_type is not None:
            pulumi.set(__self__, "vm_cluster_type", vm_cluster_type)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> pulumi.Input[_builtins.int]:
        return pulumi.get(self, "cpu_core_count")

    @cpu_core_count.setter
    def cpu_core_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "cpu_core_count", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The user-friendly name for the VM cluster. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="exadataInfrastructureId")
    def exadata_infrastructure_id(self) -> pulumi.Input[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        """
        return pulumi.get(self, "exadata_infrastructure_id")

    @exadata_infrastructure_id.setter
    def exadata_infrastructure_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "exadata_infrastructure_id", value)

    @_builtins.property
    @pulumi.getter(name="giVersion")
    def gi_version(self) -> pulumi.Input[_builtins.str]:
        """
        The Oracle Grid Infrastructure software version for the VM cluster.
        """
        return pulumi.get(self, "gi_version")

    @gi_version.setter
    def gi_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "gi_version", value)

    @_builtins.property
    @pulumi.getter(name="sshPublicKeys")
    def ssh_public_keys(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        (Updatable) The public key portion of one or more key pairs used for SSH access to the VM cluster.
        """
        return pulumi.get(self, "ssh_public_keys")

    @ssh_public_keys.setter
    def ssh_public_keys(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "ssh_public_keys", value)

    @_builtins.property
    @pulumi.getter(name="vmClusterNetworkId")
    def vm_cluster_network_id(self) -> pulumi.Input[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster network.
        """
        return pulumi.get(self, "vm_cluster_network_id")

    @vm_cluster_network_id.setter
    def vm_cluster_network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vm_cluster_network_id", value)

    @_builtins.property
    @pulumi.getter(name="cloudAutomationUpdateDetails")
    def cloud_automation_update_details(self) -> Optional[pulumi.Input['VmClusterCloudAutomationUpdateDetailsArgs']]:
        """
        (Updatable) Specifies the properties necessary for cloud automation updates. This includes modifying the apply update time preference, enabling or disabling early adoption, and enabling, modifying, or disabling the update freeze period.
        """
        return pulumi.get(self, "cloud_automation_update_details")

    @cloud_automation_update_details.setter
    def cloud_automation_update_details(self, value: Optional[pulumi.Input['VmClusterCloudAutomationUpdateDetailsArgs']]):
        pulumi.set(self, "cloud_automation_update_details", value)

    @_builtins.property
    @pulumi.getter(name="dataCollectionOptions")
    def data_collection_options(self) -> Optional[pulumi.Input['VmClusterDataCollectionOptionsArgs']]:
        """
        (Updatable) Indicates user preferences for the various diagnostic collection options for the VM cluster/Cloud VM cluster/VMBM DBCS.
        """
        return pulumi.get(self, "data_collection_options")

    @data_collection_options.setter
    def data_collection_options(self, value: Optional[pulumi.Input['VmClusterDataCollectionOptionsArgs']]):
        pulumi.set(self, "data_collection_options", value)

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInGb")
    def data_storage_size_in_gb(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        (Updatable) The data disk group size to be allocated in GBs.
        """
        return pulumi.get(self, "data_storage_size_in_gb")

    @data_storage_size_in_gb.setter
    def data_storage_size_in_gb(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "data_storage_size_in_gb", value)

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        (Updatable) The data disk group size to be allocated in TBs.
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @data_storage_size_in_tbs.setter
    def data_storage_size_in_tbs(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "data_storage_size_in_tbs", value)

    @_builtins.property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The local node storage to be allocated in GBs.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @db_node_storage_size_in_gbs.setter
    def db_node_storage_size_in_gbs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "db_node_storage_size_in_gbs", value)

    @_builtins.property
    @pulumi.getter(name="dbServers")
    def db_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of Db server.
        """
        return pulumi.get(self, "db_servers")

    @db_servers.setter
    def db_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "db_servers", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="exascaleDbStorageVaultId")
    def exascale_db_storage_vault_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Database Storage Vault.
        """
        return pulumi.get(self, "exascale_db_storage_vault_id")

    @exascale_db_storage_vault_id.setter
    def exascale_db_storage_vault_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "exascale_db_storage_vault_id", value)

    @_builtins.property
    @pulumi.getter(name="fileSystemConfigurationDetails")
    def file_system_configuration_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VmClusterFileSystemConfigurationDetailArgs']]]]:
        """
        (Updatable) Details of the file system configuration of the VM cluster.
        """
        return pulumi.get(self, "file_system_configuration_details")

    @file_system_configuration_details.setter
    def file_system_configuration_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VmClusterFileSystemConfigurationDetailArgs']]]]):
        pulumi.set(self, "file_system_configuration_details", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="isLocalBackupEnabled")
    def is_local_backup_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, database backup on local Exadata storage is configured for the VM cluster. If false, database backup on local Exadata storage is not available in the VM cluster.
        """
        return pulumi.get(self, "is_local_backup_enabled")

    @is_local_backup_enabled.setter
    def is_local_backup_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_local_backup_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isSparseDiskgroupEnabled")
    def is_sparse_diskgroup_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the sparse disk group is configured for the VM cluster. If false, the sparse disk group is not created.
        """
        return pulumi.get(self, "is_sparse_diskgroup_enabled")

    @is_sparse_diskgroup_enabled.setter
    def is_sparse_diskgroup_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_sparse_diskgroup_enabled", value)

    @_builtins.property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The Oracle license model that applies to the VM cluster. The default is BRING_YOUR_OWN_LICENSE.
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_model", value)

    @_builtins.property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The memory to be allocated in GBs.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @memory_size_in_gbs.setter
    def memory_size_in_gbs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory_size_in_gbs", value)

    @_builtins.property
    @pulumi.getter(name="ocpuCount")
    def ocpu_count(self) -> Optional[pulumi.Input[_builtins.float]]:
        return pulumi.get(self, "ocpu_count")

    @ocpu_count.setter
    def ocpu_count(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "ocpu_count", value)

    @_builtins.property
    @pulumi.getter(name="systemVersion")
    def system_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Operating system version of the image.
        """
        return pulumi.get(self, "system_version")

    @system_version.setter
    def system_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_version", value)

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time zone to use for the VM cluster. For details, see [DB System Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone", value)

    @_builtins.property
    @pulumi.getter(name="vmClusterType")
    def vm_cluster_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The vmcluster type for the VM cluster/Cloud VM cluster.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vm_cluster_type")

    @vm_cluster_type.setter
    def vm_cluster_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_cluster_type", value)


@pulumi.input_type
class _VmClusterState:
    def __init__(__self__, *,
                 availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_automation_update_details: Optional[pulumi.Input['VmClusterCloudAutomationUpdateDetailsArgs']] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_model: Optional[pulumi.Input[_builtins.str]] = None,
                 cpu_core_count: Optional[pulumi.Input[_builtins.int]] = None,
                 cpus_enabled: Optional[pulumi.Input[_builtins.int]] = None,
                 data_collection_options: Optional[pulumi.Input['VmClusterDataCollectionOptionsArgs']] = None,
                 data_storage_size_in_gb: Optional[pulumi.Input[_builtins.float]] = None,
                 data_storage_size_in_tbs: Optional[pulumi.Input[_builtins.float]] = None,
                 db_node_storage_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 db_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 exadata_infrastructure_id: Optional[pulumi.Input[_builtins.str]] = None,
                 exascale_db_storage_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 file_system_configuration_details: Optional[pulumi.Input[Sequence[pulumi.Input['VmClusterFileSystemConfigurationDetailArgs']]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 gi_version: Optional[pulumi.Input[_builtins.str]] = None,
                 is_local_backup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_sparse_diskgroup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 last_patch_history_entry_id: Optional[pulumi.Input[_builtins.str]] = None,
                 license_model: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 ocpu_count: Optional[pulumi.Input[_builtins.float]] = None,
                 ocpus_enabled: Optional[pulumi.Input[_builtins.float]] = None,
                 shape: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_public_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_management_type: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 system_version: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_cluster_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_cluster_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VmCluster resources.
        :param pulumi.Input[_builtins.str] availability_domain: The name of the availability domain that the VM cluster is located in.
        :param pulumi.Input['VmClusterCloudAutomationUpdateDetailsArgs'] cloud_automation_update_details: (Updatable) Specifies the properties necessary for cloud automation updates. This includes modifying the apply update time preference, enabling or disabling early adoption, and enabling, modifying, or disabling the update freeze period.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[_builtins.str] compute_model: The compute model of the Autonomous Database. This is required if using the `computeCount` parameter. If using `cpuCoreCount` then it is an error to specify `computeModel` to a non-null value. ECPU compute model is the recommended model and OCPU compute model is legacy.
        :param pulumi.Input[_builtins.int] cpus_enabled: The number of enabled CPU cores.
        :param pulumi.Input['VmClusterDataCollectionOptionsArgs'] data_collection_options: (Updatable) Indicates user preferences for the various diagnostic collection options for the VM cluster/Cloud VM cluster/VMBM DBCS.
        :param pulumi.Input[_builtins.float] data_storage_size_in_gb: (Updatable) The data disk group size to be allocated in GBs.
        :param pulumi.Input[_builtins.float] data_storage_size_in_tbs: (Updatable) The data disk group size to be allocated in TBs.
        :param pulumi.Input[_builtins.int] db_node_storage_size_in_gbs: (Updatable) The local node storage to be allocated in GBs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] db_servers: The list of Db server.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[_builtins.str] display_name: The user-friendly name for the VM cluster. The name does not need to be unique.
        :param pulumi.Input[_builtins.str] exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        :param pulumi.Input[_builtins.str] exascale_db_storage_vault_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Database Storage Vault.
        :param pulumi.Input[Sequence[pulumi.Input['VmClusterFileSystemConfigurationDetailArgs']]] file_system_configuration_details: (Updatable) Details of the file system configuration of the VM cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] gi_version: The Oracle Grid Infrastructure software version for the VM cluster.
        :param pulumi.Input[_builtins.bool] is_local_backup_enabled: If true, database backup on local Exadata storage is configured for the VM cluster. If false, database backup on local Exadata storage is not available in the VM cluster.
        :param pulumi.Input[_builtins.bool] is_sparse_diskgroup_enabled: If true, the sparse disk group is configured for the VM cluster. If false, the sparse disk group is not created.
        :param pulumi.Input[_builtins.str] last_patch_history_entry_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last patch history. This value is updated as soon as a patch operation starts.
        :param pulumi.Input[_builtins.str] license_model: (Updatable) The Oracle license model that applies to the VM cluster. The default is BRING_YOUR_OWN_LICENSE.
        :param pulumi.Input[_builtins.str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[_builtins.int] memory_size_in_gbs: (Updatable) The memory to be allocated in GBs.
        :param pulumi.Input[_builtins.str] shape: The shape of the Exadata infrastructure. The shape determines the amount of CPU, storage, and memory resources allocated to the instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ssh_public_keys: (Updatable) The public key portion of one or more key pairs used for SSH access to the VM cluster.
        :param pulumi.Input[_builtins.str] state: The current state of the VM cluster.
        :param pulumi.Input[_builtins.str] storage_management_type: Specifies whether the type of storage management for the VM cluster is ASM or Exascale.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[_builtins.str] system_version: Operating system version of the image.
        :param pulumi.Input[_builtins.str] time_created: The date and time that the VM cluster was created.
        :param pulumi.Input[_builtins.str] time_zone: The time zone to use for the VM cluster. For details, see [DB System Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        :param pulumi.Input[_builtins.str] vm_cluster_network_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster network.
        :param pulumi.Input[_builtins.str] vm_cluster_type: The vmcluster type for the VM cluster/Cloud VM cluster.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if cloud_automation_update_details is not None:
            pulumi.set(__self__, "cloud_automation_update_details", cloud_automation_update_details)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if compute_model is not None:
            pulumi.set(__self__, "compute_model", compute_model)
        if cpu_core_count is not None:
            pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        if cpus_enabled is not None:
            pulumi.set(__self__, "cpus_enabled", cpus_enabled)
        if data_collection_options is not None:
            pulumi.set(__self__, "data_collection_options", data_collection_options)
        if data_storage_size_in_gb is not None:
            pulumi.set(__self__, "data_storage_size_in_gb", data_storage_size_in_gb)
        if data_storage_size_in_tbs is not None:
            pulumi.set(__self__, "data_storage_size_in_tbs", data_storage_size_in_tbs)
        if db_node_storage_size_in_gbs is not None:
            pulumi.set(__self__, "db_node_storage_size_in_gbs", db_node_storage_size_in_gbs)
        if db_servers is not None:
            pulumi.set(__self__, "db_servers", db_servers)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if exadata_infrastructure_id is not None:
            pulumi.set(__self__, "exadata_infrastructure_id", exadata_infrastructure_id)
        if exascale_db_storage_vault_id is not None:
            pulumi.set(__self__, "exascale_db_storage_vault_id", exascale_db_storage_vault_id)
        if file_system_configuration_details is not None:
            pulumi.set(__self__, "file_system_configuration_details", file_system_configuration_details)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if gi_version is not None:
            pulumi.set(__self__, "gi_version", gi_version)
        if is_local_backup_enabled is not None:
            pulumi.set(__self__, "is_local_backup_enabled", is_local_backup_enabled)
        if is_sparse_diskgroup_enabled is not None:
            pulumi.set(__self__, "is_sparse_diskgroup_enabled", is_sparse_diskgroup_enabled)
        if last_patch_history_entry_id is not None:
            pulumi.set(__self__, "last_patch_history_entry_id", last_patch_history_entry_id)
        if license_model is not None:
            pulumi.set(__self__, "license_model", license_model)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if memory_size_in_gbs is not None:
            pulumi.set(__self__, "memory_size_in_gbs", memory_size_in_gbs)
        if ocpu_count is not None:
            pulumi.set(__self__, "ocpu_count", ocpu_count)
        if ocpus_enabled is not None:
            pulumi.set(__self__, "ocpus_enabled", ocpus_enabled)
        if shape is not None:
            pulumi.set(__self__, "shape", shape)
        if ssh_public_keys is not None:
            pulumi.set(__self__, "ssh_public_keys", ssh_public_keys)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if storage_management_type is not None:
            pulumi.set(__self__, "storage_management_type", storage_management_type)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if system_version is not None:
            pulumi.set(__self__, "system_version", system_version)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if vm_cluster_network_id is not None:
            pulumi.set(__self__, "vm_cluster_network_id", vm_cluster_network_id)
        if vm_cluster_type is not None:
            pulumi.set(__self__, "vm_cluster_type", vm_cluster_type)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the availability domain that the VM cluster is located in.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_domain", value)

    @_builtins.property
    @pulumi.getter(name="cloudAutomationUpdateDetails")
    def cloud_automation_update_details(self) -> Optional[pulumi.Input['VmClusterCloudAutomationUpdateDetailsArgs']]:
        """
        (Updatable) Specifies the properties necessary for cloud automation updates. This includes modifying the apply update time preference, enabling or disabling early adoption, and enabling, modifying, or disabling the update freeze period.
        """
        return pulumi.get(self, "cloud_automation_update_details")

    @cloud_automation_update_details.setter
    def cloud_automation_update_details(self, value: Optional[pulumi.Input['VmClusterCloudAutomationUpdateDetailsArgs']]):
        pulumi.set(self, "cloud_automation_update_details", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="computeModel")
    def compute_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The compute model of the Autonomous Database. This is required if using the `computeCount` parameter. If using `cpuCoreCount` then it is an error to specify `computeModel` to a non-null value. ECPU compute model is the recommended model and OCPU compute model is legacy.
        """
        return pulumi.get(self, "compute_model")

    @compute_model.setter
    def compute_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compute_model", value)

    @_builtins.property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "cpu_core_count")

    @cpu_core_count.setter
    def cpu_core_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpu_core_count", value)

    @_builtins.property
    @pulumi.getter(name="cpusEnabled")
    def cpus_enabled(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of enabled CPU cores.
        """
        return pulumi.get(self, "cpus_enabled")

    @cpus_enabled.setter
    def cpus_enabled(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpus_enabled", value)

    @_builtins.property
    @pulumi.getter(name="dataCollectionOptions")
    def data_collection_options(self) -> Optional[pulumi.Input['VmClusterDataCollectionOptionsArgs']]:
        """
        (Updatable) Indicates user preferences for the various diagnostic collection options for the VM cluster/Cloud VM cluster/VMBM DBCS.
        """
        return pulumi.get(self, "data_collection_options")

    @data_collection_options.setter
    def data_collection_options(self, value: Optional[pulumi.Input['VmClusterDataCollectionOptionsArgs']]):
        pulumi.set(self, "data_collection_options", value)

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInGb")
    def data_storage_size_in_gb(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        (Updatable) The data disk group size to be allocated in GBs.
        """
        return pulumi.get(self, "data_storage_size_in_gb")

    @data_storage_size_in_gb.setter
    def data_storage_size_in_gb(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "data_storage_size_in_gb", value)

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        (Updatable) The data disk group size to be allocated in TBs.
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @data_storage_size_in_tbs.setter
    def data_storage_size_in_tbs(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "data_storage_size_in_tbs", value)

    @_builtins.property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The local node storage to be allocated in GBs.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @db_node_storage_size_in_gbs.setter
    def db_node_storage_size_in_gbs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "db_node_storage_size_in_gbs", value)

    @_builtins.property
    @pulumi.getter(name="dbServers")
    def db_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of Db server.
        """
        return pulumi.get(self, "db_servers")

    @db_servers.setter
    def db_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "db_servers", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user-friendly name for the VM cluster. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="exadataInfrastructureId")
    def exadata_infrastructure_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        """
        return pulumi.get(self, "exadata_infrastructure_id")

    @exadata_infrastructure_id.setter
    def exadata_infrastructure_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "exadata_infrastructure_id", value)

    @_builtins.property
    @pulumi.getter(name="exascaleDbStorageVaultId")
    def exascale_db_storage_vault_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Database Storage Vault.
        """
        return pulumi.get(self, "exascale_db_storage_vault_id")

    @exascale_db_storage_vault_id.setter
    def exascale_db_storage_vault_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "exascale_db_storage_vault_id", value)

    @_builtins.property
    @pulumi.getter(name="fileSystemConfigurationDetails")
    def file_system_configuration_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VmClusterFileSystemConfigurationDetailArgs']]]]:
        """
        (Updatable) Details of the file system configuration of the VM cluster.
        """
        return pulumi.get(self, "file_system_configuration_details")

    @file_system_configuration_details.setter
    def file_system_configuration_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VmClusterFileSystemConfigurationDetailArgs']]]]):
        pulumi.set(self, "file_system_configuration_details", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="giVersion")
    def gi_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Oracle Grid Infrastructure software version for the VM cluster.
        """
        return pulumi.get(self, "gi_version")

    @gi_version.setter
    def gi_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gi_version", value)

    @_builtins.property
    @pulumi.getter(name="isLocalBackupEnabled")
    def is_local_backup_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, database backup on local Exadata storage is configured for the VM cluster. If false, database backup on local Exadata storage is not available in the VM cluster.
        """
        return pulumi.get(self, "is_local_backup_enabled")

    @is_local_backup_enabled.setter
    def is_local_backup_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_local_backup_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isSparseDiskgroupEnabled")
    def is_sparse_diskgroup_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the sparse disk group is configured for the VM cluster. If false, the sparse disk group is not created.
        """
        return pulumi.get(self, "is_sparse_diskgroup_enabled")

    @is_sparse_diskgroup_enabled.setter
    def is_sparse_diskgroup_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_sparse_diskgroup_enabled", value)

    @_builtins.property
    @pulumi.getter(name="lastPatchHistoryEntryId")
    def last_patch_history_entry_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last patch history. This value is updated as soon as a patch operation starts.
        """
        return pulumi.get(self, "last_patch_history_entry_id")

    @last_patch_history_entry_id.setter
    def last_patch_history_entry_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_patch_history_entry_id", value)

    @_builtins.property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The Oracle license model that applies to the VM cluster. The default is BRING_YOUR_OWN_LICENSE.
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_model", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The memory to be allocated in GBs.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @memory_size_in_gbs.setter
    def memory_size_in_gbs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory_size_in_gbs", value)

    @_builtins.property
    @pulumi.getter(name="ocpuCount")
    def ocpu_count(self) -> Optional[pulumi.Input[_builtins.float]]:
        return pulumi.get(self, "ocpu_count")

    @ocpu_count.setter
    def ocpu_count(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "ocpu_count", value)

    @_builtins.property
    @pulumi.getter(name="ocpusEnabled")
    def ocpus_enabled(self) -> Optional[pulumi.Input[_builtins.float]]:
        return pulumi.get(self, "ocpus_enabled")

    @ocpus_enabled.setter
    def ocpus_enabled(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "ocpus_enabled", value)

    @_builtins.property
    @pulumi.getter
    def shape(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The shape of the Exadata infrastructure. The shape determines the amount of CPU, storage, and memory resources allocated to the instance.
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shape", value)

    @_builtins.property
    @pulumi.getter(name="sshPublicKeys")
    def ssh_public_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) The public key portion of one or more key pairs used for SSH access to the VM cluster.
        """
        return pulumi.get(self, "ssh_public_keys")

    @ssh_public_keys.setter
    def ssh_public_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ssh_public_keys", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the VM cluster.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="storageManagementType")
    def storage_management_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether the type of storage management for the VM cluster is ASM or Exascale.
        """
        return pulumi.get(self, "storage_management_type")

    @storage_management_type.setter
    def storage_management_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_management_type", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="systemVersion")
    def system_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Operating system version of the image.
        """
        return pulumi.get(self, "system_version")

    @system_version.setter
    def system_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_version", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time that the VM cluster was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time zone to use for the VM cluster. For details, see [DB System Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone", value)

    @_builtins.property
    @pulumi.getter(name="vmClusterNetworkId")
    def vm_cluster_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster network.
        """
        return pulumi.get(self, "vm_cluster_network_id")

    @vm_cluster_network_id.setter
    def vm_cluster_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_cluster_network_id", value)

    @_builtins.property
    @pulumi.getter(name="vmClusterType")
    def vm_cluster_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The vmcluster type for the VM cluster/Cloud VM cluster.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vm_cluster_type")

    @vm_cluster_type.setter
    def vm_cluster_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_cluster_type", value)


@pulumi.type_token("oci:Database/vmCluster:VmCluster")
class VmCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_automation_update_details: Optional[pulumi.Input[Union['VmClusterCloudAutomationUpdateDetailsArgs', 'VmClusterCloudAutomationUpdateDetailsArgsDict']]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cpu_core_count: Optional[pulumi.Input[_builtins.int]] = None,
                 data_collection_options: Optional[pulumi.Input[Union['VmClusterDataCollectionOptionsArgs', 'VmClusterDataCollectionOptionsArgsDict']]] = None,
                 data_storage_size_in_gb: Optional[pulumi.Input[_builtins.float]] = None,
                 data_storage_size_in_tbs: Optional[pulumi.Input[_builtins.float]] = None,
                 db_node_storage_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 db_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 exadata_infrastructure_id: Optional[pulumi.Input[_builtins.str]] = None,
                 exascale_db_storage_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 file_system_configuration_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VmClusterFileSystemConfigurationDetailArgs', 'VmClusterFileSystemConfigurationDetailArgsDict']]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 gi_version: Optional[pulumi.Input[_builtins.str]] = None,
                 is_local_backup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_sparse_diskgroup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 license_model: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 ocpu_count: Optional[pulumi.Input[_builtins.float]] = None,
                 ssh_public_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 system_version: Optional[pulumi.Input[_builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_cluster_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Vm Cluster resource in Oracle Cloud Infrastructure Database service.

        Creates an Exadata Cloud@Customer VM cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_vm_cluster = oci.database.VmCluster("test_vm_cluster",
            compartment_id=compartment_id,
            cpu_core_count=vm_cluster_cpu_core_count,
            display_name=vm_cluster_display_name,
            exadata_infrastructure_id=test_exadata_infrastructure["id"],
            gi_version=vm_cluster_gi_version,
            ssh_public_keys=vm_cluster_ssh_public_keys,
            vm_cluster_network_id=test_vm_cluster_network["id"],
            cloud_automation_update_details={
                "apply_update_time_preference": {
                    "apply_update_preferred_end_time": vm_cluster_cloud_automation_update_details_apply_update_time_preference_apply_update_preferred_end_time,
                    "apply_update_preferred_start_time": vm_cluster_cloud_automation_update_details_apply_update_time_preference_apply_update_preferred_start_time,
                },
                "freeze_period": {
                    "freeze_period_end_time": vm_cluster_cloud_automation_update_details_freeze_period_freeze_period_end_time,
                    "freeze_period_start_time": vm_cluster_cloud_automation_update_details_freeze_period_freeze_period_start_time,
                },
                "is_early_adoption_enabled": vm_cluster_cloud_automation_update_details_is_early_adoption_enabled,
                "is_freeze_period_enabled": vm_cluster_cloud_automation_update_details_is_freeze_period_enabled,
            },
            data_collection_options={
                "is_diagnostics_events_enabled": vm_cluster_data_collection_options_is_diagnostics_events_enabled,
                "is_health_monitoring_enabled": vm_cluster_data_collection_options_is_health_monitoring_enabled,
                "is_incident_logs_enabled": vm_cluster_data_collection_options_is_incident_logs_enabled,
            },
            data_storage_size_in_tbs=vm_cluster_data_storage_size_in_tbs,
            db_node_storage_size_in_gbs=vm_cluster_db_node_storage_size_in_gbs,
            db_servers=vm_cluster_db_servers,
            defined_tags=vm_cluster_defined_tags,
            exascale_db_storage_vault_id=test_exascale_db_storage_vault["id"],
            file_system_configuration_details=[{
                "file_system_size_gb": vm_cluster_file_system_configuration_details_file_system_size_gb,
                "mount_point": vm_cluster_file_system_configuration_details_mount_point,
            }],
            freeform_tags={
                "Department": "Finance",
            },
            is_local_backup_enabled=vm_cluster_is_local_backup_enabled,
            is_sparse_diskgroup_enabled=vm_cluster_is_sparse_diskgroup_enabled,
            license_model=vm_cluster_license_model,
            memory_size_in_gbs=vm_cluster_memory_size_in_gbs,
            system_version=vm_cluster_system_version,
            time_zone=vm_cluster_time_zone,
            vm_cluster_type=vm_cluster_vm_cluster_type)
        ```

        ## Import

        VmClusters can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/vmCluster:VmCluster test_vm_cluster "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['VmClusterCloudAutomationUpdateDetailsArgs', 'VmClusterCloudAutomationUpdateDetailsArgsDict']] cloud_automation_update_details: (Updatable) Specifies the properties necessary for cloud automation updates. This includes modifying the apply update time preference, enabling or disabling early adoption, and enabling, modifying, or disabling the update freeze period.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Union['VmClusterDataCollectionOptionsArgs', 'VmClusterDataCollectionOptionsArgsDict']] data_collection_options: (Updatable) Indicates user preferences for the various diagnostic collection options for the VM cluster/Cloud VM cluster/VMBM DBCS.
        :param pulumi.Input[_builtins.float] data_storage_size_in_gb: (Updatable) The data disk group size to be allocated in GBs.
        :param pulumi.Input[_builtins.float] data_storage_size_in_tbs: (Updatable) The data disk group size to be allocated in TBs.
        :param pulumi.Input[_builtins.int] db_node_storage_size_in_gbs: (Updatable) The local node storage to be allocated in GBs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] db_servers: The list of Db server.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[_builtins.str] display_name: The user-friendly name for the VM cluster. The name does not need to be unique.
        :param pulumi.Input[_builtins.str] exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        :param pulumi.Input[_builtins.str] exascale_db_storage_vault_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Database Storage Vault.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VmClusterFileSystemConfigurationDetailArgs', 'VmClusterFileSystemConfigurationDetailArgsDict']]]] file_system_configuration_details: (Updatable) Details of the file system configuration of the VM cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] gi_version: The Oracle Grid Infrastructure software version for the VM cluster.
        :param pulumi.Input[_builtins.bool] is_local_backup_enabled: If true, database backup on local Exadata storage is configured for the VM cluster. If false, database backup on local Exadata storage is not available in the VM cluster.
        :param pulumi.Input[_builtins.bool] is_sparse_diskgroup_enabled: If true, the sparse disk group is configured for the VM cluster. If false, the sparse disk group is not created.
        :param pulumi.Input[_builtins.str] license_model: (Updatable) The Oracle license model that applies to the VM cluster. The default is BRING_YOUR_OWN_LICENSE.
        :param pulumi.Input[_builtins.int] memory_size_in_gbs: (Updatable) The memory to be allocated in GBs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ssh_public_keys: (Updatable) The public key portion of one or more key pairs used for SSH access to the VM cluster.
        :param pulumi.Input[_builtins.str] system_version: Operating system version of the image.
        :param pulumi.Input[_builtins.str] time_zone: The time zone to use for the VM cluster. For details, see [DB System Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        :param pulumi.Input[_builtins.str] vm_cluster_network_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster network.
        :param pulumi.Input[_builtins.str] vm_cluster_type: The vmcluster type for the VM cluster/Cloud VM cluster.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VmClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Vm Cluster resource in Oracle Cloud Infrastructure Database service.

        Creates an Exadata Cloud@Customer VM cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_vm_cluster = oci.database.VmCluster("test_vm_cluster",
            compartment_id=compartment_id,
            cpu_core_count=vm_cluster_cpu_core_count,
            display_name=vm_cluster_display_name,
            exadata_infrastructure_id=test_exadata_infrastructure["id"],
            gi_version=vm_cluster_gi_version,
            ssh_public_keys=vm_cluster_ssh_public_keys,
            vm_cluster_network_id=test_vm_cluster_network["id"],
            cloud_automation_update_details={
                "apply_update_time_preference": {
                    "apply_update_preferred_end_time": vm_cluster_cloud_automation_update_details_apply_update_time_preference_apply_update_preferred_end_time,
                    "apply_update_preferred_start_time": vm_cluster_cloud_automation_update_details_apply_update_time_preference_apply_update_preferred_start_time,
                },
                "freeze_period": {
                    "freeze_period_end_time": vm_cluster_cloud_automation_update_details_freeze_period_freeze_period_end_time,
                    "freeze_period_start_time": vm_cluster_cloud_automation_update_details_freeze_period_freeze_period_start_time,
                },
                "is_early_adoption_enabled": vm_cluster_cloud_automation_update_details_is_early_adoption_enabled,
                "is_freeze_period_enabled": vm_cluster_cloud_automation_update_details_is_freeze_period_enabled,
            },
            data_collection_options={
                "is_diagnostics_events_enabled": vm_cluster_data_collection_options_is_diagnostics_events_enabled,
                "is_health_monitoring_enabled": vm_cluster_data_collection_options_is_health_monitoring_enabled,
                "is_incident_logs_enabled": vm_cluster_data_collection_options_is_incident_logs_enabled,
            },
            data_storage_size_in_tbs=vm_cluster_data_storage_size_in_tbs,
            db_node_storage_size_in_gbs=vm_cluster_db_node_storage_size_in_gbs,
            db_servers=vm_cluster_db_servers,
            defined_tags=vm_cluster_defined_tags,
            exascale_db_storage_vault_id=test_exascale_db_storage_vault["id"],
            file_system_configuration_details=[{
                "file_system_size_gb": vm_cluster_file_system_configuration_details_file_system_size_gb,
                "mount_point": vm_cluster_file_system_configuration_details_mount_point,
            }],
            freeform_tags={
                "Department": "Finance",
            },
            is_local_backup_enabled=vm_cluster_is_local_backup_enabled,
            is_sparse_diskgroup_enabled=vm_cluster_is_sparse_diskgroup_enabled,
            license_model=vm_cluster_license_model,
            memory_size_in_gbs=vm_cluster_memory_size_in_gbs,
            system_version=vm_cluster_system_version,
            time_zone=vm_cluster_time_zone,
            vm_cluster_type=vm_cluster_vm_cluster_type)
        ```

        ## Import

        VmClusters can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/vmCluster:VmCluster test_vm_cluster "id"
        ```

        :param str resource_name: The name of the resource.
        :param VmClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VmClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_automation_update_details: Optional[pulumi.Input[Union['VmClusterCloudAutomationUpdateDetailsArgs', 'VmClusterCloudAutomationUpdateDetailsArgsDict']]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cpu_core_count: Optional[pulumi.Input[_builtins.int]] = None,
                 data_collection_options: Optional[pulumi.Input[Union['VmClusterDataCollectionOptionsArgs', 'VmClusterDataCollectionOptionsArgsDict']]] = None,
                 data_storage_size_in_gb: Optional[pulumi.Input[_builtins.float]] = None,
                 data_storage_size_in_tbs: Optional[pulumi.Input[_builtins.float]] = None,
                 db_node_storage_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 db_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 exadata_infrastructure_id: Optional[pulumi.Input[_builtins.str]] = None,
                 exascale_db_storage_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 file_system_configuration_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VmClusterFileSystemConfigurationDetailArgs', 'VmClusterFileSystemConfigurationDetailArgsDict']]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 gi_version: Optional[pulumi.Input[_builtins.str]] = None,
                 is_local_backup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_sparse_diskgroup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 license_model: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 ocpu_count: Optional[pulumi.Input[_builtins.float]] = None,
                 ssh_public_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 system_version: Optional[pulumi.Input[_builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_cluster_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VmClusterArgs.__new__(VmClusterArgs)

            __props__.__dict__["cloud_automation_update_details"] = cloud_automation_update_details
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if cpu_core_count is None and not opts.urn:
                raise TypeError("Missing required property 'cpu_core_count'")
            __props__.__dict__["cpu_core_count"] = cpu_core_count
            __props__.__dict__["data_collection_options"] = data_collection_options
            __props__.__dict__["data_storage_size_in_gb"] = data_storage_size_in_gb
            __props__.__dict__["data_storage_size_in_tbs"] = data_storage_size_in_tbs
            __props__.__dict__["db_node_storage_size_in_gbs"] = db_node_storage_size_in_gbs
            __props__.__dict__["db_servers"] = db_servers
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if exadata_infrastructure_id is None and not opts.urn:
                raise TypeError("Missing required property 'exadata_infrastructure_id'")
            __props__.__dict__["exadata_infrastructure_id"] = exadata_infrastructure_id
            __props__.__dict__["exascale_db_storage_vault_id"] = exascale_db_storage_vault_id
            __props__.__dict__["file_system_configuration_details"] = file_system_configuration_details
            __props__.__dict__["freeform_tags"] = freeform_tags
            if gi_version is None and not opts.urn:
                raise TypeError("Missing required property 'gi_version'")
            __props__.__dict__["gi_version"] = gi_version
            __props__.__dict__["is_local_backup_enabled"] = is_local_backup_enabled
            __props__.__dict__["is_sparse_diskgroup_enabled"] = is_sparse_diskgroup_enabled
            __props__.__dict__["license_model"] = license_model
            __props__.__dict__["memory_size_in_gbs"] = memory_size_in_gbs
            __props__.__dict__["ocpu_count"] = ocpu_count
            if ssh_public_keys is None and not opts.urn:
                raise TypeError("Missing required property 'ssh_public_keys'")
            __props__.__dict__["ssh_public_keys"] = ssh_public_keys
            __props__.__dict__["system_version"] = system_version
            __props__.__dict__["time_zone"] = time_zone
            if vm_cluster_network_id is None and not opts.urn:
                raise TypeError("Missing required property 'vm_cluster_network_id'")
            __props__.__dict__["vm_cluster_network_id"] = vm_cluster_network_id
            __props__.__dict__["vm_cluster_type"] = vm_cluster_type
            __props__.__dict__["availability_domain"] = None
            __props__.__dict__["compute_model"] = None
            __props__.__dict__["cpus_enabled"] = None
            __props__.__dict__["last_patch_history_entry_id"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["ocpus_enabled"] = None
            __props__.__dict__["shape"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["storage_management_type"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
        super(VmCluster, __self__).__init__(
            'oci:Database/vmCluster:VmCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
            cloud_automation_update_details: Optional[pulumi.Input[Union['VmClusterCloudAutomationUpdateDetailsArgs', 'VmClusterCloudAutomationUpdateDetailsArgsDict']]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            compute_model: Optional[pulumi.Input[_builtins.str]] = None,
            cpu_core_count: Optional[pulumi.Input[_builtins.int]] = None,
            cpus_enabled: Optional[pulumi.Input[_builtins.int]] = None,
            data_collection_options: Optional[pulumi.Input[Union['VmClusterDataCollectionOptionsArgs', 'VmClusterDataCollectionOptionsArgsDict']]] = None,
            data_storage_size_in_gb: Optional[pulumi.Input[_builtins.float]] = None,
            data_storage_size_in_tbs: Optional[pulumi.Input[_builtins.float]] = None,
            db_node_storage_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
            db_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            exadata_infrastructure_id: Optional[pulumi.Input[_builtins.str]] = None,
            exascale_db_storage_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
            file_system_configuration_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VmClusterFileSystemConfigurationDetailArgs', 'VmClusterFileSystemConfigurationDetailArgsDict']]]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            gi_version: Optional[pulumi.Input[_builtins.str]] = None,
            is_local_backup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            is_sparse_diskgroup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            last_patch_history_entry_id: Optional[pulumi.Input[_builtins.str]] = None,
            license_model: Optional[pulumi.Input[_builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            memory_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
            ocpu_count: Optional[pulumi.Input[_builtins.float]] = None,
            ocpus_enabled: Optional[pulumi.Input[_builtins.float]] = None,
            shape: Optional[pulumi.Input[_builtins.str]] = None,
            ssh_public_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            storage_management_type: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            system_version: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_zone: Optional[pulumi.Input[_builtins.str]] = None,
            vm_cluster_network_id: Optional[pulumi.Input[_builtins.str]] = None,
            vm_cluster_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'VmCluster':
        """
        Get an existing VmCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] availability_domain: The name of the availability domain that the VM cluster is located in.
        :param pulumi.Input[Union['VmClusterCloudAutomationUpdateDetailsArgs', 'VmClusterCloudAutomationUpdateDetailsArgsDict']] cloud_automation_update_details: (Updatable) Specifies the properties necessary for cloud automation updates. This includes modifying the apply update time preference, enabling or disabling early adoption, and enabling, modifying, or disabling the update freeze period.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[_builtins.str] compute_model: The compute model of the Autonomous Database. This is required if using the `computeCount` parameter. If using `cpuCoreCount` then it is an error to specify `computeModel` to a non-null value. ECPU compute model is the recommended model and OCPU compute model is legacy.
        :param pulumi.Input[_builtins.int] cpus_enabled: The number of enabled CPU cores.
        :param pulumi.Input[Union['VmClusterDataCollectionOptionsArgs', 'VmClusterDataCollectionOptionsArgsDict']] data_collection_options: (Updatable) Indicates user preferences for the various diagnostic collection options for the VM cluster/Cloud VM cluster/VMBM DBCS.
        :param pulumi.Input[_builtins.float] data_storage_size_in_gb: (Updatable) The data disk group size to be allocated in GBs.
        :param pulumi.Input[_builtins.float] data_storage_size_in_tbs: (Updatable) The data disk group size to be allocated in TBs.
        :param pulumi.Input[_builtins.int] db_node_storage_size_in_gbs: (Updatable) The local node storage to be allocated in GBs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] db_servers: The list of Db server.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[_builtins.str] display_name: The user-friendly name for the VM cluster. The name does not need to be unique.
        :param pulumi.Input[_builtins.str] exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        :param pulumi.Input[_builtins.str] exascale_db_storage_vault_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Database Storage Vault.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VmClusterFileSystemConfigurationDetailArgs', 'VmClusterFileSystemConfigurationDetailArgsDict']]]] file_system_configuration_details: (Updatable) Details of the file system configuration of the VM cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] gi_version: The Oracle Grid Infrastructure software version for the VM cluster.
        :param pulumi.Input[_builtins.bool] is_local_backup_enabled: If true, database backup on local Exadata storage is configured for the VM cluster. If false, database backup on local Exadata storage is not available in the VM cluster.
        :param pulumi.Input[_builtins.bool] is_sparse_diskgroup_enabled: If true, the sparse disk group is configured for the VM cluster. If false, the sparse disk group is not created.
        :param pulumi.Input[_builtins.str] last_patch_history_entry_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last patch history. This value is updated as soon as a patch operation starts.
        :param pulumi.Input[_builtins.str] license_model: (Updatable) The Oracle license model that applies to the VM cluster. The default is BRING_YOUR_OWN_LICENSE.
        :param pulumi.Input[_builtins.str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[_builtins.int] memory_size_in_gbs: (Updatable) The memory to be allocated in GBs.
        :param pulumi.Input[_builtins.str] shape: The shape of the Exadata infrastructure. The shape determines the amount of CPU, storage, and memory resources allocated to the instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ssh_public_keys: (Updatable) The public key portion of one or more key pairs used for SSH access to the VM cluster.
        :param pulumi.Input[_builtins.str] state: The current state of the VM cluster.
        :param pulumi.Input[_builtins.str] storage_management_type: Specifies whether the type of storage management for the VM cluster is ASM or Exascale.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[_builtins.str] system_version: Operating system version of the image.
        :param pulumi.Input[_builtins.str] time_created: The date and time that the VM cluster was created.
        :param pulumi.Input[_builtins.str] time_zone: The time zone to use for the VM cluster. For details, see [DB System Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        :param pulumi.Input[_builtins.str] vm_cluster_network_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster network.
        :param pulumi.Input[_builtins.str] vm_cluster_type: The vmcluster type for the VM cluster/Cloud VM cluster.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VmClusterState.__new__(_VmClusterState)

        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["cloud_automation_update_details"] = cloud_automation_update_details
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["compute_model"] = compute_model
        __props__.__dict__["cpu_core_count"] = cpu_core_count
        __props__.__dict__["cpus_enabled"] = cpus_enabled
        __props__.__dict__["data_collection_options"] = data_collection_options
        __props__.__dict__["data_storage_size_in_gb"] = data_storage_size_in_gb
        __props__.__dict__["data_storage_size_in_tbs"] = data_storage_size_in_tbs
        __props__.__dict__["db_node_storage_size_in_gbs"] = db_node_storage_size_in_gbs
        __props__.__dict__["db_servers"] = db_servers
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["exadata_infrastructure_id"] = exadata_infrastructure_id
        __props__.__dict__["exascale_db_storage_vault_id"] = exascale_db_storage_vault_id
        __props__.__dict__["file_system_configuration_details"] = file_system_configuration_details
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["gi_version"] = gi_version
        __props__.__dict__["is_local_backup_enabled"] = is_local_backup_enabled
        __props__.__dict__["is_sparse_diskgroup_enabled"] = is_sparse_diskgroup_enabled
        __props__.__dict__["last_patch_history_entry_id"] = last_patch_history_entry_id
        __props__.__dict__["license_model"] = license_model
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["memory_size_in_gbs"] = memory_size_in_gbs
        __props__.__dict__["ocpu_count"] = ocpu_count
        __props__.__dict__["ocpus_enabled"] = ocpus_enabled
        __props__.__dict__["shape"] = shape
        __props__.__dict__["ssh_public_keys"] = ssh_public_keys
        __props__.__dict__["state"] = state
        __props__.__dict__["storage_management_type"] = storage_management_type
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["system_version"] = system_version
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_zone"] = time_zone
        __props__.__dict__["vm_cluster_network_id"] = vm_cluster_network_id
        __props__.__dict__["vm_cluster_type"] = vm_cluster_type
        return VmCluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the availability domain that the VM cluster is located in.
        """
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter(name="cloudAutomationUpdateDetails")
    def cloud_automation_update_details(self) -> pulumi.Output['outputs.VmClusterCloudAutomationUpdateDetails']:
        """
        (Updatable) Specifies the properties necessary for cloud automation updates. This includes modifying the apply update time preference, enabling or disabling early adoption, and enabling, modifying, or disabling the update freeze period.
        """
        return pulumi.get(self, "cloud_automation_update_details")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="computeModel")
    def compute_model(self) -> pulumi.Output[_builtins.str]:
        """
        The compute model of the Autonomous Database. This is required if using the `computeCount` parameter. If using `cpuCoreCount` then it is an error to specify `computeModel` to a non-null value. ECPU compute model is the recommended model and OCPU compute model is legacy.
        """
        return pulumi.get(self, "compute_model")

    @_builtins.property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "cpu_core_count")

    @_builtins.property
    @pulumi.getter(name="cpusEnabled")
    def cpus_enabled(self) -> pulumi.Output[_builtins.int]:
        """
        The number of enabled CPU cores.
        """
        return pulumi.get(self, "cpus_enabled")

    @_builtins.property
    @pulumi.getter(name="dataCollectionOptions")
    def data_collection_options(self) -> pulumi.Output['outputs.VmClusterDataCollectionOptions']:
        """
        (Updatable) Indicates user preferences for the various diagnostic collection options for the VM cluster/Cloud VM cluster/VMBM DBCS.
        """
        return pulumi.get(self, "data_collection_options")

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInGb")
    def data_storage_size_in_gb(self) -> pulumi.Output[_builtins.float]:
        """
        (Updatable) The data disk group size to be allocated in GBs.
        """
        return pulumi.get(self, "data_storage_size_in_gb")

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> pulumi.Output[_builtins.float]:
        """
        (Updatable) The data disk group size to be allocated in TBs.
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @_builtins.property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) The local node storage to be allocated in GBs.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="dbServers")
    def db_servers(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of Db server.
        """
        return pulumi.get(self, "db_servers")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The user-friendly name for the VM cluster. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="exadataInfrastructureId")
    def exadata_infrastructure_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        """
        return pulumi.get(self, "exadata_infrastructure_id")

    @_builtins.property
    @pulumi.getter(name="exascaleDbStorageVaultId")
    def exascale_db_storage_vault_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Database Storage Vault.
        """
        return pulumi.get(self, "exascale_db_storage_vault_id")

    @_builtins.property
    @pulumi.getter(name="fileSystemConfigurationDetails")
    def file_system_configuration_details(self) -> pulumi.Output[Sequence['outputs.VmClusterFileSystemConfigurationDetail']]:
        """
        (Updatable) Details of the file system configuration of the VM cluster.
        """
        return pulumi.get(self, "file_system_configuration_details")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="giVersion")
    def gi_version(self) -> pulumi.Output[_builtins.str]:
        """
        The Oracle Grid Infrastructure software version for the VM cluster.
        """
        return pulumi.get(self, "gi_version")

    @_builtins.property
    @pulumi.getter(name="isLocalBackupEnabled")
    def is_local_backup_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        If true, database backup on local Exadata storage is configured for the VM cluster. If false, database backup on local Exadata storage is not available in the VM cluster.
        """
        return pulumi.get(self, "is_local_backup_enabled")

    @_builtins.property
    @pulumi.getter(name="isSparseDiskgroupEnabled")
    def is_sparse_diskgroup_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        If true, the sparse disk group is configured for the VM cluster. If false, the sparse disk group is not created.
        """
        return pulumi.get(self, "is_sparse_diskgroup_enabled")

    @_builtins.property
    @pulumi.getter(name="lastPatchHistoryEntryId")
    def last_patch_history_entry_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last patch history. This value is updated as soon as a patch operation starts.
        """
        return pulumi.get(self, "last_patch_history_entry_id")

    @_builtins.property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The Oracle license model that applies to the VM cluster. The default is BRING_YOUR_OWN_LICENSE.
        """
        return pulumi.get(self, "license_model")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) The memory to be allocated in GBs.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="ocpuCount")
    def ocpu_count(self) -> pulumi.Output[_builtins.float]:
        return pulumi.get(self, "ocpu_count")

    @_builtins.property
    @pulumi.getter(name="ocpusEnabled")
    def ocpus_enabled(self) -> pulumi.Output[_builtins.float]:
        return pulumi.get(self, "ocpus_enabled")

    @_builtins.property
    @pulumi.getter
    def shape(self) -> pulumi.Output[_builtins.str]:
        """
        The shape of the Exadata infrastructure. The shape determines the amount of CPU, storage, and memory resources allocated to the instance.
        """
        return pulumi.get(self, "shape")

    @_builtins.property
    @pulumi.getter(name="sshPublicKeys")
    def ssh_public_keys(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        (Updatable) The public key portion of one or more key pairs used for SSH access to the VM cluster.
        """
        return pulumi.get(self, "ssh_public_keys")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the VM cluster.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="storageManagementType")
    def storage_management_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies whether the type of storage management for the VM cluster is ASM or Exascale.
        """
        return pulumi.get(self, "storage_management_type")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="systemVersion")
    def system_version(self) -> pulumi.Output[_builtins.str]:
        """
        Operating system version of the image.
        """
        return pulumi.get(self, "system_version")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time that the VM cluster was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[_builtins.str]:
        """
        The time zone to use for the VM cluster. For details, see [DB System Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        """
        return pulumi.get(self, "time_zone")

    @_builtins.property
    @pulumi.getter(name="vmClusterNetworkId")
    def vm_cluster_network_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster network.
        """
        return pulumi.get(self, "vm_cluster_network_id")

    @_builtins.property
    @pulumi.getter(name="vmClusterType")
    def vm_cluster_type(self) -> pulumi.Output[_builtins.str]:
        """
        The vmcluster type for the VM cluster/Cloud VM cluster.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vm_cluster_type")

