# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDbManagementPrivateEndpointsResult',
    'AwaitableGetDbManagementPrivateEndpointsResult',
    'get_db_management_private_endpoints',
    'get_db_management_private_endpoints_output',
]

@pulumi.output_type
class GetDbManagementPrivateEndpointsResult:
    """
    A collection of values returned by getDbManagementPrivateEndpoints.
    """
    def __init__(__self__, compartment_id=None, db_management_private_endpoint_collections=None, filters=None, id=None, is_cluster=None, is_dns_resolution_enabled=None, name=None, state=None, vcn_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if db_management_private_endpoint_collections and not isinstance(db_management_private_endpoint_collections, list):
            raise TypeError("Expected argument 'db_management_private_endpoint_collections' to be a list")
        pulumi.set(__self__, "db_management_private_endpoint_collections", db_management_private_endpoint_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_cluster and not isinstance(is_cluster, bool):
            raise TypeError("Expected argument 'is_cluster' to be a bool")
        pulumi.set(__self__, "is_cluster", is_cluster)
        if is_dns_resolution_enabled and not isinstance(is_dns_resolution_enabled, bool):
            raise TypeError("Expected argument 'is_dns_resolution_enabled' to be a bool")
        pulumi.set(__self__, "is_dns_resolution_enabled", is_dns_resolution_enabled)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if vcn_id and not isinstance(vcn_id, str):
            raise TypeError("Expected argument 'vcn_id' to be a str")
        pulumi.set(__self__, "vcn_id", vcn_id)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="dbManagementPrivateEndpointCollections")
    def db_management_private_endpoint_collections(self) -> Sequence['outputs.GetDbManagementPrivateEndpointsDbManagementPrivateEndpointCollectionResult']:
        """
        The list of db_management_private_endpoint_collection.
        """
        return pulumi.get(self, "db_management_private_endpoint_collections")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDbManagementPrivateEndpointsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isCluster")
    def is_cluster(self) -> Optional[_builtins.bool]:
        """
        Specifies whether the Database Management private endpoint can be used for Oracle Databases in a cluster.
        """
        return pulumi.get(self, "is_cluster")

    @_builtins.property
    @pulumi.getter(name="isDnsResolutionEnabled")
    def is_dns_resolution_enabled(self) -> Optional[_builtins.bool]:
        """
        Specifies whether the Database Management private endpoint has DNS proxy server enabled to resolve private host name.
        """
        return pulumi.get(self, "is_dns_resolution_enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The display name of the Database Management private endpoint.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current lifecycle state of the Database Management private endpoint.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN.
        """
        return pulumi.get(self, "vcn_id")


class AwaitableGetDbManagementPrivateEndpointsResult(GetDbManagementPrivateEndpointsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbManagementPrivateEndpointsResult(
            compartment_id=self.compartment_id,
            db_management_private_endpoint_collections=self.db_management_private_endpoint_collections,
            filters=self.filters,
            id=self.id,
            is_cluster=self.is_cluster,
            is_dns_resolution_enabled=self.is_dns_resolution_enabled,
            name=self.name,
            state=self.state,
            vcn_id=self.vcn_id)


def get_db_management_private_endpoints(compartment_id: Optional[_builtins.str] = None,
                                        filters: Optional[Sequence[Union['GetDbManagementPrivateEndpointsFilterArgs', 'GetDbManagementPrivateEndpointsFilterArgsDict']]] = None,
                                        is_cluster: Optional[_builtins.bool] = None,
                                        is_dns_resolution_enabled: Optional[_builtins.bool] = None,
                                        name: Optional[_builtins.str] = None,
                                        state: Optional[_builtins.str] = None,
                                        vcn_id: Optional[_builtins.str] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbManagementPrivateEndpointsResult:
    """
    This data source provides the list of Db Management Private Endpoints in Oracle Cloud Infrastructure Database Management service.

    Gets a list of Database Management private endpoints.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_management_private_endpoints = oci.DatabaseManagement.get_db_management_private_endpoints(compartment_id=compartment_id,
        is_cluster=db_management_private_endpoint_is_cluster,
        is_dns_resolution_enabled=db_management_private_endpoint_is_dns_resolution_enabled,
        name=db_management_private_endpoint_name,
        state=db_management_private_endpoint_state,
        vcn_id=test_vcn["id"])
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.bool is_cluster: The option to filter Database Management private endpoints that can used for Oracle Databases in a cluster. This should be used along with the vcnId query parameter.
    :param _builtins.bool is_dns_resolution_enabled: The option to filter Database Management private endpoints which are endbled with DNS proxy server. This should be used along with the vcnId query parameter. Only one of this parameter and IsClusterDbManagementPrivateEndpointQueryParam should be set to true at one time.
    :param _builtins.str name: A filter to return only resources that match the entire name.
    :param _builtins.str state: The lifecycle state of a resource.
    :param _builtins.str vcn_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['isCluster'] = is_cluster
    __args__['isDnsResolutionEnabled'] = is_dns_resolution_enabled
    __args__['name'] = name
    __args__['state'] = state
    __args__['vcnId'] = vcn_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getDbManagementPrivateEndpoints:getDbManagementPrivateEndpoints', __args__, opts=opts, typ=GetDbManagementPrivateEndpointsResult).value

    return AwaitableGetDbManagementPrivateEndpointsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        db_management_private_endpoint_collections=pulumi.get(__ret__, 'db_management_private_endpoint_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_cluster=pulumi.get(__ret__, 'is_cluster'),
        is_dns_resolution_enabled=pulumi.get(__ret__, 'is_dns_resolution_enabled'),
        name=pulumi.get(__ret__, 'name'),
        state=pulumi.get(__ret__, 'state'),
        vcn_id=pulumi.get(__ret__, 'vcn_id'))
def get_db_management_private_endpoints_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                               filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDbManagementPrivateEndpointsFilterArgs', 'GetDbManagementPrivateEndpointsFilterArgsDict']]]]] = None,
                                               is_cluster: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                               is_dns_resolution_enabled: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                               name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                               state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                               vcn_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDbManagementPrivateEndpointsResult]:
    """
    This data source provides the list of Db Management Private Endpoints in Oracle Cloud Infrastructure Database Management service.

    Gets a list of Database Management private endpoints.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_management_private_endpoints = oci.DatabaseManagement.get_db_management_private_endpoints(compartment_id=compartment_id,
        is_cluster=db_management_private_endpoint_is_cluster,
        is_dns_resolution_enabled=db_management_private_endpoint_is_dns_resolution_enabled,
        name=db_management_private_endpoint_name,
        state=db_management_private_endpoint_state,
        vcn_id=test_vcn["id"])
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.bool is_cluster: The option to filter Database Management private endpoints that can used for Oracle Databases in a cluster. This should be used along with the vcnId query parameter.
    :param _builtins.bool is_dns_resolution_enabled: The option to filter Database Management private endpoints which are endbled with DNS proxy server. This should be used along with the vcnId query parameter. Only one of this parameter and IsClusterDbManagementPrivateEndpointQueryParam should be set to true at one time.
    :param _builtins.str name: A filter to return only resources that match the entire name.
    :param _builtins.str state: The lifecycle state of a resource.
    :param _builtins.str vcn_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['isCluster'] = is_cluster
    __args__['isDnsResolutionEnabled'] = is_dns_resolution_enabled
    __args__['name'] = name
    __args__['state'] = state
    __args__['vcnId'] = vcn_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseManagement/getDbManagementPrivateEndpoints:getDbManagementPrivateEndpoints', __args__, opts=opts, typ=GetDbManagementPrivateEndpointsResult)
    return __ret__.apply(lambda __response__: GetDbManagementPrivateEndpointsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        db_management_private_endpoint_collections=pulumi.get(__response__, 'db_management_private_endpoint_collections'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        is_cluster=pulumi.get(__response__, 'is_cluster'),
        is_dns_resolution_enabled=pulumi.get(__response__, 'is_dns_resolution_enabled'),
        name=pulumi.get(__response__, 'name'),
        state=pulumi.get(__response__, 'state'),
        vcn_id=pulumi.get(__response__, 'vcn_id')))
