# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetManagedDatabasesAsmPropertiesResult',
    'AwaitableGetManagedDatabasesAsmPropertiesResult',
    'get_managed_databases_asm_properties',
    'get_managed_databases_asm_properties_output',
]

@pulumi.output_type
class GetManagedDatabasesAsmPropertiesResult:
    """
    A collection of values returned by getManagedDatabasesAsmProperties.
    """
    def __init__(__self__, asm_property_collections=None, filters=None, id=None, managed_database_id=None, name=None):
        if asm_property_collections and not isinstance(asm_property_collections, list):
            raise TypeError("Expected argument 'asm_property_collections' to be a list")
        pulumi.set(__self__, "asm_property_collections", asm_property_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_database_id and not isinstance(managed_database_id, str):
            raise TypeError("Expected argument 'managed_database_id' to be a str")
        pulumi.set(__self__, "managed_database_id", managed_database_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="asmPropertyCollections")
    def asm_property_collections(self) -> Sequence['outputs.GetManagedDatabasesAsmPropertiesAsmPropertyCollectionResult']:
        """
        The list of asm_property_collection.
        """
        return pulumi.get(self, "asm_property_collections")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetManagedDatabasesAsmPropertiesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="managedDatabaseId")
    def managed_database_id(self) -> _builtins.str:
        return pulumi.get(self, "managed_database_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")


class AwaitableGetManagedDatabasesAsmPropertiesResult(GetManagedDatabasesAsmPropertiesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedDatabasesAsmPropertiesResult(
            asm_property_collections=self.asm_property_collections,
            filters=self.filters,
            id=self.id,
            managed_database_id=self.managed_database_id,
            name=self.name)


def get_managed_databases_asm_properties(filters: Optional[Sequence[Union['GetManagedDatabasesAsmPropertiesFilterArgs', 'GetManagedDatabasesAsmPropertiesFilterArgsDict']]] = None,
                                         managed_database_id: Optional[_builtins.str] = None,
                                         name: Optional[_builtins.str] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedDatabasesAsmPropertiesResult:
    """
    This data source provides the list of Managed Databases Asm Properties in Oracle Cloud Infrastructure Database Management service.

    Gets the list of ASM properties for the specified managedDatabaseId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_databases_asm_properties = oci.DatabaseManagement.get_managed_databases_asm_properties(managed_database_id=test_managed_database["id"],
        name=managed_databases_asm_property_name)
    ```


    :param _builtins.str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param _builtins.str name: A filter to return only resources that match the entire name.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['managedDatabaseId'] = managed_database_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getManagedDatabasesAsmProperties:getManagedDatabasesAsmProperties', __args__, opts=opts, typ=GetManagedDatabasesAsmPropertiesResult).value

    return AwaitableGetManagedDatabasesAsmPropertiesResult(
        asm_property_collections=pulumi.get(__ret__, 'asm_property_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        managed_database_id=pulumi.get(__ret__, 'managed_database_id'),
        name=pulumi.get(__ret__, 'name'))
def get_managed_databases_asm_properties_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetManagedDatabasesAsmPropertiesFilterArgs', 'GetManagedDatabasesAsmPropertiesFilterArgsDict']]]]] = None,
                                                managed_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetManagedDatabasesAsmPropertiesResult]:
    """
    This data source provides the list of Managed Databases Asm Properties in Oracle Cloud Infrastructure Database Management service.

    Gets the list of ASM properties for the specified managedDatabaseId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_databases_asm_properties = oci.DatabaseManagement.get_managed_databases_asm_properties(managed_database_id=test_managed_database["id"],
        name=managed_databases_asm_property_name)
    ```


    :param _builtins.str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param _builtins.str name: A filter to return only resources that match the entire name.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['managedDatabaseId'] = managed_database_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseManagement/getManagedDatabasesAsmProperties:getManagedDatabasesAsmProperties', __args__, opts=opts, typ=GetManagedDatabasesAsmPropertiesResult)
    return __ret__.apply(lambda __response__: GetManagedDatabasesAsmPropertiesResult(
        asm_property_collections=pulumi.get(__response__, 'asm_property_collections'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        managed_database_id=pulumi.get(__response__, 'managed_database_id'),
        name=pulumi.get(__response__, 'name')))
