# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AuditTrailManagementArgs', 'AuditTrailManagement']

@pulumi.input_type
class AuditTrailManagementArgs:
    def __init__(__self__, *,
                 audit_collection_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 can_update_last_archive_time_on_target: Optional[pulumi.Input[_builtins.bool]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_auto_purge_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resume_trigger: Optional[pulumi.Input[_builtins.bool]] = None,
                 start_trigger: Optional[pulumi.Input[_builtins.bool]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 stop_trigger: Optional[pulumi.Input[_builtins.bool]] = None,
                 target_id: Optional[pulumi.Input[_builtins.str]] = None,
                 trail_location: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AuditTrailManagement resource.
        :param pulumi.Input[_builtins.str] audit_collection_start_time: The date from which the audit trail must start collecting data, in the format defined by RFC3339. It is a required field when start_trigger is set.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.bool] can_update_last_archive_time_on_target: (Updatable) Indicates if the Datasafe updates last archive time on target database. If isAutoPurgeEnabled field is enabled, this field must be true.
        :param pulumi.Input[_builtins.str] compartment_id: The OCID of the compartment that contains the target.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the audit trail.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the audit trail. The name does not have to be unique, and it's updatable.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_auto_purge_enabled: (Updatable) Indicates if auto purge is enabled on the target database, which helps delete audit data in the target database every seven days so that the database's audit trail does not become too large.
        :param pulumi.Input[_builtins.bool] resume_trigger: (Updatable) An optional property when set to true triggers Resume.
        :param pulumi.Input[_builtins.bool] start_trigger: (Updatable) An optional property when set to true triggers Start.
        :param pulumi.Input[_builtins.str] state: (Updatable) The target state for the Audit Trail Management. Could be set to `ACTIVE` or `INACTIVE`.
        :param pulumi.Input[_builtins.bool] stop_trigger: (Updatable) An optional property when set to true triggers Stop.
        :param pulumi.Input[_builtins.str] target_id: The OCID of the target.
        :param pulumi.Input[_builtins.str] trail_location: An audit trail location represents the source of audit records that provides documentary evidence of the sequence of activities in the target database.
        """
        if audit_collection_start_time is not None:
            pulumi.set(__self__, "audit_collection_start_time", audit_collection_start_time)
        if can_update_last_archive_time_on_target is not None:
            pulumi.set(__self__, "can_update_last_archive_time_on_target", can_update_last_archive_time_on_target)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_auto_purge_enabled is not None:
            pulumi.set(__self__, "is_auto_purge_enabled", is_auto_purge_enabled)
        if resume_trigger is not None:
            pulumi.set(__self__, "resume_trigger", resume_trigger)
        if start_trigger is not None:
            pulumi.set(__self__, "start_trigger", start_trigger)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if stop_trigger is not None:
            pulumi.set(__self__, "stop_trigger", stop_trigger)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)
        if trail_location is not None:
            pulumi.set(__self__, "trail_location", trail_location)

    @_builtins.property
    @pulumi.getter(name="auditCollectionStartTime")
    def audit_collection_start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date from which the audit trail must start collecting data, in the format defined by RFC3339. It is a required field when start_trigger is set.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "audit_collection_start_time")

    @audit_collection_start_time.setter
    def audit_collection_start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "audit_collection_start_time", value)

    @_builtins.property
    @pulumi.getter(name="canUpdateLastArchiveTimeOnTarget")
    def can_update_last_archive_time_on_target(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Indicates if the Datasafe updates last archive time on target database. If isAutoPurgeEnabled field is enabled, this field must be true.
        """
        return pulumi.get(self, "can_update_last_archive_time_on_target")

    @can_update_last_archive_time_on_target.setter
    def can_update_last_archive_time_on_target(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "can_update_last_archive_time_on_target", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the compartment that contains the target.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The description of the audit trail.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The display name of the audit trail. The name does not have to be unique, and it's updatable.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="isAutoPurgeEnabled")
    def is_auto_purge_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Indicates if auto purge is enabled on the target database, which helps delete audit data in the target database every seven days so that the database's audit trail does not become too large.
        """
        return pulumi.get(self, "is_auto_purge_enabled")

    @is_auto_purge_enabled.setter
    def is_auto_purge_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_auto_purge_enabled", value)

    @_builtins.property
    @pulumi.getter(name="resumeTrigger")
    def resume_trigger(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) An optional property when set to true triggers Resume.
        """
        return pulumi.get(self, "resume_trigger")

    @resume_trigger.setter
    def resume_trigger(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "resume_trigger", value)

    @_builtins.property
    @pulumi.getter(name="startTrigger")
    def start_trigger(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) An optional property when set to true triggers Start.
        """
        return pulumi.get(self, "start_trigger")

    @start_trigger.setter
    def start_trigger(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "start_trigger", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The target state for the Audit Trail Management. Could be set to `ACTIVE` or `INACTIVE`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="stopTrigger")
    def stop_trigger(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) An optional property when set to true triggers Stop.
        """
        return pulumi.get(self, "stop_trigger")

    @stop_trigger.setter
    def stop_trigger(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "stop_trigger", value)

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the target.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_id", value)

    @_builtins.property
    @pulumi.getter(name="trailLocation")
    def trail_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An audit trail location represents the source of audit records that provides documentary evidence of the sequence of activities in the target database.
        """
        return pulumi.get(self, "trail_location")

    @trail_location.setter
    def trail_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trail_location", value)


@pulumi.input_type
class _AuditTrailManagementState:
    def __init__(__self__, *,
                 audit_collection_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 audit_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 can_update_last_archive_time_on_target: Optional[pulumi.Input[_builtins.bool]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_auto_purge_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 resume_trigger: Optional[pulumi.Input[_builtins.bool]] = None,
                 start_trigger: Optional[pulumi.Input[_builtins.bool]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 stop_trigger: Optional[pulumi.Input[_builtins.bool]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_last_collected: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 trail_location: Optional[pulumi.Input[_builtins.str]] = None,
                 work_request_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AuditTrailManagement resources.
        :param pulumi.Input[_builtins.str] audit_collection_start_time: The date from which the audit trail must start collecting data, in the format defined by RFC3339. It is a required field when start_trigger is set.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] audit_profile_id: The OCID of the  parent audit.
        :param pulumi.Input[_builtins.bool] can_update_last_archive_time_on_target: (Updatable) Indicates if the Datasafe updates last archive time on target database. If isAutoPurgeEnabled field is enabled, this field must be true.
        :param pulumi.Input[_builtins.str] compartment_id: The OCID of the compartment that contains the target.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the audit trail.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the audit trail. The name does not have to be unique, and it's updatable.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_auto_purge_enabled: (Updatable) Indicates if auto purge is enabled on the target database, which helps delete audit data in the target database every seven days so that the database's audit trail does not become too large.
        :param pulumi.Input[_builtins.str] lifecycle_details: Details about the current state of the audit trail in Data Safe.
        :param pulumi.Input[_builtins.bool] resume_trigger: (Updatable) An optional property when set to true triggers Resume.
        :param pulumi.Input[_builtins.bool] start_trigger: (Updatable) An optional property when set to true triggers Start.
        :param pulumi.Input[_builtins.str] state: (Updatable) The target state for the Audit Trail Management. Could be set to `ACTIVE` or `INACTIVE`.
        :param pulumi.Input[_builtins.str] status: The current sub-state of the audit trail.
        :param pulumi.Input[_builtins.bool] stop_trigger: (Updatable) An optional property when set to true triggers Stop.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] target_id: The OCID of the target.
        :param pulumi.Input[_builtins.str] time_created: The date and time the audit trail was created, in the format defined by RFC3339.
        :param pulumi.Input[_builtins.str] time_last_collected: The date and time until when the audit events were collected from the target database by the Data Safe audit trail  collection process, in the format defined by RFC3339.
        :param pulumi.Input[_builtins.str] time_updated: The date and time the audit trail was updated, in the format defined by RFC3339.
        :param pulumi.Input[_builtins.str] trail_location: An audit trail location represents the source of audit records that provides documentary evidence of the sequence of activities in the target database.
        :param pulumi.Input[_builtins.str] work_request_id: The OCID of the workrequest for audit trail which collects audit records.
        """
        if audit_collection_start_time is not None:
            pulumi.set(__self__, "audit_collection_start_time", audit_collection_start_time)
        if audit_profile_id is not None:
            pulumi.set(__self__, "audit_profile_id", audit_profile_id)
        if can_update_last_archive_time_on_target is not None:
            pulumi.set(__self__, "can_update_last_archive_time_on_target", can_update_last_archive_time_on_target)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_auto_purge_enabled is not None:
            pulumi.set(__self__, "is_auto_purge_enabled", is_auto_purge_enabled)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if resume_trigger is not None:
            pulumi.set(__self__, "resume_trigger", resume_trigger)
        if start_trigger is not None:
            pulumi.set(__self__, "start_trigger", start_trigger)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if stop_trigger is not None:
            pulumi.set(__self__, "stop_trigger", stop_trigger)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_last_collected is not None:
            pulumi.set(__self__, "time_last_collected", time_last_collected)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if trail_location is not None:
            pulumi.set(__self__, "trail_location", trail_location)
        if work_request_id is not None:
            pulumi.set(__self__, "work_request_id", work_request_id)

    @_builtins.property
    @pulumi.getter(name="auditCollectionStartTime")
    def audit_collection_start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date from which the audit trail must start collecting data, in the format defined by RFC3339. It is a required field when start_trigger is set.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "audit_collection_start_time")

    @audit_collection_start_time.setter
    def audit_collection_start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "audit_collection_start_time", value)

    @_builtins.property
    @pulumi.getter(name="auditProfileId")
    def audit_profile_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the  parent audit.
        """
        return pulumi.get(self, "audit_profile_id")

    @audit_profile_id.setter
    def audit_profile_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "audit_profile_id", value)

    @_builtins.property
    @pulumi.getter(name="canUpdateLastArchiveTimeOnTarget")
    def can_update_last_archive_time_on_target(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Indicates if the Datasafe updates last archive time on target database. If isAutoPurgeEnabled field is enabled, this field must be true.
        """
        return pulumi.get(self, "can_update_last_archive_time_on_target")

    @can_update_last_archive_time_on_target.setter
    def can_update_last_archive_time_on_target(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "can_update_last_archive_time_on_target", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the compartment that contains the target.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The description of the audit trail.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The display name of the audit trail. The name does not have to be unique, and it's updatable.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="isAutoPurgeEnabled")
    def is_auto_purge_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Indicates if auto purge is enabled on the target database, which helps delete audit data in the target database every seven days so that the database's audit trail does not become too large.
        """
        return pulumi.get(self, "is_auto_purge_enabled")

    @is_auto_purge_enabled.setter
    def is_auto_purge_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_auto_purge_enabled", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Details about the current state of the audit trail in Data Safe.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter(name="resumeTrigger")
    def resume_trigger(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) An optional property when set to true triggers Resume.
        """
        return pulumi.get(self, "resume_trigger")

    @resume_trigger.setter
    def resume_trigger(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "resume_trigger", value)

    @_builtins.property
    @pulumi.getter(name="startTrigger")
    def start_trigger(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) An optional property when set to true triggers Start.
        """
        return pulumi.get(self, "start_trigger")

    @start_trigger.setter
    def start_trigger(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "start_trigger", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The target state for the Audit Trail Management. Could be set to `ACTIVE` or `INACTIVE`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current sub-state of the audit trail.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="stopTrigger")
    def stop_trigger(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) An optional property when set to true triggers Stop.
        """
        return pulumi.get(self, "stop_trigger")

    @stop_trigger.setter
    def stop_trigger(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "stop_trigger", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the target.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_id", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the audit trail was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeLastCollected")
    def time_last_collected(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time until when the audit events were collected from the target database by the Data Safe audit trail  collection process, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_last_collected")

    @time_last_collected.setter
    def time_last_collected(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_last_collected", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the audit trail was updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @_builtins.property
    @pulumi.getter(name="trailLocation")
    def trail_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An audit trail location represents the source of audit records that provides documentary evidence of the sequence of activities in the target database.
        """
        return pulumi.get(self, "trail_location")

    @trail_location.setter
    def trail_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trail_location", value)

    @_builtins.property
    @pulumi.getter(name="workRequestId")
    def work_request_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the workrequest for audit trail which collects audit records.
        """
        return pulumi.get(self, "work_request_id")

    @work_request_id.setter
    def work_request_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "work_request_id", value)


@pulumi.type_token("oci:DataSafe/auditTrailManagement:AuditTrailManagement")
class AuditTrailManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audit_collection_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 can_update_last_archive_time_on_target: Optional[pulumi.Input[_builtins.bool]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_auto_purge_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resume_trigger: Optional[pulumi.Input[_builtins.bool]] = None,
                 start_trigger: Optional[pulumi.Input[_builtins.bool]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 stop_trigger: Optional[pulumi.Input[_builtins.bool]] = None,
                 target_id: Optional[pulumi.Input[_builtins.str]] = None,
                 trail_location: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Audit Trail Management resource in Oracle Cloud Infrastructure Data Safe service.

        Updates one or more attributes of the specified audit trail.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_audit_trail_management = oci.datasafe.AuditTrailManagement("test_audit_trail_management",
            compartment_id=compartment_id,
            target_id=test_target_database["id"],
            trail_location=audit_trail_management_trail_location,
            can_update_last_archive_time_on_target=audit_trail_management_can_update_last_archive_time_on_target,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=audit_trail_management_description,
            display_name=audit_trail_management_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            is_auto_purge_enabled=audit_trail_management_is_auto_purge_enabled)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] audit_collection_start_time: The date from which the audit trail must start collecting data, in the format defined by RFC3339. It is a required field when start_trigger is set.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.bool] can_update_last_archive_time_on_target: (Updatable) Indicates if the Datasafe updates last archive time on target database. If isAutoPurgeEnabled field is enabled, this field must be true.
        :param pulumi.Input[_builtins.str] compartment_id: The OCID of the compartment that contains the target.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the audit trail.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the audit trail. The name does not have to be unique, and it's updatable.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_auto_purge_enabled: (Updatable) Indicates if auto purge is enabled on the target database, which helps delete audit data in the target database every seven days so that the database's audit trail does not become too large.
        :param pulumi.Input[_builtins.bool] resume_trigger: (Updatable) An optional property when set to true triggers Resume.
        :param pulumi.Input[_builtins.bool] start_trigger: (Updatable) An optional property when set to true triggers Start.
        :param pulumi.Input[_builtins.str] state: (Updatable) The target state for the Audit Trail Management. Could be set to `ACTIVE` or `INACTIVE`.
        :param pulumi.Input[_builtins.bool] stop_trigger: (Updatable) An optional property when set to true triggers Stop.
        :param pulumi.Input[_builtins.str] target_id: The OCID of the target.
        :param pulumi.Input[_builtins.str] trail_location: An audit trail location represents the source of audit records that provides documentary evidence of the sequence of activities in the target database.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AuditTrailManagementArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Audit Trail Management resource in Oracle Cloud Infrastructure Data Safe service.

        Updates one or more attributes of the specified audit trail.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_audit_trail_management = oci.datasafe.AuditTrailManagement("test_audit_trail_management",
            compartment_id=compartment_id,
            target_id=test_target_database["id"],
            trail_location=audit_trail_management_trail_location,
            can_update_last_archive_time_on_target=audit_trail_management_can_update_last_archive_time_on_target,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=audit_trail_management_description,
            display_name=audit_trail_management_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            is_auto_purge_enabled=audit_trail_management_is_auto_purge_enabled)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param AuditTrailManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuditTrailManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audit_collection_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 can_update_last_archive_time_on_target: Optional[pulumi.Input[_builtins.bool]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_auto_purge_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resume_trigger: Optional[pulumi.Input[_builtins.bool]] = None,
                 start_trigger: Optional[pulumi.Input[_builtins.bool]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 stop_trigger: Optional[pulumi.Input[_builtins.bool]] = None,
                 target_id: Optional[pulumi.Input[_builtins.str]] = None,
                 trail_location: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuditTrailManagementArgs.__new__(AuditTrailManagementArgs)

            __props__.__dict__["audit_collection_start_time"] = audit_collection_start_time
            __props__.__dict__["can_update_last_archive_time_on_target"] = can_update_last_archive_time_on_target
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_auto_purge_enabled"] = is_auto_purge_enabled
            __props__.__dict__["resume_trigger"] = resume_trigger
            __props__.__dict__["start_trigger"] = start_trigger
            __props__.__dict__["state"] = state
            __props__.__dict__["stop_trigger"] = stop_trigger
            __props__.__dict__["target_id"] = target_id
            __props__.__dict__["trail_location"] = trail_location
            __props__.__dict__["audit_profile_id"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_last_collected"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["work_request_id"] = None
        super(AuditTrailManagement, __self__).__init__(
            'oci:DataSafe/auditTrailManagement:AuditTrailManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            audit_collection_start_time: Optional[pulumi.Input[_builtins.str]] = None,
            audit_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
            can_update_last_archive_time_on_target: Optional[pulumi.Input[_builtins.bool]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            is_auto_purge_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            resume_trigger: Optional[pulumi.Input[_builtins.bool]] = None,
            start_trigger: Optional[pulumi.Input[_builtins.bool]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            stop_trigger: Optional[pulumi.Input[_builtins.bool]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            target_id: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_last_collected: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None,
            trail_location: Optional[pulumi.Input[_builtins.str]] = None,
            work_request_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'AuditTrailManagement':
        """
        Get an existing AuditTrailManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] audit_collection_start_time: The date from which the audit trail must start collecting data, in the format defined by RFC3339. It is a required field when start_trigger is set.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] audit_profile_id: The OCID of the  parent audit.
        :param pulumi.Input[_builtins.bool] can_update_last_archive_time_on_target: (Updatable) Indicates if the Datasafe updates last archive time on target database. If isAutoPurgeEnabled field is enabled, this field must be true.
        :param pulumi.Input[_builtins.str] compartment_id: The OCID of the compartment that contains the target.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the audit trail.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the audit trail. The name does not have to be unique, and it's updatable.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_auto_purge_enabled: (Updatable) Indicates if auto purge is enabled on the target database, which helps delete audit data in the target database every seven days so that the database's audit trail does not become too large.
        :param pulumi.Input[_builtins.str] lifecycle_details: Details about the current state of the audit trail in Data Safe.
        :param pulumi.Input[_builtins.bool] resume_trigger: (Updatable) An optional property when set to true triggers Resume.
        :param pulumi.Input[_builtins.bool] start_trigger: (Updatable) An optional property when set to true triggers Start.
        :param pulumi.Input[_builtins.str] state: (Updatable) The target state for the Audit Trail Management. Could be set to `ACTIVE` or `INACTIVE`.
        :param pulumi.Input[_builtins.str] status: The current sub-state of the audit trail.
        :param pulumi.Input[_builtins.bool] stop_trigger: (Updatable) An optional property when set to true triggers Stop.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] target_id: The OCID of the target.
        :param pulumi.Input[_builtins.str] time_created: The date and time the audit trail was created, in the format defined by RFC3339.
        :param pulumi.Input[_builtins.str] time_last_collected: The date and time until when the audit events were collected from the target database by the Data Safe audit trail  collection process, in the format defined by RFC3339.
        :param pulumi.Input[_builtins.str] time_updated: The date and time the audit trail was updated, in the format defined by RFC3339.
        :param pulumi.Input[_builtins.str] trail_location: An audit trail location represents the source of audit records that provides documentary evidence of the sequence of activities in the target database.
        :param pulumi.Input[_builtins.str] work_request_id: The OCID of the workrequest for audit trail which collects audit records.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuditTrailManagementState.__new__(_AuditTrailManagementState)

        __props__.__dict__["audit_collection_start_time"] = audit_collection_start_time
        __props__.__dict__["audit_profile_id"] = audit_profile_id
        __props__.__dict__["can_update_last_archive_time_on_target"] = can_update_last_archive_time_on_target
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_auto_purge_enabled"] = is_auto_purge_enabled
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["resume_trigger"] = resume_trigger
        __props__.__dict__["start_trigger"] = start_trigger
        __props__.__dict__["state"] = state
        __props__.__dict__["status"] = status
        __props__.__dict__["stop_trigger"] = stop_trigger
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["target_id"] = target_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_last_collected"] = time_last_collected
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["trail_location"] = trail_location
        __props__.__dict__["work_request_id"] = work_request_id
        return AuditTrailManagement(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="auditCollectionStartTime")
    def audit_collection_start_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The date from which the audit trail must start collecting data, in the format defined by RFC3339. It is a required field when start_trigger is set.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "audit_collection_start_time")

    @_builtins.property
    @pulumi.getter(name="auditProfileId")
    def audit_profile_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the  parent audit.
        """
        return pulumi.get(self, "audit_profile_id")

    @_builtins.property
    @pulumi.getter(name="canUpdateLastArchiveTimeOnTarget")
    def can_update_last_archive_time_on_target(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Indicates if the Datasafe updates last archive time on target database. If isAutoPurgeEnabled field is enabled, this field must be true.
        """
        return pulumi.get(self, "can_update_last_archive_time_on_target")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the compartment that contains the target.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The description of the audit trail.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The display name of the audit trail. The name does not have to be unique, and it's updatable.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="isAutoPurgeEnabled")
    def is_auto_purge_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Indicates if auto purge is enabled on the target database, which helps delete audit data in the target database every seven days so that the database's audit trail does not become too large.
        """
        return pulumi.get(self, "is_auto_purge_enabled")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        Details about the current state of the audit trail in Data Safe.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="resumeTrigger")
    def resume_trigger(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        (Updatable) An optional property when set to true triggers Resume.
        """
        return pulumi.get(self, "resume_trigger")

    @_builtins.property
    @pulumi.getter(name="startTrigger")
    def start_trigger(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        (Updatable) An optional property when set to true triggers Start.
        """
        return pulumi.get(self, "start_trigger")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The target state for the Audit Trail Management. Could be set to `ACTIVE` or `INACTIVE`.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The current sub-state of the audit trail.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="stopTrigger")
    def stop_trigger(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        (Updatable) An optional property when set to true triggers Stop.
        """
        return pulumi.get(self, "stop_trigger")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The OCID of the target.
        """
        return pulumi.get(self, "target_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the audit trail was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeLastCollected")
    def time_last_collected(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time until when the audit events were collected from the target database by the Data Safe audit trail  collection process, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_last_collected")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the audit trail was updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="trailLocation")
    def trail_location(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An audit trail location represents the source of audit records that provides documentary evidence of the sequence of activities in the target database.
        """
        return pulumi.get(self, "trail_location")

    @_builtins.property
    @pulumi.getter(name="workRequestId")
    def work_request_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the workrequest for audit trail which collects audit records.
        """
        return pulumi.get(self, "work_request_id")

