# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAttributeSetResult',
    'AwaitableGetAttributeSetResult',
    'get_attribute_set',
    'get_attribute_set_output',
]

@pulumi.output_type
class GetAttributeSetResult:
    """
    A collection of values returned by getAttributeSet.
    """
    def __init__(__self__, attribute_set_id=None, attribute_set_type=None, attribute_set_values=None, compartment_id=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, id=None, in_use=None, is_user_defined=None, state=None, system_tags=None, time_created=None, time_updated=None):
        if attribute_set_id and not isinstance(attribute_set_id, str):
            raise TypeError("Expected argument 'attribute_set_id' to be a str")
        pulumi.set(__self__, "attribute_set_id", attribute_set_id)
        if attribute_set_type and not isinstance(attribute_set_type, str):
            raise TypeError("Expected argument 'attribute_set_type' to be a str")
        pulumi.set(__self__, "attribute_set_type", attribute_set_type)
        if attribute_set_values and not isinstance(attribute_set_values, list):
            raise TypeError("Expected argument 'attribute_set_values' to be a list")
        pulumi.set(__self__, "attribute_set_values", attribute_set_values)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if in_use and not isinstance(in_use, str):
            raise TypeError("Expected argument 'in_use' to be a str")
        pulumi.set(__self__, "in_use", in_use)
        if is_user_defined and not isinstance(is_user_defined, bool):
            raise TypeError("Expected argument 'is_user_defined' to be a bool")
        pulumi.set(__self__, "is_user_defined", is_user_defined)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="attributeSetId")
    def attribute_set_id(self) -> _builtins.str:
        return pulumi.get(self, "attribute_set_id")

    @_builtins.property
    @pulumi.getter(name="attributeSetType")
    def attribute_set_type(self) -> _builtins.str:
        """
        The type of attribute set.
        """
        return pulumi.get(self, "attribute_set_type")

    @_builtins.property
    @pulumi.getter(name="attributeSetValues")
    def attribute_set_values(self) -> Sequence[_builtins.str]:
        """
        The list of values in an attribute set
        """
        return pulumi.get(self, "attribute_set_values")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment where the attribute set is stored.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of an attribute set.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The display name of an attribute set. The name does not have to be unique, and is changeable.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The OCID of an attribute set.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="inUse")
    def in_use(self) -> _builtins.str:
        """
        Indicates whether the attribute set is in use by other resource.
        """
        return pulumi.get(self, "in_use")

    @_builtins.property
    @pulumi.getter(name="isUserDefined")
    def is_user_defined(self) -> _builtins.bool:
        """
        A boolean flag indicating to list user defined or seeded attribute sets.
        """
        return pulumi.get(self, "is_user_defined")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of an attribute set.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time an attribute set was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time an attribute set was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetAttributeSetResult(GetAttributeSetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAttributeSetResult(
            attribute_set_id=self.attribute_set_id,
            attribute_set_type=self.attribute_set_type,
            attribute_set_values=self.attribute_set_values,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            in_use=self.in_use,
            is_user_defined=self.is_user_defined,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_attribute_set(attribute_set_id: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAttributeSetResult:
    """
    This data source provides details about a specific Attribute Set resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of the specified attribute set.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_attribute_set = oci.DataSafe.get_attribute_set(attribute_set_id=test_attribute_set_oci_data_safe_attribute_set["id"])
    ```


    :param _builtins.str attribute_set_id: OCID of an attribute set.
    """
    __args__ = dict()
    __args__['attributeSetId'] = attribute_set_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getAttributeSet:getAttributeSet', __args__, opts=opts, typ=GetAttributeSetResult).value

    return AwaitableGetAttributeSetResult(
        attribute_set_id=pulumi.get(__ret__, 'attribute_set_id'),
        attribute_set_type=pulumi.get(__ret__, 'attribute_set_type'),
        attribute_set_values=pulumi.get(__ret__, 'attribute_set_values'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        in_use=pulumi.get(__ret__, 'in_use'),
        is_user_defined=pulumi.get(__ret__, 'is_user_defined'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_attribute_set_output(attribute_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAttributeSetResult]:
    """
    This data source provides details about a specific Attribute Set resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of the specified attribute set.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_attribute_set = oci.DataSafe.get_attribute_set(attribute_set_id=test_attribute_set_oci_data_safe_attribute_set["id"])
    ```


    :param _builtins.str attribute_set_id: OCID of an attribute set.
    """
    __args__ = dict()
    __args__['attributeSetId'] = attribute_set_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getAttributeSet:getAttributeSet', __args__, opts=opts, typ=GetAttributeSetResult)
    return __ret__.apply(lambda __response__: GetAttributeSetResult(
        attribute_set_id=pulumi.get(__response__, 'attribute_set_id'),
        attribute_set_type=pulumi.get(__response__, 'attribute_set_type'),
        attribute_set_values=pulumi.get(__response__, 'attribute_set_values'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        in_use=pulumi.get(__response__, 'in_use'),
        is_user_defined=pulumi.get(__response__, 'is_user_defined'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
