# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAttributeSetsResult',
    'AwaitableGetAttributeSetsResult',
    'get_attribute_sets',
    'get_attribute_sets_output',
]

@pulumi.output_type
class GetAttributeSetsResult:
    """
    A collection of values returned by getAttributeSets.
    """
    def __init__(__self__, access_level=None, attribute_set_collections=None, attribute_set_id=None, attribute_set_type=None, compartment_id=None, compartment_id_in_subtree=None, display_name=None, filters=None, id=None, in_use=None, is_user_defined=None, state=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if attribute_set_collections and not isinstance(attribute_set_collections, list):
            raise TypeError("Expected argument 'attribute_set_collections' to be a list")
        pulumi.set(__self__, "attribute_set_collections", attribute_set_collections)
        if attribute_set_id and not isinstance(attribute_set_id, str):
            raise TypeError("Expected argument 'attribute_set_id' to be a str")
        pulumi.set(__self__, "attribute_set_id", attribute_set_id)
        if attribute_set_type and not isinstance(attribute_set_type, str):
            raise TypeError("Expected argument 'attribute_set_type' to be a str")
        pulumi.set(__self__, "attribute_set_type", attribute_set_type)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if in_use and not isinstance(in_use, str):
            raise TypeError("Expected argument 'in_use' to be a str")
        pulumi.set(__self__, "in_use", in_use)
        if is_user_defined and not isinstance(is_user_defined, bool):
            raise TypeError("Expected argument 'is_user_defined' to be a bool")
        pulumi.set(__self__, "is_user_defined", is_user_defined)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "access_level")

    @_builtins.property
    @pulumi.getter(name="attributeSetCollections")
    def attribute_set_collections(self) -> Sequence['outputs.GetAttributeSetsAttributeSetCollectionResult']:
        """
        The list of attribute_set_collection.
        """
        return pulumi.get(self, "attribute_set_collections")

    @_builtins.property
    @pulumi.getter(name="attributeSetId")
    def attribute_set_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "attribute_set_id")

    @_builtins.property
    @pulumi.getter(name="attributeSetType")
    def attribute_set_type(self) -> Optional[_builtins.str]:
        """
        The type of attribute set.
        """
        return pulumi.get(self, "attribute_set_type")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment where the attribute set is stored.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        The display name of an attribute set. The name does not have to be unique, and is changeable.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAttributeSetsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="inUse")
    def in_use(self) -> Optional[_builtins.str]:
        """
        Indicates whether the attribute set is in use by other resource.
        """
        return pulumi.get(self, "in_use")

    @_builtins.property
    @pulumi.getter(name="isUserDefined")
    def is_user_defined(self) -> Optional[_builtins.bool]:
        """
        A boolean flag indicating to list user defined or seeded attribute sets.
        """
        return pulumi.get(self, "is_user_defined")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of an attribute set.
        """
        return pulumi.get(self, "state")


class AwaitableGetAttributeSetsResult(GetAttributeSetsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAttributeSetsResult(
            access_level=self.access_level,
            attribute_set_collections=self.attribute_set_collections,
            attribute_set_id=self.attribute_set_id,
            attribute_set_type=self.attribute_set_type,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            in_use=self.in_use,
            is_user_defined=self.is_user_defined,
            state=self.state)


def get_attribute_sets(access_level: Optional[_builtins.str] = None,
                       attribute_set_id: Optional[_builtins.str] = None,
                       attribute_set_type: Optional[_builtins.str] = None,
                       compartment_id: Optional[_builtins.str] = None,
                       compartment_id_in_subtree: Optional[_builtins.bool] = None,
                       display_name: Optional[_builtins.str] = None,
                       filters: Optional[Sequence[Union['GetAttributeSetsFilterArgs', 'GetAttributeSetsFilterArgsDict']]] = None,
                       in_use: Optional[_builtins.str] = None,
                       is_user_defined: Optional[_builtins.bool] = None,
                       state: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAttributeSetsResult:
    """
    This data source provides the list of Attribute Sets in Oracle Cloud Infrastructure Data Safe service.

    Retrieves the list of attribute sets.

    The ListAttributeSets operation returns only the attribute sets in the specified `compartmentId`.

    The parameter `accessLevel` specifies whether to return only those compartments for which the
    requester has INSPECT permissions on at least one resource directly
    or indirectly (ACCESSIBLE) (the resource can be in a subcompartment) or to return Not Authorized if
    Principal doesn't have access to even one of the child compartments. This is valid only when
    `compartmentIdInSubtree` is set to `true`.

    The parameter `compartmentIdInSubtree` applies when you perform ListAttributeSet on the
    `compartmentId` passed and when it is set to true, the entire hierarchy of compartments can be returned.
    To get a full list of all compartments and subcompartments in the tenancy (root compartment),
    set the parameter `compartmentIdInSubtree` to true and `accessLevel` to ACCESSIBLE.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_attribute_sets = oci.DataSafe.get_attribute_sets(compartment_id=compartment_id,
        access_level=attribute_set_access_level,
        attribute_set_id=test_attribute_set["id"],
        attribute_set_type=attribute_set_attribute_set_type,
        compartment_id_in_subtree=attribute_set_compartment_id_in_subtree,
        display_name=attribute_set_display_name,
        in_use=attribute_set_in_use,
        is_user_defined=attribute_set_is_user_defined,
        state=attribute_set_state)
    ```


    :param _builtins.str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param _builtins.str attribute_set_id: A filter to return only attribute set resources that matches the specified attribute set OCID query param.
    :param _builtins.str attribute_set_type: A filter to return only attribute set resources that matches the specified attribute set type query param.
    :param _builtins.str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param _builtins.bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param _builtins.str display_name: A filter to return only resources that match the specified display name.
    :param _builtins.str in_use: A filter to return attribute set resources that are in use by other associated resources.
    :param _builtins.bool is_user_defined: A filter to return user defined or seeded attribute set resources that matches the specified is user defined query param. A true value indicates user defined attribute set.
    :param _builtins.str state: The current state of an attribute set.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['attributeSetId'] = attribute_set_id
    __args__['attributeSetType'] = attribute_set_type
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['inUse'] = in_use
    __args__['isUserDefined'] = is_user_defined
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getAttributeSets:getAttributeSets', __args__, opts=opts, typ=GetAttributeSetsResult).value

    return AwaitableGetAttributeSetsResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        attribute_set_collections=pulumi.get(__ret__, 'attribute_set_collections'),
        attribute_set_id=pulumi.get(__ret__, 'attribute_set_id'),
        attribute_set_type=pulumi.get(__ret__, 'attribute_set_type'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        in_use=pulumi.get(__ret__, 'in_use'),
        is_user_defined=pulumi.get(__ret__, 'is_user_defined'),
        state=pulumi.get(__ret__, 'state'))
def get_attribute_sets_output(access_level: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              attribute_set_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              attribute_set_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                              compartment_id_in_subtree: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                              display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAttributeSetsFilterArgs', 'GetAttributeSetsFilterArgsDict']]]]] = None,
                              in_use: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              is_user_defined: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                              state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAttributeSetsResult]:
    """
    This data source provides the list of Attribute Sets in Oracle Cloud Infrastructure Data Safe service.

    Retrieves the list of attribute sets.

    The ListAttributeSets operation returns only the attribute sets in the specified `compartmentId`.

    The parameter `accessLevel` specifies whether to return only those compartments for which the
    requester has INSPECT permissions on at least one resource directly
    or indirectly (ACCESSIBLE) (the resource can be in a subcompartment) or to return Not Authorized if
    Principal doesn't have access to even one of the child compartments. This is valid only when
    `compartmentIdInSubtree` is set to `true`.

    The parameter `compartmentIdInSubtree` applies when you perform ListAttributeSet on the
    `compartmentId` passed and when it is set to true, the entire hierarchy of compartments can be returned.
    To get a full list of all compartments and subcompartments in the tenancy (root compartment),
    set the parameter `compartmentIdInSubtree` to true and `accessLevel` to ACCESSIBLE.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_attribute_sets = oci.DataSafe.get_attribute_sets(compartment_id=compartment_id,
        access_level=attribute_set_access_level,
        attribute_set_id=test_attribute_set["id"],
        attribute_set_type=attribute_set_attribute_set_type,
        compartment_id_in_subtree=attribute_set_compartment_id_in_subtree,
        display_name=attribute_set_display_name,
        in_use=attribute_set_in_use,
        is_user_defined=attribute_set_is_user_defined,
        state=attribute_set_state)
    ```


    :param _builtins.str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param _builtins.str attribute_set_id: A filter to return only attribute set resources that matches the specified attribute set OCID query param.
    :param _builtins.str attribute_set_type: A filter to return only attribute set resources that matches the specified attribute set type query param.
    :param _builtins.str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param _builtins.bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param _builtins.str display_name: A filter to return only resources that match the specified display name.
    :param _builtins.str in_use: A filter to return attribute set resources that are in use by other associated resources.
    :param _builtins.bool is_user_defined: A filter to return user defined or seeded attribute set resources that matches the specified is user defined query param. A true value indicates user defined attribute set.
    :param _builtins.str state: The current state of an attribute set.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['attributeSetId'] = attribute_set_id
    __args__['attributeSetType'] = attribute_set_type
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['inUse'] = in_use
    __args__['isUserDefined'] = is_user_defined
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getAttributeSets:getAttributeSets', __args__, opts=opts, typ=GetAttributeSetsResult)
    return __ret__.apply(lambda __response__: GetAttributeSetsResult(
        access_level=pulumi.get(__response__, 'access_level'),
        attribute_set_collections=pulumi.get(__response__, 'attribute_set_collections'),
        attribute_set_id=pulumi.get(__response__, 'attribute_set_id'),
        attribute_set_type=pulumi.get(__response__, 'attribute_set_type'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        in_use=pulumi.get(__response__, 'in_use'),
        is_user_defined=pulumi.get(__response__, 'is_user_defined'),
        state=pulumi.get(__response__, 'state')))
