# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAuditProfilesResult',
    'AwaitableGetAuditProfilesResult',
    'get_audit_profiles',
    'get_audit_profiles_output',
]

@pulumi.output_type
class GetAuditProfilesResult:
    """
    A collection of values returned by getAuditProfiles.
    """
    def __init__(__self__, access_level=None, audit_collected_volume_greater_than_or_equal_to=None, audit_profile_collections=None, audit_profile_id=None, compartment_id=None, compartment_id_in_subtree=None, display_name=None, filters=None, id=None, is_override_global_retention_setting=None, is_paid_usage_enabled=None, state=None, target_database_group_id=None, target_id=None, target_type=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if audit_collected_volume_greater_than_or_equal_to and not isinstance(audit_collected_volume_greater_than_or_equal_to, str):
            raise TypeError("Expected argument 'audit_collected_volume_greater_than_or_equal_to' to be a str")
        pulumi.set(__self__, "audit_collected_volume_greater_than_or_equal_to", audit_collected_volume_greater_than_or_equal_to)
        if audit_profile_collections and not isinstance(audit_profile_collections, list):
            raise TypeError("Expected argument 'audit_profile_collections' to be a list")
        pulumi.set(__self__, "audit_profile_collections", audit_profile_collections)
        if audit_profile_id and not isinstance(audit_profile_id, str):
            raise TypeError("Expected argument 'audit_profile_id' to be a str")
        pulumi.set(__self__, "audit_profile_id", audit_profile_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_override_global_retention_setting and not isinstance(is_override_global_retention_setting, bool):
            raise TypeError("Expected argument 'is_override_global_retention_setting' to be a bool")
        pulumi.set(__self__, "is_override_global_retention_setting", is_override_global_retention_setting)
        if is_paid_usage_enabled and not isinstance(is_paid_usage_enabled, bool):
            raise TypeError("Expected argument 'is_paid_usage_enabled' to be a bool")
        pulumi.set(__self__, "is_paid_usage_enabled", is_paid_usage_enabled)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if target_database_group_id and not isinstance(target_database_group_id, str):
            raise TypeError("Expected argument 'target_database_group_id' to be a str")
        pulumi.set(__self__, "target_database_group_id", target_database_group_id)
        if target_id and not isinstance(target_id, str):
            raise TypeError("Expected argument 'target_id' to be a str")
        pulumi.set(__self__, "target_id", target_id)
        if target_type and not isinstance(target_type, str):
            raise TypeError("Expected argument 'target_type' to be a str")
        pulumi.set(__self__, "target_type", target_type)

    @_builtins.property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "access_level")

    @_builtins.property
    @pulumi.getter(name="auditCollectedVolumeGreaterThanOrEqualTo")
    def audit_collected_volume_greater_than_or_equal_to(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "audit_collected_volume_greater_than_or_equal_to")

    @_builtins.property
    @pulumi.getter(name="auditProfileCollections")
    def audit_profile_collections(self) -> Sequence['outputs.GetAuditProfilesAuditProfileCollectionResult']:
        """
        The list of audit_profile_collection.
        """
        return pulumi.get(self, "audit_profile_collections")

    @_builtins.property
    @pulumi.getter(name="auditProfileId")
    def audit_profile_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the  parent audit.
        """
        return pulumi.get(self, "audit_profile_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment that contains the audit profile.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        The display name of the audit profile.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAuditProfilesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isOverrideGlobalRetentionSetting")
    def is_override_global_retention_setting(self) -> Optional[_builtins.bool]:
        """
        Indicates whether audit retention settings like online and offline months set at the  target level override both the global settings and the target group level audit retention settings.
        """
        return pulumi.get(self, "is_override_global_retention_setting")

    @_builtins.property
    @pulumi.getter(name="isPaidUsageEnabled")
    def is_paid_usage_enabled(self) -> Optional[_builtins.bool]:
        """
        Indicates if you want to continue collecting audit records beyond the free limit of one million audit records per month per target database, potentially incurring additional charges. The default value is inherited from the global settings.  You can change at the global level or at the target level.
        """
        return pulumi.get(self, "is_paid_usage_enabled")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the audit profile.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="targetDatabaseGroupId")
    def target_database_group_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "target_database_group_id")

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the target database or target database group for which the audit profile is created.
        """
        return pulumi.get(self, "target_id")

    @_builtins.property
    @pulumi.getter(name="targetType")
    def target_type(self) -> Optional[_builtins.str]:
        """
        The resource type that is represented by the audit profile.
        """
        return pulumi.get(self, "target_type")


class AwaitableGetAuditProfilesResult(GetAuditProfilesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAuditProfilesResult(
            access_level=self.access_level,
            audit_collected_volume_greater_than_or_equal_to=self.audit_collected_volume_greater_than_or_equal_to,
            audit_profile_collections=self.audit_profile_collections,
            audit_profile_id=self.audit_profile_id,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            is_override_global_retention_setting=self.is_override_global_retention_setting,
            is_paid_usage_enabled=self.is_paid_usage_enabled,
            state=self.state,
            target_database_group_id=self.target_database_group_id,
            target_id=self.target_id,
            target_type=self.target_type)


def get_audit_profiles(access_level: Optional[_builtins.str] = None,
                       audit_collected_volume_greater_than_or_equal_to: Optional[_builtins.str] = None,
                       audit_profile_id: Optional[_builtins.str] = None,
                       compartment_id: Optional[_builtins.str] = None,
                       compartment_id_in_subtree: Optional[_builtins.bool] = None,
                       display_name: Optional[_builtins.str] = None,
                       filters: Optional[Sequence[Union['GetAuditProfilesFilterArgs', 'GetAuditProfilesFilterArgsDict']]] = None,
                       is_override_global_retention_setting: Optional[_builtins.bool] = None,
                       is_paid_usage_enabled: Optional[_builtins.bool] = None,
                       state: Optional[_builtins.str] = None,
                       target_database_group_id: Optional[_builtins.str] = None,
                       target_id: Optional[_builtins.str] = None,
                       target_type: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAuditProfilesResult:
    """
    This data source provides the list of Audit Profiles in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of all audit profiles.

    The ListAuditProfiles operation returns only the audit profiles in the specified `compartmentId`.
    The list does not include any subcompartments of the compartmentId passed.

    The parameter `accessLevel` specifies whether to return only those compartments for which the
    requestor has INSPECT permissions on at least one resource directly
    or indirectly (ACCESSIBLE) (the resource can be in a subcompartment) or to return Not Authorized if
    Principal doesn't have access to even one of the child compartments. This is valid only when
    `compartmentIdInSubtree` is set to `true`.

    The parameter `compartmentIdInSubtree` applies when you perform ListAuditProfiles on the
    `compartmentId` passed and when it is set to true, the entire hierarchy of compartments can be returned.
    To get a full list of all compartments and subcompartments in the tenancy (root compartment),
    set the parameter `compartmentIdInSubtree` to true and `accessLevel` to ACCESSIBLE.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_audit_profiles = oci.DataSafe.get_audit_profiles(compartment_id=compartment_id,
        access_level=audit_profile_access_level,
        audit_collected_volume_greater_than_or_equal_to=audit_profile_audit_collected_volume_greater_than_or_equal_to,
        audit_profile_id=test_audit_profile["id"],
        compartment_id_in_subtree=audit_profile_compartment_id_in_subtree,
        display_name=audit_profile_display_name,
        is_override_global_retention_setting=audit_profile_is_override_global_retention_setting,
        is_paid_usage_enabled=audit_profile_is_paid_usage_enabled,
        state=audit_profile_state,
        target_database_group_id=test_target_database_group["id"],
        target_id=test_target["id"],
        target_type=audit_profile_target_type)
    ```


    :param _builtins.str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param _builtins.str audit_collected_volume_greater_than_or_equal_to: A filter to return only items that have count of audit records collected greater than or equal to the specified value.
    :param _builtins.str audit_profile_id: A optional filter to return only resources that match the specified id.
    :param _builtins.str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param _builtins.bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param _builtins.str display_name: A filter to return only resources that match the specified display name.
    :param _builtins.bool is_override_global_retention_setting: A optional filter to return only resources that match the specified retention configured value.
    :param _builtins.bool is_paid_usage_enabled: Indicates if you want to continue audit record collection beyond the free limit of one million audit records per month per target database, incurring additional charges. The default value is inherited from the global settings. You can change at the global level or at the target level.
    :param _builtins.str state: A optional filter to return only resources that match the specified lifecycle state.
    :param _builtins.str target_database_group_id: A filter to return the target database group that matches the specified OCID.
    :param _builtins.str target_id: A filter to return only items related to a specific target OCID.
    :param _builtins.str target_type: A optional filter to return only resources that belong to the specified audit profile type.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['auditCollectedVolumeGreaterThanOrEqualTo'] = audit_collected_volume_greater_than_or_equal_to
    __args__['auditProfileId'] = audit_profile_id
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['isOverrideGlobalRetentionSetting'] = is_override_global_retention_setting
    __args__['isPaidUsageEnabled'] = is_paid_usage_enabled
    __args__['state'] = state
    __args__['targetDatabaseGroupId'] = target_database_group_id
    __args__['targetId'] = target_id
    __args__['targetType'] = target_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getAuditProfiles:getAuditProfiles', __args__, opts=opts, typ=GetAuditProfilesResult).value

    return AwaitableGetAuditProfilesResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        audit_collected_volume_greater_than_or_equal_to=pulumi.get(__ret__, 'audit_collected_volume_greater_than_or_equal_to'),
        audit_profile_collections=pulumi.get(__ret__, 'audit_profile_collections'),
        audit_profile_id=pulumi.get(__ret__, 'audit_profile_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_override_global_retention_setting=pulumi.get(__ret__, 'is_override_global_retention_setting'),
        is_paid_usage_enabled=pulumi.get(__ret__, 'is_paid_usage_enabled'),
        state=pulumi.get(__ret__, 'state'),
        target_database_group_id=pulumi.get(__ret__, 'target_database_group_id'),
        target_id=pulumi.get(__ret__, 'target_id'),
        target_type=pulumi.get(__ret__, 'target_type'))
def get_audit_profiles_output(access_level: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              audit_collected_volume_greater_than_or_equal_to: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              audit_profile_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                              compartment_id_in_subtree: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                              display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAuditProfilesFilterArgs', 'GetAuditProfilesFilterArgsDict']]]]] = None,
                              is_override_global_retention_setting: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                              is_paid_usage_enabled: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                              state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              target_database_group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              target_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              target_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAuditProfilesResult]:
    """
    This data source provides the list of Audit Profiles in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of all audit profiles.

    The ListAuditProfiles operation returns only the audit profiles in the specified `compartmentId`.
    The list does not include any subcompartments of the compartmentId passed.

    The parameter `accessLevel` specifies whether to return only those compartments for which the
    requestor has INSPECT permissions on at least one resource directly
    or indirectly (ACCESSIBLE) (the resource can be in a subcompartment) or to return Not Authorized if
    Principal doesn't have access to even one of the child compartments. This is valid only when
    `compartmentIdInSubtree` is set to `true`.

    The parameter `compartmentIdInSubtree` applies when you perform ListAuditProfiles on the
    `compartmentId` passed and when it is set to true, the entire hierarchy of compartments can be returned.
    To get a full list of all compartments and subcompartments in the tenancy (root compartment),
    set the parameter `compartmentIdInSubtree` to true and `accessLevel` to ACCESSIBLE.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_audit_profiles = oci.DataSafe.get_audit_profiles(compartment_id=compartment_id,
        access_level=audit_profile_access_level,
        audit_collected_volume_greater_than_or_equal_to=audit_profile_audit_collected_volume_greater_than_or_equal_to,
        audit_profile_id=test_audit_profile["id"],
        compartment_id_in_subtree=audit_profile_compartment_id_in_subtree,
        display_name=audit_profile_display_name,
        is_override_global_retention_setting=audit_profile_is_override_global_retention_setting,
        is_paid_usage_enabled=audit_profile_is_paid_usage_enabled,
        state=audit_profile_state,
        target_database_group_id=test_target_database_group["id"],
        target_id=test_target["id"],
        target_type=audit_profile_target_type)
    ```


    :param _builtins.str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param _builtins.str audit_collected_volume_greater_than_or_equal_to: A filter to return only items that have count of audit records collected greater than or equal to the specified value.
    :param _builtins.str audit_profile_id: A optional filter to return only resources that match the specified id.
    :param _builtins.str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param _builtins.bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param _builtins.str display_name: A filter to return only resources that match the specified display name.
    :param _builtins.bool is_override_global_retention_setting: A optional filter to return only resources that match the specified retention configured value.
    :param _builtins.bool is_paid_usage_enabled: Indicates if you want to continue audit record collection beyond the free limit of one million audit records per month per target database, incurring additional charges. The default value is inherited from the global settings. You can change at the global level or at the target level.
    :param _builtins.str state: A optional filter to return only resources that match the specified lifecycle state.
    :param _builtins.str target_database_group_id: A filter to return the target database group that matches the specified OCID.
    :param _builtins.str target_id: A filter to return only items related to a specific target OCID.
    :param _builtins.str target_type: A optional filter to return only resources that belong to the specified audit profile type.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['auditCollectedVolumeGreaterThanOrEqualTo'] = audit_collected_volume_greater_than_or_equal_to
    __args__['auditProfileId'] = audit_profile_id
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['isOverrideGlobalRetentionSetting'] = is_override_global_retention_setting
    __args__['isPaidUsageEnabled'] = is_paid_usage_enabled
    __args__['state'] = state
    __args__['targetDatabaseGroupId'] = target_database_group_id
    __args__['targetId'] = target_id
    __args__['targetType'] = target_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getAuditProfiles:getAuditProfiles', __args__, opts=opts, typ=GetAuditProfilesResult)
    return __ret__.apply(lambda __response__: GetAuditProfilesResult(
        access_level=pulumi.get(__response__, 'access_level'),
        audit_collected_volume_greater_than_or_equal_to=pulumi.get(__response__, 'audit_collected_volume_greater_than_or_equal_to'),
        audit_profile_collections=pulumi.get(__response__, 'audit_profile_collections'),
        audit_profile_id=pulumi.get(__response__, 'audit_profile_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        is_override_global_retention_setting=pulumi.get(__response__, 'is_override_global_retention_setting'),
        is_paid_usage_enabled=pulumi.get(__response__, 'is_paid_usage_enabled'),
        state=pulumi.get(__response__, 'state'),
        target_database_group_id=pulumi.get(__response__, 'target_database_group_id'),
        target_id=pulumi.get(__response__, 'target_id'),
        target_type=pulumi.get(__response__, 'target_type')))
