# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSecurityPolicyConfigResult',
    'AwaitableGetSecurityPolicyConfigResult',
    'get_security_policy_config',
    'get_security_policy_config_output',
]

@pulumi.output_type
class GetSecurityPolicyConfigResult:
    """
    A collection of values returned by getSecurityPolicyConfig.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, description=None, display_name=None, firewall_configs=None, freeform_tags=None, id=None, lifecycle_details=None, security_policy_config_id=None, security_policy_id=None, state=None, system_tags=None, time_created=None, time_updated=None, unified_audit_policy_configs=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if firewall_configs and not isinstance(firewall_configs, list):
            raise TypeError("Expected argument 'firewall_configs' to be a list")
        pulumi.set(__self__, "firewall_configs", firewall_configs)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if security_policy_config_id and not isinstance(security_policy_config_id, str):
            raise TypeError("Expected argument 'security_policy_config_id' to be a str")
        pulumi.set(__self__, "security_policy_config_id", security_policy_config_id)
        if security_policy_id and not isinstance(security_policy_id, str):
            raise TypeError("Expected argument 'security_policy_id' to be a str")
        pulumi.set(__self__, "security_policy_id", security_policy_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if unified_audit_policy_configs and not isinstance(unified_audit_policy_configs, list):
            raise TypeError("Expected argument 'unified_audit_policy_configs' to be a list")
        pulumi.set(__self__, "unified_audit_policy_configs", unified_audit_policy_configs)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment containing the security policy configuration.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the security policy configuration.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The display name of the security policy configuration.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="firewallConfigs")
    def firewall_configs(self) -> Sequence['outputs.GetSecurityPolicyConfigFirewallConfigResult']:
        """
        The SQL Firewall related configurations.
        """
        return pulumi.get(self, "firewall_configs")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The OCID of the security policy configuration.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        Details about the current state of the security policy configuration.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="securityPolicyConfigId")
    def security_policy_config_id(self) -> _builtins.str:
        return pulumi.get(self, "security_policy_config_id")

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> _builtins.str:
        """
        The OCID of the security policy corresponding to the security policy configuration.
        """
        return pulumi.get(self, "security_policy_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the security policy configuration.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time the security policy configuration was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the security policy configuration was last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="unifiedAuditPolicyConfigs")
    def unified_audit_policy_configs(self) -> Sequence['outputs.GetSecurityPolicyConfigUnifiedAuditPolicyConfigResult']:
        """
        The unified audit policy related configurations.
        """
        return pulumi.get(self, "unified_audit_policy_configs")


class AwaitableGetSecurityPolicyConfigResult(GetSecurityPolicyConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecurityPolicyConfigResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            firewall_configs=self.firewall_configs,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            security_policy_config_id=self.security_policy_config_id,
            security_policy_id=self.security_policy_id,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            unified_audit_policy_configs=self.unified_audit_policy_configs)


def get_security_policy_config(security_policy_config_id: Optional[_builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecurityPolicyConfigResult:
    """
    This data source provides details about a specific Security Policy Config resource in Oracle Cloud Infrastructure Data Safe service.

    Gets a security policy configuration by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_security_policy_config = oci.DataSafe.get_security_policy_config(security_policy_config_id=test_security_policy_config_oci_data_safe_security_policy_config["id"])
    ```


    :param _builtins.str security_policy_config_id: The OCID of the security policy configuration resource.
    """
    __args__ = dict()
    __args__['securityPolicyConfigId'] = security_policy_config_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getSecurityPolicyConfig:getSecurityPolicyConfig', __args__, opts=opts, typ=GetSecurityPolicyConfigResult).value

    return AwaitableGetSecurityPolicyConfigResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        firewall_configs=pulumi.get(__ret__, 'firewall_configs'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        security_policy_config_id=pulumi.get(__ret__, 'security_policy_config_id'),
        security_policy_id=pulumi.get(__ret__, 'security_policy_id'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        unified_audit_policy_configs=pulumi.get(__ret__, 'unified_audit_policy_configs'))
def get_security_policy_config_output(security_policy_config_id: Optional[pulumi.Input[_builtins.str]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecurityPolicyConfigResult]:
    """
    This data source provides details about a specific Security Policy Config resource in Oracle Cloud Infrastructure Data Safe service.

    Gets a security policy configuration by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_security_policy_config = oci.DataSafe.get_security_policy_config(security_policy_config_id=test_security_policy_config_oci_data_safe_security_policy_config["id"])
    ```


    :param _builtins.str security_policy_config_id: The OCID of the security policy configuration resource.
    """
    __args__ = dict()
    __args__['securityPolicyConfigId'] = security_policy_config_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getSecurityPolicyConfig:getSecurityPolicyConfig', __args__, opts=opts, typ=GetSecurityPolicyConfigResult)
    return __ret__.apply(lambda __response__: GetSecurityPolicyConfigResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        firewall_configs=pulumi.get(__response__, 'firewall_configs'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        security_policy_config_id=pulumi.get(__response__, 'security_policy_config_id'),
        security_policy_id=pulumi.get(__response__, 'security_policy_id'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        unified_audit_policy_configs=pulumi.get(__response__, 'unified_audit_policy_configs')))
