# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSensitiveTypesResult',
    'AwaitableGetSensitiveTypesResult',
    'get_sensitive_types',
    'get_sensitive_types_output',
]

@pulumi.output_type
class GetSensitiveTypesResult:
    """
    A collection of values returned by getSensitiveTypes.
    """
    def __init__(__self__, access_level=None, compartment_id=None, compartment_id_in_subtree=None, default_masking_format_id=None, display_name=None, entity_type=None, filters=None, id=None, is_common=None, parent_category_id=None, sensitive_type_collections=None, sensitive_type_id=None, sensitive_type_source=None, state=None, time_created_greater_than_or_equal_to=None, time_created_less_than=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if default_masking_format_id and not isinstance(default_masking_format_id, str):
            raise TypeError("Expected argument 'default_masking_format_id' to be a str")
        pulumi.set(__self__, "default_masking_format_id", default_masking_format_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if entity_type and not isinstance(entity_type, str):
            raise TypeError("Expected argument 'entity_type' to be a str")
        pulumi.set(__self__, "entity_type", entity_type)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_common and not isinstance(is_common, bool):
            raise TypeError("Expected argument 'is_common' to be a bool")
        pulumi.set(__self__, "is_common", is_common)
        if parent_category_id and not isinstance(parent_category_id, str):
            raise TypeError("Expected argument 'parent_category_id' to be a str")
        pulumi.set(__self__, "parent_category_id", parent_category_id)
        if sensitive_type_collections and not isinstance(sensitive_type_collections, list):
            raise TypeError("Expected argument 'sensitive_type_collections' to be a list")
        pulumi.set(__self__, "sensitive_type_collections", sensitive_type_collections)
        if sensitive_type_id and not isinstance(sensitive_type_id, str):
            raise TypeError("Expected argument 'sensitive_type_id' to be a str")
        pulumi.set(__self__, "sensitive_type_id", sensitive_type_id)
        if sensitive_type_source and not isinstance(sensitive_type_source, str):
            raise TypeError("Expected argument 'sensitive_type_source' to be a str")
        pulumi.set(__self__, "sensitive_type_source", sensitive_type_source)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created_greater_than_or_equal_to and not isinstance(time_created_greater_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_created_greater_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_created_greater_than_or_equal_to", time_created_greater_than_or_equal_to)
        if time_created_less_than and not isinstance(time_created_less_than, str):
            raise TypeError("Expected argument 'time_created_less_than' to be a str")
        pulumi.set(__self__, "time_created_less_than", time_created_less_than)

    @_builtins.property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "access_level")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment that contains the sensitive type.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @_builtins.property
    @pulumi.getter(name="defaultMaskingFormatId")
    def default_masking_format_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the library masking format that should be used to mask the sensitive columns associated with the sensitive type.
        """
        return pulumi.get(self, "default_masking_format_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        The display name of the sensitive type.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> Optional[_builtins.str]:
        """
        The entity type. It can be either a sensitive type with regular expressions or a sensitive category used for grouping similar sensitive types.
        """
        return pulumi.get(self, "entity_type")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSensitiveTypesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isCommon")
    def is_common(self) -> Optional[_builtins.bool]:
        """
        Specifies whether the sensitive type is common. Common sensitive types belong to  library sensitive types which are frequently used to perform sensitive data discovery.
        """
        return pulumi.get(self, "is_common")

    @_builtins.property
    @pulumi.getter(name="parentCategoryId")
    def parent_category_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the parent sensitive category.
        """
        return pulumi.get(self, "parent_category_id")

    @_builtins.property
    @pulumi.getter(name="sensitiveTypeCollections")
    def sensitive_type_collections(self) -> Sequence['outputs.GetSensitiveTypesSensitiveTypeCollectionResult']:
        """
        The list of sensitive_type_collection.
        """
        return pulumi.get(self, "sensitive_type_collections")

    @_builtins.property
    @pulumi.getter(name="sensitiveTypeId")
    def sensitive_type_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "sensitive_type_id")

    @_builtins.property
    @pulumi.getter(name="sensitiveTypeSource")
    def sensitive_type_source(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "sensitive_type_source")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the sensitive type.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreatedGreaterThanOrEqualTo")
    def time_created_greater_than_or_equal_to(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "time_created_greater_than_or_equal_to")

    @_builtins.property
    @pulumi.getter(name="timeCreatedLessThan")
    def time_created_less_than(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "time_created_less_than")


class AwaitableGetSensitiveTypesResult(GetSensitiveTypesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSensitiveTypesResult(
            access_level=self.access_level,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            default_masking_format_id=self.default_masking_format_id,
            display_name=self.display_name,
            entity_type=self.entity_type,
            filters=self.filters,
            id=self.id,
            is_common=self.is_common,
            parent_category_id=self.parent_category_id,
            sensitive_type_collections=self.sensitive_type_collections,
            sensitive_type_id=self.sensitive_type_id,
            sensitive_type_source=self.sensitive_type_source,
            state=self.state,
            time_created_greater_than_or_equal_to=self.time_created_greater_than_or_equal_to,
            time_created_less_than=self.time_created_less_than)


def get_sensitive_types(access_level: Optional[_builtins.str] = None,
                        compartment_id: Optional[_builtins.str] = None,
                        compartment_id_in_subtree: Optional[_builtins.bool] = None,
                        default_masking_format_id: Optional[_builtins.str] = None,
                        display_name: Optional[_builtins.str] = None,
                        entity_type: Optional[_builtins.str] = None,
                        filters: Optional[Sequence[Union['GetSensitiveTypesFilterArgs', 'GetSensitiveTypesFilterArgsDict']]] = None,
                        is_common: Optional[_builtins.bool] = None,
                        parent_category_id: Optional[_builtins.str] = None,
                        sensitive_type_id: Optional[_builtins.str] = None,
                        sensitive_type_source: Optional[_builtins.str] = None,
                        state: Optional[_builtins.str] = None,
                        time_created_greater_than_or_equal_to: Optional[_builtins.str] = None,
                        time_created_less_than: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSensitiveTypesResult:
    """
    This data source provides the list of Sensitive Types in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of sensitive types based on the specified query parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sensitive_types = oci.DataSafe.get_sensitive_types(compartment_id=compartment_id,
        access_level=sensitive_type_access_level,
        compartment_id_in_subtree=sensitive_type_compartment_id_in_subtree,
        default_masking_format_id=test_default_masking_format["id"],
        display_name=sensitive_type_display_name,
        entity_type=sensitive_type_entity_type,
        is_common=sensitive_type_is_common,
        parent_category_id=test_category["id"],
        sensitive_type_id=test_sensitive_type["id"],
        sensitive_type_source=sensitive_type_sensitive_type_source,
        state=sensitive_type_state,
        time_created_greater_than_or_equal_to=sensitive_type_time_created_greater_than_or_equal_to,
        time_created_less_than=sensitive_type_time_created_less_than)
    ```


    :param _builtins.str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param _builtins.str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param _builtins.bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param _builtins.str default_masking_format_id: A filter to return only the sensitive types that have the default masking format identified by the specified OCID.
    :param _builtins.str display_name: A filter to return only resources that match the specified display name.
    :param _builtins.str entity_type: A filter to return the sensitive type resources based on the value of their entityType attribute.
    :param _builtins.bool is_common: A filter to return only the common sensitive type resources. Common sensitive types belong to  library sensitive types which are frequently used to perform sensitive data discovery.
    :param _builtins.str parent_category_id: A filter to return only the sensitive types that are children of the sensitive category identified by the specified OCID.
    :param _builtins.str sensitive_type_id: A filter to return only items related to a specific sensitive type OCID.
    :param _builtins.str sensitive_type_source: A filter to return the sensitive type resources based on the value of their source attribute.
    :param _builtins.str state: A filter to return only the resources that match the specified lifecycle state.
    :param _builtins.str time_created_greater_than_or_equal_to: A filter to return only the resources that were created after the specified date and time, as defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Using TimeCreatedGreaterThanOrEqualToQueryParam parameter retrieves all resources created after that date.
           
           **Example:** 2016-12-19T16:39:57.600Z
    :param _builtins.str time_created_less_than: Search for resources that were created before a specific date. Specifying this parameter corresponding `timeCreatedLessThan` parameter will retrieve all resources created before the specified created date, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by RFC 3339.
           
           **Example:** 2016-12-19T16:39:57.600Z
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['defaultMaskingFormatId'] = default_masking_format_id
    __args__['displayName'] = display_name
    __args__['entityType'] = entity_type
    __args__['filters'] = filters
    __args__['isCommon'] = is_common
    __args__['parentCategoryId'] = parent_category_id
    __args__['sensitiveTypeId'] = sensitive_type_id
    __args__['sensitiveTypeSource'] = sensitive_type_source
    __args__['state'] = state
    __args__['timeCreatedGreaterThanOrEqualTo'] = time_created_greater_than_or_equal_to
    __args__['timeCreatedLessThan'] = time_created_less_than
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getSensitiveTypes:getSensitiveTypes', __args__, opts=opts, typ=GetSensitiveTypesResult).value

    return AwaitableGetSensitiveTypesResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        default_masking_format_id=pulumi.get(__ret__, 'default_masking_format_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        entity_type=pulumi.get(__ret__, 'entity_type'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_common=pulumi.get(__ret__, 'is_common'),
        parent_category_id=pulumi.get(__ret__, 'parent_category_id'),
        sensitive_type_collections=pulumi.get(__ret__, 'sensitive_type_collections'),
        sensitive_type_id=pulumi.get(__ret__, 'sensitive_type_id'),
        sensitive_type_source=pulumi.get(__ret__, 'sensitive_type_source'),
        state=pulumi.get(__ret__, 'state'),
        time_created_greater_than_or_equal_to=pulumi.get(__ret__, 'time_created_greater_than_or_equal_to'),
        time_created_less_than=pulumi.get(__ret__, 'time_created_less_than'))
def get_sensitive_types_output(access_level: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                               compartment_id_in_subtree: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                               default_masking_format_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               entity_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSensitiveTypesFilterArgs', 'GetSensitiveTypesFilterArgsDict']]]]] = None,
                               is_common: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                               parent_category_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               sensitive_type_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               sensitive_type_source: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               time_created_greater_than_or_equal_to: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               time_created_less_than: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSensitiveTypesResult]:
    """
    This data source provides the list of Sensitive Types in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of sensitive types based on the specified query parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sensitive_types = oci.DataSafe.get_sensitive_types(compartment_id=compartment_id,
        access_level=sensitive_type_access_level,
        compartment_id_in_subtree=sensitive_type_compartment_id_in_subtree,
        default_masking_format_id=test_default_masking_format["id"],
        display_name=sensitive_type_display_name,
        entity_type=sensitive_type_entity_type,
        is_common=sensitive_type_is_common,
        parent_category_id=test_category["id"],
        sensitive_type_id=test_sensitive_type["id"],
        sensitive_type_source=sensitive_type_sensitive_type_source,
        state=sensitive_type_state,
        time_created_greater_than_or_equal_to=sensitive_type_time_created_greater_than_or_equal_to,
        time_created_less_than=sensitive_type_time_created_less_than)
    ```


    :param _builtins.str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param _builtins.str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param _builtins.bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param _builtins.str default_masking_format_id: A filter to return only the sensitive types that have the default masking format identified by the specified OCID.
    :param _builtins.str display_name: A filter to return only resources that match the specified display name.
    :param _builtins.str entity_type: A filter to return the sensitive type resources based on the value of their entityType attribute.
    :param _builtins.bool is_common: A filter to return only the common sensitive type resources. Common sensitive types belong to  library sensitive types which are frequently used to perform sensitive data discovery.
    :param _builtins.str parent_category_id: A filter to return only the sensitive types that are children of the sensitive category identified by the specified OCID.
    :param _builtins.str sensitive_type_id: A filter to return only items related to a specific sensitive type OCID.
    :param _builtins.str sensitive_type_source: A filter to return the sensitive type resources based on the value of their source attribute.
    :param _builtins.str state: A filter to return only the resources that match the specified lifecycle state.
    :param _builtins.str time_created_greater_than_or_equal_to: A filter to return only the resources that were created after the specified date and time, as defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Using TimeCreatedGreaterThanOrEqualToQueryParam parameter retrieves all resources created after that date.
           
           **Example:** 2016-12-19T16:39:57.600Z
    :param _builtins.str time_created_less_than: Search for resources that were created before a specific date. Specifying this parameter corresponding `timeCreatedLessThan` parameter will retrieve all resources created before the specified created date, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by RFC 3339.
           
           **Example:** 2016-12-19T16:39:57.600Z
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['defaultMaskingFormatId'] = default_masking_format_id
    __args__['displayName'] = display_name
    __args__['entityType'] = entity_type
    __args__['filters'] = filters
    __args__['isCommon'] = is_common
    __args__['parentCategoryId'] = parent_category_id
    __args__['sensitiveTypeId'] = sensitive_type_id
    __args__['sensitiveTypeSource'] = sensitive_type_source
    __args__['state'] = state
    __args__['timeCreatedGreaterThanOrEqualTo'] = time_created_greater_than_or_equal_to
    __args__['timeCreatedLessThan'] = time_created_less_than
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getSensitiveTypes:getSensitiveTypes', __args__, opts=opts, typ=GetSensitiveTypesResult)
    return __ret__.apply(lambda __response__: GetSensitiveTypesResult(
        access_level=pulumi.get(__response__, 'access_level'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        default_masking_format_id=pulumi.get(__response__, 'default_masking_format_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        entity_type=pulumi.get(__response__, 'entity_type'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        is_common=pulumi.get(__response__, 'is_common'),
        parent_category_id=pulumi.get(__response__, 'parent_category_id'),
        sensitive_type_collections=pulumi.get(__response__, 'sensitive_type_collections'),
        sensitive_type_id=pulumi.get(__response__, 'sensitive_type_id'),
        sensitive_type_source=pulumi.get(__response__, 'sensitive_type_source'),
        state=pulumi.get(__response__, 'state'),
        time_created_greater_than_or_equal_to=pulumi.get(__response__, 'time_created_greater_than_or_equal_to'),
        time_created_less_than=pulumi.get(__response__, 'time_created_less_than')))
