# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TargetDatabaseGroupArgs', 'TargetDatabaseGroup']

@pulumi.input_type
class TargetDatabaseGroupArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 matching_criteria: pulumi.Input['TargetDatabaseGroupMatchingCriteriaArgs'],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a TargetDatabaseGroup resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment to create the target database group.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The name of the target database group.
        :param pulumi.Input['TargetDatabaseGroupMatchingCriteriaArgs'] matching_criteria: (Updatable) Criteria to either include or exclude target databases from the target database group. These criteria can be based on compartments or tags or a list of target databases. See examples below for more details. Include: Target databases will be added to the target database group if they match at least one of the include criteria. Exclude: Target databases that will be excluded from the target database group (even if they match any of the include criteria).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) Description of the target database group (optional).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "matching_criteria", matching_criteria)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The OCID of the compartment to create the target database group.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The name of the target database group.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="matchingCriteria")
    def matching_criteria(self) -> pulumi.Input['TargetDatabaseGroupMatchingCriteriaArgs']:
        """
        (Updatable) Criteria to either include or exclude target databases from the target database group. These criteria can be based on compartments or tags or a list of target databases. See examples below for more details. Include: Target databases will be added to the target database group if they match at least one of the include criteria. Exclude: Target databases that will be excluded from the target database group (even if they match any of the include criteria).
        """
        return pulumi.get(self, "matching_criteria")

    @matching_criteria.setter
    def matching_criteria(self, value: pulumi.Input['TargetDatabaseGroupMatchingCriteriaArgs']):
        pulumi.set(self, "matching_criteria", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Description of the target database group (optional).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _TargetDatabaseGroupState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 matching_criteria: Optional[pulumi.Input['TargetDatabaseGroupMatchingCriteriaArgs']] = None,
                 membership_count: Optional[pulumi.Input[_builtins.int]] = None,
                 membership_update_time: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TargetDatabaseGroup resources.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment to create the target database group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) Description of the target database group (optional).
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The name of the target database group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] lifecycle_details: Details for the lifecycle status of the target database group.
        :param pulumi.Input['TargetDatabaseGroupMatchingCriteriaArgs'] matching_criteria: (Updatable) Criteria to either include or exclude target databases from the target database group. These criteria can be based on compartments or tags or a list of target databases. See examples below for more details. Include: Target databases will be added to the target database group if they match at least one of the include criteria. Exclude: Target databases that will be excluded from the target database group (even if they match any of the include criteria).
        :param pulumi.Input[_builtins.int] membership_count: The number of target databases in the specified target database group.
        :param pulumi.Input[_builtins.str] membership_update_time: Time when the members of the target database group were last changed, i.e. the list was refreshed, a target database was added or removed.
        :param pulumi.Input[_builtins.str] state: The lifecycle status of the target database group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: Time when the target database group was created.
        :param pulumi.Input[_builtins.str] time_updated: Time when the target database group was last updated.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if matching_criteria is not None:
            pulumi.set(__self__, "matching_criteria", matching_criteria)
        if membership_count is not None:
            pulumi.set(__self__, "membership_count", membership_count)
        if membership_update_time is not None:
            pulumi.set(__self__, "membership_update_time", membership_update_time)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The OCID of the compartment to create the target database group.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Description of the target database group (optional).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The name of the target database group.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Details for the lifecycle status of the target database group.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter(name="matchingCriteria")
    def matching_criteria(self) -> Optional[pulumi.Input['TargetDatabaseGroupMatchingCriteriaArgs']]:
        """
        (Updatable) Criteria to either include or exclude target databases from the target database group. These criteria can be based on compartments or tags or a list of target databases. See examples below for more details. Include: Target databases will be added to the target database group if they match at least one of the include criteria. Exclude: Target databases that will be excluded from the target database group (even if they match any of the include criteria).
        """
        return pulumi.get(self, "matching_criteria")

    @matching_criteria.setter
    def matching_criteria(self, value: Optional[pulumi.Input['TargetDatabaseGroupMatchingCriteriaArgs']]):
        pulumi.set(self, "matching_criteria", value)

    @_builtins.property
    @pulumi.getter(name="membershipCount")
    def membership_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of target databases in the specified target database group.
        """
        return pulumi.get(self, "membership_count")

    @membership_count.setter
    def membership_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "membership_count", value)

    @_builtins.property
    @pulumi.getter(name="membershipUpdateTime")
    def membership_update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time when the members of the target database group were last changed, i.e. the list was refreshed, a target database was added or removed.
        """
        return pulumi.get(self, "membership_update_time")

    @membership_update_time.setter
    def membership_update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "membership_update_time", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The lifecycle status of the target database group.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time when the target database group was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time when the target database group was last updated.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:DataSafe/targetDatabaseGroup:TargetDatabaseGroup")
class TargetDatabaseGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 matching_criteria: Optional[pulumi.Input[Union['TargetDatabaseGroupMatchingCriteriaArgs', 'TargetDatabaseGroupMatchingCriteriaArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Target Database Group resource in Oracle Cloud Infrastructure Data Safe service.

        Creates a new target database group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_target_database_group = oci.datasafe.TargetDatabaseGroup("test_target_database_group",
            compartment_id=compartment_id,
            display_name=target_database_group_display_name,
            matching_criteria={
                "include": {
                    "compartments": [{
                        "id": target_database_group_matching_criteria_include_compartments_id,
                        "is_include_subtree": target_database_group_matching_criteria_include_compartments_is_include_subtree,
                    }],
                    "defined_tags": {
                        "Operations.CostCenter": "42",
                    },
                    "freeform_tags": {
                        "Department": "Finance",
                    },
                    "target_database_ids": target_database_group_matching_criteria_include_target_database_ids,
                },
                "exclude": {
                    "target_database_ids": target_database_group_matching_criteria_exclude_target_database_ids,
                },
            },
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=target_database_group_description,
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        TargetDatabaseGroups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/targetDatabaseGroup:TargetDatabaseGroup test_target_database_group "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment to create the target database group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) Description of the target database group (optional).
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The name of the target database group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Union['TargetDatabaseGroupMatchingCriteriaArgs', 'TargetDatabaseGroupMatchingCriteriaArgsDict']] matching_criteria: (Updatable) Criteria to either include or exclude target databases from the target database group. These criteria can be based on compartments or tags or a list of target databases. See examples below for more details. Include: Target databases will be added to the target database group if they match at least one of the include criteria. Exclude: Target databases that will be excluded from the target database group (even if they match any of the include criteria).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TargetDatabaseGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Target Database Group resource in Oracle Cloud Infrastructure Data Safe service.

        Creates a new target database group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_target_database_group = oci.datasafe.TargetDatabaseGroup("test_target_database_group",
            compartment_id=compartment_id,
            display_name=target_database_group_display_name,
            matching_criteria={
                "include": {
                    "compartments": [{
                        "id": target_database_group_matching_criteria_include_compartments_id,
                        "is_include_subtree": target_database_group_matching_criteria_include_compartments_is_include_subtree,
                    }],
                    "defined_tags": {
                        "Operations.CostCenter": "42",
                    },
                    "freeform_tags": {
                        "Department": "Finance",
                    },
                    "target_database_ids": target_database_group_matching_criteria_include_target_database_ids,
                },
                "exclude": {
                    "target_database_ids": target_database_group_matching_criteria_exclude_target_database_ids,
                },
            },
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=target_database_group_description,
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        TargetDatabaseGroups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/targetDatabaseGroup:TargetDatabaseGroup test_target_database_group "id"
        ```

        :param str resource_name: The name of the resource.
        :param TargetDatabaseGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TargetDatabaseGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 matching_criteria: Optional[pulumi.Input[Union['TargetDatabaseGroupMatchingCriteriaArgs', 'TargetDatabaseGroupMatchingCriteriaArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TargetDatabaseGroupArgs.__new__(TargetDatabaseGroupArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if matching_criteria is None and not opts.urn:
                raise TypeError("Missing required property 'matching_criteria'")
            __props__.__dict__["matching_criteria"] = matching_criteria
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["membership_count"] = None
            __props__.__dict__["membership_update_time"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(TargetDatabaseGroup, __self__).__init__(
            'oci:DataSafe/targetDatabaseGroup:TargetDatabaseGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            matching_criteria: Optional[pulumi.Input[Union['TargetDatabaseGroupMatchingCriteriaArgs', 'TargetDatabaseGroupMatchingCriteriaArgsDict']]] = None,
            membership_count: Optional[pulumi.Input[_builtins.int]] = None,
            membership_update_time: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'TargetDatabaseGroup':
        """
        Get an existing TargetDatabaseGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment to create the target database group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) Description of the target database group (optional).
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The name of the target database group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] lifecycle_details: Details for the lifecycle status of the target database group.
        :param pulumi.Input[Union['TargetDatabaseGroupMatchingCriteriaArgs', 'TargetDatabaseGroupMatchingCriteriaArgsDict']] matching_criteria: (Updatable) Criteria to either include or exclude target databases from the target database group. These criteria can be based on compartments or tags or a list of target databases. See examples below for more details. Include: Target databases will be added to the target database group if they match at least one of the include criteria. Exclude: Target databases that will be excluded from the target database group (even if they match any of the include criteria).
        :param pulumi.Input[_builtins.int] membership_count: The number of target databases in the specified target database group.
        :param pulumi.Input[_builtins.str] membership_update_time: Time when the members of the target database group were last changed, i.e. the list was refreshed, a target database was added or removed.
        :param pulumi.Input[_builtins.str] state: The lifecycle status of the target database group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: Time when the target database group was created.
        :param pulumi.Input[_builtins.str] time_updated: Time when the target database group was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TargetDatabaseGroupState.__new__(_TargetDatabaseGroupState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["matching_criteria"] = matching_criteria
        __props__.__dict__["membership_count"] = membership_count
        __props__.__dict__["membership_update_time"] = membership_update_time
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return TargetDatabaseGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The OCID of the compartment to create the target database group.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Description of the target database group (optional).
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The name of the target database group.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        Details for the lifecycle status of the target database group.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="matchingCriteria")
    def matching_criteria(self) -> pulumi.Output['outputs.TargetDatabaseGroupMatchingCriteria']:
        """
        (Updatable) Criteria to either include or exclude target databases from the target database group. These criteria can be based on compartments or tags or a list of target databases. See examples below for more details. Include: Target databases will be added to the target database group if they match at least one of the include criteria. Exclude: Target databases that will be excluded from the target database group (even if they match any of the include criteria).
        """
        return pulumi.get(self, "matching_criteria")

    @_builtins.property
    @pulumi.getter(name="membershipCount")
    def membership_count(self) -> pulumi.Output[_builtins.int]:
        """
        The number of target databases in the specified target database group.
        """
        return pulumi.get(self, "membership_count")

    @_builtins.property
    @pulumi.getter(name="membershipUpdateTime")
    def membership_update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Time when the members of the target database group were last changed, i.e. the list was refreshed, a target database was added or removed.
        """
        return pulumi.get(self, "membership_update_time")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The lifecycle status of the target database group.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        Time when the target database group was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        Time when the target database group was last updated.
        """
        return pulumi.get(self, "time_updated")

