# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ModelGroupArtifactArgs', 'ModelGroupArtifact']

@pulumi.input_type
class ModelGroupArtifactArgs:
    def __init__(__self__, *,
                 content_length: pulumi.Input[_builtins.str],
                 model_group_artifact: pulumi.Input[_builtins.str],
                 model_group_id: pulumi.Input[_builtins.str],
                 content_disposition: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ModelGroupArtifact resource.
        :param pulumi.Input[_builtins.str] content_length: The content length of the body.
        :param pulumi.Input[_builtins.str] model_group_artifact: The model group artifact to upload.
        :param pulumi.Input[_builtins.str] model_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the modelGroup.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] content_disposition: This header allows you to specify a filename during upload. This file name is used to dispose of the file contents while downloading the file. If this optional field is not populated in the request, then the OCID of the model is used for the file name when downloading. Example: `{"Content-Disposition": "attachment" "filename"="model.tar.gz" "Content-Length": "2347" "Content-Type": "application/gzip"}`
        """
        pulumi.set(__self__, "content_length", content_length)
        pulumi.set(__self__, "model_group_artifact", model_group_artifact)
        pulumi.set(__self__, "model_group_id", model_group_id)
        if content_disposition is not None:
            pulumi.set(__self__, "content_disposition", content_disposition)

    @_builtins.property
    @pulumi.getter(name="contentLength")
    def content_length(self) -> pulumi.Input[_builtins.str]:
        """
        The content length of the body.
        """
        return pulumi.get(self, "content_length")

    @content_length.setter
    def content_length(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "content_length", value)

    @_builtins.property
    @pulumi.getter(name="modelGroupArtifact")
    def model_group_artifact(self) -> pulumi.Input[_builtins.str]:
        """
        The model group artifact to upload.
        """
        return pulumi.get(self, "model_group_artifact")

    @model_group_artifact.setter
    def model_group_artifact(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "model_group_artifact", value)

    @_builtins.property
    @pulumi.getter(name="modelGroupId")
    def model_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the modelGroup.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "model_group_id")

    @model_group_id.setter
    def model_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "model_group_id", value)

    @_builtins.property
    @pulumi.getter(name="contentDisposition")
    def content_disposition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This header allows you to specify a filename during upload. This file name is used to dispose of the file contents while downloading the file. If this optional field is not populated in the request, then the OCID of the model is used for the file name when downloading. Example: `{"Content-Disposition": "attachment" "filename"="model.tar.gz" "Content-Length": "2347" "Content-Type": "application/gzip"}`
        """
        return pulumi.get(self, "content_disposition")

    @content_disposition.setter
    def content_disposition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_disposition", value)


@pulumi.input_type
class _ModelGroupArtifactState:
    def __init__(__self__, *,
                 content_disposition: Optional[pulumi.Input[_builtins.str]] = None,
                 content_length: Optional[pulumi.Input[_builtins.str]] = None,
                 model_group_artifact: Optional[pulumi.Input[_builtins.str]] = None,
                 model_group_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ModelGroupArtifact resources.
        :param pulumi.Input[_builtins.str] content_disposition: This header allows you to specify a filename during upload. This file name is used to dispose of the file contents while downloading the file. If this optional field is not populated in the request, then the OCID of the model is used for the file name when downloading. Example: `{"Content-Disposition": "attachment" "filename"="model.tar.gz" "Content-Length": "2347" "Content-Type": "application/gzip"}`
        :param pulumi.Input[_builtins.str] content_length: The content length of the body.
        :param pulumi.Input[_builtins.str] model_group_artifact: The model group artifact to upload.
        :param pulumi.Input[_builtins.str] model_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the modelGroup.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if content_disposition is not None:
            pulumi.set(__self__, "content_disposition", content_disposition)
        if content_length is not None:
            pulumi.set(__self__, "content_length", content_length)
        if model_group_artifact is not None:
            pulumi.set(__self__, "model_group_artifact", model_group_artifact)
        if model_group_id is not None:
            pulumi.set(__self__, "model_group_id", model_group_id)

    @_builtins.property
    @pulumi.getter(name="contentDisposition")
    def content_disposition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This header allows you to specify a filename during upload. This file name is used to dispose of the file contents while downloading the file. If this optional field is not populated in the request, then the OCID of the model is used for the file name when downloading. Example: `{"Content-Disposition": "attachment" "filename"="model.tar.gz" "Content-Length": "2347" "Content-Type": "application/gzip"}`
        """
        return pulumi.get(self, "content_disposition")

    @content_disposition.setter
    def content_disposition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_disposition", value)

    @_builtins.property
    @pulumi.getter(name="contentLength")
    def content_length(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The content length of the body.
        """
        return pulumi.get(self, "content_length")

    @content_length.setter
    def content_length(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_length", value)

    @_builtins.property
    @pulumi.getter(name="modelGroupArtifact")
    def model_group_artifact(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The model group artifact to upload.
        """
        return pulumi.get(self, "model_group_artifact")

    @model_group_artifact.setter
    def model_group_artifact(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "model_group_artifact", value)

    @_builtins.property
    @pulumi.getter(name="modelGroupId")
    def model_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the modelGroup.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "model_group_id")

    @model_group_id.setter
    def model_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "model_group_id", value)


@pulumi.type_token("oci:DataScience/modelGroupArtifact:ModelGroupArtifact")
class ModelGroupArtifact(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content_disposition: Optional[pulumi.Input[_builtins.str]] = None,
                 content_length: Optional[pulumi.Input[_builtins.str]] = None,
                 model_group_artifact: Optional[pulumi.Input[_builtins.str]] = None,
                 model_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Model Group Artifact resource in Oracle Cloud Infrastructure Data Science service.

        Creates artifact for the Model Group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_model_group_artifact = oci.datascience.ModelGroupArtifact("test_model_group_artifact",
            model_group_artifact=model_group_artifact_model_group_artifact,
            content_length=model_group_artifact_content_length,
            model_group_id=test_model_group["id"],
            content_disposition=model_group_artifact_content_disposition)
        ```

        ## Import

        ModelGroupArtifacts can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataScience/modelGroupArtifact:ModelGroupArtifact test_model_group_artifact "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] content_disposition: This header allows you to specify a filename during upload. This file name is used to dispose of the file contents while downloading the file. If this optional field is not populated in the request, then the OCID of the model is used for the file name when downloading. Example: `{"Content-Disposition": "attachment" "filename"="model.tar.gz" "Content-Length": "2347" "Content-Type": "application/gzip"}`
        :param pulumi.Input[_builtins.str] content_length: The content length of the body.
        :param pulumi.Input[_builtins.str] model_group_artifact: The model group artifact to upload.
        :param pulumi.Input[_builtins.str] model_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the modelGroup.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ModelGroupArtifactArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Model Group Artifact resource in Oracle Cloud Infrastructure Data Science service.

        Creates artifact for the Model Group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_model_group_artifact = oci.datascience.ModelGroupArtifact("test_model_group_artifact",
            model_group_artifact=model_group_artifact_model_group_artifact,
            content_length=model_group_artifact_content_length,
            model_group_id=test_model_group["id"],
            content_disposition=model_group_artifact_content_disposition)
        ```

        ## Import

        ModelGroupArtifacts can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataScience/modelGroupArtifact:ModelGroupArtifact test_model_group_artifact "id"
        ```

        :param str resource_name: The name of the resource.
        :param ModelGroupArtifactArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ModelGroupArtifactArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content_disposition: Optional[pulumi.Input[_builtins.str]] = None,
                 content_length: Optional[pulumi.Input[_builtins.str]] = None,
                 model_group_artifact: Optional[pulumi.Input[_builtins.str]] = None,
                 model_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ModelGroupArtifactArgs.__new__(ModelGroupArtifactArgs)

            __props__.__dict__["content_disposition"] = content_disposition
            if content_length is None and not opts.urn:
                raise TypeError("Missing required property 'content_length'")
            __props__.__dict__["content_length"] = content_length
            if model_group_artifact is None and not opts.urn:
                raise TypeError("Missing required property 'model_group_artifact'")
            __props__.__dict__["model_group_artifact"] = model_group_artifact
            if model_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'model_group_id'")
            __props__.__dict__["model_group_id"] = model_group_id
        super(ModelGroupArtifact, __self__).__init__(
            'oci:DataScience/modelGroupArtifact:ModelGroupArtifact',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            content_disposition: Optional[pulumi.Input[_builtins.str]] = None,
            content_length: Optional[pulumi.Input[_builtins.str]] = None,
            model_group_artifact: Optional[pulumi.Input[_builtins.str]] = None,
            model_group_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ModelGroupArtifact':
        """
        Get an existing ModelGroupArtifact resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] content_disposition: This header allows you to specify a filename during upload. This file name is used to dispose of the file contents while downloading the file. If this optional field is not populated in the request, then the OCID of the model is used for the file name when downloading. Example: `{"Content-Disposition": "attachment" "filename"="model.tar.gz" "Content-Length": "2347" "Content-Type": "application/gzip"}`
        :param pulumi.Input[_builtins.str] content_length: The content length of the body.
        :param pulumi.Input[_builtins.str] model_group_artifact: The model group artifact to upload.
        :param pulumi.Input[_builtins.str] model_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the modelGroup.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ModelGroupArtifactState.__new__(_ModelGroupArtifactState)

        __props__.__dict__["content_disposition"] = content_disposition
        __props__.__dict__["content_length"] = content_length
        __props__.__dict__["model_group_artifact"] = model_group_artifact
        __props__.__dict__["model_group_id"] = model_group_id
        return ModelGroupArtifact(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="contentDisposition")
    def content_disposition(self) -> pulumi.Output[_builtins.str]:
        """
        This header allows you to specify a filename during upload. This file name is used to dispose of the file contents while downloading the file. If this optional field is not populated in the request, then the OCID of the model is used for the file name when downloading. Example: `{"Content-Disposition": "attachment" "filename"="model.tar.gz" "Content-Length": "2347" "Content-Type": "application/gzip"}`
        """
        return pulumi.get(self, "content_disposition")

    @_builtins.property
    @pulumi.getter(name="contentLength")
    def content_length(self) -> pulumi.Output[_builtins.str]:
        """
        The content length of the body.
        """
        return pulumi.get(self, "content_length")

    @_builtins.property
    @pulumi.getter(name="modelGroupArtifact")
    def model_group_artifact(self) -> pulumi.Output[_builtins.str]:
        """
        The model group artifact to upload.
        """
        return pulumi.get(self, "model_group_artifact")

    @_builtins.property
    @pulumi.getter(name="modelGroupId")
    def model_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the modelGroup.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "model_group_id")

