# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ModelProvenanceArgs', 'ModelProvenance']

@pulumi.input_type
class ModelProvenanceArgs:
    def __init__(__self__, *,
                 model_id: pulumi.Input[_builtins.str],
                 git_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 git_commit: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_url: Optional[pulumi.Input[_builtins.str]] = None,
                 script_dir: Optional[pulumi.Input[_builtins.str]] = None,
                 training_id: Optional[pulumi.Input[_builtins.str]] = None,
                 training_script: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ModelProvenance resource.
        :param pulumi.Input[_builtins.str] model_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the model.
        :param pulumi.Input[_builtins.str] git_branch: (Updatable) For model reproducibility purposes. Branch of the git repository associated with model training.
        :param pulumi.Input[_builtins.str] git_commit: (Updatable) For model reproducibility purposes. Commit ID of the git repository associated with model training.
        :param pulumi.Input[_builtins.str] repository_url: (Updatable) For model reproducibility purposes. URL of the git repository associated with model training.
        :param pulumi.Input[_builtins.str] script_dir: (Updatable) For model reproducibility purposes. Path to model artifacts.
        :param pulumi.Input[_builtins.str] training_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a training session(Job or NotebookSession) in which the model was trained. It is used for model reproducibility purposes.
        :param pulumi.Input[_builtins.str] training_script: (Updatable) For model reproducibility purposes. Path to the python script or notebook in which the model was trained." 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "model_id", model_id)
        if git_branch is not None:
            pulumi.set(__self__, "git_branch", git_branch)
        if git_commit is not None:
            pulumi.set(__self__, "git_commit", git_commit)
        if repository_url is not None:
            pulumi.set(__self__, "repository_url", repository_url)
        if script_dir is not None:
            pulumi.set(__self__, "script_dir", script_dir)
        if training_id is not None:
            pulumi.set(__self__, "training_id", training_id)
        if training_script is not None:
            pulumi.set(__self__, "training_script", training_script)

    @_builtins.property
    @pulumi.getter(name="modelId")
    def model_id(self) -> pulumi.Input[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the model.
        """
        return pulumi.get(self, "model_id")

    @model_id.setter
    def model_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "model_id", value)

    @_builtins.property
    @pulumi.getter(name="gitBranch")
    def git_branch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) For model reproducibility purposes. Branch of the git repository associated with model training.
        """
        return pulumi.get(self, "git_branch")

    @git_branch.setter
    def git_branch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "git_branch", value)

    @_builtins.property
    @pulumi.getter(name="gitCommit")
    def git_commit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) For model reproducibility purposes. Commit ID of the git repository associated with model training.
        """
        return pulumi.get(self, "git_commit")

    @git_commit.setter
    def git_commit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "git_commit", value)

    @_builtins.property
    @pulumi.getter(name="repositoryUrl")
    def repository_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) For model reproducibility purposes. URL of the git repository associated with model training.
        """
        return pulumi.get(self, "repository_url")

    @repository_url.setter
    def repository_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository_url", value)

    @_builtins.property
    @pulumi.getter(name="scriptDir")
    def script_dir(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) For model reproducibility purposes. Path to model artifacts.
        """
        return pulumi.get(self, "script_dir")

    @script_dir.setter
    def script_dir(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "script_dir", value)

    @_builtins.property
    @pulumi.getter(name="trainingId")
    def training_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a training session(Job or NotebookSession) in which the model was trained. It is used for model reproducibility purposes.
        """
        return pulumi.get(self, "training_id")

    @training_id.setter
    def training_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "training_id", value)

    @_builtins.property
    @pulumi.getter(name="trainingScript")
    def training_script(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) For model reproducibility purposes. Path to the python script or notebook in which the model was trained." 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "training_script")

    @training_script.setter
    def training_script(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "training_script", value)


@pulumi.input_type
class _ModelProvenanceState:
    def __init__(__self__, *,
                 git_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 git_commit: Optional[pulumi.Input[_builtins.str]] = None,
                 model_id: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_url: Optional[pulumi.Input[_builtins.str]] = None,
                 script_dir: Optional[pulumi.Input[_builtins.str]] = None,
                 training_id: Optional[pulumi.Input[_builtins.str]] = None,
                 training_script: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ModelProvenance resources.
        :param pulumi.Input[_builtins.str] git_branch: (Updatable) For model reproducibility purposes. Branch of the git repository associated with model training.
        :param pulumi.Input[_builtins.str] git_commit: (Updatable) For model reproducibility purposes. Commit ID of the git repository associated with model training.
        :param pulumi.Input[_builtins.str] model_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the model.
        :param pulumi.Input[_builtins.str] repository_url: (Updatable) For model reproducibility purposes. URL of the git repository associated with model training.
        :param pulumi.Input[_builtins.str] script_dir: (Updatable) For model reproducibility purposes. Path to model artifacts.
        :param pulumi.Input[_builtins.str] training_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a training session(Job or NotebookSession) in which the model was trained. It is used for model reproducibility purposes.
        :param pulumi.Input[_builtins.str] training_script: (Updatable) For model reproducibility purposes. Path to the python script or notebook in which the model was trained." 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if git_branch is not None:
            pulumi.set(__self__, "git_branch", git_branch)
        if git_commit is not None:
            pulumi.set(__self__, "git_commit", git_commit)
        if model_id is not None:
            pulumi.set(__self__, "model_id", model_id)
        if repository_url is not None:
            pulumi.set(__self__, "repository_url", repository_url)
        if script_dir is not None:
            pulumi.set(__self__, "script_dir", script_dir)
        if training_id is not None:
            pulumi.set(__self__, "training_id", training_id)
        if training_script is not None:
            pulumi.set(__self__, "training_script", training_script)

    @_builtins.property
    @pulumi.getter(name="gitBranch")
    def git_branch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) For model reproducibility purposes. Branch of the git repository associated with model training.
        """
        return pulumi.get(self, "git_branch")

    @git_branch.setter
    def git_branch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "git_branch", value)

    @_builtins.property
    @pulumi.getter(name="gitCommit")
    def git_commit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) For model reproducibility purposes. Commit ID of the git repository associated with model training.
        """
        return pulumi.get(self, "git_commit")

    @git_commit.setter
    def git_commit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "git_commit", value)

    @_builtins.property
    @pulumi.getter(name="modelId")
    def model_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the model.
        """
        return pulumi.get(self, "model_id")

    @model_id.setter
    def model_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "model_id", value)

    @_builtins.property
    @pulumi.getter(name="repositoryUrl")
    def repository_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) For model reproducibility purposes. URL of the git repository associated with model training.
        """
        return pulumi.get(self, "repository_url")

    @repository_url.setter
    def repository_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository_url", value)

    @_builtins.property
    @pulumi.getter(name="scriptDir")
    def script_dir(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) For model reproducibility purposes. Path to model artifacts.
        """
        return pulumi.get(self, "script_dir")

    @script_dir.setter
    def script_dir(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "script_dir", value)

    @_builtins.property
    @pulumi.getter(name="trainingId")
    def training_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a training session(Job or NotebookSession) in which the model was trained. It is used for model reproducibility purposes.
        """
        return pulumi.get(self, "training_id")

    @training_id.setter
    def training_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "training_id", value)

    @_builtins.property
    @pulumi.getter(name="trainingScript")
    def training_script(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) For model reproducibility purposes. Path to the python script or notebook in which the model was trained." 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "training_script")

    @training_script.setter
    def training_script(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "training_script", value)


@pulumi.type_token("oci:DataScience/modelProvenance:ModelProvenance")
class ModelProvenance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 git_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 git_commit: Optional[pulumi.Input[_builtins.str]] = None,
                 model_id: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_url: Optional[pulumi.Input[_builtins.str]] = None,
                 script_dir: Optional[pulumi.Input[_builtins.str]] = None,
                 training_id: Optional[pulumi.Input[_builtins.str]] = None,
                 training_script: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Model Provenance resource in Oracle Cloud Infrastructure Data Science service.

        Creates provenance information for the specified model.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_model_provenance = oci.datascience.ModelProvenance("test_model_provenance",
            model_id=test_model["id"],
            git_branch=model_provenance_git_branch,
            git_commit=model_provenance_git_commit,
            repository_url=model_provenance_repository_url,
            script_dir=model_provenance_script_dir,
            training_id=test_training["id"],
            training_script=model_provenance_training_script)
        ```

        ## Import

        ModelProvenances can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataScience/modelProvenance:ModelProvenance test_model_provenance "models/{modelId}/provenance"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] git_branch: (Updatable) For model reproducibility purposes. Branch of the git repository associated with model training.
        :param pulumi.Input[_builtins.str] git_commit: (Updatable) For model reproducibility purposes. Commit ID of the git repository associated with model training.
        :param pulumi.Input[_builtins.str] model_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the model.
        :param pulumi.Input[_builtins.str] repository_url: (Updatable) For model reproducibility purposes. URL of the git repository associated with model training.
        :param pulumi.Input[_builtins.str] script_dir: (Updatable) For model reproducibility purposes. Path to model artifacts.
        :param pulumi.Input[_builtins.str] training_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a training session(Job or NotebookSession) in which the model was trained. It is used for model reproducibility purposes.
        :param pulumi.Input[_builtins.str] training_script: (Updatable) For model reproducibility purposes. Path to the python script or notebook in which the model was trained." 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ModelProvenanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Model Provenance resource in Oracle Cloud Infrastructure Data Science service.

        Creates provenance information for the specified model.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_model_provenance = oci.datascience.ModelProvenance("test_model_provenance",
            model_id=test_model["id"],
            git_branch=model_provenance_git_branch,
            git_commit=model_provenance_git_commit,
            repository_url=model_provenance_repository_url,
            script_dir=model_provenance_script_dir,
            training_id=test_training["id"],
            training_script=model_provenance_training_script)
        ```

        ## Import

        ModelProvenances can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataScience/modelProvenance:ModelProvenance test_model_provenance "models/{modelId}/provenance"
        ```

        :param str resource_name: The name of the resource.
        :param ModelProvenanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ModelProvenanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 git_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 git_commit: Optional[pulumi.Input[_builtins.str]] = None,
                 model_id: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_url: Optional[pulumi.Input[_builtins.str]] = None,
                 script_dir: Optional[pulumi.Input[_builtins.str]] = None,
                 training_id: Optional[pulumi.Input[_builtins.str]] = None,
                 training_script: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ModelProvenanceArgs.__new__(ModelProvenanceArgs)

            __props__.__dict__["git_branch"] = git_branch
            __props__.__dict__["git_commit"] = git_commit
            if model_id is None and not opts.urn:
                raise TypeError("Missing required property 'model_id'")
            __props__.__dict__["model_id"] = model_id
            __props__.__dict__["repository_url"] = repository_url
            __props__.__dict__["script_dir"] = script_dir
            __props__.__dict__["training_id"] = training_id
            __props__.__dict__["training_script"] = training_script
        super(ModelProvenance, __self__).__init__(
            'oci:DataScience/modelProvenance:ModelProvenance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            git_branch: Optional[pulumi.Input[_builtins.str]] = None,
            git_commit: Optional[pulumi.Input[_builtins.str]] = None,
            model_id: Optional[pulumi.Input[_builtins.str]] = None,
            repository_url: Optional[pulumi.Input[_builtins.str]] = None,
            script_dir: Optional[pulumi.Input[_builtins.str]] = None,
            training_id: Optional[pulumi.Input[_builtins.str]] = None,
            training_script: Optional[pulumi.Input[_builtins.str]] = None) -> 'ModelProvenance':
        """
        Get an existing ModelProvenance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] git_branch: (Updatable) For model reproducibility purposes. Branch of the git repository associated with model training.
        :param pulumi.Input[_builtins.str] git_commit: (Updatable) For model reproducibility purposes. Commit ID of the git repository associated with model training.
        :param pulumi.Input[_builtins.str] model_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the model.
        :param pulumi.Input[_builtins.str] repository_url: (Updatable) For model reproducibility purposes. URL of the git repository associated with model training.
        :param pulumi.Input[_builtins.str] script_dir: (Updatable) For model reproducibility purposes. Path to model artifacts.
        :param pulumi.Input[_builtins.str] training_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a training session(Job or NotebookSession) in which the model was trained. It is used for model reproducibility purposes.
        :param pulumi.Input[_builtins.str] training_script: (Updatable) For model reproducibility purposes. Path to the python script or notebook in which the model was trained." 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ModelProvenanceState.__new__(_ModelProvenanceState)

        __props__.__dict__["git_branch"] = git_branch
        __props__.__dict__["git_commit"] = git_commit
        __props__.__dict__["model_id"] = model_id
        __props__.__dict__["repository_url"] = repository_url
        __props__.__dict__["script_dir"] = script_dir
        __props__.__dict__["training_id"] = training_id
        __props__.__dict__["training_script"] = training_script
        return ModelProvenance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="gitBranch")
    def git_branch(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) For model reproducibility purposes. Branch of the git repository associated with model training.
        """
        return pulumi.get(self, "git_branch")

    @_builtins.property
    @pulumi.getter(name="gitCommit")
    def git_commit(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) For model reproducibility purposes. Commit ID of the git repository associated with model training.
        """
        return pulumi.get(self, "git_commit")

    @_builtins.property
    @pulumi.getter(name="modelId")
    def model_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the model.
        """
        return pulumi.get(self, "model_id")

    @_builtins.property
    @pulumi.getter(name="repositoryUrl")
    def repository_url(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) For model reproducibility purposes. URL of the git repository associated with model training.
        """
        return pulumi.get(self, "repository_url")

    @_builtins.property
    @pulumi.getter(name="scriptDir")
    def script_dir(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) For model reproducibility purposes. Path to model artifacts.
        """
        return pulumi.get(self, "script_dir")

    @_builtins.property
    @pulumi.getter(name="trainingId")
    def training_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a training session(Job or NotebookSession) in which the model was trained. It is used for model reproducibility purposes.
        """
        return pulumi.get(self, "training_id")

    @_builtins.property
    @pulumi.getter(name="trainingScript")
    def training_script(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) For model reproducibility purposes. Path to the python script or notebook in which the model was trained." 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "training_script")

