# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'DesktopPoolAvailabilityPolicyArgs',
    'DesktopPoolAvailabilityPolicyArgsDict',
    'DesktopPoolAvailabilityPolicyStartScheduleArgs',
    'DesktopPoolAvailabilityPolicyStartScheduleArgsDict',
    'DesktopPoolAvailabilityPolicyStopScheduleArgs',
    'DesktopPoolAvailabilityPolicyStopScheduleArgsDict',
    'DesktopPoolDevicePolicyArgs',
    'DesktopPoolDevicePolicyArgsDict',
    'DesktopPoolImageArgs',
    'DesktopPoolImageArgsDict',
    'DesktopPoolNetworkConfigurationArgs',
    'DesktopPoolNetworkConfigurationArgsDict',
    'DesktopPoolPrivateAccessDetailsArgs',
    'DesktopPoolPrivateAccessDetailsArgsDict',
    'DesktopPoolSessionLifecycleActionsArgs',
    'DesktopPoolSessionLifecycleActionsArgsDict',
    'DesktopPoolSessionLifecycleActionsDisconnectArgs',
    'DesktopPoolSessionLifecycleActionsDisconnectArgsDict',
    'DesktopPoolSessionLifecycleActionsInactivityArgs',
    'DesktopPoolSessionLifecycleActionsInactivityArgsDict',
    'DesktopPoolShapeConfigArgs',
    'DesktopPoolShapeConfigArgsDict',
    'GetDesktopPoolDesktopsFilterArgs',
    'GetDesktopPoolDesktopsFilterArgsDict',
    'GetDesktopPoolVolumesFilterArgs',
    'GetDesktopPoolVolumesFilterArgsDict',
    'GetDesktopPoolsFilterArgs',
    'GetDesktopPoolsFilterArgsDict',
    'GetDesktopsFilterArgs',
    'GetDesktopsFilterArgsDict',
]

MYPY = False

if not MYPY:
    class DesktopPoolAvailabilityPolicyArgsDict(TypedDict):
        start_schedule: NotRequired[pulumi.Input['DesktopPoolAvailabilityPolicyStartScheduleArgsDict']]
        """
        (Updatable) Provides the schedule information for a desktop.
        """
        stop_schedule: NotRequired[pulumi.Input['DesktopPoolAvailabilityPolicyStopScheduleArgsDict']]
        """
        (Updatable) Provides the schedule information for a desktop.
        """
elif False:
    DesktopPoolAvailabilityPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DesktopPoolAvailabilityPolicyArgs:
    def __init__(__self__, *,
                 start_schedule: Optional[pulumi.Input['DesktopPoolAvailabilityPolicyStartScheduleArgs']] = None,
                 stop_schedule: Optional[pulumi.Input['DesktopPoolAvailabilityPolicyStopScheduleArgs']] = None):
        """
        :param pulumi.Input['DesktopPoolAvailabilityPolicyStartScheduleArgs'] start_schedule: (Updatable) Provides the schedule information for a desktop.
        :param pulumi.Input['DesktopPoolAvailabilityPolicyStopScheduleArgs'] stop_schedule: (Updatable) Provides the schedule information for a desktop.
        """
        if start_schedule is not None:
            pulumi.set(__self__, "start_schedule", start_schedule)
        if stop_schedule is not None:
            pulumi.set(__self__, "stop_schedule", stop_schedule)

    @_builtins.property
    @pulumi.getter(name="startSchedule")
    def start_schedule(self) -> Optional[pulumi.Input['DesktopPoolAvailabilityPolicyStartScheduleArgs']]:
        """
        (Updatable) Provides the schedule information for a desktop.
        """
        return pulumi.get(self, "start_schedule")

    @start_schedule.setter
    def start_schedule(self, value: Optional[pulumi.Input['DesktopPoolAvailabilityPolicyStartScheduleArgs']]):
        pulumi.set(self, "start_schedule", value)

    @_builtins.property
    @pulumi.getter(name="stopSchedule")
    def stop_schedule(self) -> Optional[pulumi.Input['DesktopPoolAvailabilityPolicyStopScheduleArgs']]:
        """
        (Updatable) Provides the schedule information for a desktop.
        """
        return pulumi.get(self, "stop_schedule")

    @stop_schedule.setter
    def stop_schedule(self, value: Optional[pulumi.Input['DesktopPoolAvailabilityPolicyStopScheduleArgs']]):
        pulumi.set(self, "stop_schedule", value)


if not MYPY:
    class DesktopPoolAvailabilityPolicyStartScheduleArgsDict(TypedDict):
        cron_expression: pulumi.Input[_builtins.str]
        """
        (Updatable) A cron expression describing the desktop's schedule.
        """
        timezone: pulumi.Input[_builtins.str]
        """
        (Updatable) The timezone of the desktop's schedule.
        """
elif False:
    DesktopPoolAvailabilityPolicyStartScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DesktopPoolAvailabilityPolicyStartScheduleArgs:
    def __init__(__self__, *,
                 cron_expression: pulumi.Input[_builtins.str],
                 timezone: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] cron_expression: (Updatable) A cron expression describing the desktop's schedule.
        :param pulumi.Input[_builtins.str] timezone: (Updatable) The timezone of the desktop's schedule.
        """
        pulumi.set(__self__, "cron_expression", cron_expression)
        pulumi.set(__self__, "timezone", timezone)

    @_builtins.property
    @pulumi.getter(name="cronExpression")
    def cron_expression(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) A cron expression describing the desktop's schedule.
        """
        return pulumi.get(self, "cron_expression")

    @cron_expression.setter
    def cron_expression(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cron_expression", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The timezone of the desktop's schedule.
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "timezone", value)


if not MYPY:
    class DesktopPoolAvailabilityPolicyStopScheduleArgsDict(TypedDict):
        cron_expression: pulumi.Input[_builtins.str]
        """
        (Updatable) A cron expression describing the desktop's schedule.
        """
        timezone: pulumi.Input[_builtins.str]
        """
        (Updatable) The timezone of the desktop's schedule.
        """
elif False:
    DesktopPoolAvailabilityPolicyStopScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DesktopPoolAvailabilityPolicyStopScheduleArgs:
    def __init__(__self__, *,
                 cron_expression: pulumi.Input[_builtins.str],
                 timezone: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] cron_expression: (Updatable) A cron expression describing the desktop's schedule.
        :param pulumi.Input[_builtins.str] timezone: (Updatable) The timezone of the desktop's schedule.
        """
        pulumi.set(__self__, "cron_expression", cron_expression)
        pulumi.set(__self__, "timezone", timezone)

    @_builtins.property
    @pulumi.getter(name="cronExpression")
    def cron_expression(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) A cron expression describing the desktop's schedule.
        """
        return pulumi.get(self, "cron_expression")

    @cron_expression.setter
    def cron_expression(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cron_expression", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The timezone of the desktop's schedule.
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "timezone", value)


if not MYPY:
    class DesktopPoolDevicePolicyArgsDict(TypedDict):
        audio_mode: pulumi.Input[_builtins.str]
        """
        (Updatable) The audio mode. NONE: No access to the local audio devices is permitted. TODESKTOP: The user may record audio on their desktop.  FROMDESKTOP: The user may play audio on their desktop. FULL: The user may play and record audio on their desktop.
        """
        cdm_mode: pulumi.Input[_builtins.str]
        """
        (Updatable) The client local drive access mode. NONE: No access to local drives permitted. READONLY: The user may read from local drives on their desktop. FULL: The user may read from and write to their local drives on their desktop.
        """
        clipboard_mode: pulumi.Input[_builtins.str]
        """
        (Updatable) The clipboard mode. NONE: No access to the local clipboard is permitted. TODESKTOP: The clipboard can be used to transfer data to the desktop only.  FROMDESKTOP: The clipboard can be used to transfer data from the desktop only. FULL: The clipboard can be used to transfer data to and from the desktop.
        """
        is_display_enabled: pulumi.Input[_builtins.bool]
        """
        (Updatable) Indicates whether the display is enabled.
        """
        is_keyboard_enabled: pulumi.Input[_builtins.bool]
        """
        (Updatable) Indicates whether the keyboard is enabled.
        """
        is_pointer_enabled: pulumi.Input[_builtins.bool]
        """
        (Updatable) Indicates whether the pointer is enabled.
        """
        is_printing_enabled: pulumi.Input[_builtins.bool]
        """
        (Updatable) Indicates whether printing is enabled.
        """
elif False:
    DesktopPoolDevicePolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DesktopPoolDevicePolicyArgs:
    def __init__(__self__, *,
                 audio_mode: pulumi.Input[_builtins.str],
                 cdm_mode: pulumi.Input[_builtins.str],
                 clipboard_mode: pulumi.Input[_builtins.str],
                 is_display_enabled: pulumi.Input[_builtins.bool],
                 is_keyboard_enabled: pulumi.Input[_builtins.bool],
                 is_pointer_enabled: pulumi.Input[_builtins.bool],
                 is_printing_enabled: pulumi.Input[_builtins.bool]):
        """
        :param pulumi.Input[_builtins.str] audio_mode: (Updatable) The audio mode. NONE: No access to the local audio devices is permitted. TODESKTOP: The user may record audio on their desktop.  FROMDESKTOP: The user may play audio on their desktop. FULL: The user may play and record audio on their desktop.
        :param pulumi.Input[_builtins.str] cdm_mode: (Updatable) The client local drive access mode. NONE: No access to local drives permitted. READONLY: The user may read from local drives on their desktop. FULL: The user may read from and write to their local drives on their desktop.
        :param pulumi.Input[_builtins.str] clipboard_mode: (Updatable) The clipboard mode. NONE: No access to the local clipboard is permitted. TODESKTOP: The clipboard can be used to transfer data to the desktop only.  FROMDESKTOP: The clipboard can be used to transfer data from the desktop only. FULL: The clipboard can be used to transfer data to and from the desktop.
        :param pulumi.Input[_builtins.bool] is_display_enabled: (Updatable) Indicates whether the display is enabled.
        :param pulumi.Input[_builtins.bool] is_keyboard_enabled: (Updatable) Indicates whether the keyboard is enabled.
        :param pulumi.Input[_builtins.bool] is_pointer_enabled: (Updatable) Indicates whether the pointer is enabled.
        :param pulumi.Input[_builtins.bool] is_printing_enabled: (Updatable) Indicates whether printing is enabled.
        """
        pulumi.set(__self__, "audio_mode", audio_mode)
        pulumi.set(__self__, "cdm_mode", cdm_mode)
        pulumi.set(__self__, "clipboard_mode", clipboard_mode)
        pulumi.set(__self__, "is_display_enabled", is_display_enabled)
        pulumi.set(__self__, "is_keyboard_enabled", is_keyboard_enabled)
        pulumi.set(__self__, "is_pointer_enabled", is_pointer_enabled)
        pulumi.set(__self__, "is_printing_enabled", is_printing_enabled)

    @_builtins.property
    @pulumi.getter(name="audioMode")
    def audio_mode(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The audio mode. NONE: No access to the local audio devices is permitted. TODESKTOP: The user may record audio on their desktop.  FROMDESKTOP: The user may play audio on their desktop. FULL: The user may play and record audio on their desktop.
        """
        return pulumi.get(self, "audio_mode")

    @audio_mode.setter
    def audio_mode(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "audio_mode", value)

    @_builtins.property
    @pulumi.getter(name="cdmMode")
    def cdm_mode(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The client local drive access mode. NONE: No access to local drives permitted. READONLY: The user may read from local drives on their desktop. FULL: The user may read from and write to their local drives on their desktop.
        """
        return pulumi.get(self, "cdm_mode")

    @cdm_mode.setter
    def cdm_mode(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cdm_mode", value)

    @_builtins.property
    @pulumi.getter(name="clipboardMode")
    def clipboard_mode(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The clipboard mode. NONE: No access to the local clipboard is permitted. TODESKTOP: The clipboard can be used to transfer data to the desktop only.  FROMDESKTOP: The clipboard can be used to transfer data from the desktop only. FULL: The clipboard can be used to transfer data to and from the desktop.
        """
        return pulumi.get(self, "clipboard_mode")

    @clipboard_mode.setter
    def clipboard_mode(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "clipboard_mode", value)

    @_builtins.property
    @pulumi.getter(name="isDisplayEnabled")
    def is_display_enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        (Updatable) Indicates whether the display is enabled.
        """
        return pulumi.get(self, "is_display_enabled")

    @is_display_enabled.setter
    def is_display_enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "is_display_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isKeyboardEnabled")
    def is_keyboard_enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        (Updatable) Indicates whether the keyboard is enabled.
        """
        return pulumi.get(self, "is_keyboard_enabled")

    @is_keyboard_enabled.setter
    def is_keyboard_enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "is_keyboard_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isPointerEnabled")
    def is_pointer_enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        (Updatable) Indicates whether the pointer is enabled.
        """
        return pulumi.get(self, "is_pointer_enabled")

    @is_pointer_enabled.setter
    def is_pointer_enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "is_pointer_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isPrintingEnabled")
    def is_printing_enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        (Updatable) Indicates whether printing is enabled.
        """
        return pulumi.get(self, "is_printing_enabled")

    @is_printing_enabled.setter
    def is_printing_enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "is_printing_enabled", value)


if not MYPY:
    class DesktopPoolImageArgsDict(TypedDict):
        image_id: pulumi.Input[_builtins.str]
        """
        The OCID of the desktop image.
        """
        image_name: pulumi.Input[_builtins.str]
        """
        The name of the desktop image.
        """
        operating_system: NotRequired[pulumi.Input[_builtins.str]]
        """
        The operating system of the desktop image, e.g. "Oracle Linux", "Windows".
        """
elif False:
    DesktopPoolImageArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DesktopPoolImageArgs:
    def __init__(__self__, *,
                 image_id: pulumi.Input[_builtins.str],
                 image_name: pulumi.Input[_builtins.str],
                 operating_system: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] image_id: The OCID of the desktop image.
        :param pulumi.Input[_builtins.str] image_name: The name of the desktop image.
        :param pulumi.Input[_builtins.str] operating_system: The operating system of the desktop image, e.g. "Oracle Linux", "Windows".
        """
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "image_name", image_name)
        if operating_system is not None:
            pulumi.set(__self__, "operating_system", operating_system)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the desktop image.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter(name="imageName")
    def image_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the desktop image.
        """
        return pulumi.get(self, "image_name")

    @image_name.setter
    def image_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "image_name", value)

    @_builtins.property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operating system of the desktop image, e.g. "Oracle Linux", "Windows".
        """
        return pulumi.get(self, "operating_system")

    @operating_system.setter
    def operating_system(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "operating_system", value)


if not MYPY:
    class DesktopPoolNetworkConfigurationArgsDict(TypedDict):
        subnet_id: pulumi.Input[_builtins.str]
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet in the customer VCN where the connectivity will be established.
        """
        vcn_id: pulumi.Input[_builtins.str]
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the customer VCN.
        """
elif False:
    DesktopPoolNetworkConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DesktopPoolNetworkConfigurationArgs:
    def __init__(__self__, *,
                 subnet_id: pulumi.Input[_builtins.str],
                 vcn_id: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet in the customer VCN where the connectivity will be established.
        :param pulumi.Input[_builtins.str] vcn_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the customer VCN.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vcn_id", vcn_id)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet in the customer VCN where the connectivity will be established.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> pulumi.Input[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the customer VCN.
        """
        return pulumi.get(self, "vcn_id")

    @vcn_id.setter
    def vcn_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vcn_id", value)


if not MYPY:
    class DesktopPoolPrivateAccessDetailsArgsDict(TypedDict):
        subnet_id: pulumi.Input[_builtins.str]
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the private subnet in the customer VCN where the connectivity will be established.
        """
        endpoint_fqdn: NotRequired[pulumi.Input[_builtins.str]]
        """
        The three-label FQDN to use for the private endpoint. The customer VCN's DNS records are updated with this FQDN. This enables the customer to use the FQDN instead of the private endpoint's private IP address to access the service (for example, xyz.oraclecloud.com).
        """
        nsg_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of network security groups for the private access.
        """
        private_ip: NotRequired[pulumi.Input[_builtins.str]]
        """
        The IPv4 address from the provided Oracle Cloud Infrastructure subnet which needs to be assigned to the VNIC. If not provided, it will be auto-assigned with an available IPv4 address from the subnet.
        """
        vcn_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the customer VCN.
        """
elif False:
    DesktopPoolPrivateAccessDetailsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DesktopPoolPrivateAccessDetailsArgs:
    def __init__(__self__, *,
                 subnet_id: pulumi.Input[_builtins.str],
                 endpoint_fqdn: Optional[pulumi.Input[_builtins.str]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 vcn_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the private subnet in the customer VCN where the connectivity will be established.
        :param pulumi.Input[_builtins.str] endpoint_fqdn: The three-label FQDN to use for the private endpoint. The customer VCN's DNS records are updated with this FQDN. This enables the customer to use the FQDN instead of the private endpoint's private IP address to access the service (for example, xyz.oraclecloud.com).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] nsg_ids: A list of network security groups for the private access.
        :param pulumi.Input[_builtins.str] private_ip: The IPv4 address from the provided Oracle Cloud Infrastructure subnet which needs to be assigned to the VNIC. If not provided, it will be auto-assigned with an available IPv4 address from the subnet.
        :param pulumi.Input[_builtins.str] vcn_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the customer VCN.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        if endpoint_fqdn is not None:
            pulumi.set(__self__, "endpoint_fqdn", endpoint_fqdn)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if vcn_id is not None:
            pulumi.set(__self__, "vcn_id", vcn_id)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the private subnet in the customer VCN where the connectivity will be established.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="endpointFqdn")
    def endpoint_fqdn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The three-label FQDN to use for the private endpoint. The customer VCN's DNS records are updated with this FQDN. This enables the customer to use the FQDN instead of the private endpoint's private IP address to access the service (for example, xyz.oraclecloud.com).
        """
        return pulumi.get(self, "endpoint_fqdn")

    @endpoint_fqdn.setter
    def endpoint_fqdn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_fqdn", value)

    @_builtins.property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of network security groups for the private access.
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 address from the provided Oracle Cloud Infrastructure subnet which needs to be assigned to the VNIC. If not provided, it will be auto-assigned with an available IPv4 address from the subnet.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip", value)

    @_builtins.property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the customer VCN.
        """
        return pulumi.get(self, "vcn_id")

    @vcn_id.setter
    def vcn_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vcn_id", value)


if not MYPY:
    class DesktopPoolSessionLifecycleActionsArgsDict(TypedDict):
        disconnect: NotRequired[pulumi.Input['DesktopPoolSessionLifecycleActionsDisconnectArgsDict']]
        """
        (Updatable) Action and grace period for disconnect. Session disconnect can not be used together with an `availability_policy` schedule.
        """
        inactivity: NotRequired[pulumi.Input['DesktopPoolSessionLifecycleActionsInactivityArgsDict']]
        """
        (Updatable) Action and grace period for inactivity
        """
elif False:
    DesktopPoolSessionLifecycleActionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DesktopPoolSessionLifecycleActionsArgs:
    def __init__(__self__, *,
                 disconnect: Optional[pulumi.Input['DesktopPoolSessionLifecycleActionsDisconnectArgs']] = None,
                 inactivity: Optional[pulumi.Input['DesktopPoolSessionLifecycleActionsInactivityArgs']] = None):
        """
        :param pulumi.Input['DesktopPoolSessionLifecycleActionsDisconnectArgs'] disconnect: (Updatable) Action and grace period for disconnect. Session disconnect can not be used together with an `availability_policy` schedule.
        :param pulumi.Input['DesktopPoolSessionLifecycleActionsInactivityArgs'] inactivity: (Updatable) Action and grace period for inactivity
        """
        if disconnect is not None:
            pulumi.set(__self__, "disconnect", disconnect)
        if inactivity is not None:
            pulumi.set(__self__, "inactivity", inactivity)

    @_builtins.property
    @pulumi.getter
    def disconnect(self) -> Optional[pulumi.Input['DesktopPoolSessionLifecycleActionsDisconnectArgs']]:
        """
        (Updatable) Action and grace period for disconnect. Session disconnect can not be used together with an `availability_policy` schedule.
        """
        return pulumi.get(self, "disconnect")

    @disconnect.setter
    def disconnect(self, value: Optional[pulumi.Input['DesktopPoolSessionLifecycleActionsDisconnectArgs']]):
        pulumi.set(self, "disconnect", value)

    @_builtins.property
    @pulumi.getter
    def inactivity(self) -> Optional[pulumi.Input['DesktopPoolSessionLifecycleActionsInactivityArgs']]:
        """
        (Updatable) Action and grace period for inactivity
        """
        return pulumi.get(self, "inactivity")

    @inactivity.setter
    def inactivity(self, value: Optional[pulumi.Input['DesktopPoolSessionLifecycleActionsInactivityArgs']]):
        pulumi.set(self, "inactivity", value)


if not MYPY:
    class DesktopPoolSessionLifecycleActionsDisconnectArgsDict(TypedDict):
        action: pulumi.Input[_builtins.str]
        """
        (Updatable) a disconnect action to be triggered. Could be set to NONE or STOP
        """
        grace_period_in_minutes: NotRequired[pulumi.Input[_builtins.int]]
        """
        (Updatable) The period of time (in minutes) after disconnect before any action occurs. If the value is not provided, a default value is used.
        """
elif False:
    DesktopPoolSessionLifecycleActionsDisconnectArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DesktopPoolSessionLifecycleActionsDisconnectArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[_builtins.str],
                 grace_period_in_minutes: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] action: (Updatable) a disconnect action to be triggered. Could be set to NONE or STOP
        :param pulumi.Input[_builtins.int] grace_period_in_minutes: (Updatable) The period of time (in minutes) after disconnect before any action occurs. If the value is not provided, a default value is used.
        """
        pulumi.set(__self__, "action", action)
        if grace_period_in_minutes is not None:
            pulumi.set(__self__, "grace_period_in_minutes", grace_period_in_minutes)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) a disconnect action to be triggered. Could be set to NONE or STOP
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="gracePeriodInMinutes")
    def grace_period_in_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The period of time (in minutes) after disconnect before any action occurs. If the value is not provided, a default value is used.
        """
        return pulumi.get(self, "grace_period_in_minutes")

    @grace_period_in_minutes.setter
    def grace_period_in_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "grace_period_in_minutes", value)


if not MYPY:
    class DesktopPoolSessionLifecycleActionsInactivityArgsDict(TypedDict):
        action: pulumi.Input[_builtins.str]
        """
        (Updatable) an inactivity action to be triggered. Could be set to NONE or DISCONNECT.
        """
        grace_period_in_minutes: NotRequired[pulumi.Input[_builtins.int]]
        """
        (Updatable) The period of time (in minutes) during which the session must remain inactive before any action occurs. If the value is not provided, a default value is used.
        """
elif False:
    DesktopPoolSessionLifecycleActionsInactivityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DesktopPoolSessionLifecycleActionsInactivityArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[_builtins.str],
                 grace_period_in_minutes: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] action: (Updatable) an inactivity action to be triggered. Could be set to NONE or DISCONNECT.
        :param pulumi.Input[_builtins.int] grace_period_in_minutes: (Updatable) The period of time (in minutes) during which the session must remain inactive before any action occurs. If the value is not provided, a default value is used.
        """
        pulumi.set(__self__, "action", action)
        if grace_period_in_minutes is not None:
            pulumi.set(__self__, "grace_period_in_minutes", grace_period_in_minutes)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) an inactivity action to be triggered. Could be set to NONE or DISCONNECT.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="gracePeriodInMinutes")
    def grace_period_in_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The period of time (in minutes) during which the session must remain inactive before any action occurs. If the value is not provided, a default value is used.
        """
        return pulumi.get(self, "grace_period_in_minutes")

    @grace_period_in_minutes.setter
    def grace_period_in_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "grace_period_in_minutes", value)


if not MYPY:
    class DesktopPoolShapeConfigArgsDict(TypedDict):
        baseline_ocpu_utilization: NotRequired[pulumi.Input[_builtins.str]]
        """
        The baseline OCPU utilization for a subcore burstable VM instance used for each desktop compute instance in the desktop pool. Leave this attribute blank for a non-burstable instance, or explicitly specify non-burstable with `BASELINE_1_1`. The following values are supported:
        * `BASELINE_1_8` - baseline usage is 1/8 of an OCPU.
        * `BASELINE_1_2` - baseline usage is 1/2 of an OCPU.
        * `BASELINE_1_1` - baseline usage is the entire OCPU. This represents a non-burstable instance.
        """
        memory_in_gbs: NotRequired[pulumi.Input[_builtins.str]]
        """
        The total amount of memory available in gigabytes for each desktop compute instance in the desktop pool.
        """
        ocpus: NotRequired[pulumi.Input[_builtins.str]]
        """
        The total number of OCPUs available for each desktop compute instance in the desktop pool.
        """
elif False:
    DesktopPoolShapeConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DesktopPoolShapeConfigArgs:
    def __init__(__self__, *,
                 baseline_ocpu_utilization: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_in_gbs: Optional[pulumi.Input[_builtins.str]] = None,
                 ocpus: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] baseline_ocpu_utilization: The baseline OCPU utilization for a subcore burstable VM instance used for each desktop compute instance in the desktop pool. Leave this attribute blank for a non-burstable instance, or explicitly specify non-burstable with `BASELINE_1_1`. The following values are supported:
               * `BASELINE_1_8` - baseline usage is 1/8 of an OCPU.
               * `BASELINE_1_2` - baseline usage is 1/2 of an OCPU.
               * `BASELINE_1_1` - baseline usage is the entire OCPU. This represents a non-burstable instance.
        :param pulumi.Input[_builtins.str] memory_in_gbs: The total amount of memory available in gigabytes for each desktop compute instance in the desktop pool.
        :param pulumi.Input[_builtins.str] ocpus: The total number of OCPUs available for each desktop compute instance in the desktop pool.
        """
        if baseline_ocpu_utilization is not None:
            pulumi.set(__self__, "baseline_ocpu_utilization", baseline_ocpu_utilization)
        if memory_in_gbs is not None:
            pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        if ocpus is not None:
            pulumi.set(__self__, "ocpus", ocpus)

    @_builtins.property
    @pulumi.getter(name="baselineOcpuUtilization")
    def baseline_ocpu_utilization(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The baseline OCPU utilization for a subcore burstable VM instance used for each desktop compute instance in the desktop pool. Leave this attribute blank for a non-burstable instance, or explicitly specify non-burstable with `BASELINE_1_1`. The following values are supported:
        * `BASELINE_1_8` - baseline usage is 1/8 of an OCPU.
        * `BASELINE_1_2` - baseline usage is 1/2 of an OCPU.
        * `BASELINE_1_1` - baseline usage is the entire OCPU. This represents a non-burstable instance.
        """
        return pulumi.get(self, "baseline_ocpu_utilization")

    @baseline_ocpu_utilization.setter
    def baseline_ocpu_utilization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "baseline_ocpu_utilization", value)

    @_builtins.property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The total amount of memory available in gigabytes for each desktop compute instance in the desktop pool.
        """
        return pulumi.get(self, "memory_in_gbs")

    @memory_in_gbs.setter
    def memory_in_gbs(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "memory_in_gbs", value)

    @_builtins.property
    @pulumi.getter
    def ocpus(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The total number of OCPUs available for each desktop compute instance in the desktop pool.
        """
        return pulumi.get(self, "ocpus")

    @ocpus.setter
    def ocpus(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ocpus", value)


if not MYPY:
    class GetDesktopPoolDesktopsFilterArgsDict(TypedDict):
        name: _builtins.str
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetDesktopPoolDesktopsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetDesktopPoolDesktopsFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetDesktopPoolVolumesFilterArgsDict(TypedDict):
        name: _builtins.str
        """
        The name of the desktop pool volume.
        """
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetDesktopPoolVolumesFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetDesktopPoolVolumesFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: The name of the desktop pool volume.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the desktop pool volume.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetDesktopPoolsFilterArgsDict(TypedDict):
        name: _builtins.str
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetDesktopPoolsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetDesktopPoolsFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetDesktopsFilterArgsDict(TypedDict):
        name: _builtins.str
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetDesktopsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetDesktopsFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


