# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['FileSystemQuotaRuleArgs', 'FileSystemQuotaRule']

@pulumi.input_type
class FileSystemQuotaRuleArgs:
    def __init__(__self__, *,
                 file_system_id: pulumi.Input[_builtins.str],
                 is_hard_quota: pulumi.Input[_builtins.bool],
                 principal_type: pulumi.Input[_builtins.str],
                 quota_limit_in_gigabytes: pulumi.Input[_builtins.int],
                 are_violators_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.int]] = None,
                 quota_rule_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a FileSystemQuotaRule resource.
        :param pulumi.Input[_builtins.str] file_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the file system.
        :param pulumi.Input[_builtins.bool] is_hard_quota: The flag is an identifier to tell whether the quota rule will be enforced. If `isHardQuota` is true, the quota rule will be enforced so the write will be blocked if usage exceeds the hard quota limit. If `isHardQuota` is false, usage can exceed the soft quota limit. An alarm or notification will be sent to the customer, if the specific usage exceeds.
        :param pulumi.Input[_builtins.str] principal_type: The type of the owner of this quota rule and usage.
        :param pulumi.Input[_builtins.int] quota_limit_in_gigabytes: (Updatable) The value of the quota rule. The unit is Gigabyte. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information. Example: `UserXYZ's quota`
        :param pulumi.Input[_builtins.int] principal_id: An identifier for the owner of this usage and quota rule. Unix-like operating systems use this integer value to identify a user or group to manage access control.
        """
        pulumi.set(__self__, "file_system_id", file_system_id)
        pulumi.set(__self__, "is_hard_quota", is_hard_quota)
        pulumi.set(__self__, "principal_type", principal_type)
        pulumi.set(__self__, "quota_limit_in_gigabytes", quota_limit_in_gigabytes)
        if are_violators_only is not None:
            pulumi.set(__self__, "are_violators_only", are_violators_only)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if quota_rule_id is not None:
            pulumi.set(__self__, "quota_rule_id", quota_rule_id)

    @_builtins.property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> pulumi.Input[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the file system.
        """
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "file_system_id", value)

    @_builtins.property
    @pulumi.getter(name="isHardQuota")
    def is_hard_quota(self) -> pulumi.Input[_builtins.bool]:
        """
        The flag is an identifier to tell whether the quota rule will be enforced. If `isHardQuota` is true, the quota rule will be enforced so the write will be blocked if usage exceeds the hard quota limit. If `isHardQuota` is false, usage can exceed the soft quota limit. An alarm or notification will be sent to the customer, if the specific usage exceeds.
        """
        return pulumi.get(self, "is_hard_quota")

    @is_hard_quota.setter
    def is_hard_quota(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "is_hard_quota", value)

    @_builtins.property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the owner of this quota rule and usage.
        """
        return pulumi.get(self, "principal_type")

    @principal_type.setter
    def principal_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "principal_type", value)

    @_builtins.property
    @pulumi.getter(name="quotaLimitInGigabytes")
    def quota_limit_in_gigabytes(self) -> pulumi.Input[_builtins.int]:
        """
        (Updatable) The value of the quota rule. The unit is Gigabyte. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "quota_limit_in_gigabytes")

    @quota_limit_in_gigabytes.setter
    def quota_limit_in_gigabytes(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "quota_limit_in_gigabytes", value)

    @_builtins.property
    @pulumi.getter(name="areViolatorsOnly")
    def are_violators_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "are_violators_only")

    @are_violators_only.setter
    def are_violators_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "are_violators_only", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information. Example: `UserXYZ's quota`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        An identifier for the owner of this usage and quota rule. Unix-like operating systems use this integer value to identify a user or group to manage access control.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="quotaRuleId")
    def quota_rule_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "quota_rule_id")

    @quota_rule_id.setter
    def quota_rule_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "quota_rule_id", value)


@pulumi.input_type
class _FileSystemQuotaRuleState:
    def __init__(__self__, *,
                 are_violators_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_hard_quota: Optional[pulumi.Input[_builtins.bool]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.int]] = None,
                 principal_type: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_limit_in_gigabytes: Optional[pulumi.Input[_builtins.int]] = None,
                 quota_rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FileSystemQuotaRule resources.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information. Example: `UserXYZ's quota`
        :param pulumi.Input[_builtins.str] file_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the file system.
        :param pulumi.Input[_builtins.bool] is_hard_quota: The flag is an identifier to tell whether the quota rule will be enforced. If `isHardQuota` is true, the quota rule will be enforced so the write will be blocked if usage exceeds the hard quota limit. If `isHardQuota` is false, usage can exceed the soft quota limit. An alarm or notification will be sent to the customer, if the specific usage exceeds.
        :param pulumi.Input[_builtins.int] principal_id: An identifier for the owner of this usage and quota rule. Unix-like operating systems use this integer value to identify a user or group to manage access control.
        :param pulumi.Input[_builtins.str] principal_type: The type of the owner of this quota rule and usage.
        :param pulumi.Input[_builtins.int] quota_limit_in_gigabytes: (Updatable) The value of the quota rule. The unit is Gigabyte. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] time_created: The date and time the quota rule was started, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_updated: The date and time the quota rule was last updated, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        if are_violators_only is not None:
            pulumi.set(__self__, "are_violators_only", are_violators_only)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if file_system_id is not None:
            pulumi.set(__self__, "file_system_id", file_system_id)
        if is_hard_quota is not None:
            pulumi.set(__self__, "is_hard_quota", is_hard_quota)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if principal_type is not None:
            pulumi.set(__self__, "principal_type", principal_type)
        if quota_limit_in_gigabytes is not None:
            pulumi.set(__self__, "quota_limit_in_gigabytes", quota_limit_in_gigabytes)
        if quota_rule_id is not None:
            pulumi.set(__self__, "quota_rule_id", quota_rule_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="areViolatorsOnly")
    def are_violators_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "are_violators_only")

    @are_violators_only.setter
    def are_violators_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "are_violators_only", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information. Example: `UserXYZ's quota`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the file system.
        """
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file_system_id", value)

    @_builtins.property
    @pulumi.getter(name="isHardQuota")
    def is_hard_quota(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The flag is an identifier to tell whether the quota rule will be enforced. If `isHardQuota` is true, the quota rule will be enforced so the write will be blocked if usage exceeds the hard quota limit. If `isHardQuota` is false, usage can exceed the soft quota limit. An alarm or notification will be sent to the customer, if the specific usage exceeds.
        """
        return pulumi.get(self, "is_hard_quota")

    @is_hard_quota.setter
    def is_hard_quota(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_hard_quota", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        An identifier for the owner of this usage and quota rule. Unix-like operating systems use this integer value to identify a user or group to manage access control.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the owner of this quota rule and usage.
        """
        return pulumi.get(self, "principal_type")

    @principal_type.setter
    def principal_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_type", value)

    @_builtins.property
    @pulumi.getter(name="quotaLimitInGigabytes")
    def quota_limit_in_gigabytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The value of the quota rule. The unit is Gigabyte. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "quota_limit_in_gigabytes")

    @quota_limit_in_gigabytes.setter
    def quota_limit_in_gigabytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "quota_limit_in_gigabytes", value)

    @_builtins.property
    @pulumi.getter(name="quotaRuleId")
    def quota_rule_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "quota_rule_id")

    @quota_rule_id.setter
    def quota_rule_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "quota_rule_id", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the quota rule was started, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the quota rule was last updated, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:FileStorage/fileSystemQuotaRule:FileSystemQuotaRule")
class FileSystemQuotaRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 are_violators_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_hard_quota: Optional[pulumi.Input[_builtins.bool]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.int]] = None,
                 principal_type: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_limit_in_gigabytes: Optional[pulumi.Input[_builtins.int]] = None,
                 quota_rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the File System Quota Rule resource in Oracle Cloud Infrastructure File Storage service.

        Create an FS level, user or group quota rule given the `fileSystemId`, `principalId`, `principalType` and
        `isHardQuota` parameters.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_file_system_quota_rule = oci.filestorage.FileSystemQuotaRule("test_file_system_quota_rule",
            file_system_id=test_file_system["id"],
            is_hard_quota=file_system_quota_rule_is_hard_quota,
            principal_type=file_system_quota_rule_principal_type,
            quota_limit_in_gigabytes=file_system_quota_rule_quota_limit_in_gigabytes,
            display_name=file_system_quota_rule_display_name,
            principal_id=test_principal["id"])
        ```

        ## Import

        FileSystemQuotaRules can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:FileStorage/fileSystemQuotaRule:FileSystemQuotaRule test_file_system_quota_rule "fileSystems/{fileSystemId}/quotaRules/{quotaRuleId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information. Example: `UserXYZ's quota`
        :param pulumi.Input[_builtins.str] file_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the file system.
        :param pulumi.Input[_builtins.bool] is_hard_quota: The flag is an identifier to tell whether the quota rule will be enforced. If `isHardQuota` is true, the quota rule will be enforced so the write will be blocked if usage exceeds the hard quota limit. If `isHardQuota` is false, usage can exceed the soft quota limit. An alarm or notification will be sent to the customer, if the specific usage exceeds.
        :param pulumi.Input[_builtins.int] principal_id: An identifier for the owner of this usage and quota rule. Unix-like operating systems use this integer value to identify a user or group to manage access control.
        :param pulumi.Input[_builtins.str] principal_type: The type of the owner of this quota rule and usage.
        :param pulumi.Input[_builtins.int] quota_limit_in_gigabytes: (Updatable) The value of the quota rule. The unit is Gigabyte. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FileSystemQuotaRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the File System Quota Rule resource in Oracle Cloud Infrastructure File Storage service.

        Create an FS level, user or group quota rule given the `fileSystemId`, `principalId`, `principalType` and
        `isHardQuota` parameters.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_file_system_quota_rule = oci.filestorage.FileSystemQuotaRule("test_file_system_quota_rule",
            file_system_id=test_file_system["id"],
            is_hard_quota=file_system_quota_rule_is_hard_quota,
            principal_type=file_system_quota_rule_principal_type,
            quota_limit_in_gigabytes=file_system_quota_rule_quota_limit_in_gigabytes,
            display_name=file_system_quota_rule_display_name,
            principal_id=test_principal["id"])
        ```

        ## Import

        FileSystemQuotaRules can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:FileStorage/fileSystemQuotaRule:FileSystemQuotaRule test_file_system_quota_rule "fileSystems/{fileSystemId}/quotaRules/{quotaRuleId}"
        ```

        :param str resource_name: The name of the resource.
        :param FileSystemQuotaRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FileSystemQuotaRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 are_violators_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_hard_quota: Optional[pulumi.Input[_builtins.bool]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.int]] = None,
                 principal_type: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_limit_in_gigabytes: Optional[pulumi.Input[_builtins.int]] = None,
                 quota_rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FileSystemQuotaRuleArgs.__new__(FileSystemQuotaRuleArgs)

            __props__.__dict__["are_violators_only"] = are_violators_only
            __props__.__dict__["display_name"] = display_name
            if file_system_id is None and not opts.urn:
                raise TypeError("Missing required property 'file_system_id'")
            __props__.__dict__["file_system_id"] = file_system_id
            if is_hard_quota is None and not opts.urn:
                raise TypeError("Missing required property 'is_hard_quota'")
            __props__.__dict__["is_hard_quota"] = is_hard_quota
            __props__.__dict__["principal_id"] = principal_id
            if principal_type is None and not opts.urn:
                raise TypeError("Missing required property 'principal_type'")
            __props__.__dict__["principal_type"] = principal_type
            if quota_limit_in_gigabytes is None and not opts.urn:
                raise TypeError("Missing required property 'quota_limit_in_gigabytes'")
            __props__.__dict__["quota_limit_in_gigabytes"] = quota_limit_in_gigabytes
            __props__.__dict__["quota_rule_id"] = quota_rule_id
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(FileSystemQuotaRule, __self__).__init__(
            'oci:FileStorage/fileSystemQuotaRule:FileSystemQuotaRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            are_violators_only: Optional[pulumi.Input[_builtins.bool]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
            is_hard_quota: Optional[pulumi.Input[_builtins.bool]] = None,
            principal_id: Optional[pulumi.Input[_builtins.int]] = None,
            principal_type: Optional[pulumi.Input[_builtins.str]] = None,
            quota_limit_in_gigabytes: Optional[pulumi.Input[_builtins.int]] = None,
            quota_rule_id: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'FileSystemQuotaRule':
        """
        Get an existing FileSystemQuotaRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information. Example: `UserXYZ's quota`
        :param pulumi.Input[_builtins.str] file_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the file system.
        :param pulumi.Input[_builtins.bool] is_hard_quota: The flag is an identifier to tell whether the quota rule will be enforced. If `isHardQuota` is true, the quota rule will be enforced so the write will be blocked if usage exceeds the hard quota limit. If `isHardQuota` is false, usage can exceed the soft quota limit. An alarm or notification will be sent to the customer, if the specific usage exceeds.
        :param pulumi.Input[_builtins.int] principal_id: An identifier for the owner of this usage and quota rule. Unix-like operating systems use this integer value to identify a user or group to manage access control.
        :param pulumi.Input[_builtins.str] principal_type: The type of the owner of this quota rule and usage.
        :param pulumi.Input[_builtins.int] quota_limit_in_gigabytes: (Updatable) The value of the quota rule. The unit is Gigabyte. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] time_created: The date and time the quota rule was started, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_updated: The date and time the quota rule was last updated, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FileSystemQuotaRuleState.__new__(_FileSystemQuotaRuleState)

        __props__.__dict__["are_violators_only"] = are_violators_only
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["file_system_id"] = file_system_id
        __props__.__dict__["is_hard_quota"] = is_hard_quota
        __props__.__dict__["principal_id"] = principal_id
        __props__.__dict__["principal_type"] = principal_type
        __props__.__dict__["quota_limit_in_gigabytes"] = quota_limit_in_gigabytes
        __props__.__dict__["quota_rule_id"] = quota_rule_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return FileSystemQuotaRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="areViolatorsOnly")
    def are_violators_only(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "are_violators_only")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information. Example: `UserXYZ's quota`
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the file system.
        """
        return pulumi.get(self, "file_system_id")

    @_builtins.property
    @pulumi.getter(name="isHardQuota")
    def is_hard_quota(self) -> pulumi.Output[_builtins.bool]:
        """
        The flag is an identifier to tell whether the quota rule will be enforced. If `isHardQuota` is true, the quota rule will be enforced so the write will be blocked if usage exceeds the hard quota limit. If `isHardQuota` is false, usage can exceed the soft quota limit. An alarm or notification will be sent to the customer, if the specific usage exceeds.
        """
        return pulumi.get(self, "is_hard_quota")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Output[_builtins.int]:
        """
        An identifier for the owner of this usage and quota rule. Unix-like operating systems use this integer value to identify a user or group to manage access control.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the owner of this quota rule and usage.
        """
        return pulumi.get(self, "principal_type")

    @_builtins.property
    @pulumi.getter(name="quotaLimitInGigabytes")
    def quota_limit_in_gigabytes(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) The value of the quota rule. The unit is Gigabyte. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "quota_limit_in_gigabytes")

    @_builtins.property
    @pulumi.getter(name="quotaRuleId")
    def quota_rule_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "quota_rule_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the quota rule was started, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the quota rule was last updated, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

