# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMountTargetsResult',
    'AwaitableGetMountTargetsResult',
    'get_mount_targets',
    'get_mount_targets_output',
]

@pulumi.output_type
class GetMountTargetsResult:
    """
    A collection of values returned by getMountTargets.
    """
    def __init__(__self__, availability_domain=None, compartment_id=None, display_name=None, export_set_id=None, filters=None, id=None, mount_targets=None, state=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if export_set_id and not isinstance(export_set_id, str):
            raise TypeError("Expected argument 'export_set_id' to be a str")
        pulumi.set(__self__, "export_set_id", export_set_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if mount_targets and not isinstance(mount_targets, list):
            raise TypeError("Expected argument 'mount_targets' to be a list")
        pulumi.set(__self__, "mount_targets", mount_targets)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> _builtins.str:
        """
        The availability domain the mount target is in. May be unset as a blank or NULL value.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the mount target.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My mount target`
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="exportSetId")
    def export_set_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated export set. Controls what file systems will be exported through Network File System (NFS) protocol on this mount target.
        """
        return pulumi.get(self, "export_set_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetMountTargetsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the mount target.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="mountTargets")
    def mount_targets(self) -> Sequence['outputs.GetMountTargetsMountTargetResult']:
        """
        The list of mount_targets.
        """
        return pulumi.get(self, "mount_targets")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the mount target.
        """
        return pulumi.get(self, "state")


class AwaitableGetMountTargetsResult(GetMountTargetsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMountTargetsResult(
            availability_domain=self.availability_domain,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            export_set_id=self.export_set_id,
            filters=self.filters,
            id=self.id,
            mount_targets=self.mount_targets,
            state=self.state)


def get_mount_targets(availability_domain: Optional[_builtins.str] = None,
                      compartment_id: Optional[_builtins.str] = None,
                      display_name: Optional[_builtins.str] = None,
                      export_set_id: Optional[_builtins.str] = None,
                      filters: Optional[Sequence[Union['GetMountTargetsFilterArgs', 'GetMountTargetsFilterArgsDict']]] = None,
                      id: Optional[_builtins.str] = None,
                      state: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMountTargetsResult:
    """
    This data source provides the list of Mount Targets in Oracle Cloud Infrastructure File Storage service.

    Lists the mount target resources in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_mount_targets = oci.FileStorage.get_mount_targets(availability_domain=mount_target_availability_domain,
        compartment_id=compartment_id,
        display_name=mount_target_display_name,
        export_set_id=test_export_set["id"],
        id=mount_target_id,
        state=mount_target_state)
    ```


    :param _builtins.str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.str display_name: A user-friendly name. It does not have to be unique, and it is changeable.  Example: `My resource`
    :param _builtins.str export_set_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the export set.
    :param _builtins.str id: Filter results by [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Must be an OCID of the correct type for the resouce type.
    :param _builtins.str state: Filter results by the specified lifecycle state. Must be a valid state for the resource type.
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['exportSetId'] = export_set_id
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FileStorage/getMountTargets:getMountTargets', __args__, opts=opts, typ=GetMountTargetsResult).value

    return AwaitableGetMountTargetsResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        export_set_id=pulumi.get(__ret__, 'export_set_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        mount_targets=pulumi.get(__ret__, 'mount_targets'),
        state=pulumi.get(__ret__, 'state'))
def get_mount_targets_output(availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
                             compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                             display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             export_set_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             filters: Optional[pulumi.Input[Optional[Sequence[Union['GetMountTargetsFilterArgs', 'GetMountTargetsFilterArgsDict']]]]] = None,
                             id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMountTargetsResult]:
    """
    This data source provides the list of Mount Targets in Oracle Cloud Infrastructure File Storage service.

    Lists the mount target resources in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_mount_targets = oci.FileStorage.get_mount_targets(availability_domain=mount_target_availability_domain,
        compartment_id=compartment_id,
        display_name=mount_target_display_name,
        export_set_id=test_export_set["id"],
        id=mount_target_id,
        state=mount_target_state)
    ```


    :param _builtins.str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.str display_name: A user-friendly name. It does not have to be unique, and it is changeable.  Example: `My resource`
    :param _builtins.str export_set_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the export set.
    :param _builtins.str id: Filter results by [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Must be an OCID of the correct type for the resouce type.
    :param _builtins.str state: Filter results by the specified lifecycle state. Must be a valid state for the resource type.
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['exportSetId'] = export_set_id
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FileStorage/getMountTargets:getMountTargets', __args__, opts=opts, typ=GetMountTargetsResult)
    return __ret__.apply(lambda __response__: GetMountTargetsResult(
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        export_set_id=pulumi.get(__response__, 'export_set_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        mount_targets=pulumi.get(__response__, 'mount_targets'),
        state=pulumi.get(__response__, 'state')))
