# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CatalogItemArgs', 'CatalogItem']

@pulumi.input_type
class CatalogItemArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 config_source_type: pulumi.Input[_builtins.str],
                 description: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 package_type: pulumi.Input[_builtins.str],
                 catalog_source_payload: Optional[pulumi.Input['CatalogItemCatalogSourcePayloadArgs']] = None,
                 clone_catalog_item_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 listing_id: Optional[pulumi.Input[_builtins.str]] = None,
                 listing_version: Optional[pulumi.Input[_builtins.str]] = None,
                 short_description: Optional[pulumi.Input[_builtins.str]] = None,
                 time_released: Optional[pulumi.Input[_builtins.str]] = None,
                 version_description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CatalogItem resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[_builtins.str] config_source_type: Config source type Eg: STACK_TEMPLATE_CATALOG_SOURCE, PAR_CATALOG_SOURCE, GIT_CATALOG_SOURCE, MARKETPLACE_CATALOG_SOURCE.
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the CatalogItem.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The CatalogItem name.
        :param pulumi.Input[_builtins.str] package_type: Config package type Eg: TF_PACKAGE, NON_TF_PACKAGE, CONFIG_FILE.
        :param pulumi.Input['CatalogItemCatalogSourcePayloadArgs'] catalog_source_payload: Catalog source payload.
        :param pulumi.Input[_builtins.int] clone_catalog_item_trigger: (Updatable) An optional property when incremented triggers Clone Catalog Item. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] listing_id: The catalog listing Id.
        :param pulumi.Input[_builtins.str] listing_version: The catalog package version.
        :param pulumi.Input[_builtins.str] short_description: (Updatable) Short description about the catalog item.
        :param pulumi.Input[_builtins.str] time_released: The date and time the CatalogItem was released, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] version_description: (Updatable) Version description about the catalog item.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "config_source_type", config_source_type)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "package_type", package_type)
        if catalog_source_payload is not None:
            pulumi.set(__self__, "catalog_source_payload", catalog_source_payload)
        if clone_catalog_item_trigger is not None:
            pulumi.set(__self__, "clone_catalog_item_trigger", clone_catalog_item_trigger)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if listing_id is not None:
            pulumi.set(__self__, "listing_id", listing_id)
        if listing_version is not None:
            pulumi.set(__self__, "listing_version", listing_version)
        if short_description is not None:
            pulumi.set(__self__, "short_description", short_description)
        if time_released is not None:
            pulumi.set(__self__, "time_released", time_released)
        if version_description is not None:
            pulumi.set(__self__, "version_description", version_description)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="configSourceType")
    def config_source_type(self) -> pulumi.Input[_builtins.str]:
        """
        Config source type Eg: STACK_TEMPLATE_CATALOG_SOURCE, PAR_CATALOG_SOURCE, GIT_CATALOG_SOURCE, MARKETPLACE_CATALOG_SOURCE.
        """
        return pulumi.get(self, "config_source_type")

    @config_source_type.setter
    def config_source_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "config_source_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The description of the CatalogItem.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The CatalogItem name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="packageType")
    def package_type(self) -> pulumi.Input[_builtins.str]:
        """
        Config package type Eg: TF_PACKAGE, NON_TF_PACKAGE, CONFIG_FILE.
        """
        return pulumi.get(self, "package_type")

    @package_type.setter
    def package_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "package_type", value)

    @_builtins.property
    @pulumi.getter(name="catalogSourcePayload")
    def catalog_source_payload(self) -> Optional[pulumi.Input['CatalogItemCatalogSourcePayloadArgs']]:
        """
        Catalog source payload.
        """
        return pulumi.get(self, "catalog_source_payload")

    @catalog_source_payload.setter
    def catalog_source_payload(self, value: Optional[pulumi.Input['CatalogItemCatalogSourcePayloadArgs']]):
        pulumi.set(self, "catalog_source_payload", value)

    @_builtins.property
    @pulumi.getter(name="cloneCatalogItemTrigger")
    def clone_catalog_item_trigger(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Clone Catalog Item. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "clone_catalog_item_trigger")

    @clone_catalog_item_trigger.setter
    def clone_catalog_item_trigger(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "clone_catalog_item_trigger", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="listingId")
    def listing_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The catalog listing Id.
        """
        return pulumi.get(self, "listing_id")

    @listing_id.setter
    def listing_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listing_id", value)

    @_builtins.property
    @pulumi.getter(name="listingVersion")
    def listing_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The catalog package version.
        """
        return pulumi.get(self, "listing_version")

    @listing_version.setter
    def listing_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listing_version", value)

    @_builtins.property
    @pulumi.getter(name="shortDescription")
    def short_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Short description about the catalog item.
        """
        return pulumi.get(self, "short_description")

    @short_description.setter
    def short_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "short_description", value)

    @_builtins.property
    @pulumi.getter(name="timeReleased")
    def time_released(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the CatalogItem was released, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_released")

    @time_released.setter
    def time_released(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_released", value)

    @_builtins.property
    @pulumi.getter(name="versionDescription")
    def version_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Version description about the catalog item.
        """
        return pulumi.get(self, "version_description")

    @version_description.setter
    def version_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_description", value)


@pulumi.input_type
class _CatalogItemState:
    def __init__(__self__, *,
                 catalog_result_payloads: Optional[pulumi.Input[Sequence[pulumi.Input['CatalogItemCatalogResultPayloadArgs']]]] = None,
                 catalog_source_payload: Optional[pulumi.Input['CatalogItemCatalogSourcePayloadArgs']] = None,
                 clone_catalog_item_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 config_source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 listing_id: Optional[pulumi.Input[_builtins.str]] = None,
                 listing_version: Optional[pulumi.Input[_builtins.str]] = None,
                 package_type: Optional[pulumi.Input[_builtins.str]] = None,
                 short_description: Optional[pulumi.Input[_builtins.str]] = None,
                 should_list_public_items: Optional[pulumi.Input[_builtins.bool]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_backfill_last_checked: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_last_checked: Optional[pulumi.Input[_builtins.str]] = None,
                 time_released: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 version_description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CatalogItem resources.
        :param pulumi.Input[Sequence[pulumi.Input['CatalogItemCatalogResultPayloadArgs']]] catalog_result_payloads: Catalog result payload.
        :param pulumi.Input['CatalogItemCatalogSourcePayloadArgs'] catalog_source_payload: Catalog source payload.
        :param pulumi.Input[_builtins.int] clone_catalog_item_trigger: (Updatable) An optional property when incremented triggers Clone Catalog Item. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[_builtins.str] config_source_type: Config source type Eg: STACK_TEMPLATE_CATALOG_SOURCE, PAR_CATALOG_SOURCE, GIT_CATALOG_SOURCE, MARKETPLACE_CATALOG_SOURCE.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the CatalogItem.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The CatalogItem name.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] lifecycle_details: The details of lifecycle state CatalogItem.
        :param pulumi.Input[_builtins.str] listing_id: The catalog listing Id.
        :param pulumi.Input[_builtins.str] listing_version: The catalog package version.
        :param pulumi.Input[_builtins.str] package_type: Config package type Eg: TF_PACKAGE, NON_TF_PACKAGE, CONFIG_FILE.
        :param pulumi.Input[_builtins.str] short_description: (Updatable) Short description about the catalog item.
        :param pulumi.Input[_builtins.bool] should_list_public_items: The indicator to append Public Items from the root compartment to any query, when set to TRUE.
        :param pulumi.Input[_builtins.str] state: The current state of the CatalogItem.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_backfill_last_checked: The date and time the CatalogItem was last checked by backfill job, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_created: The date and time the CatalogItem was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_last_checked: The date and time the CatalogItem was last checked, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_released: The date and time the CatalogItem was released, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_updated: The date and time the CatalogItem was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] version_description: (Updatable) Version description about the catalog item.
        """
        if catalog_result_payloads is not None:
            pulumi.set(__self__, "catalog_result_payloads", catalog_result_payloads)
        if catalog_source_payload is not None:
            pulumi.set(__self__, "catalog_source_payload", catalog_source_payload)
        if clone_catalog_item_trigger is not None:
            pulumi.set(__self__, "clone_catalog_item_trigger", clone_catalog_item_trigger)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if config_source_type is not None:
            pulumi.set(__self__, "config_source_type", config_source_type)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if listing_id is not None:
            pulumi.set(__self__, "listing_id", listing_id)
        if listing_version is not None:
            pulumi.set(__self__, "listing_version", listing_version)
        if package_type is not None:
            pulumi.set(__self__, "package_type", package_type)
        if short_description is not None:
            pulumi.set(__self__, "short_description", short_description)
        if should_list_public_items is not None:
            pulumi.set(__self__, "should_list_public_items", should_list_public_items)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_backfill_last_checked is not None:
            pulumi.set(__self__, "time_backfill_last_checked", time_backfill_last_checked)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_last_checked is not None:
            pulumi.set(__self__, "time_last_checked", time_last_checked)
        if time_released is not None:
            pulumi.set(__self__, "time_released", time_released)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if version_description is not None:
            pulumi.set(__self__, "version_description", version_description)

    @_builtins.property
    @pulumi.getter(name="catalogResultPayloads")
    def catalog_result_payloads(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CatalogItemCatalogResultPayloadArgs']]]]:
        """
        Catalog result payload.
        """
        return pulumi.get(self, "catalog_result_payloads")

    @catalog_result_payloads.setter
    def catalog_result_payloads(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CatalogItemCatalogResultPayloadArgs']]]]):
        pulumi.set(self, "catalog_result_payloads", value)

    @_builtins.property
    @pulumi.getter(name="catalogSourcePayload")
    def catalog_source_payload(self) -> Optional[pulumi.Input['CatalogItemCatalogSourcePayloadArgs']]:
        """
        Catalog source payload.
        """
        return pulumi.get(self, "catalog_source_payload")

    @catalog_source_payload.setter
    def catalog_source_payload(self, value: Optional[pulumi.Input['CatalogItemCatalogSourcePayloadArgs']]):
        pulumi.set(self, "catalog_source_payload", value)

    @_builtins.property
    @pulumi.getter(name="cloneCatalogItemTrigger")
    def clone_catalog_item_trigger(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Clone Catalog Item. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "clone_catalog_item_trigger")

    @clone_catalog_item_trigger.setter
    def clone_catalog_item_trigger(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "clone_catalog_item_trigger", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="configSourceType")
    def config_source_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Config source type Eg: STACK_TEMPLATE_CATALOG_SOURCE, PAR_CATALOG_SOURCE, GIT_CATALOG_SOURCE, MARKETPLACE_CATALOG_SOURCE.
        """
        return pulumi.get(self, "config_source_type")

    @config_source_type.setter
    def config_source_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config_source_type", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The description of the CatalogItem.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The CatalogItem name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The details of lifecycle state CatalogItem.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter(name="listingId")
    def listing_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The catalog listing Id.
        """
        return pulumi.get(self, "listing_id")

    @listing_id.setter
    def listing_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listing_id", value)

    @_builtins.property
    @pulumi.getter(name="listingVersion")
    def listing_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The catalog package version.
        """
        return pulumi.get(self, "listing_version")

    @listing_version.setter
    def listing_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listing_version", value)

    @_builtins.property
    @pulumi.getter(name="packageType")
    def package_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Config package type Eg: TF_PACKAGE, NON_TF_PACKAGE, CONFIG_FILE.
        """
        return pulumi.get(self, "package_type")

    @package_type.setter
    def package_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "package_type", value)

    @_builtins.property
    @pulumi.getter(name="shortDescription")
    def short_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Short description about the catalog item.
        """
        return pulumi.get(self, "short_description")

    @short_description.setter
    def short_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "short_description", value)

    @_builtins.property
    @pulumi.getter(name="shouldListPublicItems")
    def should_list_public_items(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The indicator to append Public Items from the root compartment to any query, when set to TRUE.
        """
        return pulumi.get(self, "should_list_public_items")

    @should_list_public_items.setter
    def should_list_public_items(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "should_list_public_items", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the CatalogItem.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeBackfillLastChecked")
    def time_backfill_last_checked(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the CatalogItem was last checked by backfill job, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_backfill_last_checked")

    @time_backfill_last_checked.setter
    def time_backfill_last_checked(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_backfill_last_checked", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the CatalogItem was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeLastChecked")
    def time_last_checked(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the CatalogItem was last checked, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_last_checked")

    @time_last_checked.setter
    def time_last_checked(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_last_checked", value)

    @_builtins.property
    @pulumi.getter(name="timeReleased")
    def time_released(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the CatalogItem was released, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_released")

    @time_released.setter
    def time_released(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_released", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the CatalogItem was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @_builtins.property
    @pulumi.getter(name="versionDescription")
    def version_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Version description about the catalog item.
        """
        return pulumi.get(self, "version_description")

    @version_description.setter
    def version_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_description", value)


@pulumi.type_token("oci:FleetAppsManagement/catalogItem:CatalogItem")
class CatalogItem(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog_source_payload: Optional[pulumi.Input[Union['CatalogItemCatalogSourcePayloadArgs', 'CatalogItemCatalogSourcePayloadArgsDict']]] = None,
                 clone_catalog_item_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 config_source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 listing_id: Optional[pulumi.Input[_builtins.str]] = None,
                 listing_version: Optional[pulumi.Input[_builtins.str]] = None,
                 package_type: Optional[pulumi.Input[_builtins.str]] = None,
                 short_description: Optional[pulumi.Input[_builtins.str]] = None,
                 time_released: Optional[pulumi.Input[_builtins.str]] = None,
                 version_description: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Catalog Item resource in Oracle Cloud Infrastructure Fleet Apps Management service.

        Creates a CatalogItem.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_catalog_item = oci.fleetappsmanagement.CatalogItem("test_catalog_item",
            compartment_id=compartment_id,
            config_source_type=catalog_item_config_source_type,
            description=catalog_item_description,
            display_name=catalog_item_display_name,
            package_type=catalog_item_package_type,
            catalog_source_payload={
                "config_source_type": catalog_item_catalog_source_payload_config_source_type,
                "access_uri": catalog_item_catalog_source_payload_access_uri,
                "branch_name": catalog_item_catalog_source_payload_branch_name,
                "bucket": catalog_item_catalog_source_payload_bucket,
                "configuration_source_provider_id": test_configuration_source_provider["id"],
                "description": catalog_item_catalog_source_payload_description,
                "listing_id": test_listing["id"],
                "long_description": catalog_item_catalog_source_payload_long_description,
                "namespace": catalog_item_catalog_source_payload_namespace,
                "object": catalog_item_catalog_source_payload_object,
                "repository_url": catalog_item_catalog_source_payload_repository_url,
                "template_display_name": catalog_item_catalog_source_payload_template_display_name,
                "time_expires": catalog_item_catalog_source_payload_time_expires,
                "version": catalog_item_catalog_source_payload_version,
                "working_directory": catalog_item_catalog_source_payload_working_directory,
                "zip_file_base64encoded": catalog_item_catalog_source_payload_zip_file_base64encoded,
            },
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            listing_id=test_listing["id"],
            listing_version=catalog_item_listing_version,
            short_description=catalog_item_short_description,
            time_released=catalog_item_time_released,
            version_description=catalog_item_version_description)
        ```

        ## Import

        CatalogItems can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:FleetAppsManagement/catalogItem:CatalogItem test_catalog_item "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CatalogItemCatalogSourcePayloadArgs', 'CatalogItemCatalogSourcePayloadArgsDict']] catalog_source_payload: Catalog source payload.
        :param pulumi.Input[_builtins.int] clone_catalog_item_trigger: (Updatable) An optional property when incremented triggers Clone Catalog Item. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[_builtins.str] config_source_type: Config source type Eg: STACK_TEMPLATE_CATALOG_SOURCE, PAR_CATALOG_SOURCE, GIT_CATALOG_SOURCE, MARKETPLACE_CATALOG_SOURCE.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the CatalogItem.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The CatalogItem name.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] listing_id: The catalog listing Id.
        :param pulumi.Input[_builtins.str] listing_version: The catalog package version.
        :param pulumi.Input[_builtins.str] package_type: Config package type Eg: TF_PACKAGE, NON_TF_PACKAGE, CONFIG_FILE.
        :param pulumi.Input[_builtins.str] short_description: (Updatable) Short description about the catalog item.
        :param pulumi.Input[_builtins.str] time_released: The date and time the CatalogItem was released, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] version_description: (Updatable) Version description about the catalog item.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CatalogItemArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Catalog Item resource in Oracle Cloud Infrastructure Fleet Apps Management service.

        Creates a CatalogItem.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_catalog_item = oci.fleetappsmanagement.CatalogItem("test_catalog_item",
            compartment_id=compartment_id,
            config_source_type=catalog_item_config_source_type,
            description=catalog_item_description,
            display_name=catalog_item_display_name,
            package_type=catalog_item_package_type,
            catalog_source_payload={
                "config_source_type": catalog_item_catalog_source_payload_config_source_type,
                "access_uri": catalog_item_catalog_source_payload_access_uri,
                "branch_name": catalog_item_catalog_source_payload_branch_name,
                "bucket": catalog_item_catalog_source_payload_bucket,
                "configuration_source_provider_id": test_configuration_source_provider["id"],
                "description": catalog_item_catalog_source_payload_description,
                "listing_id": test_listing["id"],
                "long_description": catalog_item_catalog_source_payload_long_description,
                "namespace": catalog_item_catalog_source_payload_namespace,
                "object": catalog_item_catalog_source_payload_object,
                "repository_url": catalog_item_catalog_source_payload_repository_url,
                "template_display_name": catalog_item_catalog_source_payload_template_display_name,
                "time_expires": catalog_item_catalog_source_payload_time_expires,
                "version": catalog_item_catalog_source_payload_version,
                "working_directory": catalog_item_catalog_source_payload_working_directory,
                "zip_file_base64encoded": catalog_item_catalog_source_payload_zip_file_base64encoded,
            },
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            listing_id=test_listing["id"],
            listing_version=catalog_item_listing_version,
            short_description=catalog_item_short_description,
            time_released=catalog_item_time_released,
            version_description=catalog_item_version_description)
        ```

        ## Import

        CatalogItems can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:FleetAppsManagement/catalogItem:CatalogItem test_catalog_item "id"
        ```

        :param str resource_name: The name of the resource.
        :param CatalogItemArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CatalogItemArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog_source_payload: Optional[pulumi.Input[Union['CatalogItemCatalogSourcePayloadArgs', 'CatalogItemCatalogSourcePayloadArgsDict']]] = None,
                 clone_catalog_item_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 config_source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 listing_id: Optional[pulumi.Input[_builtins.str]] = None,
                 listing_version: Optional[pulumi.Input[_builtins.str]] = None,
                 package_type: Optional[pulumi.Input[_builtins.str]] = None,
                 short_description: Optional[pulumi.Input[_builtins.str]] = None,
                 time_released: Optional[pulumi.Input[_builtins.str]] = None,
                 version_description: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CatalogItemArgs.__new__(CatalogItemArgs)

            __props__.__dict__["catalog_source_payload"] = catalog_source_payload
            __props__.__dict__["clone_catalog_item_trigger"] = clone_catalog_item_trigger
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if config_source_type is None and not opts.urn:
                raise TypeError("Missing required property 'config_source_type'")
            __props__.__dict__["config_source_type"] = config_source_type
            __props__.__dict__["defined_tags"] = defined_tags
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["listing_id"] = listing_id
            __props__.__dict__["listing_version"] = listing_version
            if package_type is None and not opts.urn:
                raise TypeError("Missing required property 'package_type'")
            __props__.__dict__["package_type"] = package_type
            __props__.__dict__["short_description"] = short_description
            __props__.__dict__["time_released"] = time_released
            __props__.__dict__["version_description"] = version_description
            __props__.__dict__["catalog_result_payloads"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["should_list_public_items"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_backfill_last_checked"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_last_checked"] = None
            __props__.__dict__["time_updated"] = None
        super(CatalogItem, __self__).__init__(
            'oci:FleetAppsManagement/catalogItem:CatalogItem',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            catalog_result_payloads: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CatalogItemCatalogResultPayloadArgs', 'CatalogItemCatalogResultPayloadArgsDict']]]]] = None,
            catalog_source_payload: Optional[pulumi.Input[Union['CatalogItemCatalogSourcePayloadArgs', 'CatalogItemCatalogSourcePayloadArgsDict']]] = None,
            clone_catalog_item_trigger: Optional[pulumi.Input[_builtins.int]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            config_source_type: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            listing_id: Optional[pulumi.Input[_builtins.str]] = None,
            listing_version: Optional[pulumi.Input[_builtins.str]] = None,
            package_type: Optional[pulumi.Input[_builtins.str]] = None,
            short_description: Optional[pulumi.Input[_builtins.str]] = None,
            should_list_public_items: Optional[pulumi.Input[_builtins.bool]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_backfill_last_checked: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_last_checked: Optional[pulumi.Input[_builtins.str]] = None,
            time_released: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None,
            version_description: Optional[pulumi.Input[_builtins.str]] = None) -> 'CatalogItem':
        """
        Get an existing CatalogItem resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CatalogItemCatalogResultPayloadArgs', 'CatalogItemCatalogResultPayloadArgsDict']]]] catalog_result_payloads: Catalog result payload.
        :param pulumi.Input[Union['CatalogItemCatalogSourcePayloadArgs', 'CatalogItemCatalogSourcePayloadArgsDict']] catalog_source_payload: Catalog source payload.
        :param pulumi.Input[_builtins.int] clone_catalog_item_trigger: (Updatable) An optional property when incremented triggers Clone Catalog Item. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[_builtins.str] config_source_type: Config source type Eg: STACK_TEMPLATE_CATALOG_SOURCE, PAR_CATALOG_SOURCE, GIT_CATALOG_SOURCE, MARKETPLACE_CATALOG_SOURCE.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the CatalogItem.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The CatalogItem name.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] lifecycle_details: The details of lifecycle state CatalogItem.
        :param pulumi.Input[_builtins.str] listing_id: The catalog listing Id.
        :param pulumi.Input[_builtins.str] listing_version: The catalog package version.
        :param pulumi.Input[_builtins.str] package_type: Config package type Eg: TF_PACKAGE, NON_TF_PACKAGE, CONFIG_FILE.
        :param pulumi.Input[_builtins.str] short_description: (Updatable) Short description about the catalog item.
        :param pulumi.Input[_builtins.bool] should_list_public_items: The indicator to append Public Items from the root compartment to any query, when set to TRUE.
        :param pulumi.Input[_builtins.str] state: The current state of the CatalogItem.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_backfill_last_checked: The date and time the CatalogItem was last checked by backfill job, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_created: The date and time the CatalogItem was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_last_checked: The date and time the CatalogItem was last checked, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_released: The date and time the CatalogItem was released, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_updated: The date and time the CatalogItem was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] version_description: (Updatable) Version description about the catalog item.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CatalogItemState.__new__(_CatalogItemState)

        __props__.__dict__["catalog_result_payloads"] = catalog_result_payloads
        __props__.__dict__["catalog_source_payload"] = catalog_source_payload
        __props__.__dict__["clone_catalog_item_trigger"] = clone_catalog_item_trigger
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["config_source_type"] = config_source_type
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["listing_id"] = listing_id
        __props__.__dict__["listing_version"] = listing_version
        __props__.__dict__["package_type"] = package_type
        __props__.__dict__["short_description"] = short_description
        __props__.__dict__["should_list_public_items"] = should_list_public_items
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_backfill_last_checked"] = time_backfill_last_checked
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_last_checked"] = time_last_checked
        __props__.__dict__["time_released"] = time_released
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["version_description"] = version_description
        return CatalogItem(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="catalogResultPayloads")
    def catalog_result_payloads(self) -> pulumi.Output[Sequence['outputs.CatalogItemCatalogResultPayload']]:
        """
        Catalog result payload.
        """
        return pulumi.get(self, "catalog_result_payloads")

    @_builtins.property
    @pulumi.getter(name="catalogSourcePayload")
    def catalog_source_payload(self) -> pulumi.Output['outputs.CatalogItemCatalogSourcePayload']:
        """
        Catalog source payload.
        """
        return pulumi.get(self, "catalog_source_payload")

    @_builtins.property
    @pulumi.getter(name="cloneCatalogItemTrigger")
    def clone_catalog_item_trigger(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Clone Catalog Item. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "clone_catalog_item_trigger")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="configSourceType")
    def config_source_type(self) -> pulumi.Output[_builtins.str]:
        """
        Config source type Eg: STACK_TEMPLATE_CATALOG_SOURCE, PAR_CATALOG_SOURCE, GIT_CATALOG_SOURCE, MARKETPLACE_CATALOG_SOURCE.
        """
        return pulumi.get(self, "config_source_type")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The description of the CatalogItem.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The CatalogItem name.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        The details of lifecycle state CatalogItem.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="listingId")
    def listing_id(self) -> pulumi.Output[_builtins.str]:
        """
        The catalog listing Id.
        """
        return pulumi.get(self, "listing_id")

    @_builtins.property
    @pulumi.getter(name="listingVersion")
    def listing_version(self) -> pulumi.Output[_builtins.str]:
        """
        The catalog package version.
        """
        return pulumi.get(self, "listing_version")

    @_builtins.property
    @pulumi.getter(name="packageType")
    def package_type(self) -> pulumi.Output[_builtins.str]:
        """
        Config package type Eg: TF_PACKAGE, NON_TF_PACKAGE, CONFIG_FILE.
        """
        return pulumi.get(self, "package_type")

    @_builtins.property
    @pulumi.getter(name="shortDescription")
    def short_description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Short description about the catalog item.
        """
        return pulumi.get(self, "short_description")

    @_builtins.property
    @pulumi.getter(name="shouldListPublicItems")
    def should_list_public_items(self) -> pulumi.Output[_builtins.bool]:
        """
        The indicator to append Public Items from the root compartment to any query, when set to TRUE.
        """
        return pulumi.get(self, "should_list_public_items")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the CatalogItem.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeBackfillLastChecked")
    def time_backfill_last_checked(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the CatalogItem was last checked by backfill job, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_backfill_last_checked")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the CatalogItem was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeLastChecked")
    def time_last_checked(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the CatalogItem was last checked, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_last_checked")

    @_builtins.property
    @pulumi.getter(name="timeReleased")
    def time_released(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the CatalogItem was released, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_released")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the CatalogItem was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="versionDescription")
    def version_description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Version description about the catalog item.
        """
        return pulumi.get(self, "version_description")

