# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FleetCredentialInitArgs', 'FleetCredential']

@pulumi.input_type
class FleetCredentialInitArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 entity_specifics: pulumi.Input['FleetCredentialEntitySpecificsArgs'],
                 fleet_id: pulumi.Input[_builtins.str],
                 password: pulumi.Input['FleetCredentialPasswordArgs'],
                 user: pulumi.Input['FleetCredentialUserArgs']):
        """
        The set of arguments for constructing a FleetCredential resource.
        :param pulumi.Input[_builtins.str] compartment_id: Compartment OCID
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        :param pulumi.Input['FleetCredentialEntitySpecificsArgs'] entity_specifics: (Updatable) Credential specific Details.
        :param pulumi.Input[_builtins.str] fleet_id: Unique Fleet identifier.
        :param pulumi.Input['FleetCredentialPasswordArgs'] password: (Updatable) Credential Details.
        :param pulumi.Input['FleetCredentialUserArgs'] user: (Updatable) Credential Details.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "entity_specifics", entity_specifics)
        pulumi.set(__self__, "fleet_id", fleet_id)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        Compartment OCID
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="entitySpecifics")
    def entity_specifics(self) -> pulumi.Input['FleetCredentialEntitySpecificsArgs']:
        """
        (Updatable) Credential specific Details.
        """
        return pulumi.get(self, "entity_specifics")

    @entity_specifics.setter
    def entity_specifics(self, value: pulumi.Input['FleetCredentialEntitySpecificsArgs']):
        pulumi.set(self, "entity_specifics", value)

    @_builtins.property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> pulumi.Input[_builtins.str]:
        """
        Unique Fleet identifier.
        """
        return pulumi.get(self, "fleet_id")

    @fleet_id.setter
    def fleet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "fleet_id", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Input['FleetCredentialPasswordArgs']:
        """
        (Updatable) Credential Details.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input['FleetCredentialPasswordArgs']):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> pulumi.Input['FleetCredentialUserArgs']:
        """
        (Updatable) Credential Details.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: pulumi.Input['FleetCredentialUserArgs']):
        pulumi.set(self, "user", value)


@pulumi.input_type
class _FleetCredentialState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 entity_specifics: Optional[pulumi.Input['FleetCredentialEntitySpecificsArgs']] = None,
                 fleet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input['FleetCredentialPasswordArgs']] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 user: Optional[pulumi.Input['FleetCredentialUserArgs']] = None):
        """
        Input properties used for looking up and filtering FleetCredential resources.
        :param pulumi.Input[_builtins.str] compartment_id: Compartment OCID
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        :param pulumi.Input['FleetCredentialEntitySpecificsArgs'] entity_specifics: (Updatable) Credential specific Details.
        :param pulumi.Input[_builtins.str] fleet_id: Unique Fleet identifier.
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input['FleetCredentialPasswordArgs'] password: (Updatable) Credential Details.
        :param pulumi.Input[_builtins.str] state: The current state of the FleetCredential.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The time this resource was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] time_updated: The time this resource was last updated. An RFC3339 formatted datetime string.
        :param pulumi.Input['FleetCredentialUserArgs'] user: (Updatable) Credential Details.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if entity_specifics is not None:
            pulumi.set(__self__, "entity_specifics", entity_specifics)
        if fleet_id is not None:
            pulumi.set(__self__, "fleet_id", fleet_id)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Compartment OCID
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="entitySpecifics")
    def entity_specifics(self) -> Optional[pulumi.Input['FleetCredentialEntitySpecificsArgs']]:
        """
        (Updatable) Credential specific Details.
        """
        return pulumi.get(self, "entity_specifics")

    @entity_specifics.setter
    def entity_specifics(self, value: Optional[pulumi.Input['FleetCredentialEntitySpecificsArgs']]):
        pulumi.set(self, "entity_specifics", value)

    @_builtins.property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique Fleet identifier.
        """
        return pulumi.get(self, "fleet_id")

    @fleet_id.setter
    def fleet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fleet_id", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input['FleetCredentialPasswordArgs']]:
        """
        (Updatable) Credential Details.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input['FleetCredentialPasswordArgs']]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the FleetCredential.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input['FleetCredentialUserArgs']]:
        """
        (Updatable) Credential Details.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input['FleetCredentialUserArgs']]):
        pulumi.set(self, "user", value)


@pulumi.type_token("oci:FleetAppsManagement/fleetCredential:FleetCredential")
class FleetCredential(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 entity_specifics: Optional[pulumi.Input[Union['FleetCredentialEntitySpecificsArgs', 'FleetCredentialEntitySpecificsArgsDict']]] = None,
                 fleet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[Union['FleetCredentialPasswordArgs', 'FleetCredentialPasswordArgsDict']]] = None,
                 user: Optional[pulumi.Input[Union['FleetCredentialUserArgs', 'FleetCredentialUserArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Fleet Credential resource in Oracle Cloud Infrastructure Fleet Apps Management service.

        Add credentials to a fleet in Fleet Application Management.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_fleet_credential = oci.fleetappsmanagement.FleetCredential("test_fleet_credential",
            display_name=fleet_credential_display_name,
            entity_specifics={
                "credential_level": fleet_credential_entity_specifics_credential_level,
                "resource_id": test_resource["id"],
                "target": fleet_credential_entity_specifics_target,
                "variables": [{
                    "name": fleet_credential_entity_specifics_variables_name,
                    "value": fleet_credential_entity_specifics_variables_value,
                }],
            },
            fleet_id=test_fleet["id"],
            password={
                "credential_type": fleet_credential_password_credential_type,
                "key_id": test_key["id"],
                "key_version": fleet_credential_password_key_version,
                "secret_id": test_secret["id"],
                "secret_version": fleet_credential_password_secret_version,
                "value": fleet_credential_password_value,
                "vault_id": test_vault["id"],
            },
            user={
                "credential_type": fleet_credential_user_credential_type,
                "key_id": test_key["id"],
                "key_version": fleet_credential_user_key_version,
                "secret_id": test_secret["id"],
                "secret_version": fleet_credential_user_secret_version,
                "value": fleet_credential_user_value,
                "vault_id": test_vault["id"],
            })
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: Compartment OCID
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        :param pulumi.Input[Union['FleetCredentialEntitySpecificsArgs', 'FleetCredentialEntitySpecificsArgsDict']] entity_specifics: (Updatable) Credential specific Details.
        :param pulumi.Input[_builtins.str] fleet_id: Unique Fleet identifier.
        :param pulumi.Input[Union['FleetCredentialPasswordArgs', 'FleetCredentialPasswordArgsDict']] password: (Updatable) Credential Details.
        :param pulumi.Input[Union['FleetCredentialUserArgs', 'FleetCredentialUserArgsDict']] user: (Updatable) Credential Details.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FleetCredentialInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Fleet Credential resource in Oracle Cloud Infrastructure Fleet Apps Management service.

        Add credentials to a fleet in Fleet Application Management.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_fleet_credential = oci.fleetappsmanagement.FleetCredential("test_fleet_credential",
            display_name=fleet_credential_display_name,
            entity_specifics={
                "credential_level": fleet_credential_entity_specifics_credential_level,
                "resource_id": test_resource["id"],
                "target": fleet_credential_entity_specifics_target,
                "variables": [{
                    "name": fleet_credential_entity_specifics_variables_name,
                    "value": fleet_credential_entity_specifics_variables_value,
                }],
            },
            fleet_id=test_fleet["id"],
            password={
                "credential_type": fleet_credential_password_credential_type,
                "key_id": test_key["id"],
                "key_version": fleet_credential_password_key_version,
                "secret_id": test_secret["id"],
                "secret_version": fleet_credential_password_secret_version,
                "value": fleet_credential_password_value,
                "vault_id": test_vault["id"],
            },
            user={
                "credential_type": fleet_credential_user_credential_type,
                "key_id": test_key["id"],
                "key_version": fleet_credential_user_key_version,
                "secret_id": test_secret["id"],
                "secret_version": fleet_credential_user_secret_version,
                "value": fleet_credential_user_value,
                "vault_id": test_vault["id"],
            })
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param FleetCredentialInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FleetCredentialInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 entity_specifics: Optional[pulumi.Input[Union['FleetCredentialEntitySpecificsArgs', 'FleetCredentialEntitySpecificsArgsDict']]] = None,
                 fleet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[Union['FleetCredentialPasswordArgs', 'FleetCredentialPasswordArgsDict']]] = None,
                 user: Optional[pulumi.Input[Union['FleetCredentialUserArgs', 'FleetCredentialUserArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FleetCredentialInitArgs.__new__(FleetCredentialInitArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if entity_specifics is None and not opts.urn:
                raise TypeError("Missing required property 'entity_specifics'")
            __props__.__dict__["entity_specifics"] = entity_specifics
            if fleet_id is None and not opts.urn:
                raise TypeError("Missing required property 'fleet_id'")
            __props__.__dict__["fleet_id"] = fleet_id
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = password
            if user is None and not opts.urn:
                raise TypeError("Missing required property 'user'")
            __props__.__dict__["user"] = user
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(FleetCredential, __self__).__init__(
            'oci:FleetAppsManagement/fleetCredential:FleetCredential',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            entity_specifics: Optional[pulumi.Input[Union['FleetCredentialEntitySpecificsArgs', 'FleetCredentialEntitySpecificsArgsDict']]] = None,
            fleet_id: Optional[pulumi.Input[_builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[Union['FleetCredentialPasswordArgs', 'FleetCredentialPasswordArgsDict']]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None,
            user: Optional[pulumi.Input[Union['FleetCredentialUserArgs', 'FleetCredentialUserArgsDict']]] = None) -> 'FleetCredential':
        """
        Get an existing FleetCredential resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: Compartment OCID
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        :param pulumi.Input[Union['FleetCredentialEntitySpecificsArgs', 'FleetCredentialEntitySpecificsArgsDict']] entity_specifics: (Updatable) Credential specific Details.
        :param pulumi.Input[_builtins.str] fleet_id: Unique Fleet identifier.
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[Union['FleetCredentialPasswordArgs', 'FleetCredentialPasswordArgsDict']] password: (Updatable) Credential Details.
        :param pulumi.Input[_builtins.str] state: The current state of the FleetCredential.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The time this resource was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] time_updated: The time this resource was last updated. An RFC3339 formatted datetime string.
        :param pulumi.Input[Union['FleetCredentialUserArgs', 'FleetCredentialUserArgsDict']] user: (Updatable) Credential Details.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FleetCredentialState.__new__(_FleetCredentialState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["entity_specifics"] = entity_specifics
        __props__.__dict__["fleet_id"] = fleet_id
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["password"] = password
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["user"] = user
        return FleetCredential(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        Compartment OCID
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="entitySpecifics")
    def entity_specifics(self) -> pulumi.Output['outputs.FleetCredentialEntitySpecifics']:
        """
        (Updatable) Credential specific Details.
        """
        return pulumi.get(self, "entity_specifics")

    @_builtins.property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique Fleet identifier.
        """
        return pulumi.get(self, "fleet_id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output['outputs.FleetCredentialPassword']:
        """
        (Updatable) Credential Details.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the FleetCredential.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def user(self) -> pulumi.Output['outputs.FleetCredentialUser']:
        """
        (Updatable) Credential Details.
        """
        return pulumi.get(self, "user")

