# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetManagedEntityCountsResult',
    'AwaitableGetManagedEntityCountsResult',
    'get_managed_entity_counts',
    'get_managed_entity_counts_output',
]

@pulumi.output_type
class GetManagedEntityCountsResult:
    """
    A collection of values returned by getManagedEntityCounts.
    """
    def __init__(__self__, compartment_id=None, compartment_id_in_subtree=None, filters=None, id=None, managed_entity_aggregation_collections=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_entity_aggregation_collections and not isinstance(managed_entity_aggregation_collections, list):
            raise TypeError("Expected argument 'managed_entity_aggregation_collections' to be a list")
        pulumi.set(__self__, "managed_entity_aggregation_collections", managed_entity_aggregation_collections)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetManagedEntityCountsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="managedEntityAggregationCollections")
    def managed_entity_aggregation_collections(self) -> Sequence['outputs.GetManagedEntityCountsManagedEntityAggregationCollectionResult']:
        """
        The list of managed_entity_aggregation_collection.
        """
        return pulumi.get(self, "managed_entity_aggregation_collections")


class AwaitableGetManagedEntityCountsResult(GetManagedEntityCountsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedEntityCountsResult(
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            filters=self.filters,
            id=self.id,
            managed_entity_aggregation_collections=self.managed_entity_aggregation_collections)


def get_managed_entity_counts(compartment_id: Optional[_builtins.str] = None,
                              compartment_id_in_subtree: Optional[_builtins.bool] = None,
                              filters: Optional[Sequence[Union['GetManagedEntityCountsFilterArgs', 'GetManagedEntityCountsFilterArgsDict']]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedEntityCountsResult:
    """
    This data source provides the list of Managed Entity Counts in Oracle Cloud Infrastructure Fleet Apps Management service.

    Retrieve  aggregated summary information of Managed entities within a Compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_entity_counts = oci.FleetAppsManagement.get_managed_entity_counts(compartment_id=compartment_id,
        compartment_id_in_subtree=managed_entity_count_compartment_id_in_subtree)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources. Empty only if the resource OCID query param is not specified.
    :param _builtins.bool compartment_id_in_subtree: If set to true, resources will be returned for not only the provided compartment, but all compartments which descend from it. Which resources are returned and their field contents depends on the value of accessLevel.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getManagedEntityCounts:getManagedEntityCounts', __args__, opts=opts, typ=GetManagedEntityCountsResult).value

    return AwaitableGetManagedEntityCountsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        managed_entity_aggregation_collections=pulumi.get(__ret__, 'managed_entity_aggregation_collections'))
def get_managed_entity_counts_output(compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     compartment_id_in_subtree: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                     filters: Optional[pulumi.Input[Optional[Sequence[Union['GetManagedEntityCountsFilterArgs', 'GetManagedEntityCountsFilterArgsDict']]]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetManagedEntityCountsResult]:
    """
    This data source provides the list of Managed Entity Counts in Oracle Cloud Infrastructure Fleet Apps Management service.

    Retrieve  aggregated summary information of Managed entities within a Compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_entity_counts = oci.FleetAppsManagement.get_managed_entity_counts(compartment_id=compartment_id,
        compartment_id_in_subtree=managed_entity_count_compartment_id_in_subtree)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources. Empty only if the resource OCID query param is not specified.
    :param _builtins.bool compartment_id_in_subtree: If set to true, resources will be returned for not only the provided compartment, but all compartments which descend from it. Which resources are returned and their field contents depends on the value of accessLevel.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getManagedEntityCounts:getManagedEntityCounts', __args__, opts=opts, typ=GetManagedEntityCountsResult)
    return __ret__.apply(lambda __response__: GetManagedEntityCountsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        managed_entity_aggregation_collections=pulumi.get(__response__, 'managed_entity_aggregation_collections')))
