# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPlatformConfigurationsResult',
    'AwaitableGetPlatformConfigurationsResult',
    'get_platform_configurations',
    'get_platform_configurations_output',
]

@pulumi.output_type
class GetPlatformConfigurationsResult:
    """
    A collection of values returned by getPlatformConfigurations.
    """
    def __init__(__self__, compartment_id=None, compartment_id_in_subtree=None, config_category=None, display_name=None, filters=None, id=None, platform_configuration_collections=None, state=None, type=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if config_category and not isinstance(config_category, str):
            raise TypeError("Expected argument 'config_category' to be a str")
        pulumi.set(__self__, "config_category", config_category)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if platform_configuration_collections and not isinstance(platform_configuration_collections, list):
            raise TypeError("Expected argument 'platform_configuration_collections' to be a list")
        pulumi.set(__self__, "platform_configuration_collections", platform_configuration_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        """
        Compartment OCID
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @_builtins.property
    @pulumi.getter(name="configCategory")
    def config_category(self) -> Optional[_builtins.str]:
        """
        Category of configuration
        """
        return pulumi.get(self, "config_category")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetPlatformConfigurationsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="platformConfigurationCollections")
    def platform_configuration_collections(self) -> Sequence['outputs.GetPlatformConfigurationsPlatformConfigurationCollectionResult']:
        """
        The list of platform_configuration_collection.
        """
        return pulumi.get(self, "platform_configuration_collections")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the PlatformConfiguration.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The type of the configuration.
        """
        return pulumi.get(self, "type")


class AwaitableGetPlatformConfigurationsResult(GetPlatformConfigurationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPlatformConfigurationsResult(
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            config_category=self.config_category,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            platform_configuration_collections=self.platform_configuration_collections,
            state=self.state,
            type=self.type)


def get_platform_configurations(compartment_id: Optional[_builtins.str] = None,
                                compartment_id_in_subtree: Optional[_builtins.bool] = None,
                                config_category: Optional[_builtins.str] = None,
                                display_name: Optional[_builtins.str] = None,
                                filters: Optional[Sequence[Union['GetPlatformConfigurationsFilterArgs', 'GetPlatformConfigurationsFilterArgsDict']]] = None,
                                id: Optional[_builtins.str] = None,
                                state: Optional[_builtins.str] = None,
                                type: Optional[_builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPlatformConfigurationsResult:
    """
    This data source provides the list of Platform Configurations in Oracle Cloud Infrastructure Fleet Apps Management service.

    Returns a list of all the Platform Configurations in the specified compartment.
    The query parameter `compartmentId` is required unless the query parameter `id` is specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_platform_configurations = oci.FleetAppsManagement.get_platform_configurations(compartment_id=compartment_id,
        compartment_id_in_subtree=platform_configuration_compartment_id_in_subtree,
        config_category=platform_configuration_config_category,
        display_name=platform_configuration_display_name,
        id=platform_configuration_id,
        state=platform_configuration_state,
        type=platform_configuration_type)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources. Empty only if the resource OCID query param is not specified.
    :param _builtins.bool compartment_id_in_subtree: If set to true, resources will be returned for not only the provided compartment, but all compartments which descend from it. Which resources are returned and their field contents depends on the value of accessLevel.
    :param _builtins.str config_category: Config Category
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param _builtins.str id: Unique identifier or OCID for listing a single Platform Configuration by id. Either compartmentId or id must be provided.
    :param _builtins.str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    :param _builtins.str type: A filter to return Platform Configurations whose type matches the given type.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['configCategory'] = config_category
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getPlatformConfigurations:getPlatformConfigurations', __args__, opts=opts, typ=GetPlatformConfigurationsResult).value

    return AwaitableGetPlatformConfigurationsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        config_category=pulumi.get(__ret__, 'config_category'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        platform_configuration_collections=pulumi.get(__ret__, 'platform_configuration_collections'),
        state=pulumi.get(__ret__, 'state'),
        type=pulumi.get(__ret__, 'type'))
def get_platform_configurations_output(compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       compartment_id_in_subtree: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                       config_category: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       filters: Optional[pulumi.Input[Optional[Sequence[Union['GetPlatformConfigurationsFilterArgs', 'GetPlatformConfigurationsFilterArgsDict']]]]] = None,
                                       id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPlatformConfigurationsResult]:
    """
    This data source provides the list of Platform Configurations in Oracle Cloud Infrastructure Fleet Apps Management service.

    Returns a list of all the Platform Configurations in the specified compartment.
    The query parameter `compartmentId` is required unless the query parameter `id` is specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_platform_configurations = oci.FleetAppsManagement.get_platform_configurations(compartment_id=compartment_id,
        compartment_id_in_subtree=platform_configuration_compartment_id_in_subtree,
        config_category=platform_configuration_config_category,
        display_name=platform_configuration_display_name,
        id=platform_configuration_id,
        state=platform_configuration_state,
        type=platform_configuration_type)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources. Empty only if the resource OCID query param is not specified.
    :param _builtins.bool compartment_id_in_subtree: If set to true, resources will be returned for not only the provided compartment, but all compartments which descend from it. Which resources are returned and their field contents depends on the value of accessLevel.
    :param _builtins.str config_category: Config Category
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param _builtins.str id: Unique identifier or OCID for listing a single Platform Configuration by id. Either compartmentId or id must be provided.
    :param _builtins.str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    :param _builtins.str type: A filter to return Platform Configurations whose type matches the given type.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['configCategory'] = config_category
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getPlatformConfigurations:getPlatformConfigurations', __args__, opts=opts, typ=GetPlatformConfigurationsResult)
    return __ret__.apply(lambda __response__: GetPlatformConfigurationsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        config_category=pulumi.get(__response__, 'config_category'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        platform_configuration_collections=pulumi.get(__response__, 'platform_configuration_collections'),
        state=pulumi.get(__response__, 'state'),
        type=pulumi.get(__response__, 'type')))
