# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetProvisionResult',
    'AwaitableGetProvisionResult',
    'get_provision',
    'get_provision_output',
]

@pulumi.output_type
class GetProvisionResult:
    """
    A collection of values returned by getProvision.
    """
    def __init__(__self__, compartment_id=None, config_catalog_item_display_name=None, config_catalog_item_id=None, config_catalog_item_listing_id=None, config_catalog_item_listing_version=None, defined_tags=None, deployed_resources=None, display_name=None, fleet_id=None, freeform_tags=None, id=None, lifecycle_details=None, package_catalog_item_display_name=None, package_catalog_item_id=None, package_catalog_item_listing_id=None, package_catalog_item_listing_version=None, provision_description=None, provision_id=None, rms_apply_job_id=None, stack_id=None, state=None, system_tags=None, tf_outputs=None, tf_variable_compartment_id=None, tf_variable_current_user_id=None, tf_variable_region_id=None, tf_variable_tenancy_id=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if config_catalog_item_display_name and not isinstance(config_catalog_item_display_name, str):
            raise TypeError("Expected argument 'config_catalog_item_display_name' to be a str")
        pulumi.set(__self__, "config_catalog_item_display_name", config_catalog_item_display_name)
        if config_catalog_item_id and not isinstance(config_catalog_item_id, str):
            raise TypeError("Expected argument 'config_catalog_item_id' to be a str")
        pulumi.set(__self__, "config_catalog_item_id", config_catalog_item_id)
        if config_catalog_item_listing_id and not isinstance(config_catalog_item_listing_id, str):
            raise TypeError("Expected argument 'config_catalog_item_listing_id' to be a str")
        pulumi.set(__self__, "config_catalog_item_listing_id", config_catalog_item_listing_id)
        if config_catalog_item_listing_version and not isinstance(config_catalog_item_listing_version, str):
            raise TypeError("Expected argument 'config_catalog_item_listing_version' to be a str")
        pulumi.set(__self__, "config_catalog_item_listing_version", config_catalog_item_listing_version)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if deployed_resources and not isinstance(deployed_resources, list):
            raise TypeError("Expected argument 'deployed_resources' to be a list")
        pulumi.set(__self__, "deployed_resources", deployed_resources)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if fleet_id and not isinstance(fleet_id, str):
            raise TypeError("Expected argument 'fleet_id' to be a str")
        pulumi.set(__self__, "fleet_id", fleet_id)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if package_catalog_item_display_name and not isinstance(package_catalog_item_display_name, str):
            raise TypeError("Expected argument 'package_catalog_item_display_name' to be a str")
        pulumi.set(__self__, "package_catalog_item_display_name", package_catalog_item_display_name)
        if package_catalog_item_id and not isinstance(package_catalog_item_id, str):
            raise TypeError("Expected argument 'package_catalog_item_id' to be a str")
        pulumi.set(__self__, "package_catalog_item_id", package_catalog_item_id)
        if package_catalog_item_listing_id and not isinstance(package_catalog_item_listing_id, str):
            raise TypeError("Expected argument 'package_catalog_item_listing_id' to be a str")
        pulumi.set(__self__, "package_catalog_item_listing_id", package_catalog_item_listing_id)
        if package_catalog_item_listing_version and not isinstance(package_catalog_item_listing_version, str):
            raise TypeError("Expected argument 'package_catalog_item_listing_version' to be a str")
        pulumi.set(__self__, "package_catalog_item_listing_version", package_catalog_item_listing_version)
        if provision_description and not isinstance(provision_description, str):
            raise TypeError("Expected argument 'provision_description' to be a str")
        pulumi.set(__self__, "provision_description", provision_description)
        if provision_id and not isinstance(provision_id, str):
            raise TypeError("Expected argument 'provision_id' to be a str")
        pulumi.set(__self__, "provision_id", provision_id)
        if rms_apply_job_id and not isinstance(rms_apply_job_id, str):
            raise TypeError("Expected argument 'rms_apply_job_id' to be a str")
        pulumi.set(__self__, "rms_apply_job_id", rms_apply_job_id)
        if stack_id and not isinstance(stack_id, str):
            raise TypeError("Expected argument 'stack_id' to be a str")
        pulumi.set(__self__, "stack_id", stack_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if tf_outputs and not isinstance(tf_outputs, list):
            raise TypeError("Expected argument 'tf_outputs' to be a list")
        pulumi.set(__self__, "tf_outputs", tf_outputs)
        if tf_variable_compartment_id and not isinstance(tf_variable_compartment_id, str):
            raise TypeError("Expected argument 'tf_variable_compartment_id' to be a str")
        pulumi.set(__self__, "tf_variable_compartment_id", tf_variable_compartment_id)
        if tf_variable_current_user_id and not isinstance(tf_variable_current_user_id, str):
            raise TypeError("Expected argument 'tf_variable_current_user_id' to be a str")
        pulumi.set(__self__, "tf_variable_current_user_id", tf_variable_current_user_id)
        if tf_variable_region_id and not isinstance(tf_variable_region_id, str):
            raise TypeError("Expected argument 'tf_variable_region_id' to be a str")
        pulumi.set(__self__, "tf_variable_region_id", tf_variable_region_id)
        if tf_variable_tenancy_id and not isinstance(tf_variable_tenancy_id, str):
            raise TypeError("Expected argument 'tf_variable_tenancy_id' to be a str")
        pulumi.set(__self__, "tf_variable_tenancy_id", tf_variable_tenancy_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which instance is deployed.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="configCatalogItemDisplayName")
    def config_catalog_item_display_name(self) -> _builtins.str:
        """
        A display Name of the Catalog Item in the Catalog.
        """
        return pulumi.get(self, "config_catalog_item_display_name")

    @_builtins.property
    @pulumi.getter(name="configCatalogItemId")
    def config_catalog_item_id(self) -> _builtins.str:
        """
        A [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Catalog Item to a file with key/value pairs to set up variables for createStack API.
        """
        return pulumi.get(self, "config_catalog_item_id")

    @_builtins.property
    @pulumi.getter(name="configCatalogItemListingId")
    def config_catalog_item_listing_id(self) -> _builtins.str:
        """
        A listing ID of the Catalog Item in the Catalog.
        """
        return pulumi.get(self, "config_catalog_item_listing_id")

    @_builtins.property
    @pulumi.getter(name="configCatalogItemListingVersion")
    def config_catalog_item_listing_version(self) -> _builtins.str:
        """
        A listing version of the Catalog Item in the Catalog.
        """
        return pulumi.get(self, "config_catalog_item_listing_version")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="deployedResources")
    def deployed_resources(self) -> Sequence['outputs.GetProvisionDeployedResourceResult']:
        """
        The deployed resources and their summary
        """
        return pulumi.get(self, "deployed_resources")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
        """
        return pulumi.get(self, "fleet_id")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the FamProvision.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message that describes the current state of the FamProvision in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="packageCatalogItemDisplayName")
    def package_catalog_item_display_name(self) -> _builtins.str:
        """
        A display Name of the Catalog Item in the Catalog.
        """
        return pulumi.get(self, "package_catalog_item_display_name")

    @_builtins.property
    @pulumi.getter(name="packageCatalogItemId")
    def package_catalog_item_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Catalog Item.
        """
        return pulumi.get(self, "package_catalog_item_id")

    @_builtins.property
    @pulumi.getter(name="packageCatalogItemListingId")
    def package_catalog_item_listing_id(self) -> _builtins.str:
        """
        A listing ID of the Catalog Item in the Catalog.
        """
        return pulumi.get(self, "package_catalog_item_listing_id")

    @_builtins.property
    @pulumi.getter(name="packageCatalogItemListingVersion")
    def package_catalog_item_listing_version(self) -> _builtins.str:
        """
        A listing version of the Catalog Item in the Catalog.
        """
        return pulumi.get(self, "package_catalog_item_listing_version")

    @_builtins.property
    @pulumi.getter(name="provisionDescription")
    def provision_description(self) -> _builtins.str:
        """
        A description of the provision.
        """
        return pulumi.get(self, "provision_description")

    @_builtins.property
    @pulumi.getter(name="provisionId")
    def provision_id(self) -> _builtins.str:
        return pulumi.get(self, "provision_id")

    @_builtins.property
    @pulumi.getter(name="rmsApplyJobId")
    def rms_apply_job_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the RMS APPLY Job.
        """
        return pulumi.get(self, "rms_apply_job_id")

    @_builtins.property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the RMS Stack.
        """
        return pulumi.get(self, "stack_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the FamProvision.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="tfOutputs")
    def tf_outputs(self) -> Sequence['outputs.GetProvisionTfOutputResult']:
        """
        Outputs from the pulumi up job
        """
        return pulumi.get(self, "tf_outputs")

    @_builtins.property
    @pulumi.getter(name="tfVariableCompartmentId")
    def tf_variable_compartment_id(self) -> _builtins.str:
        """
        An optional variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.
        """
        return pulumi.get(self, "tf_variable_compartment_id")

    @_builtins.property
    @pulumi.getter(name="tfVariableCurrentUserId")
    def tf_variable_current_user_id(self) -> _builtins.str:
        """
        An optional variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.
        """
        return pulumi.get(self, "tf_variable_current_user_id")

    @_builtins.property
    @pulumi.getter(name="tfVariableRegionId")
    def tf_variable_region_id(self) -> _builtins.str:
        """
        A mandatory variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.
        """
        return pulumi.get(self, "tf_variable_region_id")

    @_builtins.property
    @pulumi.getter(name="tfVariableTenancyId")
    def tf_variable_tenancy_id(self) -> _builtins.str:
        """
        A mandatory variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.
        """
        return pulumi.get(self, "tf_variable_tenancy_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the FamProvision was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the FamProvision was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetProvisionResult(GetProvisionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProvisionResult(
            compartment_id=self.compartment_id,
            config_catalog_item_display_name=self.config_catalog_item_display_name,
            config_catalog_item_id=self.config_catalog_item_id,
            config_catalog_item_listing_id=self.config_catalog_item_listing_id,
            config_catalog_item_listing_version=self.config_catalog_item_listing_version,
            defined_tags=self.defined_tags,
            deployed_resources=self.deployed_resources,
            display_name=self.display_name,
            fleet_id=self.fleet_id,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            package_catalog_item_display_name=self.package_catalog_item_display_name,
            package_catalog_item_id=self.package_catalog_item_id,
            package_catalog_item_listing_id=self.package_catalog_item_listing_id,
            package_catalog_item_listing_version=self.package_catalog_item_listing_version,
            provision_description=self.provision_description,
            provision_id=self.provision_id,
            rms_apply_job_id=self.rms_apply_job_id,
            stack_id=self.stack_id,
            state=self.state,
            system_tags=self.system_tags,
            tf_outputs=self.tf_outputs,
            tf_variable_compartment_id=self.tf_variable_compartment_id,
            tf_variable_current_user_id=self.tf_variable_current_user_id,
            tf_variable_region_id=self.tf_variable_region_id,
            tf_variable_tenancy_id=self.tf_variable_tenancy_id,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_provision(provision_id: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProvisionResult:
    """
    This data source provides details about a specific Provision resource in Oracle Cloud Infrastructure Fleet Apps Management service.

    Gets information about a Provision.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_provision = oci.FleetAppsManagement.get_provision(provision_id=test_provision_oci_fleet_apps_management_provision["id"])
    ```


    :param _builtins.str provision_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the FamProvision.
    """
    __args__ = dict()
    __args__['provisionId'] = provision_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getProvision:getProvision', __args__, opts=opts, typ=GetProvisionResult).value

    return AwaitableGetProvisionResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        config_catalog_item_display_name=pulumi.get(__ret__, 'config_catalog_item_display_name'),
        config_catalog_item_id=pulumi.get(__ret__, 'config_catalog_item_id'),
        config_catalog_item_listing_id=pulumi.get(__ret__, 'config_catalog_item_listing_id'),
        config_catalog_item_listing_version=pulumi.get(__ret__, 'config_catalog_item_listing_version'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        deployed_resources=pulumi.get(__ret__, 'deployed_resources'),
        display_name=pulumi.get(__ret__, 'display_name'),
        fleet_id=pulumi.get(__ret__, 'fleet_id'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        package_catalog_item_display_name=pulumi.get(__ret__, 'package_catalog_item_display_name'),
        package_catalog_item_id=pulumi.get(__ret__, 'package_catalog_item_id'),
        package_catalog_item_listing_id=pulumi.get(__ret__, 'package_catalog_item_listing_id'),
        package_catalog_item_listing_version=pulumi.get(__ret__, 'package_catalog_item_listing_version'),
        provision_description=pulumi.get(__ret__, 'provision_description'),
        provision_id=pulumi.get(__ret__, 'provision_id'),
        rms_apply_job_id=pulumi.get(__ret__, 'rms_apply_job_id'),
        stack_id=pulumi.get(__ret__, 'stack_id'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        tf_outputs=pulumi.get(__ret__, 'tf_outputs'),
        tf_variable_compartment_id=pulumi.get(__ret__, 'tf_variable_compartment_id'),
        tf_variable_current_user_id=pulumi.get(__ret__, 'tf_variable_current_user_id'),
        tf_variable_region_id=pulumi.get(__ret__, 'tf_variable_region_id'),
        tf_variable_tenancy_id=pulumi.get(__ret__, 'tf_variable_tenancy_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_provision_output(provision_id: Optional[pulumi.Input[_builtins.str]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProvisionResult]:
    """
    This data source provides details about a specific Provision resource in Oracle Cloud Infrastructure Fleet Apps Management service.

    Gets information about a Provision.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_provision = oci.FleetAppsManagement.get_provision(provision_id=test_provision_oci_fleet_apps_management_provision["id"])
    ```


    :param _builtins.str provision_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the FamProvision.
    """
    __args__ = dict()
    __args__['provisionId'] = provision_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getProvision:getProvision', __args__, opts=opts, typ=GetProvisionResult)
    return __ret__.apply(lambda __response__: GetProvisionResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        config_catalog_item_display_name=pulumi.get(__response__, 'config_catalog_item_display_name'),
        config_catalog_item_id=pulumi.get(__response__, 'config_catalog_item_id'),
        config_catalog_item_listing_id=pulumi.get(__response__, 'config_catalog_item_listing_id'),
        config_catalog_item_listing_version=pulumi.get(__response__, 'config_catalog_item_listing_version'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        deployed_resources=pulumi.get(__response__, 'deployed_resources'),
        display_name=pulumi.get(__response__, 'display_name'),
        fleet_id=pulumi.get(__response__, 'fleet_id'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        package_catalog_item_display_name=pulumi.get(__response__, 'package_catalog_item_display_name'),
        package_catalog_item_id=pulumi.get(__response__, 'package_catalog_item_id'),
        package_catalog_item_listing_id=pulumi.get(__response__, 'package_catalog_item_listing_id'),
        package_catalog_item_listing_version=pulumi.get(__response__, 'package_catalog_item_listing_version'),
        provision_description=pulumi.get(__response__, 'provision_description'),
        provision_id=pulumi.get(__response__, 'provision_id'),
        rms_apply_job_id=pulumi.get(__response__, 'rms_apply_job_id'),
        stack_id=pulumi.get(__response__, 'stack_id'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        tf_outputs=pulumi.get(__response__, 'tf_outputs'),
        tf_variable_compartment_id=pulumi.get(__response__, 'tf_variable_compartment_id'),
        tf_variable_current_user_id=pulumi.get(__response__, 'tf_variable_current_user_id'),
        tf_variable_region_id=pulumi.get(__response__, 'tf_variable_region_id'),
        tf_variable_tenancy_id=pulumi.get(__response__, 'tf_variable_tenancy_id'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
