# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FusionEnvironmentArgs', 'FusionEnvironment']

@pulumi.input_type
class FusionEnvironmentArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 create_fusion_environment_admin_user_details: pulumi.Input['FusionEnvironmentCreateFusionEnvironmentAdminUserDetailsArgs'],
                 display_name: pulumi.Input[_builtins.str],
                 fusion_environment_family_id: pulumi.Input[_builtins.str],
                 fusion_environment_type: pulumi.Input[_builtins.str],
                 additional_language_packs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 dns_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_policy: Optional[pulumi.Input['FusionEnvironmentMaintenancePolicyArgs']] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['FusionEnvironmentRuleArgs']]]] = None):
        """
        The set of arguments for constructing a FusionEnvironment resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The unique identifier (OCID) of the compartment where the Fusion Environment is located.
        :param pulumi.Input['FusionEnvironmentCreateFusionEnvironmentAdminUserDetailsArgs'] create_fusion_environment_admin_user_details: The credentials for the Fusion Applications service administrator.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) FusionEnvironment Identifier can be renamed.
        :param pulumi.Input[_builtins.str] fusion_environment_family_id: The unique identifier (OCID) of the Fusion Environment Family that the Fusion Environment belongs to.
        :param pulumi.Input[_builtins.str] fusion_environment_type: The type of environment. Valid values are Production, Test, or Development.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] additional_language_packs: (Updatable) Language packs.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] dns_prefix: DNS prefix.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] kms_key_id: (Updatable) byok kms keyId
        :param pulumi.Input['FusionEnvironmentMaintenancePolicyArgs'] maintenance_policy: (Updatable) The policy that specifies the maintenance and upgrade preferences for an environment. For more information about the options, see [Understanding Environment Maintenance](https://docs.cloud.oracle.com/iaas/Content/fusion-applications/plan-environment-family.htm#about-env-maintenance).
        :param pulumi.Input[Sequence[pulumi.Input['FusionEnvironmentRuleArgs']]] rules: (Updatable) Rules.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "create_fusion_environment_admin_user_details", create_fusion_environment_admin_user_details)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "fusion_environment_family_id", fusion_environment_family_id)
        pulumi.set(__self__, "fusion_environment_type", fusion_environment_type)
        if additional_language_packs is not None:
            pulumi.set(__self__, "additional_language_packs", additional_language_packs)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if dns_prefix is not None:
            pulumi.set(__self__, "dns_prefix", dns_prefix)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if maintenance_policy is not None:
            pulumi.set(__self__, "maintenance_policy", maintenance_policy)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The unique identifier (OCID) of the compartment where the Fusion Environment is located.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="createFusionEnvironmentAdminUserDetails")
    def create_fusion_environment_admin_user_details(self) -> pulumi.Input['FusionEnvironmentCreateFusionEnvironmentAdminUserDetailsArgs']:
        """
        The credentials for the Fusion Applications service administrator.
        """
        return pulumi.get(self, "create_fusion_environment_admin_user_details")

    @create_fusion_environment_admin_user_details.setter
    def create_fusion_environment_admin_user_details(self, value: pulumi.Input['FusionEnvironmentCreateFusionEnvironmentAdminUserDetailsArgs']):
        pulumi.set(self, "create_fusion_environment_admin_user_details", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) FusionEnvironment Identifier can be renamed.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="fusionEnvironmentFamilyId")
    def fusion_environment_family_id(self) -> pulumi.Input[_builtins.str]:
        """
        The unique identifier (OCID) of the Fusion Environment Family that the Fusion Environment belongs to.
        """
        return pulumi.get(self, "fusion_environment_family_id")

    @fusion_environment_family_id.setter
    def fusion_environment_family_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "fusion_environment_family_id", value)

    @_builtins.property
    @pulumi.getter(name="fusionEnvironmentType")
    def fusion_environment_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of environment. Valid values are Production, Test, or Development.
        """
        return pulumi.get(self, "fusion_environment_type")

    @fusion_environment_type.setter
    def fusion_environment_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "fusion_environment_type", value)

    @_builtins.property
    @pulumi.getter(name="additionalLanguagePacks")
    def additional_language_packs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Language packs.
        """
        return pulumi.get(self, "additional_language_packs")

    @additional_language_packs.setter
    def additional_language_packs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_language_packs", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="dnsPrefix")
    def dns_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        DNS prefix.
        """
        return pulumi.get(self, "dns_prefix")

    @dns_prefix.setter
    def dns_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_prefix", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) byok kms keyId
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="maintenancePolicy")
    def maintenance_policy(self) -> Optional[pulumi.Input['FusionEnvironmentMaintenancePolicyArgs']]:
        """
        (Updatable) The policy that specifies the maintenance and upgrade preferences for an environment. For more information about the options, see [Understanding Environment Maintenance](https://docs.cloud.oracle.com/iaas/Content/fusion-applications/plan-environment-family.htm#about-env-maintenance).
        """
        return pulumi.get(self, "maintenance_policy")

    @maintenance_policy.setter
    def maintenance_policy(self, value: Optional[pulumi.Input['FusionEnvironmentMaintenancePolicyArgs']]):
        pulumi.set(self, "maintenance_policy", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionEnvironmentRuleArgs']]]]:
        """
        (Updatable) Rules.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionEnvironmentRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class _FusionEnvironmentState:
    def __init__(__self__, *,
                 additional_language_packs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 applied_patch_bundles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 create_fusion_environment_admin_user_details: Optional[pulumi.Input['FusionEnvironmentCreateFusionEnvironmentAdminUserDetailsArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 fusion_environment_family_id: Optional[pulumi.Input[_builtins.str]] = None,
                 fusion_environment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 idcs_domain_url: Optional[pulumi.Input[_builtins.str]] = None,
                 is_break_glass_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_infos: Optional[pulumi.Input[Sequence[pulumi.Input['FusionEnvironmentKmsKeyInfoArgs']]]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 lockbox_id: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_policy: Optional[pulumi.Input['FusionEnvironmentMaintenancePolicyArgs']] = None,
                 public_url: Optional[pulumi.Input[_builtins.str]] = None,
                 refreshes: Optional[pulumi.Input[Sequence[pulumi.Input['FusionEnvironmentRefreshArgs']]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['FusionEnvironmentRuleArgs']]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 system_name: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_upcoming_maintenance: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FusionEnvironment resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] additional_language_packs: (Updatable) Language packs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applied_patch_bundles: Patch bundle names
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The unique identifier (OCID) of the compartment where the Fusion Environment is located.
        :param pulumi.Input['FusionEnvironmentCreateFusionEnvironmentAdminUserDetailsArgs'] create_fusion_environment_admin_user_details: The credentials for the Fusion Applications service administrator.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) FusionEnvironment Identifier can be renamed.
        :param pulumi.Input[_builtins.str] dns_prefix: DNS prefix.
        :param pulumi.Input[_builtins.str] domain_id: The IDCS domain created for the fusion instance
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] fusion_environment_family_id: The unique identifier (OCID) of the Fusion Environment Family that the Fusion Environment belongs to.
        :param pulumi.Input[_builtins.str] fusion_environment_type: The type of environment. Valid values are Production, Test, or Development.
        :param pulumi.Input[_builtins.str] idcs_domain_url: The IDCS Domain URL
        :param pulumi.Input[_builtins.bool] is_break_glass_enabled: If it's true, then the Break Glass feature is enabled
        :param pulumi.Input[_builtins.str] kms_key_id: (Updatable) byok kms keyId
        :param pulumi.Input[Sequence[pulumi.Input['FusionEnvironmentKmsKeyInfoArgs']]] kms_key_infos: BYOK key info
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[_builtins.str] lockbox_id: The lockbox Id of this fusion environment. If there's no lockbox id, this field will be null
        :param pulumi.Input['FusionEnvironmentMaintenancePolicyArgs'] maintenance_policy: (Updatable) The policy that specifies the maintenance and upgrade preferences for an environment. For more information about the options, see [Understanding Environment Maintenance](https://docs.cloud.oracle.com/iaas/Content/fusion-applications/plan-environment-family.htm#about-env-maintenance).
        :param pulumi.Input[_builtins.str] public_url: Public URL
        :param pulumi.Input[Sequence[pulumi.Input['FusionEnvironmentRefreshArgs']]] refreshes: Describes a refresh of a fusion environment
        :param pulumi.Input[Sequence[pulumi.Input['FusionEnvironmentRuleArgs']]] rules: (Updatable) Rules.
        :param pulumi.Input[_builtins.str] state: The current state of the ServiceInstance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subscription_ids: List of subscription IDs.
        :param pulumi.Input[_builtins.str] system_name: Environment Specific Guid/ System Name
        :param pulumi.Input[_builtins.str] time_created: The time the the FusionEnvironment was created. An RFC3339 formatted datetime string
        :param pulumi.Input[_builtins.str] time_upcoming_maintenance: The next maintenance for this environment
        :param pulumi.Input[_builtins.str] time_updated: The time the FusionEnvironment was updated. An RFC3339 formatted datetime string
        :param pulumi.Input[_builtins.str] version: Version of Fusion Apps used by this environment
        """
        if additional_language_packs is not None:
            pulumi.set(__self__, "additional_language_packs", additional_language_packs)
        if applied_patch_bundles is not None:
            pulumi.set(__self__, "applied_patch_bundles", applied_patch_bundles)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if create_fusion_environment_admin_user_details is not None:
            pulumi.set(__self__, "create_fusion_environment_admin_user_details", create_fusion_environment_admin_user_details)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if dns_prefix is not None:
            pulumi.set(__self__, "dns_prefix", dns_prefix)
        if domain_id is not None:
            pulumi.set(__self__, "domain_id", domain_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if fusion_environment_family_id is not None:
            pulumi.set(__self__, "fusion_environment_family_id", fusion_environment_family_id)
        if fusion_environment_type is not None:
            pulumi.set(__self__, "fusion_environment_type", fusion_environment_type)
        if idcs_domain_url is not None:
            pulumi.set(__self__, "idcs_domain_url", idcs_domain_url)
        if is_break_glass_enabled is not None:
            pulumi.set(__self__, "is_break_glass_enabled", is_break_glass_enabled)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if kms_key_infos is not None:
            pulumi.set(__self__, "kms_key_infos", kms_key_infos)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if lockbox_id is not None:
            pulumi.set(__self__, "lockbox_id", lockbox_id)
        if maintenance_policy is not None:
            pulumi.set(__self__, "maintenance_policy", maintenance_policy)
        if public_url is not None:
            pulumi.set(__self__, "public_url", public_url)
        if refreshes is not None:
            pulumi.set(__self__, "refreshes", refreshes)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subscription_ids is not None:
            pulumi.set(__self__, "subscription_ids", subscription_ids)
        if system_name is not None:
            pulumi.set(__self__, "system_name", system_name)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_upcoming_maintenance is not None:
            pulumi.set(__self__, "time_upcoming_maintenance", time_upcoming_maintenance)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="additionalLanguagePacks")
    def additional_language_packs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Language packs.
        """
        return pulumi.get(self, "additional_language_packs")

    @additional_language_packs.setter
    def additional_language_packs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_language_packs", value)

    @_builtins.property
    @pulumi.getter(name="appliedPatchBundles")
    def applied_patch_bundles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Patch bundle names
        """
        return pulumi.get(self, "applied_patch_bundles")

    @applied_patch_bundles.setter
    def applied_patch_bundles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "applied_patch_bundles", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The unique identifier (OCID) of the compartment where the Fusion Environment is located.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="createFusionEnvironmentAdminUserDetails")
    def create_fusion_environment_admin_user_details(self) -> Optional[pulumi.Input['FusionEnvironmentCreateFusionEnvironmentAdminUserDetailsArgs']]:
        """
        The credentials for the Fusion Applications service administrator.
        """
        return pulumi.get(self, "create_fusion_environment_admin_user_details")

    @create_fusion_environment_admin_user_details.setter
    def create_fusion_environment_admin_user_details(self, value: Optional[pulumi.Input['FusionEnvironmentCreateFusionEnvironmentAdminUserDetailsArgs']]):
        pulumi.set(self, "create_fusion_environment_admin_user_details", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) FusionEnvironment Identifier can be renamed.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="dnsPrefix")
    def dns_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        DNS prefix.
        """
        return pulumi.get(self, "dns_prefix")

    @dns_prefix.setter
    def dns_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_prefix", value)

    @_builtins.property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IDCS domain created for the fusion instance
        """
        return pulumi.get(self, "domain_id")

    @domain_id.setter
    def domain_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_id", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="fusionEnvironmentFamilyId")
    def fusion_environment_family_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier (OCID) of the Fusion Environment Family that the Fusion Environment belongs to.
        """
        return pulumi.get(self, "fusion_environment_family_id")

    @fusion_environment_family_id.setter
    def fusion_environment_family_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fusion_environment_family_id", value)

    @_builtins.property
    @pulumi.getter(name="fusionEnvironmentType")
    def fusion_environment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of environment. Valid values are Production, Test, or Development.
        """
        return pulumi.get(self, "fusion_environment_type")

    @fusion_environment_type.setter
    def fusion_environment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fusion_environment_type", value)

    @_builtins.property
    @pulumi.getter(name="idcsDomainUrl")
    def idcs_domain_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IDCS Domain URL
        """
        return pulumi.get(self, "idcs_domain_url")

    @idcs_domain_url.setter
    def idcs_domain_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "idcs_domain_url", value)

    @_builtins.property
    @pulumi.getter(name="isBreakGlassEnabled")
    def is_break_glass_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If it's true, then the Break Glass feature is enabled
        """
        return pulumi.get(self, "is_break_glass_enabled")

    @is_break_glass_enabled.setter
    def is_break_glass_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_break_glass_enabled", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) byok kms keyId
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyInfos")
    def kms_key_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionEnvironmentKmsKeyInfoArgs']]]]:
        """
        BYOK key info
        """
        return pulumi.get(self, "kms_key_infos")

    @kms_key_infos.setter
    def kms_key_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionEnvironmentKmsKeyInfoArgs']]]]):
        pulumi.set(self, "kms_key_infos", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter(name="lockboxId")
    def lockbox_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The lockbox Id of this fusion environment. If there's no lockbox id, this field will be null
        """
        return pulumi.get(self, "lockbox_id")

    @lockbox_id.setter
    def lockbox_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lockbox_id", value)

    @_builtins.property
    @pulumi.getter(name="maintenancePolicy")
    def maintenance_policy(self) -> Optional[pulumi.Input['FusionEnvironmentMaintenancePolicyArgs']]:
        """
        (Updatable) The policy that specifies the maintenance and upgrade preferences for an environment. For more information about the options, see [Understanding Environment Maintenance](https://docs.cloud.oracle.com/iaas/Content/fusion-applications/plan-environment-family.htm#about-env-maintenance).
        """
        return pulumi.get(self, "maintenance_policy")

    @maintenance_policy.setter
    def maintenance_policy(self, value: Optional[pulumi.Input['FusionEnvironmentMaintenancePolicyArgs']]):
        pulumi.set(self, "maintenance_policy", value)

    @_builtins.property
    @pulumi.getter(name="publicUrl")
    def public_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Public URL
        """
        return pulumi.get(self, "public_url")

    @public_url.setter
    def public_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_url", value)

    @_builtins.property
    @pulumi.getter
    def refreshes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionEnvironmentRefreshArgs']]]]:
        """
        Describes a refresh of a fusion environment
        """
        return pulumi.get(self, "refreshes")

    @refreshes.setter
    def refreshes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionEnvironmentRefreshArgs']]]]):
        pulumi.set(self, "refreshes", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionEnvironmentRuleArgs']]]]:
        """
        (Updatable) Rules.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionEnvironmentRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the ServiceInstance.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionIds")
    def subscription_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of subscription IDs.
        """
        return pulumi.get(self, "subscription_ids")

    @subscription_ids.setter
    def subscription_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "subscription_ids", value)

    @_builtins.property
    @pulumi.getter(name="systemName")
    def system_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Environment Specific Guid/ System Name
        """
        return pulumi.get(self, "system_name")

    @system_name.setter
    def system_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_name", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the the FusionEnvironment was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpcomingMaintenance")
    def time_upcoming_maintenance(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The next maintenance for this environment
        """
        return pulumi.get(self, "time_upcoming_maintenance")

    @time_upcoming_maintenance.setter
    def time_upcoming_maintenance(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_upcoming_maintenance", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the FusionEnvironment was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of Fusion Apps used by this environment
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("oci:FusionApps/fusionEnvironment:FusionEnvironment")
class FusionEnvironment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_language_packs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 create_fusion_environment_admin_user_details: Optional[pulumi.Input[Union['FusionEnvironmentCreateFusionEnvironmentAdminUserDetailsArgs', 'FusionEnvironmentCreateFusionEnvironmentAdminUserDetailsArgsDict']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 fusion_environment_family_id: Optional[pulumi.Input[_builtins.str]] = None,
                 fusion_environment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_policy: Optional[pulumi.Input[Union['FusionEnvironmentMaintenancePolicyArgs', 'FusionEnvironmentMaintenancePolicyArgsDict']]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FusionEnvironmentRuleArgs', 'FusionEnvironmentRuleArgsDict']]]]] = None,
                 __props__=None):
        """
        This resource provides the Fusion Environment resource in Oracle Cloud Infrastructure Fusion Apps service.

        Creates a new FusionEnvironment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_fusion_environment = oci.fusionapps.FusionEnvironment("test_fusion_environment",
            compartment_id=compartment_id,
            create_fusion_environment_admin_user_details={
                "email_address": fusion_environment_create_fusion_environment_admin_user_details_email_address,
                "first_name": fusion_environment_create_fusion_environment_admin_user_details_first_name,
                "last_name": fusion_environment_create_fusion_environment_admin_user_details_last_name,
                "username": fusion_environment_create_fusion_environment_admin_user_details_username,
                "password": fusion_environment_create_fusion_environment_admin_user_details_password,
            },
            display_name=fusion_environment_display_name,
            fusion_environment_family_id=test_fusion_environment_family["id"],
            fusion_environment_type=fusion_environment_fusion_environment_type,
            additional_language_packs=fusion_environment_additional_language_packs,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            dns_prefix=fusion_environment_dns_prefix,
            freeform_tags={
                "bar-key": "value",
            },
            kms_key_id=test_key["id"],
            maintenance_policy={
                "environment_maintenance_override": fusion_environment_maintenance_policy_environment_maintenance_override,
                "monthly_patching_override": fusion_environment_maintenance_policy_monthly_patching_override,
            },
            rules=[{
                "action": fusion_environment_rules_action,
                "conditions": [{
                    "attribute_name": fusion_environment_rules_conditions_attribute_name,
                    "attribute_value": fusion_environment_rules_conditions_attribute_value,
                }],
                "description": fusion_environment_rules_description,
            }])
        ```

        ## Import

        FusionEnvironments can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:FusionApps/fusionEnvironment:FusionEnvironment test_fusion_environment "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] additional_language_packs: (Updatable) Language packs.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The unique identifier (OCID) of the compartment where the Fusion Environment is located.
        :param pulumi.Input[Union['FusionEnvironmentCreateFusionEnvironmentAdminUserDetailsArgs', 'FusionEnvironmentCreateFusionEnvironmentAdminUserDetailsArgsDict']] create_fusion_environment_admin_user_details: The credentials for the Fusion Applications service administrator.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) FusionEnvironment Identifier can be renamed.
        :param pulumi.Input[_builtins.str] dns_prefix: DNS prefix.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] fusion_environment_family_id: The unique identifier (OCID) of the Fusion Environment Family that the Fusion Environment belongs to.
        :param pulumi.Input[_builtins.str] fusion_environment_type: The type of environment. Valid values are Production, Test, or Development.
        :param pulumi.Input[_builtins.str] kms_key_id: (Updatable) byok kms keyId
        :param pulumi.Input[Union['FusionEnvironmentMaintenancePolicyArgs', 'FusionEnvironmentMaintenancePolicyArgsDict']] maintenance_policy: (Updatable) The policy that specifies the maintenance and upgrade preferences for an environment. For more information about the options, see [Understanding Environment Maintenance](https://docs.cloud.oracle.com/iaas/Content/fusion-applications/plan-environment-family.htm#about-env-maintenance).
        :param pulumi.Input[Sequence[pulumi.Input[Union['FusionEnvironmentRuleArgs', 'FusionEnvironmentRuleArgsDict']]]] rules: (Updatable) Rules.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FusionEnvironmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Fusion Environment resource in Oracle Cloud Infrastructure Fusion Apps service.

        Creates a new FusionEnvironment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_fusion_environment = oci.fusionapps.FusionEnvironment("test_fusion_environment",
            compartment_id=compartment_id,
            create_fusion_environment_admin_user_details={
                "email_address": fusion_environment_create_fusion_environment_admin_user_details_email_address,
                "first_name": fusion_environment_create_fusion_environment_admin_user_details_first_name,
                "last_name": fusion_environment_create_fusion_environment_admin_user_details_last_name,
                "username": fusion_environment_create_fusion_environment_admin_user_details_username,
                "password": fusion_environment_create_fusion_environment_admin_user_details_password,
            },
            display_name=fusion_environment_display_name,
            fusion_environment_family_id=test_fusion_environment_family["id"],
            fusion_environment_type=fusion_environment_fusion_environment_type,
            additional_language_packs=fusion_environment_additional_language_packs,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            dns_prefix=fusion_environment_dns_prefix,
            freeform_tags={
                "bar-key": "value",
            },
            kms_key_id=test_key["id"],
            maintenance_policy={
                "environment_maintenance_override": fusion_environment_maintenance_policy_environment_maintenance_override,
                "monthly_patching_override": fusion_environment_maintenance_policy_monthly_patching_override,
            },
            rules=[{
                "action": fusion_environment_rules_action,
                "conditions": [{
                    "attribute_name": fusion_environment_rules_conditions_attribute_name,
                    "attribute_value": fusion_environment_rules_conditions_attribute_value,
                }],
                "description": fusion_environment_rules_description,
            }])
        ```

        ## Import

        FusionEnvironments can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:FusionApps/fusionEnvironment:FusionEnvironment test_fusion_environment "id"
        ```

        :param str resource_name: The name of the resource.
        :param FusionEnvironmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FusionEnvironmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_language_packs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 create_fusion_environment_admin_user_details: Optional[pulumi.Input[Union['FusionEnvironmentCreateFusionEnvironmentAdminUserDetailsArgs', 'FusionEnvironmentCreateFusionEnvironmentAdminUserDetailsArgsDict']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 fusion_environment_family_id: Optional[pulumi.Input[_builtins.str]] = None,
                 fusion_environment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_policy: Optional[pulumi.Input[Union['FusionEnvironmentMaintenancePolicyArgs', 'FusionEnvironmentMaintenancePolicyArgsDict']]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FusionEnvironmentRuleArgs', 'FusionEnvironmentRuleArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FusionEnvironmentArgs.__new__(FusionEnvironmentArgs)

            __props__.__dict__["additional_language_packs"] = additional_language_packs
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if create_fusion_environment_admin_user_details is None and not opts.urn:
                raise TypeError("Missing required property 'create_fusion_environment_admin_user_details'")
            __props__.__dict__["create_fusion_environment_admin_user_details"] = create_fusion_environment_admin_user_details
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["dns_prefix"] = dns_prefix
            __props__.__dict__["freeform_tags"] = freeform_tags
            if fusion_environment_family_id is None and not opts.urn:
                raise TypeError("Missing required property 'fusion_environment_family_id'")
            __props__.__dict__["fusion_environment_family_id"] = fusion_environment_family_id
            if fusion_environment_type is None and not opts.urn:
                raise TypeError("Missing required property 'fusion_environment_type'")
            __props__.__dict__["fusion_environment_type"] = fusion_environment_type
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["maintenance_policy"] = maintenance_policy
            __props__.__dict__["rules"] = rules
            __props__.__dict__["applied_patch_bundles"] = None
            __props__.__dict__["domain_id"] = None
            __props__.__dict__["idcs_domain_url"] = None
            __props__.__dict__["is_break_glass_enabled"] = None
            __props__.__dict__["kms_key_infos"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["lockbox_id"] = None
            __props__.__dict__["public_url"] = None
            __props__.__dict__["refreshes"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["subscription_ids"] = None
            __props__.__dict__["system_name"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_upcoming_maintenance"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["version"] = None
        super(FusionEnvironment, __self__).__init__(
            'oci:FusionApps/fusionEnvironment:FusionEnvironment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_language_packs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            applied_patch_bundles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            create_fusion_environment_admin_user_details: Optional[pulumi.Input[Union['FusionEnvironmentCreateFusionEnvironmentAdminUserDetailsArgs', 'FusionEnvironmentCreateFusionEnvironmentAdminUserDetailsArgsDict']]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            dns_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            domain_id: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            fusion_environment_family_id: Optional[pulumi.Input[_builtins.str]] = None,
            fusion_environment_type: Optional[pulumi.Input[_builtins.str]] = None,
            idcs_domain_url: Optional[pulumi.Input[_builtins.str]] = None,
            is_break_glass_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            kms_key_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FusionEnvironmentKmsKeyInfoArgs', 'FusionEnvironmentKmsKeyInfoArgsDict']]]]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            lockbox_id: Optional[pulumi.Input[_builtins.str]] = None,
            maintenance_policy: Optional[pulumi.Input[Union['FusionEnvironmentMaintenancePolicyArgs', 'FusionEnvironmentMaintenancePolicyArgsDict']]] = None,
            public_url: Optional[pulumi.Input[_builtins.str]] = None,
            refreshes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FusionEnvironmentRefreshArgs', 'FusionEnvironmentRefreshArgsDict']]]]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FusionEnvironmentRuleArgs', 'FusionEnvironmentRuleArgsDict']]]]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            subscription_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            system_name: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_upcoming_maintenance: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'FusionEnvironment':
        """
        Get an existing FusionEnvironment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] additional_language_packs: (Updatable) Language packs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applied_patch_bundles: Patch bundle names
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The unique identifier (OCID) of the compartment where the Fusion Environment is located.
        :param pulumi.Input[Union['FusionEnvironmentCreateFusionEnvironmentAdminUserDetailsArgs', 'FusionEnvironmentCreateFusionEnvironmentAdminUserDetailsArgsDict']] create_fusion_environment_admin_user_details: The credentials for the Fusion Applications service administrator.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) FusionEnvironment Identifier can be renamed.
        :param pulumi.Input[_builtins.str] dns_prefix: DNS prefix.
        :param pulumi.Input[_builtins.str] domain_id: The IDCS domain created for the fusion instance
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] fusion_environment_family_id: The unique identifier (OCID) of the Fusion Environment Family that the Fusion Environment belongs to.
        :param pulumi.Input[_builtins.str] fusion_environment_type: The type of environment. Valid values are Production, Test, or Development.
        :param pulumi.Input[_builtins.str] idcs_domain_url: The IDCS Domain URL
        :param pulumi.Input[_builtins.bool] is_break_glass_enabled: If it's true, then the Break Glass feature is enabled
        :param pulumi.Input[_builtins.str] kms_key_id: (Updatable) byok kms keyId
        :param pulumi.Input[Sequence[pulumi.Input[Union['FusionEnvironmentKmsKeyInfoArgs', 'FusionEnvironmentKmsKeyInfoArgsDict']]]] kms_key_infos: BYOK key info
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[_builtins.str] lockbox_id: The lockbox Id of this fusion environment. If there's no lockbox id, this field will be null
        :param pulumi.Input[Union['FusionEnvironmentMaintenancePolicyArgs', 'FusionEnvironmentMaintenancePolicyArgsDict']] maintenance_policy: (Updatable) The policy that specifies the maintenance and upgrade preferences for an environment. For more information about the options, see [Understanding Environment Maintenance](https://docs.cloud.oracle.com/iaas/Content/fusion-applications/plan-environment-family.htm#about-env-maintenance).
        :param pulumi.Input[_builtins.str] public_url: Public URL
        :param pulumi.Input[Sequence[pulumi.Input[Union['FusionEnvironmentRefreshArgs', 'FusionEnvironmentRefreshArgsDict']]]] refreshes: Describes a refresh of a fusion environment
        :param pulumi.Input[Sequence[pulumi.Input[Union['FusionEnvironmentRuleArgs', 'FusionEnvironmentRuleArgsDict']]]] rules: (Updatable) Rules.
        :param pulumi.Input[_builtins.str] state: The current state of the ServiceInstance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subscription_ids: List of subscription IDs.
        :param pulumi.Input[_builtins.str] system_name: Environment Specific Guid/ System Name
        :param pulumi.Input[_builtins.str] time_created: The time the the FusionEnvironment was created. An RFC3339 formatted datetime string
        :param pulumi.Input[_builtins.str] time_upcoming_maintenance: The next maintenance for this environment
        :param pulumi.Input[_builtins.str] time_updated: The time the FusionEnvironment was updated. An RFC3339 formatted datetime string
        :param pulumi.Input[_builtins.str] version: Version of Fusion Apps used by this environment
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FusionEnvironmentState.__new__(_FusionEnvironmentState)

        __props__.__dict__["additional_language_packs"] = additional_language_packs
        __props__.__dict__["applied_patch_bundles"] = applied_patch_bundles
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["create_fusion_environment_admin_user_details"] = create_fusion_environment_admin_user_details
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["dns_prefix"] = dns_prefix
        __props__.__dict__["domain_id"] = domain_id
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["fusion_environment_family_id"] = fusion_environment_family_id
        __props__.__dict__["fusion_environment_type"] = fusion_environment_type
        __props__.__dict__["idcs_domain_url"] = idcs_domain_url
        __props__.__dict__["is_break_glass_enabled"] = is_break_glass_enabled
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["kms_key_infos"] = kms_key_infos
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["lockbox_id"] = lockbox_id
        __props__.__dict__["maintenance_policy"] = maintenance_policy
        __props__.__dict__["public_url"] = public_url
        __props__.__dict__["refreshes"] = refreshes
        __props__.__dict__["rules"] = rules
        __props__.__dict__["state"] = state
        __props__.__dict__["subscription_ids"] = subscription_ids
        __props__.__dict__["system_name"] = system_name
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_upcoming_maintenance"] = time_upcoming_maintenance
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["version"] = version
        return FusionEnvironment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="additionalLanguagePacks")
    def additional_language_packs(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        (Updatable) Language packs.
        """
        return pulumi.get(self, "additional_language_packs")

    @_builtins.property
    @pulumi.getter(name="appliedPatchBundles")
    def applied_patch_bundles(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Patch bundle names
        """
        return pulumi.get(self, "applied_patch_bundles")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The unique identifier (OCID) of the compartment where the Fusion Environment is located.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="createFusionEnvironmentAdminUserDetails")
    def create_fusion_environment_admin_user_details(self) -> pulumi.Output['outputs.FusionEnvironmentCreateFusionEnvironmentAdminUserDetails']:
        """
        The credentials for the Fusion Applications service administrator.
        """
        return pulumi.get(self, "create_fusion_environment_admin_user_details")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) FusionEnvironment Identifier can be renamed.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="dnsPrefix")
    def dns_prefix(self) -> pulumi.Output[_builtins.str]:
        """
        DNS prefix.
        """
        return pulumi.get(self, "dns_prefix")

    @_builtins.property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> pulumi.Output[_builtins.str]:
        """
        The IDCS domain created for the fusion instance
        """
        return pulumi.get(self, "domain_id")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="fusionEnvironmentFamilyId")
    def fusion_environment_family_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier (OCID) of the Fusion Environment Family that the Fusion Environment belongs to.
        """
        return pulumi.get(self, "fusion_environment_family_id")

    @_builtins.property
    @pulumi.getter(name="fusionEnvironmentType")
    def fusion_environment_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of environment. Valid values are Production, Test, or Development.
        """
        return pulumi.get(self, "fusion_environment_type")

    @_builtins.property
    @pulumi.getter(name="idcsDomainUrl")
    def idcs_domain_url(self) -> pulumi.Output[_builtins.str]:
        """
        The IDCS Domain URL
        """
        return pulumi.get(self, "idcs_domain_url")

    @_builtins.property
    @pulumi.getter(name="isBreakGlassEnabled")
    def is_break_glass_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        If it's true, then the Break Glass feature is enabled
        """
        return pulumi.get(self, "is_break_glass_enabled")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) byok kms keyId
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter(name="kmsKeyInfos")
    def kms_key_infos(self) -> pulumi.Output[Sequence['outputs.FusionEnvironmentKmsKeyInfo']]:
        """
        BYOK key info
        """
        return pulumi.get(self, "kms_key_infos")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="lockboxId")
    def lockbox_id(self) -> pulumi.Output[_builtins.str]:
        """
        The lockbox Id of this fusion environment. If there's no lockbox id, this field will be null
        """
        return pulumi.get(self, "lockbox_id")

    @_builtins.property
    @pulumi.getter(name="maintenancePolicy")
    def maintenance_policy(self) -> pulumi.Output['outputs.FusionEnvironmentMaintenancePolicy']:
        """
        (Updatable) The policy that specifies the maintenance and upgrade preferences for an environment. For more information about the options, see [Understanding Environment Maintenance](https://docs.cloud.oracle.com/iaas/Content/fusion-applications/plan-environment-family.htm#about-env-maintenance).
        """
        return pulumi.get(self, "maintenance_policy")

    @_builtins.property
    @pulumi.getter(name="publicUrl")
    def public_url(self) -> pulumi.Output[_builtins.str]:
        """
        Public URL
        """
        return pulumi.get(self, "public_url")

    @_builtins.property
    @pulumi.getter
    def refreshes(self) -> pulumi.Output[Sequence['outputs.FusionEnvironmentRefresh']]:
        """
        Describes a refresh of a fusion environment
        """
        return pulumi.get(self, "refreshes")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Sequence['outputs.FusionEnvironmentRule']]:
        """
        (Updatable) Rules.
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the ServiceInstance.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="subscriptionIds")
    def subscription_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of subscription IDs.
        """
        return pulumi.get(self, "subscription_ids")

    @_builtins.property
    @pulumi.getter(name="systemName")
    def system_name(self) -> pulumi.Output[_builtins.str]:
        """
        Environment Specific Guid/ System Name
        """
        return pulumi.get(self, "system_name")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The time the the FusionEnvironment was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpcomingMaintenance")
    def time_upcoming_maintenance(self) -> pulumi.Output[_builtins.str]:
        """
        The next maintenance for this environment
        """
        return pulumi.get(self, "time_upcoming_maintenance")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The time the FusionEnvironment was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        Version of Fusion Apps used by this environment
        """
        return pulumi.get(self, "version")

