# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AgentToolArgs', 'AgentTool']

@pulumi.input_type
class AgentToolArgs:
    def __init__(__self__, *,
                 agent_id: pulumi.Input[_builtins.str],
                 compartment_id: pulumi.Input[_builtins.str],
                 description: pulumi.Input[_builtins.str],
                 tool_config: pulumi.Input['AgentToolToolConfigArgs'],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a AgentTool resource.
        :param pulumi.Input[_builtins.str] agent_id: The OCID of the agent that this Tool is attached to.
        :param pulumi.Input[_builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[_builtins.str] description: (Updatable) Description about the Tool.
        :param pulumi.Input['AgentToolToolConfigArgs'] tool_config: (Updatable) The configuration and type of Tool.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: (Updatable) Key-value pairs to allow additional configurations.
        """
        pulumi.set(__self__, "agent_id", agent_id)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "tool_config", tool_config)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the agent that this Tool is attached to.
        """
        return pulumi.get(self, "agent_id")

    @agent_id.setter
    def agent_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "agent_id", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Description about the Tool.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="toolConfig")
    def tool_config(self) -> pulumi.Input['AgentToolToolConfigArgs']:
        """
        (Updatable) The configuration and type of Tool.
        """
        return pulumi.get(self, "tool_config")

    @tool_config.setter
    def tool_config(self, value: pulumi.Input['AgentToolToolConfigArgs']):
        pulumi.set(self, "tool_config", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Key-value pairs to allow additional configurations.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)


@pulumi.input_type
class _AgentToolState:
    def __init__(__self__, *,
                 agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 tool_config: Optional[pulumi.Input['AgentToolToolConfigArgs']] = None):
        """
        Input properties used for looking up and filtering AgentTool resources.
        :param pulumi.Input[_builtins.str] agent_id: The OCID of the agent that this Tool is attached to.
        :param pulumi.Input[_builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) Description about the Tool.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: (Updatable) Key-value pairs to allow additional configurations.
        :param pulumi.Input[_builtins.str] state: The current state of the Tool.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The date and time the Tool was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_updated: The date and time the Tool was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input['AgentToolToolConfigArgs'] tool_config: (Updatable) The configuration and type of Tool.
        """
        if agent_id is not None:
            pulumi.set(__self__, "agent_id", agent_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if tool_config is not None:
            pulumi.set(__self__, "tool_config", tool_config)

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the agent that this Tool is attached to.
        """
        return pulumi.get(self, "agent_id")

    @agent_id.setter
    def agent_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_id", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Description about the Tool.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Key-value pairs to allow additional configurations.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the Tool.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the Tool was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the Tool was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @_builtins.property
    @pulumi.getter(name="toolConfig")
    def tool_config(self) -> Optional[pulumi.Input['AgentToolToolConfigArgs']]:
        """
        (Updatable) The configuration and type of Tool.
        """
        return pulumi.get(self, "tool_config")

    @tool_config.setter
    def tool_config(self, value: Optional[pulumi.Input['AgentToolToolConfigArgs']]):
        pulumi.set(self, "tool_config", value)


@pulumi.type_token("oci:GenerativeAi/agentTool:AgentTool")
class AgentTool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tool_config: Optional[pulumi.Input[Union['AgentToolToolConfigArgs', 'AgentToolToolConfigArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Tool resource in Oracle Cloud Infrastructure Generative Ai Agent service.

        Creates a tool.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_tool = oci.generativeai.AgentTool("test_tool",
            agent_id=test_agent["id"],
            compartment_id=compartment_id,
            description=tool_description,
            tool_config={
                "tool_config_type": tool_tool_config_tool_config_type,
                "agent_endpoint_id": test_agent_endpoint["id"],
                "api_schema": {
                    "api_schema_input_location_type": tool_tool_config_api_schema_api_schema_input_location_type,
                    "bucket": tool_tool_config_api_schema_bucket,
                    "content": tool_tool_config_api_schema_content,
                    "namespace": tool_tool_config_api_schema_namespace,
                    "object": tool_tool_config_api_schema_object,
                },
                "database_connection": {
                    "connection_id": test_connection["id"],
                    "connection_type": tool_tool_config_database_connection_connection_type,
                },
                "database_schema": {
                    "input_location_type": tool_tool_config_database_schema_input_location_type,
                    "bucket": tool_tool_config_database_schema_bucket,
                    "content": tool_tool_config_database_schema_content,
                    "namespace": tool_tool_config_database_schema_namespace,
                    "prefix": tool_tool_config_database_schema_prefix,
                },
                "dialect": tool_tool_config_dialect,
                "function": {
                    "description": tool_tool_config_function_description,
                    "name": tool_tool_config_function_name,
                    "parameters": tool_tool_config_function_parameters,
                },
                "generation_llm_customization": {
                    "instruction": tool_tool_config_generation_llm_customization_instruction,
                },
                "http_endpoint_auth_config": {
                    "http_endpoint_auth_sources": [{
                        "http_endpoint_auth_scope": tool_tool_config_http_endpoint_auth_config_http_endpoint_auth_sources_http_endpoint_auth_scope,
                        "http_endpoint_auth_scope_config": {
                            "http_endpoint_auth_scope_config_type": tool_tool_config_http_endpoint_auth_config_http_endpoint_auth_sources_http_endpoint_auth_scope_config_http_endpoint_auth_scope_config_type,
                            "client_id": test_client["id"],
                            "idcs_url": tool_tool_config_http_endpoint_auth_config_http_endpoint_auth_sources_http_endpoint_auth_scope_config_idcs_url,
                            "key_location": tool_tool_config_http_endpoint_auth_config_http_endpoint_auth_sources_http_endpoint_auth_scope_config_key_location,
                            "key_name": test_key["name"],
                            "scope_url": tool_tool_config_http_endpoint_auth_config_http_endpoint_auth_sources_http_endpoint_auth_scope_config_scope_url,
                            "vault_secret_id": test_secret["id"],
                        },
                    }],
                },
                "icl_examples": {
                    "input_location_type": tool_tool_config_icl_examples_input_location_type,
                    "bucket": tool_tool_config_icl_examples_bucket,
                    "content": tool_tool_config_icl_examples_content,
                    "namespace": tool_tool_config_icl_examples_namespace,
                    "prefix": tool_tool_config_icl_examples_prefix,
                },
                "knowledge_base_configs": [{
                    "knowledge_base_id": test_knowledge_base["id"],
                }],
                "model_size": tool_tool_config_model_size,
                "should_enable_self_correction": tool_tool_config_should_enable_self_correction,
                "should_enable_sql_execution": tool_tool_config_should_enable_sql_execution,
                "subnet_id": test_subnet["id"],
                "table_and_column_description": {
                    "input_location_type": tool_tool_config_table_and_column_description_input_location_type,
                    "bucket": tool_tool_config_table_and_column_description_bucket,
                    "content": tool_tool_config_table_and_column_description_content,
                    "namespace": tool_tool_config_table_and_column_description_namespace,
                    "prefix": tool_tool_config_table_and_column_description_prefix,
                },
            },
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=tool_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            metadata=tool_metadata)
        ```

        ## Import

        Tools can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:GenerativeAi/agentTool:AgentTool test_tool "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] agent_id: The OCID of the agent that this Tool is attached to.
        :param pulumi.Input[_builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) Description about the Tool.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: (Updatable) Key-value pairs to allow additional configurations.
        :param pulumi.Input[Union['AgentToolToolConfigArgs', 'AgentToolToolConfigArgsDict']] tool_config: (Updatable) The configuration and type of Tool.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AgentToolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Tool resource in Oracle Cloud Infrastructure Generative Ai Agent service.

        Creates a tool.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_tool = oci.generativeai.AgentTool("test_tool",
            agent_id=test_agent["id"],
            compartment_id=compartment_id,
            description=tool_description,
            tool_config={
                "tool_config_type": tool_tool_config_tool_config_type,
                "agent_endpoint_id": test_agent_endpoint["id"],
                "api_schema": {
                    "api_schema_input_location_type": tool_tool_config_api_schema_api_schema_input_location_type,
                    "bucket": tool_tool_config_api_schema_bucket,
                    "content": tool_tool_config_api_schema_content,
                    "namespace": tool_tool_config_api_schema_namespace,
                    "object": tool_tool_config_api_schema_object,
                },
                "database_connection": {
                    "connection_id": test_connection["id"],
                    "connection_type": tool_tool_config_database_connection_connection_type,
                },
                "database_schema": {
                    "input_location_type": tool_tool_config_database_schema_input_location_type,
                    "bucket": tool_tool_config_database_schema_bucket,
                    "content": tool_tool_config_database_schema_content,
                    "namespace": tool_tool_config_database_schema_namespace,
                    "prefix": tool_tool_config_database_schema_prefix,
                },
                "dialect": tool_tool_config_dialect,
                "function": {
                    "description": tool_tool_config_function_description,
                    "name": tool_tool_config_function_name,
                    "parameters": tool_tool_config_function_parameters,
                },
                "generation_llm_customization": {
                    "instruction": tool_tool_config_generation_llm_customization_instruction,
                },
                "http_endpoint_auth_config": {
                    "http_endpoint_auth_sources": [{
                        "http_endpoint_auth_scope": tool_tool_config_http_endpoint_auth_config_http_endpoint_auth_sources_http_endpoint_auth_scope,
                        "http_endpoint_auth_scope_config": {
                            "http_endpoint_auth_scope_config_type": tool_tool_config_http_endpoint_auth_config_http_endpoint_auth_sources_http_endpoint_auth_scope_config_http_endpoint_auth_scope_config_type,
                            "client_id": test_client["id"],
                            "idcs_url": tool_tool_config_http_endpoint_auth_config_http_endpoint_auth_sources_http_endpoint_auth_scope_config_idcs_url,
                            "key_location": tool_tool_config_http_endpoint_auth_config_http_endpoint_auth_sources_http_endpoint_auth_scope_config_key_location,
                            "key_name": test_key["name"],
                            "scope_url": tool_tool_config_http_endpoint_auth_config_http_endpoint_auth_sources_http_endpoint_auth_scope_config_scope_url,
                            "vault_secret_id": test_secret["id"],
                        },
                    }],
                },
                "icl_examples": {
                    "input_location_type": tool_tool_config_icl_examples_input_location_type,
                    "bucket": tool_tool_config_icl_examples_bucket,
                    "content": tool_tool_config_icl_examples_content,
                    "namespace": tool_tool_config_icl_examples_namespace,
                    "prefix": tool_tool_config_icl_examples_prefix,
                },
                "knowledge_base_configs": [{
                    "knowledge_base_id": test_knowledge_base["id"],
                }],
                "model_size": tool_tool_config_model_size,
                "should_enable_self_correction": tool_tool_config_should_enable_self_correction,
                "should_enable_sql_execution": tool_tool_config_should_enable_sql_execution,
                "subnet_id": test_subnet["id"],
                "table_and_column_description": {
                    "input_location_type": tool_tool_config_table_and_column_description_input_location_type,
                    "bucket": tool_tool_config_table_and_column_description_bucket,
                    "content": tool_tool_config_table_and_column_description_content,
                    "namespace": tool_tool_config_table_and_column_description_namespace,
                    "prefix": tool_tool_config_table_and_column_description_prefix,
                },
            },
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=tool_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            metadata=tool_metadata)
        ```

        ## Import

        Tools can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:GenerativeAi/agentTool:AgentTool test_tool "id"
        ```

        :param str resource_name: The name of the resource.
        :param AgentToolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AgentToolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tool_config: Optional[pulumi.Input[Union['AgentToolToolConfigArgs', 'AgentToolToolConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AgentToolArgs.__new__(AgentToolArgs)

            if agent_id is None and not opts.urn:
                raise TypeError("Missing required property 'agent_id'")
            __props__.__dict__["agent_id"] = agent_id
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["metadata"] = metadata
            if tool_config is None and not opts.urn:
                raise TypeError("Missing required property 'tool_config'")
            __props__.__dict__["tool_config"] = tool_config
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(AgentTool, __self__).__init__(
            'oci:GenerativeAi/agentTool:AgentTool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_id: Optional[pulumi.Input[_builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None,
            tool_config: Optional[pulumi.Input[Union['AgentToolToolConfigArgs', 'AgentToolToolConfigArgsDict']]] = None) -> 'AgentTool':
        """
        Get an existing AgentTool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] agent_id: The OCID of the agent that this Tool is attached to.
        :param pulumi.Input[_builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) Description about the Tool.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: (Updatable) Key-value pairs to allow additional configurations.
        :param pulumi.Input[_builtins.str] state: The current state of the Tool.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The date and time the Tool was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_updated: The date and time the Tool was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[Union['AgentToolToolConfigArgs', 'AgentToolToolConfigArgsDict']] tool_config: (Updatable) The configuration and type of Tool.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AgentToolState.__new__(_AgentToolState)

        __props__.__dict__["agent_id"] = agent_id
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["tool_config"] = tool_config
        return AgentTool(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the agent that this Tool is attached to.
        """
        return pulumi.get(self, "agent_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Description about the Tool.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Key-value pairs to allow additional configurations.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the Tool.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the Tool was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the Tool was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="toolConfig")
    def tool_config(self) -> pulumi.Output['outputs.AgentToolToolConfig']:
        """
        (Updatable) The configuration and type of Tool.
        """
        return pulumi.get(self, "tool_config")

