# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAgentToolsResult',
    'AwaitableGetAgentToolsResult',
    'get_agent_tools',
    'get_agent_tools_output',
]

@pulumi.output_type
class GetAgentToolsResult:
    """
    A collection of values returned by getAgentTools.
    """
    def __init__(__self__, agent_id=None, compartment_id=None, display_name=None, filters=None, id=None, state=None, tool_collections=None):
        if agent_id and not isinstance(agent_id, str):
            raise TypeError("Expected argument 'agent_id' to be a str")
        pulumi.set(__self__, "agent_id", agent_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if tool_collections and not isinstance(tool_collections, list):
            raise TypeError("Expected argument 'tool_collections' to be a list")
        pulumi.set(__self__, "tool_collections", tool_collections)

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the agent that this Tool is attached to.
        """
        return pulumi.get(self, "agent_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAgentToolsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the Tool.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="toolCollections")
    def tool_collections(self) -> Sequence['outputs.GetAgentToolsToolCollectionResult']:
        """
        The list of tool_collection.
        """
        return pulumi.get(self, "tool_collections")


class AwaitableGetAgentToolsResult(GetAgentToolsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAgentToolsResult(
            agent_id=self.agent_id,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state,
            tool_collections=self.tool_collections)


def get_agent_tools(agent_id: Optional[_builtins.str] = None,
                    compartment_id: Optional[_builtins.str] = None,
                    display_name: Optional[_builtins.str] = None,
                    filters: Optional[Sequence[Union['GetAgentToolsFilterArgs', 'GetAgentToolsFilterArgsDict']]] = None,
                    state: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAgentToolsResult:
    """
    This data source provides the list of Tools in Oracle Cloud Infrastructure Generative Ai Agent service.

    Gets a list of tools.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_tools = oci.GenerativeAi.get_agent_tools(agent_id=test_agent["id"],
        compartment_id=compartment_id,
        display_name=tool_display_name,
        state=tool_state)
    ```


    :param _builtins.str agent_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the agent.
    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param _builtins.str display_name: A filter to return only resources that match the given display name exactly.
    :param _builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['agentId'] = agent_id
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:GenerativeAi/getAgentTools:getAgentTools', __args__, opts=opts, typ=GetAgentToolsResult).value

    return AwaitableGetAgentToolsResult(
        agent_id=pulumi.get(__ret__, 'agent_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        tool_collections=pulumi.get(__ret__, 'tool_collections'))
def get_agent_tools_output(agent_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAgentToolsFilterArgs', 'GetAgentToolsFilterArgsDict']]]]] = None,
                           state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAgentToolsResult]:
    """
    This data source provides the list of Tools in Oracle Cloud Infrastructure Generative Ai Agent service.

    Gets a list of tools.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_tools = oci.GenerativeAi.get_agent_tools(agent_id=test_agent["id"],
        compartment_id=compartment_id,
        display_name=tool_display_name,
        state=tool_state)
    ```


    :param _builtins.str agent_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the agent.
    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param _builtins.str display_name: A filter to return only resources that match the given display name exactly.
    :param _builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['agentId'] = agent_id
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:GenerativeAi/getAgentTools:getAgentTools', __args__, opts=opts, typ=GetAgentToolsResult)
    return __ret__.apply(lambda __response__: GetAgentToolsResult(
        agent_id=pulumi.get(__response__, 'agent_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state'),
        tool_collections=pulumi.get(__response__, 'tool_collections')))
