# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetConnectionAssignmentResult',
    'AwaitableGetConnectionAssignmentResult',
    'get_connection_assignment',
    'get_connection_assignment_output',
]

@pulumi.output_type
class GetConnectionAssignmentResult:
    """
    A collection of values returned by getConnectionAssignment.
    """
    def __init__(__self__, alias_name=None, compartment_id=None, connection_assignment_id=None, connection_id=None, deployment_id=None, id=None, is_lock_override=None, state=None, time_created=None, time_updated=None):
        if alias_name and not isinstance(alias_name, str):
            raise TypeError("Expected argument 'alias_name' to be a str")
        pulumi.set(__self__, "alias_name", alias_name)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if connection_assignment_id and not isinstance(connection_assignment_id, str):
            raise TypeError("Expected argument 'connection_assignment_id' to be a str")
        pulumi.set(__self__, "connection_assignment_id", connection_assignment_id)
        if connection_id and not isinstance(connection_id, str):
            raise TypeError("Expected argument 'connection_id' to be a str")
        pulumi.set(__self__, "connection_id", connection_id)
        if deployment_id and not isinstance(deployment_id, str):
            raise TypeError("Expected argument 'deployment_id' to be a str")
        pulumi.set(__self__, "deployment_id", deployment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_lock_override and not isinstance(is_lock_override, bool):
            raise TypeError("Expected argument 'is_lock_override' to be a bool")
        pulumi.set(__self__, "is_lock_override", is_lock_override)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="aliasName")
    def alias_name(self) -> _builtins.str:
        """
        Credential store alias.
        """
        return pulumi.get(self, "alias_name")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment being referenced.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="connectionAssignmentId")
    def connection_assignment_id(self) -> _builtins.str:
        return pulumi.get(self, "connection_assignment_id")

    @_builtins.property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the connection being referenced.
        """
        return pulumi.get(self, "connection_id")

    @_builtins.property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deployment being referenced.
        """
        return pulumi.get(self, "deployment_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the connection assignment being referenced.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isLockOverride")
    def is_lock_override(self) -> _builtins.bool:
        return pulumi.get(self, "is_lock_override")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        Possible lifecycle states for connection assignments.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time the resource was created. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time the resource was last updated. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetConnectionAssignmentResult(GetConnectionAssignmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConnectionAssignmentResult(
            alias_name=self.alias_name,
            compartment_id=self.compartment_id,
            connection_assignment_id=self.connection_assignment_id,
            connection_id=self.connection_id,
            deployment_id=self.deployment_id,
            id=self.id,
            is_lock_override=self.is_lock_override,
            state=self.state,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_connection_assignment(connection_assignment_id: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConnectionAssignmentResult:
    """
    This data source provides details about a specific Connection Assignment resource in Oracle Cloud Infrastructure Golden Gate service.

    Retrieves a Connection Assignment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_connection_assignment = oci.GoldenGate.get_connection_assignment(connection_assignment_id=test_connection_assignment_oci_golden_gate_connection_assignment["id"])
    ```


    :param _builtins.str connection_assignment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Connection Assignment.
    """
    __args__ = dict()
    __args__['connectionAssignmentId'] = connection_assignment_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:GoldenGate/getConnectionAssignment:getConnectionAssignment', __args__, opts=opts, typ=GetConnectionAssignmentResult).value

    return AwaitableGetConnectionAssignmentResult(
        alias_name=pulumi.get(__ret__, 'alias_name'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        connection_assignment_id=pulumi.get(__ret__, 'connection_assignment_id'),
        connection_id=pulumi.get(__ret__, 'connection_id'),
        deployment_id=pulumi.get(__ret__, 'deployment_id'),
        id=pulumi.get(__ret__, 'id'),
        is_lock_override=pulumi.get(__ret__, 'is_lock_override'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_connection_assignment_output(connection_assignment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetConnectionAssignmentResult]:
    """
    This data source provides details about a specific Connection Assignment resource in Oracle Cloud Infrastructure Golden Gate service.

    Retrieves a Connection Assignment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_connection_assignment = oci.GoldenGate.get_connection_assignment(connection_assignment_id=test_connection_assignment_oci_golden_gate_connection_assignment["id"])
    ```


    :param _builtins.str connection_assignment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Connection Assignment.
    """
    __args__ = dict()
    __args__['connectionAssignmentId'] = connection_assignment_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:GoldenGate/getConnectionAssignment:getConnectionAssignment', __args__, opts=opts, typ=GetConnectionAssignmentResult)
    return __ret__.apply(lambda __response__: GetConnectionAssignmentResult(
        alias_name=pulumi.get(__response__, 'alias_name'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        connection_assignment_id=pulumi.get(__response__, 'connection_assignment_id'),
        connection_id=pulumi.get(__response__, 'connection_id'),
        deployment_id=pulumi.get(__response__, 'deployment_id'),
        id=pulumi.get(__response__, 'id'),
        is_lock_override=pulumi.get(__response__, 'is_lock_override'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
