# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFleetContainersResult',
    'AwaitableGetFleetContainersResult',
    'get_fleet_containers',
    'get_fleet_containers_output',
]

@pulumi.output_type
class GetFleetContainersResult:
    """
    A collection of values returned by getFleetContainers.
    """
    def __init__(__self__, application_name=None, container_collections=None, display_name=None, filters=None, fleet_id=None, id=None, jre_security_status=None, jre_version=None, managed_instance_id=None, time_started_greater_than_or_equal_to=None, time_started_less_than_or_equal_to=None):
        if application_name and not isinstance(application_name, str):
            raise TypeError("Expected argument 'application_name' to be a str")
        pulumi.set(__self__, "application_name", application_name)
        if container_collections and not isinstance(container_collections, list):
            raise TypeError("Expected argument 'container_collections' to be a list")
        pulumi.set(__self__, "container_collections", container_collections)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if fleet_id and not isinstance(fleet_id, str):
            raise TypeError("Expected argument 'fleet_id' to be a str")
        pulumi.set(__self__, "fleet_id", fleet_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if jre_security_status and not isinstance(jre_security_status, str):
            raise TypeError("Expected argument 'jre_security_status' to be a str")
        pulumi.set(__self__, "jre_security_status", jre_security_status)
        if jre_version and not isinstance(jre_version, str):
            raise TypeError("Expected argument 'jre_version' to be a str")
        pulumi.set(__self__, "jre_version", jre_version)
        if managed_instance_id and not isinstance(managed_instance_id, str):
            raise TypeError("Expected argument 'managed_instance_id' to be a str")
        pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if time_started_greater_than_or_equal_to and not isinstance(time_started_greater_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_started_greater_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_started_greater_than_or_equal_to", time_started_greater_than_or_equal_to)
        if time_started_less_than_or_equal_to and not isinstance(time_started_less_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_started_less_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_started_less_than_or_equal_to", time_started_less_than_or_equal_to)

    @_builtins.property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> Optional[_builtins.str]:
        """
        The name of the application running in the container.
        """
        return pulumi.get(self, "application_name")

    @_builtins.property
    @pulumi.getter(name="containerCollections")
    def container_collections(self) -> Sequence['outputs.GetFleetContainersContainerCollectionResult']:
        """
        The list of container_collection.
        """
        return pulumi.get(self, "container_collections")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        The name of the container.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetFleetContainersFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> _builtins.str:
        return pulumi.get(self, "fleet_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="jreSecurityStatus")
    def jre_security_status(self) -> Optional[_builtins.str]:
        """
        The security status of the Java runtime used to run the application in the container.
        """
        return pulumi.get(self, "jre_security_status")

    @_builtins.property
    @pulumi.getter(name="jreVersion")
    def jre_version(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "jre_version")

    @_builtins.property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated managed instance of type OCMA.
        """
        return pulumi.get(self, "managed_instance_id")

    @_builtins.property
    @pulumi.getter(name="timeStartedGreaterThanOrEqualTo")
    def time_started_greater_than_or_equal_to(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "time_started_greater_than_or_equal_to")

    @_builtins.property
    @pulumi.getter(name="timeStartedLessThanOrEqualTo")
    def time_started_less_than_or_equal_to(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "time_started_less_than_or_equal_to")


class AwaitableGetFleetContainersResult(GetFleetContainersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFleetContainersResult(
            application_name=self.application_name,
            container_collections=self.container_collections,
            display_name=self.display_name,
            filters=self.filters,
            fleet_id=self.fleet_id,
            id=self.id,
            jre_security_status=self.jre_security_status,
            jre_version=self.jre_version,
            managed_instance_id=self.managed_instance_id,
            time_started_greater_than_or_equal_to=self.time_started_greater_than_or_equal_to,
            time_started_less_than_or_equal_to=self.time_started_less_than_or_equal_to)


def get_fleet_containers(application_name: Optional[_builtins.str] = None,
                         display_name: Optional[_builtins.str] = None,
                         filters: Optional[Sequence[Union['GetFleetContainersFilterArgs', 'GetFleetContainersFilterArgsDict']]] = None,
                         fleet_id: Optional[_builtins.str] = None,
                         jre_security_status: Optional[_builtins.str] = None,
                         jre_version: Optional[_builtins.str] = None,
                         managed_instance_id: Optional[_builtins.str] = None,
                         time_started_greater_than_or_equal_to: Optional[_builtins.str] = None,
                         time_started_less_than_or_equal_to: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFleetContainersResult:
    """
    This data source provides the list of Fleet Containers in Oracle Cloud Infrastructure Jms service.

    List containers in a fleet filtered by query parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_containers = oci.Jms.get_fleet_containers(fleet_id=test_fleet["id"],
        application_name=test_application["name"],
        display_name=fleet_container_display_name,
        jre_security_status=fleet_container_jre_security_status,
        jre_version=fleet_container_jre_version,
        managed_instance_id=test_managed_instance["id"],
        time_started_greater_than_or_equal_to=fleet_container_time_started_greater_than_or_equal_to,
        time_started_less_than_or_equal_to=fleet_container_time_started_less_than_or_equal_to)
    ```


    :param _builtins.str application_name: The name of the application.
    :param _builtins.str display_name: The display name.
    :param _builtins.str fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
    :param _builtins.str jre_security_status: The security status of the Java Runtime.
    :param _builtins.str jre_version: The version of the related Java Runtime.
    :param _builtins.str managed_instance_id: The Fleet-unique identifier of the managed instance.
    :param _builtins.str time_started_greater_than_or_equal_to: If specified, only containers with a start time later than or equal to this parameter will be included in the response (formatted according to RFC3339).
    :param _builtins.str time_started_less_than_or_equal_to: If specified, only containers with a start time earlier than or equal to this parameter will be included in the response (formatted according to RFC3339).
    """
    __args__ = dict()
    __args__['applicationName'] = application_name
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    __args__['jreSecurityStatus'] = jre_security_status
    __args__['jreVersion'] = jre_version
    __args__['managedInstanceId'] = managed_instance_id
    __args__['timeStartedGreaterThanOrEqualTo'] = time_started_greater_than_or_equal_to
    __args__['timeStartedLessThanOrEqualTo'] = time_started_less_than_or_equal_to
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getFleetContainers:getFleetContainers', __args__, opts=opts, typ=GetFleetContainersResult).value

    return AwaitableGetFleetContainersResult(
        application_name=pulumi.get(__ret__, 'application_name'),
        container_collections=pulumi.get(__ret__, 'container_collections'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        fleet_id=pulumi.get(__ret__, 'fleet_id'),
        id=pulumi.get(__ret__, 'id'),
        jre_security_status=pulumi.get(__ret__, 'jre_security_status'),
        jre_version=pulumi.get(__ret__, 'jre_version'),
        managed_instance_id=pulumi.get(__ret__, 'managed_instance_id'),
        time_started_greater_than_or_equal_to=pulumi.get(__ret__, 'time_started_greater_than_or_equal_to'),
        time_started_less_than_or_equal_to=pulumi.get(__ret__, 'time_started_less_than_or_equal_to'))
def get_fleet_containers_output(application_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                filters: Optional[pulumi.Input[Optional[Sequence[Union['GetFleetContainersFilterArgs', 'GetFleetContainersFilterArgsDict']]]]] = None,
                                fleet_id: Optional[pulumi.Input[_builtins.str]] = None,
                                jre_security_status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                jre_version: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                managed_instance_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                time_started_greater_than_or_equal_to: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                time_started_less_than_or_equal_to: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFleetContainersResult]:
    """
    This data source provides the list of Fleet Containers in Oracle Cloud Infrastructure Jms service.

    List containers in a fleet filtered by query parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_containers = oci.Jms.get_fleet_containers(fleet_id=test_fleet["id"],
        application_name=test_application["name"],
        display_name=fleet_container_display_name,
        jre_security_status=fleet_container_jre_security_status,
        jre_version=fleet_container_jre_version,
        managed_instance_id=test_managed_instance["id"],
        time_started_greater_than_or_equal_to=fleet_container_time_started_greater_than_or_equal_to,
        time_started_less_than_or_equal_to=fleet_container_time_started_less_than_or_equal_to)
    ```


    :param _builtins.str application_name: The name of the application.
    :param _builtins.str display_name: The display name.
    :param _builtins.str fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
    :param _builtins.str jre_security_status: The security status of the Java Runtime.
    :param _builtins.str jre_version: The version of the related Java Runtime.
    :param _builtins.str managed_instance_id: The Fleet-unique identifier of the managed instance.
    :param _builtins.str time_started_greater_than_or_equal_to: If specified, only containers with a start time later than or equal to this parameter will be included in the response (formatted according to RFC3339).
    :param _builtins.str time_started_less_than_or_equal_to: If specified, only containers with a start time earlier than or equal to this parameter will be included in the response (formatted according to RFC3339).
    """
    __args__ = dict()
    __args__['applicationName'] = application_name
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    __args__['jreSecurityStatus'] = jre_security_status
    __args__['jreVersion'] = jre_version
    __args__['managedInstanceId'] = managed_instance_id
    __args__['timeStartedGreaterThanOrEqualTo'] = time_started_greater_than_or_equal_to
    __args__['timeStartedLessThanOrEqualTo'] = time_started_less_than_or_equal_to
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Jms/getFleetContainers:getFleetContainers', __args__, opts=opts, typ=GetFleetContainersResult)
    return __ret__.apply(lambda __response__: GetFleetContainersResult(
        application_name=pulumi.get(__response__, 'application_name'),
        container_collections=pulumi.get(__response__, 'container_collections'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        fleet_id=pulumi.get(__response__, 'fleet_id'),
        id=pulumi.get(__response__, 'id'),
        jre_security_status=pulumi.get(__response__, 'jre_security_status'),
        jre_version=pulumi.get(__response__, 'jre_version'),
        managed_instance_id=pulumi.get(__response__, 'managed_instance_id'),
        time_started_greater_than_or_equal_to=pulumi.get(__response__, 'time_started_greater_than_or_equal_to'),
        time_started_less_than_or_equal_to=pulumi.get(__response__, 'time_started_less_than_or_equal_to')))
