# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFleetLibraryApplicationsResult',
    'AwaitableGetFleetLibraryApplicationsResult',
    'get_fleet_library_applications',
    'get_fleet_library_applications_output',
]

@pulumi.output_type
class GetFleetLibraryApplicationsResult:
    """
    A collection of values returned by getFleetLibraryApplications.
    """
    def __init__(__self__, application_id=None, application_name=None, application_name_contains=None, filters=None, fleet_id=None, id=None, library_application_usage_collections=None, library_key=None, managed_instance_id=None, time_end=None, time_start=None):
        if application_id and not isinstance(application_id, str):
            raise TypeError("Expected argument 'application_id' to be a str")
        pulumi.set(__self__, "application_id", application_id)
        if application_name and not isinstance(application_name, str):
            raise TypeError("Expected argument 'application_name' to be a str")
        pulumi.set(__self__, "application_name", application_name)
        if application_name_contains and not isinstance(application_name_contains, str):
            raise TypeError("Expected argument 'application_name_contains' to be a str")
        pulumi.set(__self__, "application_name_contains", application_name_contains)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if fleet_id and not isinstance(fleet_id, str):
            raise TypeError("Expected argument 'fleet_id' to be a str")
        pulumi.set(__self__, "fleet_id", fleet_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if library_application_usage_collections and not isinstance(library_application_usage_collections, list):
            raise TypeError("Expected argument 'library_application_usage_collections' to be a list")
        pulumi.set(__self__, "library_application_usage_collections", library_application_usage_collections)
        if library_key and not isinstance(library_key, str):
            raise TypeError("Expected argument 'library_key' to be a str")
        pulumi.set(__self__, "library_key", library_key)
        if managed_instance_id and not isinstance(managed_instance_id, str):
            raise TypeError("Expected argument 'managed_instance_id' to be a str")
        pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if time_end and not isinstance(time_end, str):
            raise TypeError("Expected argument 'time_end' to be a str")
        pulumi.set(__self__, "time_end", time_end)
        if time_start and not isinstance(time_start, str):
            raise TypeError("Expected argument 'time_start' to be a str")
        pulumi.set(__self__, "time_start", time_start)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "application_id")

    @_builtins.property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> Optional[_builtins.str]:
        """
        The displayed name of the Java application.
        """
        return pulumi.get(self, "application_name")

    @_builtins.property
    @pulumi.getter(name="applicationNameContains")
    def application_name_contains(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "application_name_contains")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetFleetLibraryApplicationsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> _builtins.str:
        return pulumi.get(self, "fleet_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="libraryApplicationUsageCollections")
    def library_application_usage_collections(self) -> Sequence['outputs.GetFleetLibraryApplicationsLibraryApplicationUsageCollectionResult']:
        """
        The list of library_application_usage_collection.
        """
        return pulumi.get(self, "library_application_usage_collections")

    @_builtins.property
    @pulumi.getter(name="libraryKey")
    def library_key(self) -> _builtins.str:
        return pulumi.get(self, "library_key")

    @_builtins.property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "managed_instance_id")

    @_builtins.property
    @pulumi.getter(name="timeEnd")
    def time_end(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "time_end")

    @_builtins.property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "time_start")


class AwaitableGetFleetLibraryApplicationsResult(GetFleetLibraryApplicationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFleetLibraryApplicationsResult(
            application_id=self.application_id,
            application_name=self.application_name,
            application_name_contains=self.application_name_contains,
            filters=self.filters,
            fleet_id=self.fleet_id,
            id=self.id,
            library_application_usage_collections=self.library_application_usage_collections,
            library_key=self.library_key,
            managed_instance_id=self.managed_instance_id,
            time_end=self.time_end,
            time_start=self.time_start)


def get_fleet_library_applications(application_id: Optional[_builtins.str] = None,
                                   application_name: Optional[_builtins.str] = None,
                                   application_name_contains: Optional[_builtins.str] = None,
                                   filters: Optional[Sequence[Union['GetFleetLibraryApplicationsFilterArgs', 'GetFleetLibraryApplicationsFilterArgsDict']]] = None,
                                   fleet_id: Optional[_builtins.str] = None,
                                   library_key: Optional[_builtins.str] = None,
                                   managed_instance_id: Optional[_builtins.str] = None,
                                   time_end: Optional[_builtins.str] = None,
                                   time_start: Optional[_builtins.str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFleetLibraryApplicationsResult:
    """
    This data source provides the list of Fleet Library Applications in Oracle Cloud Infrastructure Jms service.

    List applications where a library has been detected filtered by query parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_library_applications = oci.Jms.get_fleet_library_applications(fleet_id=test_fleet["id"],
        library_key=fleet_library_application_library_key,
        application_id=test_application["id"],
        application_name=test_application["name"],
        application_name_contains=fleet_library_application_application_name_contains,
        managed_instance_id=test_managed_instance["id"],
        time_end=fleet_library_application_time_end,
        time_start=fleet_library_application_time_start)
    ```


    :param _builtins.str application_id: The Fleet-unique identifier of the application.
    :param _builtins.str application_name: The name of the application.
    :param _builtins.str application_name_contains: Filter the list with application name contains the given value.
    :param _builtins.str fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
    :param _builtins.str library_key: The unique identifier of a Java library.
    :param _builtins.str managed_instance_id: The Fleet-unique identifier of the managed instance.
    :param _builtins.str time_end: The end of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    :param _builtins.str time_start: The start of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    """
    __args__ = dict()
    __args__['applicationId'] = application_id
    __args__['applicationName'] = application_name
    __args__['applicationNameContains'] = application_name_contains
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    __args__['libraryKey'] = library_key
    __args__['managedInstanceId'] = managed_instance_id
    __args__['timeEnd'] = time_end
    __args__['timeStart'] = time_start
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getFleetLibraryApplications:getFleetLibraryApplications', __args__, opts=opts, typ=GetFleetLibraryApplicationsResult).value

    return AwaitableGetFleetLibraryApplicationsResult(
        application_id=pulumi.get(__ret__, 'application_id'),
        application_name=pulumi.get(__ret__, 'application_name'),
        application_name_contains=pulumi.get(__ret__, 'application_name_contains'),
        filters=pulumi.get(__ret__, 'filters'),
        fleet_id=pulumi.get(__ret__, 'fleet_id'),
        id=pulumi.get(__ret__, 'id'),
        library_application_usage_collections=pulumi.get(__ret__, 'library_application_usage_collections'),
        library_key=pulumi.get(__ret__, 'library_key'),
        managed_instance_id=pulumi.get(__ret__, 'managed_instance_id'),
        time_end=pulumi.get(__ret__, 'time_end'),
        time_start=pulumi.get(__ret__, 'time_start'))
def get_fleet_library_applications_output(application_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          application_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          application_name_contains: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          filters: Optional[pulumi.Input[Optional[Sequence[Union['GetFleetLibraryApplicationsFilterArgs', 'GetFleetLibraryApplicationsFilterArgsDict']]]]] = None,
                                          fleet_id: Optional[pulumi.Input[_builtins.str]] = None,
                                          library_key: Optional[pulumi.Input[_builtins.str]] = None,
                                          managed_instance_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          time_end: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          time_start: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFleetLibraryApplicationsResult]:
    """
    This data source provides the list of Fleet Library Applications in Oracle Cloud Infrastructure Jms service.

    List applications where a library has been detected filtered by query parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_library_applications = oci.Jms.get_fleet_library_applications(fleet_id=test_fleet["id"],
        library_key=fleet_library_application_library_key,
        application_id=test_application["id"],
        application_name=test_application["name"],
        application_name_contains=fleet_library_application_application_name_contains,
        managed_instance_id=test_managed_instance["id"],
        time_end=fleet_library_application_time_end,
        time_start=fleet_library_application_time_start)
    ```


    :param _builtins.str application_id: The Fleet-unique identifier of the application.
    :param _builtins.str application_name: The name of the application.
    :param _builtins.str application_name_contains: Filter the list with application name contains the given value.
    :param _builtins.str fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
    :param _builtins.str library_key: The unique identifier of a Java library.
    :param _builtins.str managed_instance_id: The Fleet-unique identifier of the managed instance.
    :param _builtins.str time_end: The end of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    :param _builtins.str time_start: The start of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    """
    __args__ = dict()
    __args__['applicationId'] = application_id
    __args__['applicationName'] = application_name
    __args__['applicationNameContains'] = application_name_contains
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    __args__['libraryKey'] = library_key
    __args__['managedInstanceId'] = managed_instance_id
    __args__['timeEnd'] = time_end
    __args__['timeStart'] = time_start
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Jms/getFleetLibraryApplications:getFleetLibraryApplications', __args__, opts=opts, typ=GetFleetLibraryApplicationsResult)
    return __ret__.apply(lambda __response__: GetFleetLibraryApplicationsResult(
        application_id=pulumi.get(__response__, 'application_id'),
        application_name=pulumi.get(__response__, 'application_name'),
        application_name_contains=pulumi.get(__response__, 'application_name_contains'),
        filters=pulumi.get(__response__, 'filters'),
        fleet_id=pulumi.get(__response__, 'fleet_id'),
        id=pulumi.get(__response__, 'id'),
        library_application_usage_collections=pulumi.get(__response__, 'library_application_usage_collections'),
        library_key=pulumi.get(__response__, 'library_key'),
        managed_instance_id=pulumi.get(__response__, 'managed_instance_id'),
        time_end=pulumi.get(__response__, 'time_end'),
        time_start=pulumi.get(__response__, 'time_start')))
