# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetTaskScheduleResult',
    'AwaitableGetTaskScheduleResult',
    'get_task_schedule',
    'get_task_schedule_output',
]

@pulumi.output_type
class GetTaskScheduleResult:
    """
    A collection of values returned by getTaskSchedule.
    """
    def __init__(__self__, created_by=None, execution_recurrences=None, fleet_id=None, id=None, name=None, state=None, task_details=None, task_schedule_id=None, time_created=None, time_last_run=None, time_last_updated=None, time_next_run=None):
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if execution_recurrences and not isinstance(execution_recurrences, str):
            raise TypeError("Expected argument 'execution_recurrences' to be a str")
        pulumi.set(__self__, "execution_recurrences", execution_recurrences)
        if fleet_id and not isinstance(fleet_id, str):
            raise TypeError("Expected argument 'fleet_id' to be a str")
        pulumi.set(__self__, "fleet_id", fleet_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if task_details and not isinstance(task_details, list):
            raise TypeError("Expected argument 'task_details' to be a list")
        pulumi.set(__self__, "task_details", task_details)
        if task_schedule_id and not isinstance(task_schedule_id, str):
            raise TypeError("Expected argument 'task_schedule_id' to be a str")
        pulumi.set(__self__, "task_schedule_id", task_schedule_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_last_run and not isinstance(time_last_run, str):
            raise TypeError("Expected argument 'time_last_run' to be a str")
        pulumi.set(__self__, "time_last_run", time_last_run)
        if time_last_updated and not isinstance(time_last_updated, str):
            raise TypeError("Expected argument 'time_last_updated' to be a str")
        pulumi.set(__self__, "time_last_updated", time_last_updated)
        if time_next_run and not isinstance(time_next_run, str):
            raise TypeError("Expected argument 'time_next_run' to be a str")
        pulumi.set(__self__, "time_next_run", time_next_run)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> _builtins.str:
        """
        Name of the task creator.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="executionRecurrences")
    def execution_recurrences(self) -> _builtins.str:
        """
        Recurrence specification for the task schedule execution (formatted according to [RFC-5545](https://icalendar.org/RFC-Specifications/iCalendar-RFC-5545/)). To run daily for 10 occurrences starts on September 2, 2024 09:00 EDT, it should be 'DTSTART;TZID=America/New_York:20240902T090000 RRULE:FREQ=DAILY;COUNT=10'. To run every 3 hours from 9:00 AM to 5:00 PM on August 5, 2024 EDT, it should be 'DTSTART;TZID=America/New_York:20240805T090000 RRULE:FREQ=HOURLY;INTERVAL=3;UNTIL=20240805T170000Z'.
        """
        return pulumi.get(self, "execution_recurrences")

    @_builtins.property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
        """
        return pulumi.get(self, "fleet_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to identify this task schedule.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the task schedule.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        All possible status of task schedule.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="taskDetails")
    def task_details(self) -> Sequence['outputs.GetTaskScheduleTaskDetailResult']:
        """
        The minimum details of a task.
        """
        return pulumi.get(self, "task_details")

    @_builtins.property
    @pulumi.getter(name="taskScheduleId")
    def task_schedule_id(self) -> _builtins.str:
        return pulumi.get(self, "task_schedule_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the task schedule was created (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeLastRun")
    def time_last_run(self) -> _builtins.str:
        """
        The date and time the task schedule ran last (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_last_run")

    @_builtins.property
    @pulumi.getter(name="timeLastUpdated")
    def time_last_updated(self) -> _builtins.str:
        """
        The date and time the task schedule was last updated (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_last_updated")

    @_builtins.property
    @pulumi.getter(name="timeNextRun")
    def time_next_run(self) -> _builtins.str:
        """
        The date and time the task schedule will run next (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_next_run")


class AwaitableGetTaskScheduleResult(GetTaskScheduleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTaskScheduleResult(
            created_by=self.created_by,
            execution_recurrences=self.execution_recurrences,
            fleet_id=self.fleet_id,
            id=self.id,
            name=self.name,
            state=self.state,
            task_details=self.task_details,
            task_schedule_id=self.task_schedule_id,
            time_created=self.time_created,
            time_last_run=self.time_last_run,
            time_last_updated=self.time_last_updated,
            time_next_run=self.time_next_run)


def get_task_schedule(fleet_id: Optional[_builtins.str] = None,
                      task_schedule_id: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTaskScheduleResult:
    """
    This data source provides details about a specific Task Schedule resource in Oracle Cloud Infrastructure Jms service.

    Returns a task schedule.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_task_schedule = oci.Jms.get_task_schedule(task_schedule_id=test_task_schedule_oci_jms_task_schedule["id"],
        fleet_id=test_fleet["id"])
    ```


    :param _builtins.str fleet_id: The ID of the Fleet.
    :param _builtins.str task_schedule_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to identify this task schedule.
    """
    __args__ = dict()
    __args__['fleetId'] = fleet_id
    __args__['taskScheduleId'] = task_schedule_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getTaskSchedule:getTaskSchedule', __args__, opts=opts, typ=GetTaskScheduleResult).value

    return AwaitableGetTaskScheduleResult(
        created_by=pulumi.get(__ret__, 'created_by'),
        execution_recurrences=pulumi.get(__ret__, 'execution_recurrences'),
        fleet_id=pulumi.get(__ret__, 'fleet_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        state=pulumi.get(__ret__, 'state'),
        task_details=pulumi.get(__ret__, 'task_details'),
        task_schedule_id=pulumi.get(__ret__, 'task_schedule_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_last_run=pulumi.get(__ret__, 'time_last_run'),
        time_last_updated=pulumi.get(__ret__, 'time_last_updated'),
        time_next_run=pulumi.get(__ret__, 'time_next_run'))
def get_task_schedule_output(fleet_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             task_schedule_id: Optional[pulumi.Input[_builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTaskScheduleResult]:
    """
    This data source provides details about a specific Task Schedule resource in Oracle Cloud Infrastructure Jms service.

    Returns a task schedule.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_task_schedule = oci.Jms.get_task_schedule(task_schedule_id=test_task_schedule_oci_jms_task_schedule["id"],
        fleet_id=test_fleet["id"])
    ```


    :param _builtins.str fleet_id: The ID of the Fleet.
    :param _builtins.str task_schedule_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to identify this task schedule.
    """
    __args__ = dict()
    __args__['fleetId'] = fleet_id
    __args__['taskScheduleId'] = task_schedule_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Jms/getTaskSchedule:getTaskSchedule', __args__, opts=opts, typ=GetTaskScheduleResult)
    return __ret__.apply(lambda __response__: GetTaskScheduleResult(
        created_by=pulumi.get(__response__, 'created_by'),
        execution_recurrences=pulumi.get(__response__, 'execution_recurrences'),
        fleet_id=pulumi.get(__response__, 'fleet_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        state=pulumi.get(__response__, 'state'),
        task_details=pulumi.get(__response__, 'task_details'),
        task_schedule_id=pulumi.get(__response__, 'task_schedule_id'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_last_run=pulumi.get(__response__, 'time_last_run'),
        time_last_updated=pulumi.get(__response__, 'time_last_updated'),
        time_next_run=pulumi.get(__response__, 'time_next_run')))
