# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetTaskSchedulesResult',
    'AwaitableGetTaskSchedulesResult',
    'get_task_schedules',
    'get_task_schedules_output',
]

@pulumi.output_type
class GetTaskSchedulesResult:
    """
    A collection of values returned by getTaskSchedules.
    """
    def __init__(__self__, filters=None, fleet_id=None, id=None, managed_instance_id=None, name=None, task_schedule_collections=None, task_schedule_name_contains=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if fleet_id and not isinstance(fleet_id, str):
            raise TypeError("Expected argument 'fleet_id' to be a str")
        pulumi.set(__self__, "fleet_id", fleet_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_instance_id and not isinstance(managed_instance_id, str):
            raise TypeError("Expected argument 'managed_instance_id' to be a str")
        pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if task_schedule_collections and not isinstance(task_schedule_collections, list):
            raise TypeError("Expected argument 'task_schedule_collections' to be a list")
        pulumi.set(__self__, "task_schedule_collections", task_schedule_collections)
        if task_schedule_name_contains and not isinstance(task_schedule_name_contains, str):
            raise TypeError("Expected argument 'task_schedule_name_contains' to be a str")
        pulumi.set(__self__, "task_schedule_name_contains", task_schedule_name_contains)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetTaskSchedulesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
        """
        return pulumi.get(self, "fleet_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to identify this task schedule.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the related managed instance.
        """
        return pulumi.get(self, "managed_instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the task schedule.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="taskScheduleCollections")
    def task_schedule_collections(self) -> Sequence['outputs.GetTaskSchedulesTaskScheduleCollectionResult']:
        """
        The list of task_schedule_collection.
        """
        return pulumi.get(self, "task_schedule_collections")

    @_builtins.property
    @pulumi.getter(name="taskScheduleNameContains")
    def task_schedule_name_contains(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "task_schedule_name_contains")


class AwaitableGetTaskSchedulesResult(GetTaskSchedulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTaskSchedulesResult(
            filters=self.filters,
            fleet_id=self.fleet_id,
            id=self.id,
            managed_instance_id=self.managed_instance_id,
            name=self.name,
            task_schedule_collections=self.task_schedule_collections,
            task_schedule_name_contains=self.task_schedule_name_contains)


def get_task_schedules(filters: Optional[Sequence[Union['GetTaskSchedulesFilterArgs', 'GetTaskSchedulesFilterArgsDict']]] = None,
                       fleet_id: Optional[_builtins.str] = None,
                       id: Optional[_builtins.str] = None,
                       managed_instance_id: Optional[_builtins.str] = None,
                       name: Optional[_builtins.str] = None,
                       task_schedule_name_contains: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTaskSchedulesResult:
    """
    This data source provides the list of Task Schedules in Oracle Cloud Infrastructure Jms service.

    Returns a list of task schedules.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_task_schedules = oci.Jms.get_task_schedules(fleet_id=test_fleet["id"],
        id=task_schedule_id,
        managed_instance_id=test_managed_instance["id"],
        name=task_schedule_name,
        task_schedule_name_contains=task_schedule_task_schedule_name_contains)
    ```


    :param _builtins.str fleet_id: The ID of the Fleet.
    :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to identify this task schedule.
    :param _builtins.str managed_instance_id: The Fleet-unique identifier of the related managed instance.
    :param _builtins.str name: The task name.
    :param _builtins.str task_schedule_name_contains: Filter the list with task schedule name contains the given value.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    __args__['id'] = id
    __args__['managedInstanceId'] = managed_instance_id
    __args__['name'] = name
    __args__['taskScheduleNameContains'] = task_schedule_name_contains
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getTaskSchedules:getTaskSchedules', __args__, opts=opts, typ=GetTaskSchedulesResult).value

    return AwaitableGetTaskSchedulesResult(
        filters=pulumi.get(__ret__, 'filters'),
        fleet_id=pulumi.get(__ret__, 'fleet_id'),
        id=pulumi.get(__ret__, 'id'),
        managed_instance_id=pulumi.get(__ret__, 'managed_instance_id'),
        name=pulumi.get(__ret__, 'name'),
        task_schedule_collections=pulumi.get(__ret__, 'task_schedule_collections'),
        task_schedule_name_contains=pulumi.get(__ret__, 'task_schedule_name_contains'))
def get_task_schedules_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetTaskSchedulesFilterArgs', 'GetTaskSchedulesFilterArgsDict']]]]] = None,
                              fleet_id: Optional[pulumi.Input[_builtins.str]] = None,
                              id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              managed_instance_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              task_schedule_name_contains: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTaskSchedulesResult]:
    """
    This data source provides the list of Task Schedules in Oracle Cloud Infrastructure Jms service.

    Returns a list of task schedules.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_task_schedules = oci.Jms.get_task_schedules(fleet_id=test_fleet["id"],
        id=task_schedule_id,
        managed_instance_id=test_managed_instance["id"],
        name=task_schedule_name,
        task_schedule_name_contains=task_schedule_task_schedule_name_contains)
    ```


    :param _builtins.str fleet_id: The ID of the Fleet.
    :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to identify this task schedule.
    :param _builtins.str managed_instance_id: The Fleet-unique identifier of the related managed instance.
    :param _builtins.str name: The task name.
    :param _builtins.str task_schedule_name_contains: Filter the list with task schedule name contains the given value.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    __args__['id'] = id
    __args__['managedInstanceId'] = managed_instance_id
    __args__['name'] = name
    __args__['taskScheduleNameContains'] = task_schedule_name_contains
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Jms/getTaskSchedules:getTaskSchedules', __args__, opts=opts, typ=GetTaskSchedulesResult)
    return __ret__.apply(lambda __response__: GetTaskSchedulesResult(
        filters=pulumi.get(__response__, 'filters'),
        fleet_id=pulumi.get(__response__, 'fleet_id'),
        id=pulumi.get(__response__, 'id'),
        managed_instance_id=pulumi.get(__response__, 'managed_instance_id'),
        name=pulumi.get(__response__, 'name'),
        task_schedule_collections=pulumi.get(__response__, 'task_schedule_collections'),
        task_schedule_name_contains=pulumi.get(__response__, 'task_schedule_name_contains')))
