# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetUtilsAnalyzeApplicationsConfigurationResult',
    'AwaitableGetUtilsAnalyzeApplicationsConfigurationResult',
    'get_utils_analyze_applications_configuration',
    'get_utils_analyze_applications_configuration_output',
]

@pulumi.output_type
class GetUtilsAnalyzeApplicationsConfigurationResult:
    """
    A collection of values returned by getUtilsAnalyzeApplicationsConfiguration.
    """
    def __init__(__self__, bucket=None, compartment_id=None, id=None, namespace=None):
        if bucket and not isinstance(bucket, str):
            raise TypeError("Expected argument 'bucket' to be a str")
        pulumi.set(__self__, "bucket", bucket)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        The name of the bucket used for analyzing applications.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        The Object Storage namespace used for analyzing applications.
        """
        return pulumi.get(self, "namespace")


class AwaitableGetUtilsAnalyzeApplicationsConfigurationResult(GetUtilsAnalyzeApplicationsConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUtilsAnalyzeApplicationsConfigurationResult(
            bucket=self.bucket,
            compartment_id=self.compartment_id,
            id=self.id,
            namespace=self.namespace)


def get_utils_analyze_applications_configuration(bucket: Optional[_builtins.str] = None,
                                                 compartment_id: Optional[_builtins.str] = None,
                                                 namespace: Optional[_builtins.str] = None,
                                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUtilsAnalyzeApplicationsConfigurationResult:
    """
    This data source provides details about a specific Analyze Applications Configuration resource in Oracle Cloud Infrastructure Jms Utils service.

    Returns the configuration for analyzing applications.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_analyze_applications_configuration = oci.Jms.get_utils_analyze_applications_configuration(compartment_id=compartment_id)
    ```


    :param _builtins.str bucket: The name of the bucket used for analyzing applications.
    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param _builtins.str namespace: The Object Storage namespace used for analyzing applications.
    """
    __args__ = dict()
    __args__['bucket'] = bucket
    __args__['compartmentId'] = compartment_id
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getUtilsAnalyzeApplicationsConfiguration:getUtilsAnalyzeApplicationsConfiguration', __args__, opts=opts, typ=GetUtilsAnalyzeApplicationsConfigurationResult).value

    return AwaitableGetUtilsAnalyzeApplicationsConfigurationResult(
        bucket=pulumi.get(__ret__, 'bucket'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        id=pulumi.get(__ret__, 'id'),
        namespace=pulumi.get(__ret__, 'namespace'))
def get_utils_analyze_applications_configuration_output(bucket: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                        compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                        namespace: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUtilsAnalyzeApplicationsConfigurationResult]:
    """
    This data source provides details about a specific Analyze Applications Configuration resource in Oracle Cloud Infrastructure Jms Utils service.

    Returns the configuration for analyzing applications.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_analyze_applications_configuration = oci.Jms.get_utils_analyze_applications_configuration(compartment_id=compartment_id)
    ```


    :param _builtins.str bucket: The name of the bucket used for analyzing applications.
    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param _builtins.str namespace: The Object Storage namespace used for analyzing applications.
    """
    __args__ = dict()
    __args__['bucket'] = bucket
    __args__['compartmentId'] = compartment_id
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Jms/getUtilsAnalyzeApplicationsConfiguration:getUtilsAnalyzeApplicationsConfiguration', __args__, opts=opts, typ=GetUtilsAnalyzeApplicationsConfigurationResult)
    return __ret__.apply(lambda __response__: GetUtilsAnalyzeApplicationsConfigurationResult(
        bucket=pulumi.get(__response__, 'bucket'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        id=pulumi.get(__response__, 'id'),
        namespace=pulumi.get(__response__, 'namespace')))
