# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetUtilsJavaMigrationAnalysisResult',
    'AwaitableGetUtilsJavaMigrationAnalysisResult',
    'get_utils_java_migration_analysis',
    'get_utils_java_migration_analysis_output',
]

@pulumi.output_type
class GetUtilsJavaMigrationAnalysisResult:
    """
    A collection of values returned by getUtilsJavaMigrationAnalysis.
    """
    def __init__(__self__, analysis_project_name=None, compartment_id=None, filters=None, id=None, java_migration_analysis_collections=None):
        if analysis_project_name and not isinstance(analysis_project_name, str):
            raise TypeError("Expected argument 'analysis_project_name' to be a str")
        pulumi.set(__self__, "analysis_project_name", analysis_project_name)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if java_migration_analysis_collections and not isinstance(java_migration_analysis_collections, list):
            raise TypeError("Expected argument 'java_migration_analysis_collections' to be a list")
        pulumi.set(__self__, "java_migration_analysis_collections", java_migration_analysis_collections)

    @_builtins.property
    @pulumi.getter(name="analysisProjectName")
    def analysis_project_name(self) -> Optional[_builtins.str]:
        """
        Name of the analysis project.
        """
        return pulumi.get(self, "analysis_project_name")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetUtilsJavaMigrationAnalysisFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Java Migration Analysis.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="javaMigrationAnalysisCollections")
    def java_migration_analysis_collections(self) -> Sequence['outputs.GetUtilsJavaMigrationAnalysisJavaMigrationAnalysisCollectionResult']:
        """
        The list of java_migration_analysis_collection.
        """
        return pulumi.get(self, "java_migration_analysis_collections")


class AwaitableGetUtilsJavaMigrationAnalysisResult(GetUtilsJavaMigrationAnalysisResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUtilsJavaMigrationAnalysisResult(
            analysis_project_name=self.analysis_project_name,
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            java_migration_analysis_collections=self.java_migration_analysis_collections)


def get_utils_java_migration_analysis(analysis_project_name: Optional[_builtins.str] = None,
                                      compartment_id: Optional[_builtins.str] = None,
                                      filters: Optional[Sequence[Union['GetUtilsJavaMigrationAnalysisFilterArgs', 'GetUtilsJavaMigrationAnalysisFilterArgsDict']]] = None,
                                      id: Optional[_builtins.str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUtilsJavaMigrationAnalysisResult:
    """
    This data source provides the list of Java Migration Analysis in Oracle Cloud Infrastructure Jms Utils service.

    Gets a list of Java Migration Analysis.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_java_migration_analysis = oci.Jms.get_utils_java_migration_analysis(analysis_project_name=test_project["name"],
        compartment_id=compartment_id,
        id=java_migration_analysi_id)
    ```


    :param _builtins.str analysis_project_name: The project name of the Performance Tuning Analysis to query for.
    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Java Migration Analysis.
    """
    __args__ = dict()
    __args__['analysisProjectName'] = analysis_project_name
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getUtilsJavaMigrationAnalysis:getUtilsJavaMigrationAnalysis', __args__, opts=opts, typ=GetUtilsJavaMigrationAnalysisResult).value

    return AwaitableGetUtilsJavaMigrationAnalysisResult(
        analysis_project_name=pulumi.get(__ret__, 'analysis_project_name'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        java_migration_analysis_collections=pulumi.get(__ret__, 'java_migration_analysis_collections'))
def get_utils_java_migration_analysis_output(analysis_project_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             filters: Optional[pulumi.Input[Optional[Sequence[Union['GetUtilsJavaMigrationAnalysisFilterArgs', 'GetUtilsJavaMigrationAnalysisFilterArgsDict']]]]] = None,
                                             id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUtilsJavaMigrationAnalysisResult]:
    """
    This data source provides the list of Java Migration Analysis in Oracle Cloud Infrastructure Jms Utils service.

    Gets a list of Java Migration Analysis.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_java_migration_analysis = oci.Jms.get_utils_java_migration_analysis(analysis_project_name=test_project["name"],
        compartment_id=compartment_id,
        id=java_migration_analysi_id)
    ```


    :param _builtins.str analysis_project_name: The project name of the Performance Tuning Analysis to query for.
    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Java Migration Analysis.
    """
    __args__ = dict()
    __args__['analysisProjectName'] = analysis_project_name
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Jms/getUtilsJavaMigrationAnalysis:getUtilsJavaMigrationAnalysis', __args__, opts=opts, typ=GetUtilsJavaMigrationAnalysisResult)
    return __ret__.apply(lambda __response__: GetUtilsJavaMigrationAnalysisResult(
        analysis_project_name=pulumi.get(__response__, 'analysis_project_name'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        java_migration_analysis_collections=pulumi.get(__response__, 'java_migration_analysis_collections')))
