# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetUtilsPerformanceTuningAnalysiResult',
    'AwaitableGetUtilsPerformanceTuningAnalysiResult',
    'get_utils_performance_tuning_analysi',
    'get_utils_performance_tuning_analysi_output',
]

@pulumi.output_type
class GetUtilsPerformanceTuningAnalysiResult:
    """
    A collection of values returned by getUtilsPerformanceTuningAnalysi.
    """
    def __init__(__self__, analysis_project_name=None, artifact_object_storage_path=None, compartment_id=None, created_bies=None, id=None, performance_tuning_analysis_id=None, result=None, result_object_storage_path=None, time_created=None, time_finished=None, time_started=None, warning_count=None, work_request_id=None):
        if analysis_project_name and not isinstance(analysis_project_name, str):
            raise TypeError("Expected argument 'analysis_project_name' to be a str")
        pulumi.set(__self__, "analysis_project_name", analysis_project_name)
        if artifact_object_storage_path and not isinstance(artifact_object_storage_path, str):
            raise TypeError("Expected argument 'artifact_object_storage_path' to be a str")
        pulumi.set(__self__, "artifact_object_storage_path", artifact_object_storage_path)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if created_bies and not isinstance(created_bies, list):
            raise TypeError("Expected argument 'created_bies' to be a list")
        pulumi.set(__self__, "created_bies", created_bies)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if performance_tuning_analysis_id and not isinstance(performance_tuning_analysis_id, str):
            raise TypeError("Expected argument 'performance_tuning_analysis_id' to be a str")
        pulumi.set(__self__, "performance_tuning_analysis_id", performance_tuning_analysis_id)
        if result and not isinstance(result, str):
            raise TypeError("Expected argument 'result' to be a str")
        pulumi.set(__self__, "result", result)
        if result_object_storage_path and not isinstance(result_object_storage_path, str):
            raise TypeError("Expected argument 'result_object_storage_path' to be a str")
        pulumi.set(__self__, "result_object_storage_path", result_object_storage_path)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_finished and not isinstance(time_finished, str):
            raise TypeError("Expected argument 'time_finished' to be a str")
        pulumi.set(__self__, "time_finished", time_finished)
        if time_started and not isinstance(time_started, str):
            raise TypeError("Expected argument 'time_started' to be a str")
        pulumi.set(__self__, "time_started", time_started)
        if warning_count and not isinstance(warning_count, int):
            raise TypeError("Expected argument 'warning_count' to be a int")
        pulumi.set(__self__, "warning_count", warning_count)
        if work_request_id and not isinstance(work_request_id, str):
            raise TypeError("Expected argument 'work_request_id' to be a str")
        pulumi.set(__self__, "work_request_id", work_request_id)

    @_builtins.property
    @pulumi.getter(name="analysisProjectName")
    def analysis_project_name(self) -> _builtins.str:
        """
        Name of the analysis project.
        """
        return pulumi.get(self, "analysis_project_name")

    @_builtins.property
    @pulumi.getter(name="artifactObjectStoragePath")
    def artifact_object_storage_path(self) -> _builtins.str:
        """
        Object storage path to the artifact.
        """
        return pulumi.get(self, "artifact_object_storage_path")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="createdBies")
    def created_bies(self) -> Sequence['outputs.GetUtilsPerformanceTuningAnalysiCreatedByResult']:
        """
        An authorized principal.
        """
        return pulumi.get(self, "created_bies")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="performanceTuningAnalysisId")
    def performance_tuning_analysis_id(self) -> _builtins.str:
        return pulumi.get(self, "performance_tuning_analysis_id")

    @_builtins.property
    @pulumi.getter
    def result(self) -> _builtins.str:
        """
        Possible Performance Tuning Result statuses.
        """
        return pulumi.get(self, "result")

    @_builtins.property
    @pulumi.getter(name="resultObjectStoragePath")
    def result_object_storage_path(self) -> _builtins.str:
        """
        Object storage path to the analysis.
        """
        return pulumi.get(self, "result_object_storage_path")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the Performance Tuning Analysis was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> _builtins.str:
        """
        The date and time the Performance Tuning Analysis was finished, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_finished")

    @_builtins.property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> _builtins.str:
        """
        The date and time the Performance Tuning Analysis was started, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_started")

    @_builtins.property
    @pulumi.getter(name="warningCount")
    def warning_count(self) -> _builtins.int:
        """
        Number of warnings in the Performance Tuning Analysis.
        """
        return pulumi.get(self, "warning_count")

    @_builtins.property
    @pulumi.getter(name="workRequestId")
    def work_request_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Work Request.
        """
        return pulumi.get(self, "work_request_id")


class AwaitableGetUtilsPerformanceTuningAnalysiResult(GetUtilsPerformanceTuningAnalysiResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUtilsPerformanceTuningAnalysiResult(
            analysis_project_name=self.analysis_project_name,
            artifact_object_storage_path=self.artifact_object_storage_path,
            compartment_id=self.compartment_id,
            created_bies=self.created_bies,
            id=self.id,
            performance_tuning_analysis_id=self.performance_tuning_analysis_id,
            result=self.result,
            result_object_storage_path=self.result_object_storage_path,
            time_created=self.time_created,
            time_finished=self.time_finished,
            time_started=self.time_started,
            warning_count=self.warning_count,
            work_request_id=self.work_request_id)


def get_utils_performance_tuning_analysi(compartment_id: Optional[_builtins.str] = None,
                                         performance_tuning_analysis_id: Optional[_builtins.str] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUtilsPerformanceTuningAnalysiResult:
    """
    This data source provides details about a specific Performance Tuning Analysi resource in Oracle Cloud Infrastructure Jms Utils service.

    Gets information about a Performance Tuning Analysis.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_performance_tuning_analysi = oci.Jms.get_utils_performance_tuning_analysi(performance_tuning_analysis_id=test_performance_tuning_analysi_oci_jms_utils_performance_tuning_analysi["id"])
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.str performance_tuning_analysis_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Performance Tuning Analysis.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['performanceTuningAnalysisId'] = performance_tuning_analysis_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getUtilsPerformanceTuningAnalysi:getUtilsPerformanceTuningAnalysi', __args__, opts=opts, typ=GetUtilsPerformanceTuningAnalysiResult).value

    return AwaitableGetUtilsPerformanceTuningAnalysiResult(
        analysis_project_name=pulumi.get(__ret__, 'analysis_project_name'),
        artifact_object_storage_path=pulumi.get(__ret__, 'artifact_object_storage_path'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        created_bies=pulumi.get(__ret__, 'created_bies'),
        id=pulumi.get(__ret__, 'id'),
        performance_tuning_analysis_id=pulumi.get(__ret__, 'performance_tuning_analysis_id'),
        result=pulumi.get(__ret__, 'result'),
        result_object_storage_path=pulumi.get(__ret__, 'result_object_storage_path'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_finished=pulumi.get(__ret__, 'time_finished'),
        time_started=pulumi.get(__ret__, 'time_started'),
        warning_count=pulumi.get(__ret__, 'warning_count'),
        work_request_id=pulumi.get(__ret__, 'work_request_id'))
def get_utils_performance_tuning_analysi_output(compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                performance_tuning_analysis_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUtilsPerformanceTuningAnalysiResult]:
    """
    This data source provides details about a specific Performance Tuning Analysi resource in Oracle Cloud Infrastructure Jms Utils service.

    Gets information about a Performance Tuning Analysis.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_performance_tuning_analysi = oci.Jms.get_utils_performance_tuning_analysi(performance_tuning_analysis_id=test_performance_tuning_analysi_oci_jms_utils_performance_tuning_analysi["id"])
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.str performance_tuning_analysis_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Performance Tuning Analysis.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['performanceTuningAnalysisId'] = performance_tuning_analysis_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Jms/getUtilsPerformanceTuningAnalysi:getUtilsPerformanceTuningAnalysi', __args__, opts=opts, typ=GetUtilsPerformanceTuningAnalysiResult)
    return __ret__.apply(lambda __response__: GetUtilsPerformanceTuningAnalysiResult(
        analysis_project_name=pulumi.get(__response__, 'analysis_project_name'),
        artifact_object_storage_path=pulumi.get(__response__, 'artifact_object_storage_path'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        created_bies=pulumi.get(__response__, 'created_bies'),
        id=pulumi.get(__response__, 'id'),
        performance_tuning_analysis_id=pulumi.get(__response__, 'performance_tuning_analysis_id'),
        result=pulumi.get(__response__, 'result'),
        result_object_storage_path=pulumi.get(__response__, 'result_object_storage_path'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_finished=pulumi.get(__response__, 'time_finished'),
        time_started=pulumi.get(__response__, 'time_started'),
        warning_count=pulumi.get(__response__, 'warning_count'),
        work_request_id=pulumi.get(__response__, 'work_request_id')))
