# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetUtilsSubscriptionAcknowledgmentConfigurationResult',
    'AwaitableGetUtilsSubscriptionAcknowledgmentConfigurationResult',
    'get_utils_subscription_acknowledgment_configuration',
    'get_utils_subscription_acknowledgment_configuration_output',
]

@pulumi.output_type
class GetUtilsSubscriptionAcknowledgmentConfigurationResult:
    """
    A collection of values returned by getUtilsSubscriptionAcknowledgmentConfiguration.
    """
    def __init__(__self__, acknowledged_by=None, compartment_id=None, id=None, is_acknowledged=None, time_acknowledged=None):
        if acknowledged_by and not isinstance(acknowledged_by, str):
            raise TypeError("Expected argument 'acknowledged_by' to be a str")
        pulumi.set(__self__, "acknowledged_by", acknowledged_by)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_acknowledged and not isinstance(is_acknowledged, bool):
            raise TypeError("Expected argument 'is_acknowledged' to be a bool")
        pulumi.set(__self__, "is_acknowledged", is_acknowledged)
        if time_acknowledged and not isinstance(time_acknowledged, str):
            raise TypeError("Expected argument 'time_acknowledged' to be a str")
        pulumi.set(__self__, "time_acknowledged", time_acknowledged)

    @_builtins.property
    @pulumi.getter(name="acknowledgedBy")
    def acknowledged_by(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the principal that ackwnoledged the subscription.
        """
        return pulumi.get(self, "acknowledged_by")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isAcknowledged")
    def is_acknowledged(self) -> _builtins.bool:
        """
        Flag to determine whether the subscription was acknowledged or not.
        """
        return pulumi.get(self, "is_acknowledged")

    @_builtins.property
    @pulumi.getter(name="timeAcknowledged")
    def time_acknowledged(self) -> _builtins.str:
        """
        The date and time the subscription was acknowledged (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_acknowledged")


class AwaitableGetUtilsSubscriptionAcknowledgmentConfigurationResult(GetUtilsSubscriptionAcknowledgmentConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUtilsSubscriptionAcknowledgmentConfigurationResult(
            acknowledged_by=self.acknowledged_by,
            compartment_id=self.compartment_id,
            id=self.id,
            is_acknowledged=self.is_acknowledged,
            time_acknowledged=self.time_acknowledged)


def get_utils_subscription_acknowledgment_configuration(compartment_id: Optional[_builtins.str] = None,
                                                        is_acknowledged: Optional[_builtins.bool] = None,
                                                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUtilsSubscriptionAcknowledgmentConfigurationResult:
    """
    This data source provides details about a specific Subscription Acknowledgment Configuration resource in Oracle Cloud Infrastructure Jms Utils service.

    Returns the configuration for subscription acknowledgment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_subscription_acknowledgment_configuration = oci.Jms.get_utils_subscription_acknowledgment_configuration(compartment_id=compartment_id)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param _builtins.bool is_acknowledged: Flag to determine whether the subscription was acknowledged or not.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['isAcknowledged'] = is_acknowledged
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getUtilsSubscriptionAcknowledgmentConfiguration:getUtilsSubscriptionAcknowledgmentConfiguration', __args__, opts=opts, typ=GetUtilsSubscriptionAcknowledgmentConfigurationResult).value

    return AwaitableGetUtilsSubscriptionAcknowledgmentConfigurationResult(
        acknowledged_by=pulumi.get(__ret__, 'acknowledged_by'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        id=pulumi.get(__ret__, 'id'),
        is_acknowledged=pulumi.get(__ret__, 'is_acknowledged'),
        time_acknowledged=pulumi.get(__ret__, 'time_acknowledged'))
def get_utils_subscription_acknowledgment_configuration_output(compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                               is_acknowledged: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUtilsSubscriptionAcknowledgmentConfigurationResult]:
    """
    This data source provides details about a specific Subscription Acknowledgment Configuration resource in Oracle Cloud Infrastructure Jms Utils service.

    Returns the configuration for subscription acknowledgment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_subscription_acknowledgment_configuration = oci.Jms.get_utils_subscription_acknowledgment_configuration(compartment_id=compartment_id)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param _builtins.bool is_acknowledged: Flag to determine whether the subscription was acknowledged or not.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['isAcknowledged'] = is_acknowledged
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Jms/getUtilsSubscriptionAcknowledgmentConfiguration:getUtilsSubscriptionAcknowledgmentConfiguration', __args__, opts=opts, typ=GetUtilsSubscriptionAcknowledgmentConfigurationResult)
    return __ret__.apply(lambda __response__: GetUtilsSubscriptionAcknowledgmentConfigurationResult(
        acknowledged_by=pulumi.get(__response__, 'acknowledged_by'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        id=pulumi.get(__response__, 'id'),
        is_acknowledged=pulumi.get(__response__, 'is_acknowledged'),
        time_acknowledged=pulumi.get(__response__, 'time_acknowledged')))
