# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TaskScheduleArgs', 'TaskSchedule']

@pulumi.input_type
class TaskScheduleArgs:
    def __init__(__self__, *,
                 execution_recurrences: pulumi.Input[_builtins.str],
                 fleet_id: pulumi.Input[_builtins.str],
                 task_details: pulumi.Input['TaskScheduleTaskDetailsArgs']):
        """
        The set of arguments for constructing a TaskSchedule resource.
        :param pulumi.Input[_builtins.str] execution_recurrences: (Updatable) Recurrence specification for the task schedule execution (formatted according to [RFC-5545](https://icalendar.org/RFC-Specifications/iCalendar-RFC-5545/)). To run daily for 10 occurrences starts on September 2, 2024 09:00 EDT, it should be 'DTSTART;TZID=America/New_York:20240902T090000 RRULE:FREQ=DAILY;COUNT=10'. To run every 3 hours from 9:00 AM to 5:00 PM on August 5, 2024 EDT, it should be 'DTSTART;TZID=America/New_York:20240805T090000 RRULE:FREQ=HOURLY;INTERVAL=3;UNTIL=20240805T170000Z'.
        :param pulumi.Input[_builtins.str] fleet_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
        :param pulumi.Input['TaskScheduleTaskDetailsArgs'] task_details: (Updatable) The minimum details of a task.
        """
        pulumi.set(__self__, "execution_recurrences", execution_recurrences)
        pulumi.set(__self__, "fleet_id", fleet_id)
        pulumi.set(__self__, "task_details", task_details)

    @_builtins.property
    @pulumi.getter(name="executionRecurrences")
    def execution_recurrences(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Recurrence specification for the task schedule execution (formatted according to [RFC-5545](https://icalendar.org/RFC-Specifications/iCalendar-RFC-5545/)). To run daily for 10 occurrences starts on September 2, 2024 09:00 EDT, it should be 'DTSTART;TZID=America/New_York:20240902T090000 RRULE:FREQ=DAILY;COUNT=10'. To run every 3 hours from 9:00 AM to 5:00 PM on August 5, 2024 EDT, it should be 'DTSTART;TZID=America/New_York:20240805T090000 RRULE:FREQ=HOURLY;INTERVAL=3;UNTIL=20240805T170000Z'.
        """
        return pulumi.get(self, "execution_recurrences")

    @execution_recurrences.setter
    def execution_recurrences(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "execution_recurrences", value)

    @_builtins.property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
        """
        return pulumi.get(self, "fleet_id")

    @fleet_id.setter
    def fleet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "fleet_id", value)

    @_builtins.property
    @pulumi.getter(name="taskDetails")
    def task_details(self) -> pulumi.Input['TaskScheduleTaskDetailsArgs']:
        """
        (Updatable) The minimum details of a task.
        """
        return pulumi.get(self, "task_details")

    @task_details.setter
    def task_details(self, value: pulumi.Input['TaskScheduleTaskDetailsArgs']):
        pulumi.set(self, "task_details", value)


@pulumi.input_type
class _TaskScheduleState:
    def __init__(__self__, *,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_recurrences: Optional[pulumi.Input[_builtins.str]] = None,
                 fleet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 task_details: Optional[pulumi.Input['TaskScheduleTaskDetailsArgs']] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_last_run: Optional[pulumi.Input[_builtins.str]] = None,
                 time_last_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 time_next_run: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TaskSchedule resources.
        :param pulumi.Input[_builtins.str] created_by: Name of the task creator.
        :param pulumi.Input[_builtins.str] execution_recurrences: (Updatable) Recurrence specification for the task schedule execution (formatted according to [RFC-5545](https://icalendar.org/RFC-Specifications/iCalendar-RFC-5545/)). To run daily for 10 occurrences starts on September 2, 2024 09:00 EDT, it should be 'DTSTART;TZID=America/New_York:20240902T090000 RRULE:FREQ=DAILY;COUNT=10'. To run every 3 hours from 9:00 AM to 5:00 PM on August 5, 2024 EDT, it should be 'DTSTART;TZID=America/New_York:20240805T090000 RRULE:FREQ=HOURLY;INTERVAL=3;UNTIL=20240805T170000Z'.
        :param pulumi.Input[_builtins.str] fleet_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
        :param pulumi.Input[_builtins.str] name: The name of the task schedule.
        :param pulumi.Input[_builtins.str] state: All possible status of task schedule.
        :param pulumi.Input['TaskScheduleTaskDetailsArgs'] task_details: (Updatable) The minimum details of a task.
        :param pulumi.Input[_builtins.str] time_created: The date and time the task schedule was created (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param pulumi.Input[_builtins.str] time_last_run: The date and time the task schedule ran last (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param pulumi.Input[_builtins.str] time_last_updated: The date and time the task schedule was last updated (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param pulumi.Input[_builtins.str] time_next_run: The date and time the task schedule will run next (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if execution_recurrences is not None:
            pulumi.set(__self__, "execution_recurrences", execution_recurrences)
        if fleet_id is not None:
            pulumi.set(__self__, "fleet_id", fleet_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if task_details is not None:
            pulumi.set(__self__, "task_details", task_details)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_last_run is not None:
            pulumi.set(__self__, "time_last_run", time_last_run)
        if time_last_updated is not None:
            pulumi.set(__self__, "time_last_updated", time_last_updated)
        if time_next_run is not None:
            pulumi.set(__self__, "time_next_run", time_next_run)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the task creator.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter(name="executionRecurrences")
    def execution_recurrences(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Recurrence specification for the task schedule execution (formatted according to [RFC-5545](https://icalendar.org/RFC-Specifications/iCalendar-RFC-5545/)). To run daily for 10 occurrences starts on September 2, 2024 09:00 EDT, it should be 'DTSTART;TZID=America/New_York:20240902T090000 RRULE:FREQ=DAILY;COUNT=10'. To run every 3 hours from 9:00 AM to 5:00 PM on August 5, 2024 EDT, it should be 'DTSTART;TZID=America/New_York:20240805T090000 RRULE:FREQ=HOURLY;INTERVAL=3;UNTIL=20240805T170000Z'.
        """
        return pulumi.get(self, "execution_recurrences")

    @execution_recurrences.setter
    def execution_recurrences(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "execution_recurrences", value)

    @_builtins.property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
        """
        return pulumi.get(self, "fleet_id")

    @fleet_id.setter
    def fleet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fleet_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the task schedule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        All possible status of task schedule.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="taskDetails")
    def task_details(self) -> Optional[pulumi.Input['TaskScheduleTaskDetailsArgs']]:
        """
        (Updatable) The minimum details of a task.
        """
        return pulumi.get(self, "task_details")

    @task_details.setter
    def task_details(self, value: Optional[pulumi.Input['TaskScheduleTaskDetailsArgs']]):
        pulumi.set(self, "task_details", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the task schedule was created (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeLastRun")
    def time_last_run(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the task schedule ran last (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_last_run")

    @time_last_run.setter
    def time_last_run(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_last_run", value)

    @_builtins.property
    @pulumi.getter(name="timeLastUpdated")
    def time_last_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the task schedule was last updated (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_last_updated")

    @time_last_updated.setter
    def time_last_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_last_updated", value)

    @_builtins.property
    @pulumi.getter(name="timeNextRun")
    def time_next_run(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the task schedule will run next (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_next_run")

    @time_next_run.setter
    def time_next_run(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_next_run", value)


@pulumi.type_token("oci:Jms/taskSchedule:TaskSchedule")
class TaskSchedule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 execution_recurrences: Optional[pulumi.Input[_builtins.str]] = None,
                 fleet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 task_details: Optional[pulumi.Input[Union['TaskScheduleTaskDetailsArgs', 'TaskScheduleTaskDetailsArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Task Schedule resource in Oracle Cloud Infrastructure Jms service.

        Create a task schedule using the information provided.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_task_schedule = oci.jms.TaskSchedule("test_task_schedule",
            execution_recurrences=task_schedule_execution_recurrences,
            fleet_id=test_fleet["id"],
            task_details={
                "task_type": task_schedule_task_details_task_type,
                "add_installation_site_task_request": {
                    "installation_sites": [{
                        "artifact_content_type": task_schedule_task_details_add_installation_site_task_request_installation_sites_artifact_content_type,
                        "force_install": task_schedule_task_details_add_installation_site_task_request_installation_sites_force_install,
                        "headless_mode": task_schedule_task_details_add_installation_site_task_request_installation_sites_headless_mode,
                        "installation_path": task_schedule_task_details_add_installation_site_task_request_installation_sites_installation_path,
                        "managed_instance_id": test_managed_instance["id"],
                        "release_version": task_schedule_task_details_add_installation_site_task_request_installation_sites_release_version,
                    }],
                    "post_installation_actions": task_schedule_task_details_add_installation_site_task_request_post_installation_actions,
                },
                "crypto_task_request": {
                    "recording_duration_in_minutes": task_schedule_task_details_crypto_task_request_recording_duration_in_minutes,
                    "targets": [{
                        "application_installation_key": task_schedule_task_details_crypto_task_request_targets_application_installation_key,
                        "application_key": task_schedule_task_details_crypto_task_request_targets_application_key,
                        "container_key": task_schedule_task_details_crypto_task_request_targets_container_key,
                        "jre_key": task_schedule_task_details_crypto_task_request_targets_jre_key,
                        "managed_instance_id": test_managed_instance["id"],
                    }],
                    "waiting_period_in_minutes": task_schedule_task_details_crypto_task_request_waiting_period_in_minutes,
                },
                "deployed_application_migration_task_request": {
                    "targets": [{
                        "deployed_application_installation_key": task_schedule_task_details_deployed_application_migration_task_request_targets_deployed_application_installation_key,
                        "exclude_package_prefixes": task_schedule_task_details_deployed_application_migration_task_request_targets_exclude_package_prefixes,
                        "include_package_prefixes": task_schedule_task_details_deployed_application_migration_task_request_targets_include_package_prefixes,
                        "managed_instance_id": test_managed_instance["id"],
                        "source_jdk_version": task_schedule_task_details_deployed_application_migration_task_request_targets_source_jdk_version,
                        "target_jdk_version": task_schedule_task_details_deployed_application_migration_task_request_targets_target_jdk_version,
                    }],
                },
                "java_migration_task_request": {
                    "targets": [{
                        "application_installation_key": task_schedule_task_details_java_migration_task_request_targets_application_installation_key,
                        "exclude_package_prefixes": task_schedule_task_details_java_migration_task_request_targets_exclude_package_prefixes,
                        "include_package_prefixes": task_schedule_task_details_java_migration_task_request_targets_include_package_prefixes,
                        "managed_instance_id": test_managed_instance["id"],
                        "source_jdk_version": task_schedule_task_details_java_migration_task_request_targets_source_jdk_version,
                        "target_jdk_version": task_schedule_task_details_java_migration_task_request_targets_target_jdk_version,
                    }],
                },
                "jfr_task_request": {
                    "jfc_profile_name": test_profile["name"],
                    "jfc_v1": task_schedule_task_details_jfr_task_request_jfc_v1,
                    "jfc_v2": task_schedule_task_details_jfr_task_request_jfc_v2,
                    "recording_duration_in_minutes": task_schedule_task_details_jfr_task_request_recording_duration_in_minutes,
                    "recording_size_in_mb": task_schedule_task_details_jfr_task_request_recording_size_in_mb,
                    "targets": [{
                        "application_installation_key": task_schedule_task_details_jfr_task_request_targets_application_installation_key,
                        "application_key": task_schedule_task_details_jfr_task_request_targets_application_key,
                        "container_key": task_schedule_task_details_jfr_task_request_targets_container_key,
                        "jre_key": task_schedule_task_details_jfr_task_request_targets_jre_key,
                        "managed_instance_id": test_managed_instance["id"],
                    }],
                    "waiting_period_in_minutes": task_schedule_task_details_jfr_task_request_waiting_period_in_minutes,
                },
                "performance_tuning_task_request": {
                    "recording_duration_in_minutes": task_schedule_task_details_performance_tuning_task_request_recording_duration_in_minutes,
                    "targets": [{
                        "application_installation_key": task_schedule_task_details_performance_tuning_task_request_targets_application_installation_key,
                        "application_key": task_schedule_task_details_performance_tuning_task_request_targets_application_key,
                        "container_key": task_schedule_task_details_performance_tuning_task_request_targets_container_key,
                        "jre_key": task_schedule_task_details_performance_tuning_task_request_targets_jre_key,
                        "managed_instance_id": test_managed_instance["id"],
                    }],
                    "waiting_period_in_minutes": task_schedule_task_details_performance_tuning_task_request_waiting_period_in_minutes,
                },
                "remove_installation_site_task_request": {
                    "installation_sites": [{
                        "installation_key": task_schedule_task_details_remove_installation_site_task_request_installation_sites_installation_key,
                        "managed_instance_id": test_managed_instance["id"],
                    }],
                },
                "scan_java_server_task_request": {
                    "managed_instance_ids": task_schedule_task_details_scan_java_server_task_request_managed_instance_ids,
                },
                "scan_library_task_request": {
                    "dynamic_scan_duration_in_minutes": task_schedule_task_details_scan_library_task_request_dynamic_scan_duration_in_minutes,
                    "is_dynamic_scan": task_schedule_task_details_scan_library_task_request_is_dynamic_scan,
                    "managed_instance_ids": task_schedule_task_details_scan_library_task_request_managed_instance_ids,
                },
            })
        ```

        ## Import

        TaskSchedules can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Jms/taskSchedule:TaskSchedule test_task_schedule "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] execution_recurrences: (Updatable) Recurrence specification for the task schedule execution (formatted according to [RFC-5545](https://icalendar.org/RFC-Specifications/iCalendar-RFC-5545/)). To run daily for 10 occurrences starts on September 2, 2024 09:00 EDT, it should be 'DTSTART;TZID=America/New_York:20240902T090000 RRULE:FREQ=DAILY;COUNT=10'. To run every 3 hours from 9:00 AM to 5:00 PM on August 5, 2024 EDT, it should be 'DTSTART;TZID=America/New_York:20240805T090000 RRULE:FREQ=HOURLY;INTERVAL=3;UNTIL=20240805T170000Z'.
        :param pulumi.Input[_builtins.str] fleet_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
        :param pulumi.Input[Union['TaskScheduleTaskDetailsArgs', 'TaskScheduleTaskDetailsArgsDict']] task_details: (Updatable) The minimum details of a task.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TaskScheduleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Task Schedule resource in Oracle Cloud Infrastructure Jms service.

        Create a task schedule using the information provided.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_task_schedule = oci.jms.TaskSchedule("test_task_schedule",
            execution_recurrences=task_schedule_execution_recurrences,
            fleet_id=test_fleet["id"],
            task_details={
                "task_type": task_schedule_task_details_task_type,
                "add_installation_site_task_request": {
                    "installation_sites": [{
                        "artifact_content_type": task_schedule_task_details_add_installation_site_task_request_installation_sites_artifact_content_type,
                        "force_install": task_schedule_task_details_add_installation_site_task_request_installation_sites_force_install,
                        "headless_mode": task_schedule_task_details_add_installation_site_task_request_installation_sites_headless_mode,
                        "installation_path": task_schedule_task_details_add_installation_site_task_request_installation_sites_installation_path,
                        "managed_instance_id": test_managed_instance["id"],
                        "release_version": task_schedule_task_details_add_installation_site_task_request_installation_sites_release_version,
                    }],
                    "post_installation_actions": task_schedule_task_details_add_installation_site_task_request_post_installation_actions,
                },
                "crypto_task_request": {
                    "recording_duration_in_minutes": task_schedule_task_details_crypto_task_request_recording_duration_in_minutes,
                    "targets": [{
                        "application_installation_key": task_schedule_task_details_crypto_task_request_targets_application_installation_key,
                        "application_key": task_schedule_task_details_crypto_task_request_targets_application_key,
                        "container_key": task_schedule_task_details_crypto_task_request_targets_container_key,
                        "jre_key": task_schedule_task_details_crypto_task_request_targets_jre_key,
                        "managed_instance_id": test_managed_instance["id"],
                    }],
                    "waiting_period_in_minutes": task_schedule_task_details_crypto_task_request_waiting_period_in_minutes,
                },
                "deployed_application_migration_task_request": {
                    "targets": [{
                        "deployed_application_installation_key": task_schedule_task_details_deployed_application_migration_task_request_targets_deployed_application_installation_key,
                        "exclude_package_prefixes": task_schedule_task_details_deployed_application_migration_task_request_targets_exclude_package_prefixes,
                        "include_package_prefixes": task_schedule_task_details_deployed_application_migration_task_request_targets_include_package_prefixes,
                        "managed_instance_id": test_managed_instance["id"],
                        "source_jdk_version": task_schedule_task_details_deployed_application_migration_task_request_targets_source_jdk_version,
                        "target_jdk_version": task_schedule_task_details_deployed_application_migration_task_request_targets_target_jdk_version,
                    }],
                },
                "java_migration_task_request": {
                    "targets": [{
                        "application_installation_key": task_schedule_task_details_java_migration_task_request_targets_application_installation_key,
                        "exclude_package_prefixes": task_schedule_task_details_java_migration_task_request_targets_exclude_package_prefixes,
                        "include_package_prefixes": task_schedule_task_details_java_migration_task_request_targets_include_package_prefixes,
                        "managed_instance_id": test_managed_instance["id"],
                        "source_jdk_version": task_schedule_task_details_java_migration_task_request_targets_source_jdk_version,
                        "target_jdk_version": task_schedule_task_details_java_migration_task_request_targets_target_jdk_version,
                    }],
                },
                "jfr_task_request": {
                    "jfc_profile_name": test_profile["name"],
                    "jfc_v1": task_schedule_task_details_jfr_task_request_jfc_v1,
                    "jfc_v2": task_schedule_task_details_jfr_task_request_jfc_v2,
                    "recording_duration_in_minutes": task_schedule_task_details_jfr_task_request_recording_duration_in_minutes,
                    "recording_size_in_mb": task_schedule_task_details_jfr_task_request_recording_size_in_mb,
                    "targets": [{
                        "application_installation_key": task_schedule_task_details_jfr_task_request_targets_application_installation_key,
                        "application_key": task_schedule_task_details_jfr_task_request_targets_application_key,
                        "container_key": task_schedule_task_details_jfr_task_request_targets_container_key,
                        "jre_key": task_schedule_task_details_jfr_task_request_targets_jre_key,
                        "managed_instance_id": test_managed_instance["id"],
                    }],
                    "waiting_period_in_minutes": task_schedule_task_details_jfr_task_request_waiting_period_in_minutes,
                },
                "performance_tuning_task_request": {
                    "recording_duration_in_minutes": task_schedule_task_details_performance_tuning_task_request_recording_duration_in_minutes,
                    "targets": [{
                        "application_installation_key": task_schedule_task_details_performance_tuning_task_request_targets_application_installation_key,
                        "application_key": task_schedule_task_details_performance_tuning_task_request_targets_application_key,
                        "container_key": task_schedule_task_details_performance_tuning_task_request_targets_container_key,
                        "jre_key": task_schedule_task_details_performance_tuning_task_request_targets_jre_key,
                        "managed_instance_id": test_managed_instance["id"],
                    }],
                    "waiting_period_in_minutes": task_schedule_task_details_performance_tuning_task_request_waiting_period_in_minutes,
                },
                "remove_installation_site_task_request": {
                    "installation_sites": [{
                        "installation_key": task_schedule_task_details_remove_installation_site_task_request_installation_sites_installation_key,
                        "managed_instance_id": test_managed_instance["id"],
                    }],
                },
                "scan_java_server_task_request": {
                    "managed_instance_ids": task_schedule_task_details_scan_java_server_task_request_managed_instance_ids,
                },
                "scan_library_task_request": {
                    "dynamic_scan_duration_in_minutes": task_schedule_task_details_scan_library_task_request_dynamic_scan_duration_in_minutes,
                    "is_dynamic_scan": task_schedule_task_details_scan_library_task_request_is_dynamic_scan,
                    "managed_instance_ids": task_schedule_task_details_scan_library_task_request_managed_instance_ids,
                },
            })
        ```

        ## Import

        TaskSchedules can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Jms/taskSchedule:TaskSchedule test_task_schedule "id"
        ```

        :param str resource_name: The name of the resource.
        :param TaskScheduleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TaskScheduleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 execution_recurrences: Optional[pulumi.Input[_builtins.str]] = None,
                 fleet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 task_details: Optional[pulumi.Input[Union['TaskScheduleTaskDetailsArgs', 'TaskScheduleTaskDetailsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TaskScheduleArgs.__new__(TaskScheduleArgs)

            if execution_recurrences is None and not opts.urn:
                raise TypeError("Missing required property 'execution_recurrences'")
            __props__.__dict__["execution_recurrences"] = execution_recurrences
            if fleet_id is None and not opts.urn:
                raise TypeError("Missing required property 'fleet_id'")
            __props__.__dict__["fleet_id"] = fleet_id
            if task_details is None and not opts.urn:
                raise TypeError("Missing required property 'task_details'")
            __props__.__dict__["task_details"] = task_details
            __props__.__dict__["created_by"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_last_run"] = None
            __props__.__dict__["time_last_updated"] = None
            __props__.__dict__["time_next_run"] = None
        super(TaskSchedule, __self__).__init__(
            'oci:Jms/taskSchedule:TaskSchedule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            execution_recurrences: Optional[pulumi.Input[_builtins.str]] = None,
            fleet_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            task_details: Optional[pulumi.Input[Union['TaskScheduleTaskDetailsArgs', 'TaskScheduleTaskDetailsArgsDict']]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_last_run: Optional[pulumi.Input[_builtins.str]] = None,
            time_last_updated: Optional[pulumi.Input[_builtins.str]] = None,
            time_next_run: Optional[pulumi.Input[_builtins.str]] = None) -> 'TaskSchedule':
        """
        Get an existing TaskSchedule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_by: Name of the task creator.
        :param pulumi.Input[_builtins.str] execution_recurrences: (Updatable) Recurrence specification for the task schedule execution (formatted according to [RFC-5545](https://icalendar.org/RFC-Specifications/iCalendar-RFC-5545/)). To run daily for 10 occurrences starts on September 2, 2024 09:00 EDT, it should be 'DTSTART;TZID=America/New_York:20240902T090000 RRULE:FREQ=DAILY;COUNT=10'. To run every 3 hours from 9:00 AM to 5:00 PM on August 5, 2024 EDT, it should be 'DTSTART;TZID=America/New_York:20240805T090000 RRULE:FREQ=HOURLY;INTERVAL=3;UNTIL=20240805T170000Z'.
        :param pulumi.Input[_builtins.str] fleet_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
        :param pulumi.Input[_builtins.str] name: The name of the task schedule.
        :param pulumi.Input[_builtins.str] state: All possible status of task schedule.
        :param pulumi.Input[Union['TaskScheduleTaskDetailsArgs', 'TaskScheduleTaskDetailsArgsDict']] task_details: (Updatable) The minimum details of a task.
        :param pulumi.Input[_builtins.str] time_created: The date and time the task schedule was created (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param pulumi.Input[_builtins.str] time_last_run: The date and time the task schedule ran last (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param pulumi.Input[_builtins.str] time_last_updated: The date and time the task schedule was last updated (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param pulumi.Input[_builtins.str] time_next_run: The date and time the task schedule will run next (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TaskScheduleState.__new__(_TaskScheduleState)

        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["execution_recurrences"] = execution_recurrences
        __props__.__dict__["fleet_id"] = fleet_id
        __props__.__dict__["name"] = name
        __props__.__dict__["state"] = state
        __props__.__dict__["task_details"] = task_details
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_last_run"] = time_last_run
        __props__.__dict__["time_last_updated"] = time_last_updated
        __props__.__dict__["time_next_run"] = time_next_run
        return TaskSchedule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the task creator.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="executionRecurrences")
    def execution_recurrences(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Recurrence specification for the task schedule execution (formatted according to [RFC-5545](https://icalendar.org/RFC-Specifications/iCalendar-RFC-5545/)). To run daily for 10 occurrences starts on September 2, 2024 09:00 EDT, it should be 'DTSTART;TZID=America/New_York:20240902T090000 RRULE:FREQ=DAILY;COUNT=10'. To run every 3 hours from 9:00 AM to 5:00 PM on August 5, 2024 EDT, it should be 'DTSTART;TZID=America/New_York:20240805T090000 RRULE:FREQ=HOURLY;INTERVAL=3;UNTIL=20240805T170000Z'.
        """
        return pulumi.get(self, "execution_recurrences")

    @_builtins.property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
        """
        return pulumi.get(self, "fleet_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the task schedule.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        All possible status of task schedule.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="taskDetails")
    def task_details(self) -> pulumi.Output['outputs.TaskScheduleTaskDetails']:
        """
        (Updatable) The minimum details of a task.
        """
        return pulumi.get(self, "task_details")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the task schedule was created (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeLastRun")
    def time_last_run(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the task schedule ran last (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_last_run")

    @_builtins.property
    @pulumi.getter(name="timeLastUpdated")
    def time_last_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the task schedule was last updated (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_last_updated")

    @_builtins.property
    @pulumi.getter(name="timeNextRun")
    def time_next_run(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the task schedule will run next (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_next_run")

