# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetLogAnalyticsEntityTypesResult',
    'AwaitableGetLogAnalyticsEntityTypesResult',
    'get_log_analytics_entity_types',
    'get_log_analytics_entity_types_output',
]

@pulumi.output_type
class GetLogAnalyticsEntityTypesResult:
    """
    A collection of values returned by getLogAnalyticsEntityTypes.
    """
    def __init__(__self__, cloud_type=None, filters=None, id=None, log_analytics_entity_type_collections=None, name=None, name_contains=None, namespace=None, state=None):
        if cloud_type and not isinstance(cloud_type, str):
            raise TypeError("Expected argument 'cloud_type' to be a str")
        pulumi.set(__self__, "cloud_type", cloud_type)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if log_analytics_entity_type_collections and not isinstance(log_analytics_entity_type_collections, list):
            raise TypeError("Expected argument 'log_analytics_entity_type_collections' to be a list")
        pulumi.set(__self__, "log_analytics_entity_type_collections", log_analytics_entity_type_collections)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if name_contains and not isinstance(name_contains, str):
            raise TypeError("Expected argument 'name_contains' to be a str")
        pulumi.set(__self__, "name_contains", name_contains)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="cloudType")
    def cloud_type(self) -> Optional[_builtins.str]:
        """
        Log analytics entity type group. This can be CLOUD (OCI) or NON_CLOUD otherwise.
        """
        return pulumi.get(self, "cloud_type")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetLogAnalyticsEntityTypesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="logAnalyticsEntityTypeCollections")
    def log_analytics_entity_type_collections(self) -> Sequence['outputs.GetLogAnalyticsEntityTypesLogAnalyticsEntityTypeCollectionResult']:
        """
        The list of log_analytics_entity_type_collection.
        """
        return pulumi.get(self, "log_analytics_entity_type_collections")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Log analytics entity type name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nameContains")
    def name_contains(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_contains")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current lifecycle state of the log analytics entity type.
        """
        return pulumi.get(self, "state")


class AwaitableGetLogAnalyticsEntityTypesResult(GetLogAnalyticsEntityTypesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLogAnalyticsEntityTypesResult(
            cloud_type=self.cloud_type,
            filters=self.filters,
            id=self.id,
            log_analytics_entity_type_collections=self.log_analytics_entity_type_collections,
            name=self.name,
            name_contains=self.name_contains,
            namespace=self.namespace,
            state=self.state)


def get_log_analytics_entity_types(cloud_type: Optional[_builtins.str] = None,
                                   filters: Optional[Sequence[Union['GetLogAnalyticsEntityTypesFilterArgs', 'GetLogAnalyticsEntityTypesFilterArgsDict']]] = None,
                                   name: Optional[_builtins.str] = None,
                                   name_contains: Optional[_builtins.str] = None,
                                   namespace: Optional[_builtins.str] = None,
                                   state: Optional[_builtins.str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLogAnalyticsEntityTypesResult:
    """
    This data source provides the list of Log Analytics Entity Types in Oracle Cloud Infrastructure Log Analytics service.

    Return a list of log analytics entity types.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_log_analytics_entity_types = oci.LogAnalytics.get_log_analytics_entity_types(namespace=log_analytics_entity_type_namespace,
        cloud_type=log_analytics_entity_type_cloud_type,
        name=log_analytics_entity_type_name,
        name_contains=log_analytics_entity_type_name_contains,
        state=log_analytics_entity_type_state)
    ```


    :param _builtins.str cloud_type: A filter to return CLOUD or NON_CLOUD entity types.
    :param _builtins.str name: A filter to return only log analytics entity types whose name matches the entire name given. The match is case-insensitive.
    :param _builtins.str name_contains: A filter to return only log analytics entity types whose name or internalName contains name given. The match is case-insensitive.
    :param _builtins.str namespace: The Logging Analytics namespace used for the request.
    :param _builtins.str state: A filter to return only those log analytics entity types with the specified lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['cloudType'] = cloud_type
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['nameContains'] = name_contains
    __args__['namespace'] = namespace
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LogAnalytics/getLogAnalyticsEntityTypes:getLogAnalyticsEntityTypes', __args__, opts=opts, typ=GetLogAnalyticsEntityTypesResult).value

    return AwaitableGetLogAnalyticsEntityTypesResult(
        cloud_type=pulumi.get(__ret__, 'cloud_type'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        log_analytics_entity_type_collections=pulumi.get(__ret__, 'log_analytics_entity_type_collections'),
        name=pulumi.get(__ret__, 'name'),
        name_contains=pulumi.get(__ret__, 'name_contains'),
        namespace=pulumi.get(__ret__, 'namespace'),
        state=pulumi.get(__ret__, 'state'))
def get_log_analytics_entity_types_output(cloud_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          filters: Optional[pulumi.Input[Optional[Sequence[Union['GetLogAnalyticsEntityTypesFilterArgs', 'GetLogAnalyticsEntityTypesFilterArgsDict']]]]] = None,
                                          name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          name_contains: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          namespace: Optional[pulumi.Input[_builtins.str]] = None,
                                          state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLogAnalyticsEntityTypesResult]:
    """
    This data source provides the list of Log Analytics Entity Types in Oracle Cloud Infrastructure Log Analytics service.

    Return a list of log analytics entity types.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_log_analytics_entity_types = oci.LogAnalytics.get_log_analytics_entity_types(namespace=log_analytics_entity_type_namespace,
        cloud_type=log_analytics_entity_type_cloud_type,
        name=log_analytics_entity_type_name,
        name_contains=log_analytics_entity_type_name_contains,
        state=log_analytics_entity_type_state)
    ```


    :param _builtins.str cloud_type: A filter to return CLOUD or NON_CLOUD entity types.
    :param _builtins.str name: A filter to return only log analytics entity types whose name matches the entire name given. The match is case-insensitive.
    :param _builtins.str name_contains: A filter to return only log analytics entity types whose name or internalName contains name given. The match is case-insensitive.
    :param _builtins.str namespace: The Logging Analytics namespace used for the request.
    :param _builtins.str state: A filter to return only those log analytics entity types with the specified lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['cloudType'] = cloud_type
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['nameContains'] = name_contains
    __args__['namespace'] = namespace
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:LogAnalytics/getLogAnalyticsEntityTypes:getLogAnalyticsEntityTypes', __args__, opts=opts, typ=GetLogAnalyticsEntityTypesResult)
    return __ret__.apply(lambda __response__: GetLogAnalyticsEntityTypesResult(
        cloud_type=pulumi.get(__response__, 'cloud_type'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        log_analytics_entity_type_collections=pulumi.get(__response__, 'log_analytics_entity_type_collections'),
        name=pulumi.get(__response__, 'name'),
        name_contains=pulumi.get(__response__, 'name_contains'),
        namespace=pulumi.get(__response__, 'namespace'),
        state=pulumi.get(__response__, 'state')))
