# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetUnifiedAgentConfigurationsResult',
    'AwaitableGetUnifiedAgentConfigurationsResult',
    'get_unified_agent_configurations',
    'get_unified_agent_configurations_output',
]

@pulumi.output_type
class GetUnifiedAgentConfigurationsResult:
    """
    A collection of values returned by getUnifiedAgentConfigurations.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, group_id=None, id=None, is_compartment_id_in_subtree=None, log_id=None, state=None, unified_agent_configuration_collections=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if group_id and not isinstance(group_id, str):
            raise TypeError("Expected argument 'group_id' to be a str")
        pulumi.set(__self__, "group_id", group_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_compartment_id_in_subtree and not isinstance(is_compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'is_compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "is_compartment_id_in_subtree", is_compartment_id_in_subtree)
        if log_id and not isinstance(log_id, str):
            raise TypeError("Expected argument 'log_id' to be a str")
        pulumi.set(__self__, "log_id", log_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if unified_agent_configuration_collections and not isinstance(unified_agent_configuration_collections, list):
            raise TypeError("Expected argument 'unified_agent_configuration_collections' to be a list")
        pulumi.set(__self__, "unified_agent_configuration_collections", unified_agent_configuration_collections)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment that the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        The user-friendly display name. This must be unique within the enclosing resource, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetUnifiedAgentConfigurationsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isCompartmentIdInSubtree")
    def is_compartment_id_in_subtree(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "is_compartment_id_in_subtree")

    @_builtins.property
    @pulumi.getter(name="logId")
    def log_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "log_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The pipeline state.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="unifiedAgentConfigurationCollections")
    def unified_agent_configuration_collections(self) -> Sequence['outputs.GetUnifiedAgentConfigurationsUnifiedAgentConfigurationCollectionResult']:
        """
        The list of unified_agent_configuration_collection.
        """
        return pulumi.get(self, "unified_agent_configuration_collections")


class AwaitableGetUnifiedAgentConfigurationsResult(GetUnifiedAgentConfigurationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUnifiedAgentConfigurationsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            group_id=self.group_id,
            id=self.id,
            is_compartment_id_in_subtree=self.is_compartment_id_in_subtree,
            log_id=self.log_id,
            state=self.state,
            unified_agent_configuration_collections=self.unified_agent_configuration_collections)


def get_unified_agent_configurations(compartment_id: Optional[_builtins.str] = None,
                                     display_name: Optional[_builtins.str] = None,
                                     filters: Optional[Sequence[Union['GetUnifiedAgentConfigurationsFilterArgs', 'GetUnifiedAgentConfigurationsFilterArgsDict']]] = None,
                                     group_id: Optional[_builtins.str] = None,
                                     is_compartment_id_in_subtree: Optional[_builtins.bool] = None,
                                     log_id: Optional[_builtins.str] = None,
                                     state: Optional[_builtins.str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUnifiedAgentConfigurationsResult:
    """
    This data source provides the list of Unified Agent Configurations in Oracle Cloud Infrastructure Logging service.

    Lists all unified agent configurations in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_unified_agent_configurations = oci.Logging.get_unified_agent_configurations(compartment_id=compartment_id,
        display_name=unified_agent_configuration_display_name,
        group_id=test_group["id"],
        is_compartment_id_in_subtree=unified_agent_configuration_is_compartment_id_in_subtree,
        log_id=test_log["id"],
        state=unified_agent_configuration_state)
    ```


    :param _builtins.str compartment_id: Compartment OCID to list resources in. See compartmentIdInSubtree for nested compartments traversal.
    :param _builtins.str display_name: Resource name.
    :param _builtins.str group_id: The OCID of a group or a dynamic group.
    :param _builtins.bool is_compartment_id_in_subtree: Specifies whether or not nested compartments should be traversed. Defaults to false.
    :param _builtins.str log_id: Custom log OCID to list resources with the log as destination.
    :param _builtins.str state: Lifecycle state of the log object
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['groupId'] = group_id
    __args__['isCompartmentIdInSubtree'] = is_compartment_id_in_subtree
    __args__['logId'] = log_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Logging/getUnifiedAgentConfigurations:getUnifiedAgentConfigurations', __args__, opts=opts, typ=GetUnifiedAgentConfigurationsResult).value

    return AwaitableGetUnifiedAgentConfigurationsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        group_id=pulumi.get(__ret__, 'group_id'),
        id=pulumi.get(__ret__, 'id'),
        is_compartment_id_in_subtree=pulumi.get(__ret__, 'is_compartment_id_in_subtree'),
        log_id=pulumi.get(__ret__, 'log_id'),
        state=pulumi.get(__ret__, 'state'),
        unified_agent_configuration_collections=pulumi.get(__ret__, 'unified_agent_configuration_collections'))
def get_unified_agent_configurations_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                            display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            filters: Optional[pulumi.Input[Optional[Sequence[Union['GetUnifiedAgentConfigurationsFilterArgs', 'GetUnifiedAgentConfigurationsFilterArgsDict']]]]] = None,
                                            group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            is_compartment_id_in_subtree: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                            log_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUnifiedAgentConfigurationsResult]:
    """
    This data source provides the list of Unified Agent Configurations in Oracle Cloud Infrastructure Logging service.

    Lists all unified agent configurations in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_unified_agent_configurations = oci.Logging.get_unified_agent_configurations(compartment_id=compartment_id,
        display_name=unified_agent_configuration_display_name,
        group_id=test_group["id"],
        is_compartment_id_in_subtree=unified_agent_configuration_is_compartment_id_in_subtree,
        log_id=test_log["id"],
        state=unified_agent_configuration_state)
    ```


    :param _builtins.str compartment_id: Compartment OCID to list resources in. See compartmentIdInSubtree for nested compartments traversal.
    :param _builtins.str display_name: Resource name.
    :param _builtins.str group_id: The OCID of a group or a dynamic group.
    :param _builtins.bool is_compartment_id_in_subtree: Specifies whether or not nested compartments should be traversed. Defaults to false.
    :param _builtins.str log_id: Custom log OCID to list resources with the log as destination.
    :param _builtins.str state: Lifecycle state of the log object
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['groupId'] = group_id
    __args__['isCompartmentIdInSubtree'] = is_compartment_id_in_subtree
    __args__['logId'] = log_id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Logging/getUnifiedAgentConfigurations:getUnifiedAgentConfigurations', __args__, opts=opts, typ=GetUnifiedAgentConfigurationsResult)
    return __ret__.apply(lambda __response__: GetUnifiedAgentConfigurationsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        group_id=pulumi.get(__response__, 'group_id'),
        id=pulumi.get(__response__, 'id'),
        is_compartment_id_in_subtree=pulumi.get(__response__, 'is_compartment_id_in_subtree'),
        log_id=pulumi.get(__response__, 'log_id'),
        state=pulumi.get(__response__, 'state'),
        unified_agent_configuration_collections=pulumi.get(__response__, 'unified_agent_configuration_collections')))
