# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NamedCredentialArgs', 'NamedCredential']

@pulumi.input_type
class NamedCredentialArgs:
    def __init__(__self__, *,
                 management_agent_id: pulumi.Input[_builtins.str],
                 properties: pulumi.Input[Sequence[pulumi.Input['NamedCredentialPropertyArgs']]],
                 type: pulumi.Input[_builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NamedCredential resource.
        :param pulumi.Input[_builtins.str] management_agent_id: The Management Agent parent resource to associate this named credential with.  This is the ManagementAgent resource OCID.
        :param pulumi.Input[Sequence[pulumi.Input['NamedCredentialPropertyArgs']]] properties: (Updatable) Properties for the named credential
        :param pulumi.Input[_builtins.str] type: The type of the Named Credential.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) Description of the Named Credential.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] name: Identifier for Named Credential. This is unique for the Management Agent.
        """
        pulumi.set(__self__, "management_agent_id", management_agent_id)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "type", type)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="managementAgentId")
    def management_agent_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Management Agent parent resource to associate this named credential with.  This is the ManagementAgent resource OCID.
        """
        return pulumi.get(self, "management_agent_id")

    @management_agent_id.setter
    def management_agent_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "management_agent_id", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> pulumi.Input[Sequence[pulumi.Input['NamedCredentialPropertyArgs']]]:
        """
        (Updatable) Properties for the named credential
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: pulumi.Input[Sequence[pulumi.Input['NamedCredentialPropertyArgs']]]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the Named Credential.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Description of the Named Credential.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier for Named Credential. This is unique for the Management Agent.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _NamedCredentialState:
    def __init__(__self__, *,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 management_agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input['NamedCredentialPropertyArgs']]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NamedCredential resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) Description of the Named Credential.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] management_agent_id: The Management Agent parent resource to associate this named credential with.  This is the ManagementAgent resource OCID.
        :param pulumi.Input[_builtins.str] name: Identifier for Named Credential. This is unique for the Management Agent.
        :param pulumi.Input[Sequence[pulumi.Input['NamedCredentialPropertyArgs']]] properties: (Updatable) Properties for the named credential
        :param pulumi.Input[_builtins.str] state: The current state of the named credential
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The time the Named Credential was created. An RFC3339 formatted datetime string
        :param pulumi.Input[_builtins.str] time_updated: The time the Named Credential data was last updated. An RFC3339 formatted datetime string
        :param pulumi.Input[_builtins.str] type: The type of the Named Credential.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if management_agent_id is not None:
            pulumi.set(__self__, "management_agent_id", management_agent_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Description of the Named Credential.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="managementAgentId")
    def management_agent_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Management Agent parent resource to associate this named credential with.  This is the ManagementAgent resource OCID.
        """
        return pulumi.get(self, "management_agent_id")

    @management_agent_id.setter
    def management_agent_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "management_agent_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier for Named Credential. This is unique for the Management Agent.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NamedCredentialPropertyArgs']]]]:
        """
        (Updatable) Properties for the named credential
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NamedCredentialPropertyArgs']]]]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the named credential
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the Named Credential was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the Named Credential data was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the Named Credential.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("oci:ManagementAgent/namedCredential:NamedCredential")
class NamedCredential(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 management_agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NamedCredentialPropertyArgs', 'NamedCredentialPropertyArgsDict']]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Named Credential resource in Oracle Cloud Infrastructure Management Agent service.

        Named credential creation request to given Management Agent.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_named_credential = oci.managementagent.NamedCredential("test_named_credential",
            management_agent_id=test_management_agent["id"],
            name=named_credential_name,
            properties=[
                {
                    "name": named_credential_properties_name,
                    "value": named_credential_properties_value,
                    "value_category": named_credential_properties_value_category,
                },
                {
                    "name": named_credential_properties_name2,
                    "value": named_credential_properties_value2,
                    "value_category": named_credential_properties_value_category2,
                },
            ],
            type=named_credential_type,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=named_credential_description,
            freeform_tags={
                "bar-key": "value",
            })
        example_named_credential = oci.managementagent.NamedCredential("example_named_credential",
            management_agent_id=test_management_agent["id"],
            name="Example1",
            properties=[
                {
                    "name": "DBUserName",
                    "value": vault_secret_id,
                    "value_category": "SECRET_IDENTIFIER",
                },
                {
                    "name": "DBPassword",
                    "value": vault_secret2_id,
                    "value_category": "SECRET_IDENTIFIER",
                },
            ],
            type="DBCREDS",
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description="Example DBCREDS named credential for management agent",
            freeform_tags={
                "bar-key": "value",
            })
        ```

        ## Import

        NamedCredentials can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:ManagementAgent/namedCredential:NamedCredential test_named_credential "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) Description of the Named Credential.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] management_agent_id: The Management Agent parent resource to associate this named credential with.  This is the ManagementAgent resource OCID.
        :param pulumi.Input[_builtins.str] name: Identifier for Named Credential. This is unique for the Management Agent.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NamedCredentialPropertyArgs', 'NamedCredentialPropertyArgsDict']]]] properties: (Updatable) Properties for the named credential
        :param pulumi.Input[_builtins.str] type: The type of the Named Credential.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NamedCredentialArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Named Credential resource in Oracle Cloud Infrastructure Management Agent service.

        Named credential creation request to given Management Agent.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_named_credential = oci.managementagent.NamedCredential("test_named_credential",
            management_agent_id=test_management_agent["id"],
            name=named_credential_name,
            properties=[
                {
                    "name": named_credential_properties_name,
                    "value": named_credential_properties_value,
                    "value_category": named_credential_properties_value_category,
                },
                {
                    "name": named_credential_properties_name2,
                    "value": named_credential_properties_value2,
                    "value_category": named_credential_properties_value_category2,
                },
            ],
            type=named_credential_type,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=named_credential_description,
            freeform_tags={
                "bar-key": "value",
            })
        example_named_credential = oci.managementagent.NamedCredential("example_named_credential",
            management_agent_id=test_management_agent["id"],
            name="Example1",
            properties=[
                {
                    "name": "DBUserName",
                    "value": vault_secret_id,
                    "value_category": "SECRET_IDENTIFIER",
                },
                {
                    "name": "DBPassword",
                    "value": vault_secret2_id,
                    "value_category": "SECRET_IDENTIFIER",
                },
            ],
            type="DBCREDS",
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description="Example DBCREDS named credential for management agent",
            freeform_tags={
                "bar-key": "value",
            })
        ```

        ## Import

        NamedCredentials can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:ManagementAgent/namedCredential:NamedCredential test_named_credential "id"
        ```

        :param str resource_name: The name of the resource.
        :param NamedCredentialArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NamedCredentialArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 management_agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NamedCredentialPropertyArgs', 'NamedCredentialPropertyArgsDict']]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NamedCredentialArgs.__new__(NamedCredentialArgs)

            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["freeform_tags"] = freeform_tags
            if management_agent_id is None and not opts.urn:
                raise TypeError("Missing required property 'management_agent_id'")
            __props__.__dict__["management_agent_id"] = management_agent_id
            __props__.__dict__["name"] = name
            if properties is None and not opts.urn:
                raise TypeError("Missing required property 'properties'")
            __props__.__dict__["properties"] = properties
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(NamedCredential, __self__).__init__(
            'oci:ManagementAgent/namedCredential:NamedCredential',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            management_agent_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            properties: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NamedCredentialPropertyArgs', 'NamedCredentialPropertyArgsDict']]]]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'NamedCredential':
        """
        Get an existing NamedCredential resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) Description of the Named Credential.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] management_agent_id: The Management Agent parent resource to associate this named credential with.  This is the ManagementAgent resource OCID.
        :param pulumi.Input[_builtins.str] name: Identifier for Named Credential. This is unique for the Management Agent.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NamedCredentialPropertyArgs', 'NamedCredentialPropertyArgsDict']]]] properties: (Updatable) Properties for the named credential
        :param pulumi.Input[_builtins.str] state: The current state of the named credential
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The time the Named Credential was created. An RFC3339 formatted datetime string
        :param pulumi.Input[_builtins.str] time_updated: The time the Named Credential data was last updated. An RFC3339 formatted datetime string
        :param pulumi.Input[_builtins.str] type: The type of the Named Credential.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NamedCredentialState.__new__(_NamedCredentialState)

        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["management_agent_id"] = management_agent_id
        __props__.__dict__["name"] = name
        __props__.__dict__["properties"] = properties
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["type"] = type
        return NamedCredential(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Description of the Named Credential.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="managementAgentId")
    def management_agent_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Management Agent parent resource to associate this named credential with.  This is the ManagementAgent resource OCID.
        """
        return pulumi.get(self, "management_agent_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier for Named Credential. This is unique for the Management Agent.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Sequence['outputs.NamedCredentialProperty']]:
        """
        (Updatable) Properties for the named credential
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the named credential
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The time the Named Credential was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The time the Named Credential data was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the Named Credential.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

