# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['MarketplaceExternalAttestedMetadataArgs', 'MarketplaceExternalAttestedMetadata']

@pulumi.input_type
class MarketplaceExternalAttestedMetadataArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 instance_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a MarketplaceExternalAttestedMetadata resource.
        :param pulumi.Input[_builtins.str] compartment_id: compartment that associated instance is in
        :param pulumi.Input[_builtins.str] instance_id: unique id that identifies the associated instance
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "instance_id", instance_id)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        compartment that associated instance is in
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        unique id that identifies the associated instance


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)


@pulumi.input_type
class _MarketplaceExternalAttestedMetadataState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 serialized_jwt: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MarketplaceExternalAttestedMetadata resources.
        :param pulumi.Input[_builtins.str] compartment_id: compartment that associated instance is in
        :param pulumi.Input[_builtins.str] instance_id: unique id that identifies the associated instance
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] serialized_jwt: The serialized JWT token, containing header, payload, signature
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if serialized_jwt is not None:
            pulumi.set(__self__, "serialized_jwt", serialized_jwt)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        compartment that associated instance is in
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        unique id that identifies the associated instance


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="serializedJwt")
    def serialized_jwt(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The serialized JWT token, containing header, payload, signature
        """
        return pulumi.get(self, "serialized_jwt")

    @serialized_jwt.setter
    def serialized_jwt(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "serialized_jwt", value)


@pulumi.type_token("oci:Marketplace/marketplaceExternalAttestedMetadata:MarketplaceExternalAttestedMetadata")
class MarketplaceExternalAttestedMetadata(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Marketplace External Attested Metadata resource in Oracle Cloud Infrastructure Marketplace service.

        Generates attested marketplace metadata

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_marketplace_external_attested_metadata = oci.marketplace.MarketplaceExternalAttestedMetadata("test_marketplace_external_attested_metadata",
            compartment_id=compartment_id,
            instance_id=test_instance["id"])
        ```

        ## Import

        MarketplaceExternalAttestedMetadata can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Marketplace/marketplaceExternalAttestedMetadata:MarketplaceExternalAttestedMetadata test_marketplace_external_attested_metadata "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: compartment that associated instance is in
        :param pulumi.Input[_builtins.str] instance_id: unique id that identifies the associated instance
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MarketplaceExternalAttestedMetadataArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Marketplace External Attested Metadata resource in Oracle Cloud Infrastructure Marketplace service.

        Generates attested marketplace metadata

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_marketplace_external_attested_metadata = oci.marketplace.MarketplaceExternalAttestedMetadata("test_marketplace_external_attested_metadata",
            compartment_id=compartment_id,
            instance_id=test_instance["id"])
        ```

        ## Import

        MarketplaceExternalAttestedMetadata can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Marketplace/marketplaceExternalAttestedMetadata:MarketplaceExternalAttestedMetadata test_marketplace_external_attested_metadata "id"
        ```

        :param str resource_name: The name of the resource.
        :param MarketplaceExternalAttestedMetadataArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MarketplaceExternalAttestedMetadataArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MarketplaceExternalAttestedMetadataArgs.__new__(MarketplaceExternalAttestedMetadataArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["serialized_jwt"] = None
        super(MarketplaceExternalAttestedMetadata, __self__).__init__(
            'oci:Marketplace/marketplaceExternalAttestedMetadata:MarketplaceExternalAttestedMetadata',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            serialized_jwt: Optional[pulumi.Input[_builtins.str]] = None) -> 'MarketplaceExternalAttestedMetadata':
        """
        Get an existing MarketplaceExternalAttestedMetadata resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: compartment that associated instance is in
        :param pulumi.Input[_builtins.str] instance_id: unique id that identifies the associated instance
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] serialized_jwt: The serialized JWT token, containing header, payload, signature
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MarketplaceExternalAttestedMetadataState.__new__(_MarketplaceExternalAttestedMetadataState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["serialized_jwt"] = serialized_jwt
        return MarketplaceExternalAttestedMetadata(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        compartment that associated instance is in
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        unique id that identifies the associated instance


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="serializedJwt")
    def serialized_jwt(self) -> pulumi.Output[_builtins.str]:
        """
        The serialized JWT token, containing header, payload, signature
        """
        return pulumi.get(self, "serialized_jwt")

