# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'MediaAssetLockArgs',
    'MediaAssetLockArgsDict',
    'MediaAssetMediaAssetTagArgs',
    'MediaAssetMediaAssetTagArgsDict',
    'MediaAssetMetadataArgs',
    'MediaAssetMetadataArgsDict',
    'MediaWorkflowConfigurationLockArgs',
    'MediaWorkflowConfigurationLockArgsDict',
    'MediaWorkflowJobLockArgs',
    'MediaWorkflowJobLockArgsDict',
    'MediaWorkflowJobOutputArgs',
    'MediaWorkflowJobOutputArgsDict',
    'MediaWorkflowJobTaskLifecycleStateArgs',
    'MediaWorkflowJobTaskLifecycleStateArgsDict',
    'MediaWorkflowLockArgs',
    'MediaWorkflowLockArgsDict',
    'MediaWorkflowTaskArgs',
    'MediaWorkflowTaskArgsDict',
    'StreamCdnConfigConfigArgs',
    'StreamCdnConfigConfigArgsDict',
    'StreamCdnConfigLockArgs',
    'StreamCdnConfigLockArgsDict',
    'StreamDistributionChannelLockArgs',
    'StreamDistributionChannelLockArgsDict',
    'StreamPackagingConfigEncryptionArgs',
    'StreamPackagingConfigEncryptionArgsDict',
    'StreamPackagingConfigLockArgs',
    'StreamPackagingConfigLockArgsDict',
    'GetMediaAssetDistributionChannelAttachmentLockArgs',
    'GetMediaAssetDistributionChannelAttachmentLockArgsDict',
    'GetMediaAssetsFilterArgs',
    'GetMediaAssetsFilterArgsDict',
    'GetMediaWorkflowConfigurationsFilterArgs',
    'GetMediaWorkflowConfigurationsFilterArgsDict',
    'GetMediaWorkflowJobFactsFilterArgs',
    'GetMediaWorkflowJobFactsFilterArgsDict',
    'GetMediaWorkflowJobsFilterArgs',
    'GetMediaWorkflowJobsFilterArgsDict',
    'GetMediaWorkflowsFilterArgs',
    'GetMediaWorkflowsFilterArgsDict',
    'GetStreamCdnConfigsFilterArgs',
    'GetStreamCdnConfigsFilterArgsDict',
    'GetStreamDistributionChannelsFilterArgs',
    'GetStreamDistributionChannelsFilterArgsDict',
    'GetStreamPackagingConfigsFilterArgs',
    'GetStreamPackagingConfigsFilterArgsDict',
]

MYPY = False

if not MYPY:
    class MediaAssetLockArgsDict(TypedDict):
        compartment_id: pulumi.Input[_builtins.str]
        """
        (Updatable) The compartment ID of the lock.
        """
        type: pulumi.Input[_builtins.str]
        """
        Type of the lock.
        """
        message: NotRequired[pulumi.Input[_builtins.str]]
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        related_resource_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        time_created: NotRequired[pulumi.Input[_builtins.str]]
        """
        When the lock was created.
        """
elif False:
    MediaAssetLockArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MediaAssetLockArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 message: Optional[pulumi.Input[_builtins.str]] = None,
                 related_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The compartment ID of the lock.
        :param pulumi.Input[_builtins.str] type: Type of the lock.
        :param pulumi.Input[_builtins.str] message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param pulumi.Input[_builtins.str] related_resource_id: The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param pulumi.Input[_builtins.str] time_created: When the lock was created.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "type", type)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if related_resource_id is not None:
            pulumi.set(__self__, "related_resource_id", related_resource_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The compartment ID of the lock.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of the lock.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message", value)

    @_builtins.property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @related_resource_id.setter
    def related_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "related_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the lock was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)


if not MYPY:
    class MediaAssetMediaAssetTagArgsDict(TypedDict):
        value: pulumi.Input[_builtins.str]
        """
        (Updatable) Tag of the MediaAsset.
        """
        type: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) Type of the tag.
        """
elif False:
    MediaAssetMediaAssetTagArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MediaAssetMediaAssetTagArgs:
    def __init__(__self__, *,
                 value: pulumi.Input[_builtins.str],
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] value: (Updatable) Tag of the MediaAsset.
        :param pulumi.Input[_builtins.str] type: (Updatable) Type of the tag.
        """
        pulumi.set(__self__, "value", value)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Tag of the MediaAsset.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Type of the tag.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class MediaAssetMetadataArgsDict(TypedDict):
        metadata: pulumi.Input[_builtins.str]
        """
        (Updatable) JSON string containing the technial metadata for the media asset.
        """
elif False:
    MediaAssetMetadataArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MediaAssetMetadataArgs:
    def __init__(__self__, *,
                 metadata: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] metadata: (Updatable) JSON string containing the technial metadata for the media asset.
        """
        pulumi.set(__self__, "metadata", metadata)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) JSON string containing the technial metadata for the media asset.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "metadata", value)


if not MYPY:
    class MediaWorkflowConfigurationLockArgsDict(TypedDict):
        compartment_id: pulumi.Input[_builtins.str]
        """
        (Updatable) The compartment ID of the lock.
        """
        type: pulumi.Input[_builtins.str]
        """
        Type of the lock.
        """
        message: NotRequired[pulumi.Input[_builtins.str]]
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        related_resource_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        time_created: NotRequired[pulumi.Input[_builtins.str]]
        """
        When the lock was created.
        """
elif False:
    MediaWorkflowConfigurationLockArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MediaWorkflowConfigurationLockArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 message: Optional[pulumi.Input[_builtins.str]] = None,
                 related_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The compartment ID of the lock.
        :param pulumi.Input[_builtins.str] type: Type of the lock.
        :param pulumi.Input[_builtins.str] message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param pulumi.Input[_builtins.str] related_resource_id: The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param pulumi.Input[_builtins.str] time_created: When the lock was created.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "type", type)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if related_resource_id is not None:
            pulumi.set(__self__, "related_resource_id", related_resource_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The compartment ID of the lock.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of the lock.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message", value)

    @_builtins.property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @related_resource_id.setter
    def related_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "related_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the lock was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)


if not MYPY:
    class MediaWorkflowJobLockArgsDict(TypedDict):
        compartment_id: pulumi.Input[_builtins.str]
        """
        (Updatable) The compartment ID of the lock.
        """
        type: pulumi.Input[_builtins.str]
        """
        Type of the lock.
        """
        message: NotRequired[pulumi.Input[_builtins.str]]
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        related_resource_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        time_created: NotRequired[pulumi.Input[_builtins.str]]
        """
        When the lock was created.
        """
elif False:
    MediaWorkflowJobLockArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MediaWorkflowJobLockArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 message: Optional[pulumi.Input[_builtins.str]] = None,
                 related_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The compartment ID of the lock.
        :param pulumi.Input[_builtins.str] type: Type of the lock.
        :param pulumi.Input[_builtins.str] message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param pulumi.Input[_builtins.str] related_resource_id: The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param pulumi.Input[_builtins.str] time_created: When the lock was created.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "type", type)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if related_resource_id is not None:
            pulumi.set(__self__, "related_resource_id", related_resource_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The compartment ID of the lock.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of the lock.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message", value)

    @_builtins.property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @related_resource_id.setter
    def related_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "related_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the lock was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)


if not MYPY:
    class MediaWorkflowJobOutputArgsDict(TypedDict):
        asset_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Type of job output.
        """
        bucket: NotRequired[pulumi.Input[_builtins.str]]
        """
        The bucket name of the job output.
        """
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID associated with the job output.
        """
        namespace: NotRequired[pulumi.Input[_builtins.str]]
        """
        The namespace name of the job output.
        """
        object: NotRequired[pulumi.Input[_builtins.str]]
        """
        The object name of the job output.
        """
elif False:
    MediaWorkflowJobOutputArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MediaWorkflowJobOutputArgs:
    def __init__(__self__, *,
                 asset_type: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 id: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 object: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] asset_type: Type of job output.
        :param pulumi.Input[_builtins.str] bucket: The bucket name of the job output.
        :param pulumi.Input[_builtins.str] id: The ID associated with the job output.
        :param pulumi.Input[_builtins.str] namespace: The namespace name of the job output.
        :param pulumi.Input[_builtins.str] object: The object name of the job output.
        """
        if asset_type is not None:
            pulumi.set(__self__, "asset_type", asset_type)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @_builtins.property
    @pulumi.getter(name="assetType")
    def asset_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of job output.
        """
        return pulumi.get(self, "asset_type")

    @asset_type.setter
    def asset_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "asset_type", value)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The bucket name of the job output.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID associated with the job output.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace name of the job output.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The object name of the job output.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object", value)


if not MYPY:
    class MediaWorkflowJobTaskLifecycleStateArgsDict(TypedDict):
        key: NotRequired[pulumi.Input[_builtins.str]]
        """
        Unique key within a MediaWorkflowJob for the task.
        """
        lifecycle_details: NotRequired[pulumi.Input[_builtins.str]]
        """
        The lifecycle details of MediaWorkflowJob task.
        """
        state: NotRequired[pulumi.Input[_builtins.str]]
        """
        The current state of the MediaWorkflowJob task.
        """
elif False:
    MediaWorkflowJobTaskLifecycleStateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MediaWorkflowJobTaskLifecycleStateArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] key: Unique key within a MediaWorkflowJob for the task.
        :param pulumi.Input[_builtins.str] lifecycle_details: The lifecycle details of MediaWorkflowJob task.
        :param pulumi.Input[_builtins.str] state: The current state of the MediaWorkflowJob task.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique key within a MediaWorkflowJob for the task.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The lifecycle details of MediaWorkflowJob task.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the MediaWorkflowJob task.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)


if not MYPY:
    class MediaWorkflowLockArgsDict(TypedDict):
        compartment_id: pulumi.Input[_builtins.str]
        """
        (Updatable) The compartment ID of the lock.
        """
        type: pulumi.Input[_builtins.str]
        """
        Type of the lock.
        """
        message: NotRequired[pulumi.Input[_builtins.str]]
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        related_resource_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        time_created: NotRequired[pulumi.Input[_builtins.str]]
        """
        When the lock was created.
        """
elif False:
    MediaWorkflowLockArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MediaWorkflowLockArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 message: Optional[pulumi.Input[_builtins.str]] = None,
                 related_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The compartment ID of the lock.
        :param pulumi.Input[_builtins.str] type: Type of the lock.
        :param pulumi.Input[_builtins.str] message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param pulumi.Input[_builtins.str] related_resource_id: The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param pulumi.Input[_builtins.str] time_created: When the lock was created.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "type", type)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if related_resource_id is not None:
            pulumi.set(__self__, "related_resource_id", related_resource_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The compartment ID of the lock.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of the lock.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message", value)

    @_builtins.property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @related_resource_id.setter
    def related_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "related_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the lock was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)


if not MYPY:
    class MediaWorkflowTaskArgsDict(TypedDict):
        key: pulumi.Input[_builtins.str]
        """
        (Updatable) A unique identifier for this task within its workflow. Keys are used to reference a task within workflows and MediaWorkflowJobs. Tasks are referenced as prerequisites and to track output and state.
        """
        parameters: pulumi.Input[_builtins.str]
        """
        (Updatable) Data specifiying how this task is to be run. The data is a JSON object that must conform to the JSON Schema specified by the parameters of the MediaWorkflowTaskDeclaration this task references. The parameters may contain values or references to other parameters.
        """
        type: pulumi.Input[_builtins.str]
        """
        (Updatable) The type of process to run at this task. Refers to the name of a MediaWorkflowTaskDeclaration.
        """
        version: pulumi.Input[_builtins.str]
        """
        (Updatable) The version of the MediaWorkflowTaskDeclaration.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        enable_parameter_reference: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) Allows this task to be conditionally enabled.  If no value or a blank value is given, the task is unconditionally enbled.  Otherwise the given string specifies a parameter of the job created for this task's workflow using the JSON pointer syntax. The JSON pointer is validated when a job is created from the workflow of this task.
        """
        enable_when_referenced_parameter_equals: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        (Updatable) Used in conjunction with enableParameterReference to conditionally enable a task.  When a job is created from the workflow of this task, the task will only be enabled if the value of the parameter specified by enableParameterReference is equal to the value of this property. This property must be prenset if and only if a enableParameterReference is given. The value is a JSON node.
        """
        prerequisites: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        (Updatable) Keys to the other tasks in this workflow that must be completed before execution of this task can begin.
        """
elif False:
    MediaWorkflowTaskArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MediaWorkflowTaskArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[_builtins.str],
                 parameters: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 version: pulumi.Input[_builtins.str],
                 enable_parameter_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_when_referenced_parameter_equals: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 prerequisites: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.str] key: (Updatable) A unique identifier for this task within its workflow. Keys are used to reference a task within workflows and MediaWorkflowJobs. Tasks are referenced as prerequisites and to track output and state.
        :param pulumi.Input[_builtins.str] parameters: (Updatable) Data specifiying how this task is to be run. The data is a JSON object that must conform to the JSON Schema specified by the parameters of the MediaWorkflowTaskDeclaration this task references. The parameters may contain values or references to other parameters.
        :param pulumi.Input[_builtins.str] type: (Updatable) The type of process to run at this task. Refers to the name of a MediaWorkflowTaskDeclaration.
        :param pulumi.Input[_builtins.str] version: (Updatable) The version of the MediaWorkflowTaskDeclaration.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] enable_parameter_reference: (Updatable) Allows this task to be conditionally enabled.  If no value or a blank value is given, the task is unconditionally enbled.  Otherwise the given string specifies a parameter of the job created for this task's workflow using the JSON pointer syntax. The JSON pointer is validated when a job is created from the workflow of this task.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] enable_when_referenced_parameter_equals: (Updatable) Used in conjunction with enableParameterReference to conditionally enable a task.  When a job is created from the workflow of this task, the task will only be enabled if the value of the parameter specified by enableParameterReference is equal to the value of this property. This property must be prenset if and only if a enableParameterReference is given. The value is a JSON node.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] prerequisites: (Updatable) Keys to the other tasks in this workflow that must be completed before execution of this task can begin.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "version", version)
        if enable_parameter_reference is not None:
            pulumi.set(__self__, "enable_parameter_reference", enable_parameter_reference)
        if enable_when_referenced_parameter_equals is not None:
            pulumi.set(__self__, "enable_when_referenced_parameter_equals", enable_when_referenced_parameter_equals)
        if prerequisites is not None:
            pulumi.set(__self__, "prerequisites", prerequisites)

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) A unique identifier for this task within its workflow. Keys are used to reference a task within workflows and MediaWorkflowJobs. Tasks are referenced as prerequisites and to track output and state.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Data specifiying how this task is to be run. The data is a JSON object that must conform to the JSON Schema specified by the parameters of the MediaWorkflowTaskDeclaration this task references. The parameters may contain values or references to other parameters.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The type of process to run at this task. Refers to the name of a MediaWorkflowTaskDeclaration.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The version of the MediaWorkflowTaskDeclaration.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="enableParameterReference")
    def enable_parameter_reference(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Allows this task to be conditionally enabled.  If no value or a blank value is given, the task is unconditionally enbled.  Otherwise the given string specifies a parameter of the job created for this task's workflow using the JSON pointer syntax. The JSON pointer is validated when a job is created from the workflow of this task.
        """
        return pulumi.get(self, "enable_parameter_reference")

    @enable_parameter_reference.setter
    def enable_parameter_reference(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enable_parameter_reference", value)

    @_builtins.property
    @pulumi.getter(name="enableWhenReferencedParameterEquals")
    def enable_when_referenced_parameter_equals(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Used in conjunction with enableParameterReference to conditionally enable a task.  When a job is created from the workflow of this task, the task will only be enabled if the value of the parameter specified by enableParameterReference is equal to the value of this property. This property must be prenset if and only if a enableParameterReference is given. The value is a JSON node.
        """
        return pulumi.get(self, "enable_when_referenced_parameter_equals")

    @enable_when_referenced_parameter_equals.setter
    def enable_when_referenced_parameter_equals(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "enable_when_referenced_parameter_equals", value)

    @_builtins.property
    @pulumi.getter
    def prerequisites(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Keys to the other tasks in this workflow that must be completed before execution of this task can begin.
        """
        return pulumi.get(self, "prerequisites")

    @prerequisites.setter
    def prerequisites(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "prerequisites", value)


if not MYPY:
    class StreamCdnConfigConfigArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        (Updatable) The name of the CDN configuration type.
        """
        edge_hostname: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) The hostname of the CDN edge server to use when building CDN URLs.
        """
        edge_path_prefix: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) The path to prepend when building CDN URLs.
        """
        edge_token_key: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) The encryption key to use for edge token authentication.
        """
        edge_token_salt: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) Salt to use when encrypting authentication token.
        """
        is_edge_token_auth: NotRequired[pulumi.Input[_builtins.bool]]
        """
        (Updatable) Whether token authentication should be used at the CDN edge.
        """
        origin_auth_secret_key_a: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) The shared secret key A, two for errorless key rotation.
        """
        origin_auth_secret_key_b: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) The shared secret key B, two for errorless key rotation.
        """
        origin_auth_secret_key_nonce_a: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) Nonce identifier for originAuthSecretKeyA (used to determine key used to sign).
        """
        origin_auth_secret_key_nonce_b: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) Nonce identifier for originAuthSecretKeyB (used to determine key used to sign).
        """
        origin_auth_sign_encryption: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) The type of encryption used to compute the signature.
        """
        origin_auth_sign_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Updatable) The type of data used to compute the signature.
        """
elif False:
    StreamCdnConfigConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StreamCdnConfigConfigArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 edge_hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 edge_path_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 edge_token_key: Optional[pulumi.Input[_builtins.str]] = None,
                 edge_token_salt: Optional[pulumi.Input[_builtins.str]] = None,
                 is_edge_token_auth: Optional[pulumi.Input[_builtins.bool]] = None,
                 origin_auth_secret_key_a: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_auth_secret_key_b: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_auth_secret_key_nonce_a: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_auth_secret_key_nonce_b: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_auth_sign_encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_auth_sign_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: (Updatable) The name of the CDN configuration type.
        :param pulumi.Input[_builtins.str] edge_hostname: (Updatable) The hostname of the CDN edge server to use when building CDN URLs.
        :param pulumi.Input[_builtins.str] edge_path_prefix: (Updatable) The path to prepend when building CDN URLs.
        :param pulumi.Input[_builtins.str] edge_token_key: (Updatable) The encryption key to use for edge token authentication.
        :param pulumi.Input[_builtins.str] edge_token_salt: (Updatable) Salt to use when encrypting authentication token.
        :param pulumi.Input[_builtins.bool] is_edge_token_auth: (Updatable) Whether token authentication should be used at the CDN edge.
        :param pulumi.Input[_builtins.str] origin_auth_secret_key_a: (Updatable) The shared secret key A, two for errorless key rotation.
        :param pulumi.Input[_builtins.str] origin_auth_secret_key_b: (Updatable) The shared secret key B, two for errorless key rotation.
        :param pulumi.Input[_builtins.str] origin_auth_secret_key_nonce_a: (Updatable) Nonce identifier for originAuthSecretKeyA (used to determine key used to sign).
        :param pulumi.Input[_builtins.str] origin_auth_secret_key_nonce_b: (Updatable) Nonce identifier for originAuthSecretKeyB (used to determine key used to sign).
        :param pulumi.Input[_builtins.str] origin_auth_sign_encryption: (Updatable) The type of encryption used to compute the signature.
        :param pulumi.Input[_builtins.str] origin_auth_sign_type: (Updatable) The type of data used to compute the signature.
        """
        pulumi.set(__self__, "type", type)
        if edge_hostname is not None:
            pulumi.set(__self__, "edge_hostname", edge_hostname)
        if edge_path_prefix is not None:
            pulumi.set(__self__, "edge_path_prefix", edge_path_prefix)
        if edge_token_key is not None:
            pulumi.set(__self__, "edge_token_key", edge_token_key)
        if edge_token_salt is not None:
            pulumi.set(__self__, "edge_token_salt", edge_token_salt)
        if is_edge_token_auth is not None:
            pulumi.set(__self__, "is_edge_token_auth", is_edge_token_auth)
        if origin_auth_secret_key_a is not None:
            pulumi.set(__self__, "origin_auth_secret_key_a", origin_auth_secret_key_a)
        if origin_auth_secret_key_b is not None:
            pulumi.set(__self__, "origin_auth_secret_key_b", origin_auth_secret_key_b)
        if origin_auth_secret_key_nonce_a is not None:
            pulumi.set(__self__, "origin_auth_secret_key_nonce_a", origin_auth_secret_key_nonce_a)
        if origin_auth_secret_key_nonce_b is not None:
            pulumi.set(__self__, "origin_auth_secret_key_nonce_b", origin_auth_secret_key_nonce_b)
        if origin_auth_sign_encryption is not None:
            pulumi.set(__self__, "origin_auth_sign_encryption", origin_auth_sign_encryption)
        if origin_auth_sign_type is not None:
            pulumi.set(__self__, "origin_auth_sign_type", origin_auth_sign_type)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The name of the CDN configuration type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="edgeHostname")
    def edge_hostname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The hostname of the CDN edge server to use when building CDN URLs.
        """
        return pulumi.get(self, "edge_hostname")

    @edge_hostname.setter
    def edge_hostname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edge_hostname", value)

    @_builtins.property
    @pulumi.getter(name="edgePathPrefix")
    def edge_path_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The path to prepend when building CDN URLs.
        """
        return pulumi.get(self, "edge_path_prefix")

    @edge_path_prefix.setter
    def edge_path_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edge_path_prefix", value)

    @_builtins.property
    @pulumi.getter(name="edgeTokenKey")
    def edge_token_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The encryption key to use for edge token authentication.
        """
        return pulumi.get(self, "edge_token_key")

    @edge_token_key.setter
    def edge_token_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edge_token_key", value)

    @_builtins.property
    @pulumi.getter(name="edgeTokenSalt")
    def edge_token_salt(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Salt to use when encrypting authentication token.
        """
        return pulumi.get(self, "edge_token_salt")

    @edge_token_salt.setter
    def edge_token_salt(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edge_token_salt", value)

    @_builtins.property
    @pulumi.getter(name="isEdgeTokenAuth")
    def is_edge_token_auth(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Whether token authentication should be used at the CDN edge.
        """
        return pulumi.get(self, "is_edge_token_auth")

    @is_edge_token_auth.setter
    def is_edge_token_auth(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_edge_token_auth", value)

    @_builtins.property
    @pulumi.getter(name="originAuthSecretKeyA")
    def origin_auth_secret_key_a(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The shared secret key A, two for errorless key rotation.
        """
        return pulumi.get(self, "origin_auth_secret_key_a")

    @origin_auth_secret_key_a.setter
    def origin_auth_secret_key_a(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "origin_auth_secret_key_a", value)

    @_builtins.property
    @pulumi.getter(name="originAuthSecretKeyB")
    def origin_auth_secret_key_b(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The shared secret key B, two for errorless key rotation.
        """
        return pulumi.get(self, "origin_auth_secret_key_b")

    @origin_auth_secret_key_b.setter
    def origin_auth_secret_key_b(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "origin_auth_secret_key_b", value)

    @_builtins.property
    @pulumi.getter(name="originAuthSecretKeyNonceA")
    def origin_auth_secret_key_nonce_a(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Nonce identifier for originAuthSecretKeyA (used to determine key used to sign).
        """
        return pulumi.get(self, "origin_auth_secret_key_nonce_a")

    @origin_auth_secret_key_nonce_a.setter
    def origin_auth_secret_key_nonce_a(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "origin_auth_secret_key_nonce_a", value)

    @_builtins.property
    @pulumi.getter(name="originAuthSecretKeyNonceB")
    def origin_auth_secret_key_nonce_b(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Nonce identifier for originAuthSecretKeyB (used to determine key used to sign).
        """
        return pulumi.get(self, "origin_auth_secret_key_nonce_b")

    @origin_auth_secret_key_nonce_b.setter
    def origin_auth_secret_key_nonce_b(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "origin_auth_secret_key_nonce_b", value)

    @_builtins.property
    @pulumi.getter(name="originAuthSignEncryption")
    def origin_auth_sign_encryption(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The type of encryption used to compute the signature.
        """
        return pulumi.get(self, "origin_auth_sign_encryption")

    @origin_auth_sign_encryption.setter
    def origin_auth_sign_encryption(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "origin_auth_sign_encryption", value)

    @_builtins.property
    @pulumi.getter(name="originAuthSignType")
    def origin_auth_sign_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The type of data used to compute the signature.
        """
        return pulumi.get(self, "origin_auth_sign_type")

    @origin_auth_sign_type.setter
    def origin_auth_sign_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "origin_auth_sign_type", value)


if not MYPY:
    class StreamCdnConfigLockArgsDict(TypedDict):
        compartment_id: pulumi.Input[_builtins.str]
        """
        The compartment ID of the lock.
        """
        type: pulumi.Input[_builtins.str]
        """
        Type of the lock.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        message: NotRequired[pulumi.Input[_builtins.str]]
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        related_resource_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        time_created: NotRequired[pulumi.Input[_builtins.str]]
        """
        When the lock was created.
        """
elif False:
    StreamCdnConfigLockArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StreamCdnConfigLockArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 message: Optional[pulumi.Input[_builtins.str]] = None,
                 related_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] compartment_id: The compartment ID of the lock.
        :param pulumi.Input[_builtins.str] type: Type of the lock.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param pulumi.Input[_builtins.str] related_resource_id: The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param pulumi.Input[_builtins.str] time_created: When the lock was created.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "type", type)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if related_resource_id is not None:
            pulumi.set(__self__, "related_resource_id", related_resource_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        The compartment ID of the lock.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of the lock.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message", value)

    @_builtins.property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @related_resource_id.setter
    def related_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "related_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the lock was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)


if not MYPY:
    class StreamDistributionChannelLockArgsDict(TypedDict):
        compartment_id: pulumi.Input[_builtins.str]
        """
        (Updatable) The compartment ID of the lock.
        """
        type: pulumi.Input[_builtins.str]
        """
        Type of the lock.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        message: NotRequired[pulumi.Input[_builtins.str]]
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        related_resource_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        time_created: NotRequired[pulumi.Input[_builtins.str]]
        """
        When the lock was created.
        """
elif False:
    StreamDistributionChannelLockArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StreamDistributionChannelLockArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 message: Optional[pulumi.Input[_builtins.str]] = None,
                 related_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The compartment ID of the lock.
        :param pulumi.Input[_builtins.str] type: Type of the lock.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param pulumi.Input[_builtins.str] related_resource_id: The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param pulumi.Input[_builtins.str] time_created: When the lock was created.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "type", type)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if related_resource_id is not None:
            pulumi.set(__self__, "related_resource_id", related_resource_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The compartment ID of the lock.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of the lock.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message", value)

    @_builtins.property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @related_resource_id.setter
    def related_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "related_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the lock was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)


if not MYPY:
    class StreamPackagingConfigEncryptionArgsDict(TypedDict):
        algorithm: pulumi.Input[_builtins.str]
        """
        The encryption algorithm for the stream packaging configuration.
        """
        kms_key_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The identifier of the customer managed Vault KMS symmetric encryption key (null if Oracle managed).
        """
elif False:
    StreamPackagingConfigEncryptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StreamPackagingConfigEncryptionArgs:
    def __init__(__self__, *,
                 algorithm: pulumi.Input[_builtins.str],
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] algorithm: The encryption algorithm for the stream packaging configuration.
        :param pulumi.Input[_builtins.str] kms_key_id: The identifier of the customer managed Vault KMS symmetric encryption key (null if Oracle managed).
        """
        pulumi.set(__self__, "algorithm", algorithm)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> pulumi.Input[_builtins.str]:
        """
        The encryption algorithm for the stream packaging configuration.
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "algorithm", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier of the customer managed Vault KMS symmetric encryption key (null if Oracle managed).
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_id", value)


if not MYPY:
    class StreamPackagingConfigLockArgsDict(TypedDict):
        compartment_id: pulumi.Input[_builtins.str]
        """
        The compartment ID of the lock.
        """
        type: pulumi.Input[_builtins.str]
        """
        Type of the lock.
        """
        message: NotRequired[pulumi.Input[_builtins.str]]
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        related_resource_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        time_created: NotRequired[pulumi.Input[_builtins.str]]
        """
        When the lock was created.
        """
elif False:
    StreamPackagingConfigLockArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StreamPackagingConfigLockArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 message: Optional[pulumi.Input[_builtins.str]] = None,
                 related_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] compartment_id: The compartment ID of the lock.
        :param pulumi.Input[_builtins.str] type: Type of the lock.
        :param pulumi.Input[_builtins.str] message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param pulumi.Input[_builtins.str] related_resource_id: The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param pulumi.Input[_builtins.str] time_created: When the lock was created.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "type", type)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if related_resource_id is not None:
            pulumi.set(__self__, "related_resource_id", related_resource_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        The compartment ID of the lock.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of the lock.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message", value)

    @_builtins.property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @related_resource_id.setter
    def related_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "related_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the lock was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)


if not MYPY:
    class GetMediaAssetDistributionChannelAttachmentLockArgsDict(TypedDict):
        compartment_id: _builtins.str
        """
        The compartment ID of the lock.
        """
        message: _builtins.str
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        related_resource_id: _builtins.str
        """
        The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        time_created: _builtins.str
        """
        When the lock was created.
        """
        type: _builtins.str
        """
        Type of the lock.
        """
elif False:
    GetMediaAssetDistributionChannelAttachmentLockArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetMediaAssetDistributionChannelAttachmentLockArgs:
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 message: _builtins.str,
                 related_resource_id: _builtins.str,
                 time_created: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str compartment_id: The compartment ID of the lock.
        :param _builtins.str message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param _builtins.str related_resource_id: The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param _builtins.str time_created: When the lock was created.
        :param _builtins.str type: Type of the lock.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "related_resource_id", related_resource_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The compartment ID of the lock.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: _builtins.str):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: _builtins.str):
        pulumi.set(self, "message", value)

    @_builtins.property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> _builtins.str:
        """
        The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @related_resource_id.setter
    def related_resource_id(self, value: _builtins.str):
        pulumi.set(self, "related_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        When the lock was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: _builtins.str):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the lock.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: _builtins.str):
        pulumi.set(self, "type", value)


if not MYPY:
    class GetMediaAssetsFilterArgsDict(TypedDict):
        name: _builtins.str
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetMediaAssetsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetMediaAssetsFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetMediaWorkflowConfigurationsFilterArgsDict(TypedDict):
        name: _builtins.str
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetMediaWorkflowConfigurationsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetMediaWorkflowConfigurationsFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetMediaWorkflowJobFactsFilterArgsDict(TypedDict):
        name: _builtins.str
        """
        Unique name. It is read-only and generated for the fact.
        """
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetMediaWorkflowJobFactsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetMediaWorkflowJobFactsFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Unique name. It is read-only and generated for the fact.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Unique name. It is read-only and generated for the fact.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetMediaWorkflowJobsFilterArgsDict(TypedDict):
        name: _builtins.str
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetMediaWorkflowJobsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetMediaWorkflowJobsFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetMediaWorkflowsFilterArgsDict(TypedDict):
        name: _builtins.str
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetMediaWorkflowsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetMediaWorkflowsFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetStreamCdnConfigsFilterArgsDict(TypedDict):
        name: _builtins.str
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetStreamCdnConfigsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetStreamCdnConfigsFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetStreamDistributionChannelsFilterArgsDict(TypedDict):
        name: _builtins.str
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetStreamDistributionChannelsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetStreamDistributionChannelsFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetStreamPackagingConfigsFilterArgsDict(TypedDict):
        name: _builtins.str
        values: Sequence[_builtins.str]
        regex: NotRequired[_builtins.bool]
elif False:
    GetStreamPackagingConfigsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetStreamPackagingConfigsFilterArgs:
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "regex", value)


