# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetReplicasResult',
    'AwaitableGetReplicasResult',
    'get_replicas',
    'get_replicas_output',
]

@pulumi.output_type
class GetReplicasResult:
    """
    A collection of values returned by getReplicas.
    """
    def __init__(__self__, compartment_id=None, configuration_id=None, db_system_id=None, display_name=None, filters=None, id=None, is_up_to_date=None, replica_id=None, replicas=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if configuration_id and not isinstance(configuration_id, str):
            raise TypeError("Expected argument 'configuration_id' to be a str")
        pulumi.set(__self__, "configuration_id", configuration_id)
        if db_system_id and not isinstance(db_system_id, str):
            raise TypeError("Expected argument 'db_system_id' to be a str")
        pulumi.set(__self__, "db_system_id", db_system_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_up_to_date and not isinstance(is_up_to_date, bool):
            raise TypeError("Expected argument 'is_up_to_date' to be a bool")
        pulumi.set(__self__, "is_up_to_date", is_up_to_date)
        if replica_id and not isinstance(replica_id, str):
            raise TypeError("Expected argument 'replica_id' to be a str")
        pulumi.set(__self__, "replica_id", replica_id)
        if replicas and not isinstance(replicas, list):
            raise TypeError("Expected argument 'replicas' to be a list")
        pulumi.set(__self__, "replicas", replicas)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment that contains the read replica.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the Configuration to be used by the read replica.
        """
        return pulumi.get(self, "configuration_id")

    @_builtins.property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the DB System the read replica is associated with.
        """
        return pulumi.get(self, "db_system_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        The user-friendly name for the read replica. It does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetReplicasFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isUpToDate")
    def is_up_to_date(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "is_up_to_date")

    @_builtins.property
    @pulumi.getter(name="replicaId")
    def replica_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "replica_id")

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> Sequence['outputs.GetReplicasReplicaResult']:
        """
        The list of replicas.
        """
        return pulumi.get(self, "replicas")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The state of the read replica.
        """
        return pulumi.get(self, "state")


class AwaitableGetReplicasResult(GetReplicasResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetReplicasResult(
            compartment_id=self.compartment_id,
            configuration_id=self.configuration_id,
            db_system_id=self.db_system_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            is_up_to_date=self.is_up_to_date,
            replica_id=self.replica_id,
            replicas=self.replicas,
            state=self.state)


def get_replicas(compartment_id: Optional[_builtins.str] = None,
                 configuration_id: Optional[_builtins.str] = None,
                 db_system_id: Optional[_builtins.str] = None,
                 display_name: Optional[_builtins.str] = None,
                 filters: Optional[Sequence[Union['GetReplicasFilterArgs', 'GetReplicasFilterArgsDict']]] = None,
                 is_up_to_date: Optional[_builtins.bool] = None,
                 replica_id: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetReplicasResult:
    """
    This data source provides the list of Replicas in Oracle Cloud Infrastructure MySQL Database service.

    Lists all the read replicas that match the specified filters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_replicas = oci.Mysql.get_replicas(compartment_id=compartment_id,
        configuration_id=test_mysql_configuration["id"],
        db_system_id=test_mysql_db_system["id"],
        display_name=replica_display_name,
        is_up_to_date=replica_is_up_to_date,
        replica_id=test_replica["id"],
        state=replica_state)
    ```


    :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str configuration_id: The requested Configuration instance.
    :param _builtins.str db_system_id: The DB System [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str display_name: A filter to return only the resource matching the given display name exactly.
    :param _builtins.bool is_up_to_date: Filter instances if they are using the latest revision of the Configuration they are associated with.
    :param _builtins.str replica_id: The read replica [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str state: The LifecycleState of the read replica.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['configurationId'] = configuration_id
    __args__['dbSystemId'] = db_system_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['isUpToDate'] = is_up_to_date
    __args__['replicaId'] = replica_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Mysql/getReplicas:getReplicas', __args__, opts=opts, typ=GetReplicasResult).value

    return AwaitableGetReplicasResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        configuration_id=pulumi.get(__ret__, 'configuration_id'),
        db_system_id=pulumi.get(__ret__, 'db_system_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_up_to_date=pulumi.get(__ret__, 'is_up_to_date'),
        replica_id=pulumi.get(__ret__, 'replica_id'),
        replicas=pulumi.get(__ret__, 'replicas'),
        state=pulumi.get(__ret__, 'state'))
def get_replicas_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                        configuration_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        db_system_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        filters: Optional[pulumi.Input[Optional[Sequence[Union['GetReplicasFilterArgs', 'GetReplicasFilterArgsDict']]]]] = None,
                        is_up_to_date: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                        replica_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetReplicasResult]:
    """
    This data source provides the list of Replicas in Oracle Cloud Infrastructure MySQL Database service.

    Lists all the read replicas that match the specified filters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_replicas = oci.Mysql.get_replicas(compartment_id=compartment_id,
        configuration_id=test_mysql_configuration["id"],
        db_system_id=test_mysql_db_system["id"],
        display_name=replica_display_name,
        is_up_to_date=replica_is_up_to_date,
        replica_id=test_replica["id"],
        state=replica_state)
    ```


    :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str configuration_id: The requested Configuration instance.
    :param _builtins.str db_system_id: The DB System [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str display_name: A filter to return only the resource matching the given display name exactly.
    :param _builtins.bool is_up_to_date: Filter instances if they are using the latest revision of the Configuration they are associated with.
    :param _builtins.str replica_id: The read replica [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str state: The LifecycleState of the read replica.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['configurationId'] = configuration_id
    __args__['dbSystemId'] = db_system_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['isUpToDate'] = is_up_to_date
    __args__['replicaId'] = replica_id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Mysql/getReplicas:getReplicas', __args__, opts=opts, typ=GetReplicasResult)
    return __ret__.apply(lambda __response__: GetReplicasResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        configuration_id=pulumi.get(__response__, 'configuration_id'),
        db_system_id=pulumi.get(__response__, 'db_system_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        is_up_to_date=pulumi.get(__response__, 'is_up_to_date'),
        replica_id=pulumi.get(__response__, 'replica_id'),
        replicas=pulumi.get(__response__, 'replicas'),
        state=pulumi.get(__response__, 'state')))
