# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetTablesResult',
    'AwaitableGetTablesResult',
    'get_tables',
    'get_tables_output',
]

@pulumi.output_type
class GetTablesResult:
    """
    A collection of values returned by getTables.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, name=None, state=None, table_collections=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if table_collections and not isinstance(table_collections, list):
            raise TypeError("Expected argument 'table_collections' to be a list")
        pulumi.set(__self__, "table_collections", table_collections)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        Compartment Identifier.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetTablesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Human-friendly table name, immutable.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The state of a table.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="tableCollections")
    def table_collections(self) -> Sequence['outputs.GetTablesTableCollectionResult']:
        """
        The list of table_collection.
        """
        return pulumi.get(self, "table_collections")


class AwaitableGetTablesResult(GetTablesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTablesResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            name=self.name,
            state=self.state,
            table_collections=self.table_collections)


def get_tables(compartment_id: Optional[_builtins.str] = None,
               filters: Optional[Sequence[Union['GetTablesFilterArgs', 'GetTablesFilterArgsDict']]] = None,
               name: Optional[_builtins.str] = None,
               state: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTablesResult:
    """
    This data source provides the list of Tables in Oracle Cloud Infrastructure NoSQL Database service.

    Get a list of tables in a compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_tables = oci.Nosql.get_tables(compartment_id=compartment_id,
        name=table_name,
        state=table_state)
    ```


    :param _builtins.str compartment_id: The ID of a table's compartment.
    :param _builtins.str name: A shell-globbing-style (*?[]) filter for names.
    :param _builtins.str state: Filter list by the lifecycle state of the item.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Nosql/getTables:getTables', __args__, opts=opts, typ=GetTablesResult).value

    return AwaitableGetTablesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        state=pulumi.get(__ret__, 'state'),
        table_collections=pulumi.get(__ret__, 'table_collections'))
def get_tables_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                      filters: Optional[pulumi.Input[Optional[Sequence[Union['GetTablesFilterArgs', 'GetTablesFilterArgsDict']]]]] = None,
                      name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTablesResult]:
    """
    This data source provides the list of Tables in Oracle Cloud Infrastructure NoSQL Database service.

    Get a list of tables in a compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_tables = oci.Nosql.get_tables(compartment_id=compartment_id,
        name=table_name,
        state=table_state)
    ```


    :param _builtins.str compartment_id: The ID of a table's compartment.
    :param _builtins.str name: A shell-globbing-style (*?[]) filter for names.
    :param _builtins.str state: Filter list by the lifecycle state of the item.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Nosql/getTables:getTables', __args__, opts=opts, typ=GetTablesResult)
    return __ret__.apply(lambda __response__: GetTablesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        state=pulumi.get(__response__, 'state'),
        table_collections=pulumi.get(__response__, 'table_collections')))
