# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApiaccesscontrolPrivilegedApiControlArgs', 'ApiaccesscontrolPrivilegedApiControl']

@pulumi.input_type
class ApiaccesscontrolPrivilegedApiControlArgs:
    def __init__(__self__, *,
                 approver_group_id_lists: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 compartment_id: pulumi.Input[_builtins.str],
                 notification_topic_id: pulumi.Input[_builtins.str],
                 privileged_operation_lists: pulumi.Input[Sequence[pulumi.Input['ApiaccesscontrolPrivilegedApiControlPrivilegedOperationListArgs']]],
                 resource_type: pulumi.Input[_builtins.str],
                 resources: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 number_of_approvers: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a ApiaccesscontrolPrivilegedApiControl resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] approver_group_id_lists: (Updatable) List of user IAM group ids who can approve an privilegedApi request associated with a resource governed by this operator control.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the PrivilegedApiControl in.
        :param pulumi.Input[_builtins.str] notification_topic_id: (Updatable) The OCID of the Oracle Cloud Infrastructure Notification topic to publish messages related to this Delegation Control.
        :param pulumi.Input[Sequence[pulumi.Input['ApiaccesscontrolPrivilegedApiControlPrivilegedOperationListArgs']]] privileged_operation_lists: (Updatable) List of privileged operator operations. If Privileged API Managment is enabled for a resource it will be validated whether the operation done by the operator is a part of privileged operation.
        :param pulumi.Input[_builtins.str] resource_type: (Updatable) resourceType for which the PrivilegedApiControl is applicable
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resources: (Updatable) contains Resource details
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) Description of the privilegedApi control.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Name of the privilegedApi control It has to be unique.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.int] number_of_approvers: (Updatable) Number of approvers required to approve an privilegedApi request.
        """
        pulumi.set(__self__, "approver_group_id_lists", approver_group_id_lists)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "notification_topic_id", notification_topic_id)
        pulumi.set(__self__, "privileged_operation_lists", privileged_operation_lists)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "resources", resources)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if number_of_approvers is not None:
            pulumi.set(__self__, "number_of_approvers", number_of_approvers)

    @_builtins.property
    @pulumi.getter(name="approverGroupIdLists")
    def approver_group_id_lists(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        (Updatable) List of user IAM group ids who can approve an privilegedApi request associated with a resource governed by this operator control.
        """
        return pulumi.get(self, "approver_group_id_lists")

    @approver_group_id_lists.setter
    def approver_group_id_lists(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "approver_group_id_lists", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the PrivilegedApiControl in.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="notificationTopicId")
    def notification_topic_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The OCID of the Oracle Cloud Infrastructure Notification topic to publish messages related to this Delegation Control.
        """
        return pulumi.get(self, "notification_topic_id")

    @notification_topic_id.setter
    def notification_topic_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "notification_topic_id", value)

    @_builtins.property
    @pulumi.getter(name="privilegedOperationLists")
    def privileged_operation_lists(self) -> pulumi.Input[Sequence[pulumi.Input['ApiaccesscontrolPrivilegedApiControlPrivilegedOperationListArgs']]]:
        """
        (Updatable) List of privileged operator operations. If Privileged API Managment is enabled for a resource it will be validated whether the operation done by the operator is a part of privileged operation.
        """
        return pulumi.get(self, "privileged_operation_lists")

    @privileged_operation_lists.setter
    def privileged_operation_lists(self, value: pulumi.Input[Sequence[pulumi.Input['ApiaccesscontrolPrivilegedApiControlPrivilegedOperationListArgs']]]):
        pulumi.set(self, "privileged_operation_lists", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) resourceType for which the PrivilegedApiControl is applicable
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_type", value)

    @_builtins.property
    @pulumi.getter
    def resources(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        (Updatable) contains Resource details


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "resources", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Description of the privilegedApi control.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Name of the privilegedApi control It has to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="numberOfApprovers")
    def number_of_approvers(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Number of approvers required to approve an privilegedApi request.
        """
        return pulumi.get(self, "number_of_approvers")

    @number_of_approvers.setter
    def number_of_approvers(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "number_of_approvers", value)


@pulumi.input_type
class _ApiaccesscontrolPrivilegedApiControlState:
    def __init__(__self__, *,
                 approver_group_id_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_topic_id: Optional[pulumi.Input[_builtins.str]] = None,
                 number_of_approvers: Optional[pulumi.Input[_builtins.int]] = None,
                 privileged_operation_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ApiaccesscontrolPrivilegedApiControlPrivilegedOperationListArgs']]]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 state_details: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_deleted: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ApiaccesscontrolPrivilegedApiControl resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] approver_group_id_lists: (Updatable) List of user IAM group ids who can approve an privilegedApi request associated with a resource governed by this operator control.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the PrivilegedApiControl in.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) Description of the privilegedApi control.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Name of the privilegedApi control It has to be unique.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] lifecycle_details: A message that describes the current state of the PrivilegedApiControl in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        :param pulumi.Input[_builtins.str] notification_topic_id: (Updatable) The OCID of the Oracle Cloud Infrastructure Notification topic to publish messages related to this Delegation Control.
        :param pulumi.Input[_builtins.int] number_of_approvers: (Updatable) Number of approvers required to approve an privilegedApi request.
        :param pulumi.Input[Sequence[pulumi.Input['ApiaccesscontrolPrivilegedApiControlPrivilegedOperationListArgs']]] privileged_operation_lists: (Updatable) List of privileged operator operations. If Privileged API Managment is enabled for a resource it will be validated whether the operation done by the operator is a part of privileged operation.
        :param pulumi.Input[_builtins.str] resource_type: (Updatable) resourceType for which the PrivilegedApiControl is applicable
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resources: (Updatable) contains Resource details
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] state: The current state of the PrivilegedApiControl.
        :param pulumi.Input[_builtins.str] state_details: A message that describes the current state of the PrivilegedApiControl in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The date and time the PrivilegedApiControl was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_deleted: The date and time the PrivilegedApiControl was marked for delete, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_updated: The date and time the PrivilegedApiControl was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        if approver_group_id_lists is not None:
            pulumi.set(__self__, "approver_group_id_lists", approver_group_id_lists)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if notification_topic_id is not None:
            pulumi.set(__self__, "notification_topic_id", notification_topic_id)
        if number_of_approvers is not None:
            pulumi.set(__self__, "number_of_approvers", number_of_approvers)
        if privileged_operation_lists is not None:
            pulumi.set(__self__, "privileged_operation_lists", privileged_operation_lists)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_details is not None:
            pulumi.set(__self__, "state_details", state_details)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_deleted is not None:
            pulumi.set(__self__, "time_deleted", time_deleted)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="approverGroupIdLists")
    def approver_group_id_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) List of user IAM group ids who can approve an privilegedApi request associated with a resource governed by this operator control.
        """
        return pulumi.get(self, "approver_group_id_lists")

    @approver_group_id_lists.setter
    def approver_group_id_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "approver_group_id_lists", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the PrivilegedApiControl in.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Description of the privilegedApi control.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Name of the privilegedApi control It has to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message that describes the current state of the PrivilegedApiControl in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter(name="notificationTopicId")
    def notification_topic_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The OCID of the Oracle Cloud Infrastructure Notification topic to publish messages related to this Delegation Control.
        """
        return pulumi.get(self, "notification_topic_id")

    @notification_topic_id.setter
    def notification_topic_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notification_topic_id", value)

    @_builtins.property
    @pulumi.getter(name="numberOfApprovers")
    def number_of_approvers(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Number of approvers required to approve an privilegedApi request.
        """
        return pulumi.get(self, "number_of_approvers")

    @number_of_approvers.setter
    def number_of_approvers(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "number_of_approvers", value)

    @_builtins.property
    @pulumi.getter(name="privilegedOperationLists")
    def privileged_operation_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiaccesscontrolPrivilegedApiControlPrivilegedOperationListArgs']]]]:
        """
        (Updatable) List of privileged operator operations. If Privileged API Managment is enabled for a resource it will be validated whether the operation done by the operator is a part of privileged operation.
        """
        return pulumi.get(self, "privileged_operation_lists")

    @privileged_operation_lists.setter
    def privileged_operation_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiaccesscontrolPrivilegedApiControlPrivilegedOperationListArgs']]]]):
        pulumi.set(self, "privileged_operation_lists", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) resourceType for which the PrivilegedApiControl is applicable
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) contains Resource details


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "resources", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the PrivilegedApiControl.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="stateDetails")
    def state_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message that describes the current state of the PrivilegedApiControl in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "state_details")

    @state_details.setter
    def state_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state_details", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the PrivilegedApiControl was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeDeleted")
    def time_deleted(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the PrivilegedApiControl was marked for delete, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_deleted")

    @time_deleted.setter
    def time_deleted(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_deleted", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the PrivilegedApiControl was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:oci/apiaccesscontrolPrivilegedApiControl:ApiaccesscontrolPrivilegedApiControl")
class ApiaccesscontrolPrivilegedApiControl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 approver_group_id_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 notification_topic_id: Optional[pulumi.Input[_builtins.str]] = None,
                 number_of_approvers: Optional[pulumi.Input[_builtins.int]] = None,
                 privileged_operation_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApiaccesscontrolPrivilegedApiControlPrivilegedOperationListArgs', 'ApiaccesscontrolPrivilegedApiControlPrivilegedOperationListArgsDict']]]]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        This resource provides the Privileged Api Control resource in Oracle Cloud Infrastructure Apiaccesscontrol service.

        Creates a PrivilegedApiControl.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_privileged_api_control = oci.oci.ApiaccesscontrolPrivilegedApiControl("test_privileged_api_control",
            approver_group_id_lists=privileged_api_control_approver_group_id_list,
            compartment_id=compartment_id,
            notification_topic_id=test_notification_topic["id"],
            privileged_operation_lists=[{
                "api_name": test_api["name"],
                "attribute_names": privileged_api_control_privileged_operation_list_attribute_names,
                "entity_type": privileged_api_control_privileged_operation_list_entity_type,
            }],
            resource_type=privileged_api_control_resource_type,
            resources=privileged_api_control_resources,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=privileged_api_control_description,
            display_name=privileged_api_control_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            number_of_approvers=privileged_api_control_number_of_approvers)
        ```

        ## Import

        PrivilegedApiControls can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:oci/apiaccesscontrolPrivilegedApiControl:ApiaccesscontrolPrivilegedApiControl test_privileged_api_control "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] approver_group_id_lists: (Updatable) List of user IAM group ids who can approve an privilegedApi request associated with a resource governed by this operator control.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the PrivilegedApiControl in.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) Description of the privilegedApi control.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Name of the privilegedApi control It has to be unique.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] notification_topic_id: (Updatable) The OCID of the Oracle Cloud Infrastructure Notification topic to publish messages related to this Delegation Control.
        :param pulumi.Input[_builtins.int] number_of_approvers: (Updatable) Number of approvers required to approve an privilegedApi request.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApiaccesscontrolPrivilegedApiControlPrivilegedOperationListArgs', 'ApiaccesscontrolPrivilegedApiControlPrivilegedOperationListArgsDict']]]] privileged_operation_lists: (Updatable) List of privileged operator operations. If Privileged API Managment is enabled for a resource it will be validated whether the operation done by the operator is a part of privileged operation.
        :param pulumi.Input[_builtins.str] resource_type: (Updatable) resourceType for which the PrivilegedApiControl is applicable
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resources: (Updatable) contains Resource details
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApiaccesscontrolPrivilegedApiControlArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Privileged Api Control resource in Oracle Cloud Infrastructure Apiaccesscontrol service.

        Creates a PrivilegedApiControl.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_privileged_api_control = oci.oci.ApiaccesscontrolPrivilegedApiControl("test_privileged_api_control",
            approver_group_id_lists=privileged_api_control_approver_group_id_list,
            compartment_id=compartment_id,
            notification_topic_id=test_notification_topic["id"],
            privileged_operation_lists=[{
                "api_name": test_api["name"],
                "attribute_names": privileged_api_control_privileged_operation_list_attribute_names,
                "entity_type": privileged_api_control_privileged_operation_list_entity_type,
            }],
            resource_type=privileged_api_control_resource_type,
            resources=privileged_api_control_resources,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=privileged_api_control_description,
            display_name=privileged_api_control_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            number_of_approvers=privileged_api_control_number_of_approvers)
        ```

        ## Import

        PrivilegedApiControls can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:oci/apiaccesscontrolPrivilegedApiControl:ApiaccesscontrolPrivilegedApiControl test_privileged_api_control "id"
        ```

        :param str resource_name: The name of the resource.
        :param ApiaccesscontrolPrivilegedApiControlArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApiaccesscontrolPrivilegedApiControlArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 approver_group_id_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 notification_topic_id: Optional[pulumi.Input[_builtins.str]] = None,
                 number_of_approvers: Optional[pulumi.Input[_builtins.int]] = None,
                 privileged_operation_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApiaccesscontrolPrivilegedApiControlPrivilegedOperationListArgs', 'ApiaccesscontrolPrivilegedApiControlPrivilegedOperationListArgsDict']]]]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApiaccesscontrolPrivilegedApiControlArgs.__new__(ApiaccesscontrolPrivilegedApiControlArgs)

            if approver_group_id_lists is None and not opts.urn:
                raise TypeError("Missing required property 'approver_group_id_lists'")
            __props__.__dict__["approver_group_id_lists"] = approver_group_id_lists
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if notification_topic_id is None and not opts.urn:
                raise TypeError("Missing required property 'notification_topic_id'")
            __props__.__dict__["notification_topic_id"] = notification_topic_id
            __props__.__dict__["number_of_approvers"] = number_of_approvers
            if privileged_operation_lists is None and not opts.urn:
                raise TypeError("Missing required property 'privileged_operation_lists'")
            __props__.__dict__["privileged_operation_lists"] = privileged_operation_lists
            if resource_type is None and not opts.urn:
                raise TypeError("Missing required property 'resource_type'")
            __props__.__dict__["resource_type"] = resource_type
            if resources is None and not opts.urn:
                raise TypeError("Missing required property 'resources'")
            __props__.__dict__["resources"] = resources
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["state_details"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_deleted"] = None
            __props__.__dict__["time_updated"] = None
        super(ApiaccesscontrolPrivilegedApiControl, __self__).__init__(
            'oci:oci/apiaccesscontrolPrivilegedApiControl:ApiaccesscontrolPrivilegedApiControl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            approver_group_id_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            notification_topic_id: Optional[pulumi.Input[_builtins.str]] = None,
            number_of_approvers: Optional[pulumi.Input[_builtins.int]] = None,
            privileged_operation_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApiaccesscontrolPrivilegedApiControlPrivilegedOperationListArgs', 'ApiaccesscontrolPrivilegedApiControlPrivilegedOperationListArgsDict']]]]] = None,
            resource_type: Optional[pulumi.Input[_builtins.str]] = None,
            resources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            state_details: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_deleted: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'ApiaccesscontrolPrivilegedApiControl':
        """
        Get an existing ApiaccesscontrolPrivilegedApiControl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] approver_group_id_lists: (Updatable) List of user IAM group ids who can approve an privilegedApi request associated with a resource governed by this operator control.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the PrivilegedApiControl in.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) Description of the privilegedApi control.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Name of the privilegedApi control It has to be unique.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] lifecycle_details: A message that describes the current state of the PrivilegedApiControl in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        :param pulumi.Input[_builtins.str] notification_topic_id: (Updatable) The OCID of the Oracle Cloud Infrastructure Notification topic to publish messages related to this Delegation Control.
        :param pulumi.Input[_builtins.int] number_of_approvers: (Updatable) Number of approvers required to approve an privilegedApi request.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApiaccesscontrolPrivilegedApiControlPrivilegedOperationListArgs', 'ApiaccesscontrolPrivilegedApiControlPrivilegedOperationListArgsDict']]]] privileged_operation_lists: (Updatable) List of privileged operator operations. If Privileged API Managment is enabled for a resource it will be validated whether the operation done by the operator is a part of privileged operation.
        :param pulumi.Input[_builtins.str] resource_type: (Updatable) resourceType for which the PrivilegedApiControl is applicable
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resources: (Updatable) contains Resource details
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] state: The current state of the PrivilegedApiControl.
        :param pulumi.Input[_builtins.str] state_details: A message that describes the current state of the PrivilegedApiControl in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The date and time the PrivilegedApiControl was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_deleted: The date and time the PrivilegedApiControl was marked for delete, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_updated: The date and time the PrivilegedApiControl was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApiaccesscontrolPrivilegedApiControlState.__new__(_ApiaccesscontrolPrivilegedApiControlState)

        __props__.__dict__["approver_group_id_lists"] = approver_group_id_lists
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["notification_topic_id"] = notification_topic_id
        __props__.__dict__["number_of_approvers"] = number_of_approvers
        __props__.__dict__["privileged_operation_lists"] = privileged_operation_lists
        __props__.__dict__["resource_type"] = resource_type
        __props__.__dict__["resources"] = resources
        __props__.__dict__["state"] = state
        __props__.__dict__["state_details"] = state_details
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_deleted"] = time_deleted
        __props__.__dict__["time_updated"] = time_updated
        return ApiaccesscontrolPrivilegedApiControl(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="approverGroupIdLists")
    def approver_group_id_lists(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        (Updatable) List of user IAM group ids who can approve an privilegedApi request associated with a resource governed by this operator control.
        """
        return pulumi.get(self, "approver_group_id_lists")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the PrivilegedApiControl in.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Description of the privilegedApi control.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Name of the privilegedApi control It has to be unique.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        A message that describes the current state of the PrivilegedApiControl in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="notificationTopicId")
    def notification_topic_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The OCID of the Oracle Cloud Infrastructure Notification topic to publish messages related to this Delegation Control.
        """
        return pulumi.get(self, "notification_topic_id")

    @_builtins.property
    @pulumi.getter(name="numberOfApprovers")
    def number_of_approvers(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) Number of approvers required to approve an privilegedApi request.
        """
        return pulumi.get(self, "number_of_approvers")

    @_builtins.property
    @pulumi.getter(name="privilegedOperationLists")
    def privileged_operation_lists(self) -> pulumi.Output[Sequence['outputs.ApiaccesscontrolPrivilegedApiControlPrivilegedOperationList']]:
        """
        (Updatable) List of privileged operator operations. If Privileged API Managment is enabled for a resource it will be validated whether the operation done by the operator is a part of privileged operation.
        """
        return pulumi.get(self, "privileged_operation_lists")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) resourceType for which the PrivilegedApiControl is applicable
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        (Updatable) contains Resource details


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "resources")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the PrivilegedApiControl.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="stateDetails")
    def state_details(self) -> pulumi.Output[_builtins.str]:
        """
        A message that describes the current state of the PrivilegedApiControl in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "state_details")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the PrivilegedApiControl was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeDeleted")
    def time_deleted(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the PrivilegedApiControl was marked for delete, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_deleted")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the PrivilegedApiControl was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

