# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDbmulticloudOracleDbAzureBlobMountsResult',
    'AwaitableGetDbmulticloudOracleDbAzureBlobMountsResult',
    'get_dbmulticloud_oracle_db_azure_blob_mounts',
    'get_dbmulticloud_oracle_db_azure_blob_mounts_output',
]

@pulumi.output_type
class GetDbmulticloudOracleDbAzureBlobMountsResult:
    """
    A collection of values returned by getDbmulticloudOracleDbAzureBlobMounts.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, oracle_db_azure_blob_container_id=None, oracle_db_azure_blob_mount_id=None, oracle_db_azure_blob_mount_summary_collections=None, oracle_db_azure_connector_id=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if oracle_db_azure_blob_container_id and not isinstance(oracle_db_azure_blob_container_id, str):
            raise TypeError("Expected argument 'oracle_db_azure_blob_container_id' to be a str")
        pulumi.set(__self__, "oracle_db_azure_blob_container_id", oracle_db_azure_blob_container_id)
        if oracle_db_azure_blob_mount_id and not isinstance(oracle_db_azure_blob_mount_id, str):
            raise TypeError("Expected argument 'oracle_db_azure_blob_mount_id' to be a str")
        pulumi.set(__self__, "oracle_db_azure_blob_mount_id", oracle_db_azure_blob_mount_id)
        if oracle_db_azure_blob_mount_summary_collections and not isinstance(oracle_db_azure_blob_mount_summary_collections, list):
            raise TypeError("Expected argument 'oracle_db_azure_blob_mount_summary_collections' to be a list")
        pulumi.set(__self__, "oracle_db_azure_blob_mount_summary_collections", oracle_db_azure_blob_mount_summary_collections)
        if oracle_db_azure_connector_id and not isinstance(oracle_db_azure_connector_id, str):
            raise TypeError("Expected argument 'oracle_db_azure_connector_id' to be a str")
        pulumi.set(__self__, "oracle_db_azure_connector_id", oracle_db_azure_connector_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains Oracle DB Azure Blob Mount resource.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        Oracle DB Azure Blob Mount resource name.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDbmulticloudOracleDbAzureBlobMountsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="oracleDbAzureBlobContainerId")
    def oracle_db_azure_blob_container_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle DB Azure Blob Container resource that contains Oracle DB Azure Blob Mount resource.
        """
        return pulumi.get(self, "oracle_db_azure_blob_container_id")

    @_builtins.property
    @pulumi.getter(name="oracleDbAzureBlobMountId")
    def oracle_db_azure_blob_mount_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "oracle_db_azure_blob_mount_id")

    @_builtins.property
    @pulumi.getter(name="oracleDbAzureBlobMountSummaryCollections")
    def oracle_db_azure_blob_mount_summary_collections(self) -> Sequence['outputs.GetDbmulticloudOracleDbAzureBlobMountsOracleDbAzureBlobMountSummaryCollectionResult']:
        """
        The list of oracle_db_azure_blob_mount_summary_collection.
        """
        return pulumi.get(self, "oracle_db_azure_blob_mount_summary_collections")

    @_builtins.property
    @pulumi.getter(name="oracleDbAzureConnectorId")
    def oracle_db_azure_connector_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle DB Azure Connector resource that contains Oracle DB Azure Blob Mount resource.
        """
        return pulumi.get(self, "oracle_db_azure_connector_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current lifecycle state of the Oracle DB Azure Blob Mount resource.
        """
        return pulumi.get(self, "state")


class AwaitableGetDbmulticloudOracleDbAzureBlobMountsResult(GetDbmulticloudOracleDbAzureBlobMountsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbmulticloudOracleDbAzureBlobMountsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            oracle_db_azure_blob_container_id=self.oracle_db_azure_blob_container_id,
            oracle_db_azure_blob_mount_id=self.oracle_db_azure_blob_mount_id,
            oracle_db_azure_blob_mount_summary_collections=self.oracle_db_azure_blob_mount_summary_collections,
            oracle_db_azure_connector_id=self.oracle_db_azure_connector_id,
            state=self.state)


def get_dbmulticloud_oracle_db_azure_blob_mounts(compartment_id: Optional[_builtins.str] = None,
                                                 display_name: Optional[_builtins.str] = None,
                                                 filters: Optional[Sequence[Union['GetDbmulticloudOracleDbAzureBlobMountsFilterArgs', 'GetDbmulticloudOracleDbAzureBlobMountsFilterArgsDict']]] = None,
                                                 oracle_db_azure_blob_container_id: Optional[_builtins.str] = None,
                                                 oracle_db_azure_blob_mount_id: Optional[_builtins.str] = None,
                                                 oracle_db_azure_connector_id: Optional[_builtins.str] = None,
                                                 state: Optional[_builtins.str] = None,
                                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbmulticloudOracleDbAzureBlobMountsResult:
    """
    This data source provides the list of Oracle Db Azure Blob Mounts in Oracle Cloud Infrastructure Dbmulticloud service.

    Lists all Oracle DB Azure Blob Mount resources based on the specified filters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oracle_db_azure_blob_mounts = oci.oci.get_dbmulticloud_oracle_db_azure_blob_mounts(compartment_id=compartment_id,
        display_name=oracle_db_azure_blob_mount_display_name,
        oracle_db_azure_blob_container_id=test_oracle_db_azure_blob_container["id"],
        oracle_db_azure_blob_mount_id=test_oracle_db_azure_blob_mount["id"],
        oracle_db_azure_connector_id=test_oracle_db_azure_connector["id"],
        state=oracle_db_azure_blob_mount_state)
    ```


    :param _builtins.str compartment_id: The [ID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.str display_name: A filter to return Oracle DB Azure Blob Mount resources that match the specified display name.
    :param _builtins.str oracle_db_azure_blob_container_id: A filter to return Oracle DB Azure Blob Container resource.
    :param _builtins.str oracle_db_azure_blob_mount_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle DB Azure Blob Mount resource.
    :param _builtins.str oracle_db_azure_connector_id: A filter to return Oracle DB Azure Azure Identity Connector resources.
    :param _builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['oracleDbAzureBlobContainerId'] = oracle_db_azure_blob_container_id
    __args__['oracleDbAzureBlobMountId'] = oracle_db_azure_blob_mount_id
    __args__['oracleDbAzureConnectorId'] = oracle_db_azure_connector_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getDbmulticloudOracleDbAzureBlobMounts:getDbmulticloudOracleDbAzureBlobMounts', __args__, opts=opts, typ=GetDbmulticloudOracleDbAzureBlobMountsResult).value

    return AwaitableGetDbmulticloudOracleDbAzureBlobMountsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        oracle_db_azure_blob_container_id=pulumi.get(__ret__, 'oracle_db_azure_blob_container_id'),
        oracle_db_azure_blob_mount_id=pulumi.get(__ret__, 'oracle_db_azure_blob_mount_id'),
        oracle_db_azure_blob_mount_summary_collections=pulumi.get(__ret__, 'oracle_db_azure_blob_mount_summary_collections'),
        oracle_db_azure_connector_id=pulumi.get(__ret__, 'oracle_db_azure_connector_id'),
        state=pulumi.get(__ret__, 'state'))
def get_dbmulticloud_oracle_db_azure_blob_mounts_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                        display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                        filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDbmulticloudOracleDbAzureBlobMountsFilterArgs', 'GetDbmulticloudOracleDbAzureBlobMountsFilterArgsDict']]]]] = None,
                                                        oracle_db_azure_blob_container_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                        oracle_db_azure_blob_mount_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                        oracle_db_azure_connector_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                        state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDbmulticloudOracleDbAzureBlobMountsResult]:
    """
    This data source provides the list of Oracle Db Azure Blob Mounts in Oracle Cloud Infrastructure Dbmulticloud service.

    Lists all Oracle DB Azure Blob Mount resources based on the specified filters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oracle_db_azure_blob_mounts = oci.oci.get_dbmulticloud_oracle_db_azure_blob_mounts(compartment_id=compartment_id,
        display_name=oracle_db_azure_blob_mount_display_name,
        oracle_db_azure_blob_container_id=test_oracle_db_azure_blob_container["id"],
        oracle_db_azure_blob_mount_id=test_oracle_db_azure_blob_mount["id"],
        oracle_db_azure_connector_id=test_oracle_db_azure_connector["id"],
        state=oracle_db_azure_blob_mount_state)
    ```


    :param _builtins.str compartment_id: The [ID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.str display_name: A filter to return Oracle DB Azure Blob Mount resources that match the specified display name.
    :param _builtins.str oracle_db_azure_blob_container_id: A filter to return Oracle DB Azure Blob Container resource.
    :param _builtins.str oracle_db_azure_blob_mount_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle DB Azure Blob Mount resource.
    :param _builtins.str oracle_db_azure_connector_id: A filter to return Oracle DB Azure Azure Identity Connector resources.
    :param _builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['oracleDbAzureBlobContainerId'] = oracle_db_azure_blob_container_id
    __args__['oracleDbAzureBlobMountId'] = oracle_db_azure_blob_mount_id
    __args__['oracleDbAzureConnectorId'] = oracle_db_azure_connector_id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getDbmulticloudOracleDbAzureBlobMounts:getDbmulticloudOracleDbAzureBlobMounts', __args__, opts=opts, typ=GetDbmulticloudOracleDbAzureBlobMountsResult)
    return __ret__.apply(lambda __response__: GetDbmulticloudOracleDbAzureBlobMountsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        oracle_db_azure_blob_container_id=pulumi.get(__response__, 'oracle_db_azure_blob_container_id'),
        oracle_db_azure_blob_mount_id=pulumi.get(__response__, 'oracle_db_azure_blob_mount_id'),
        oracle_db_azure_blob_mount_summary_collections=pulumi.get(__response__, 'oracle_db_azure_blob_mount_summary_collections'),
        oracle_db_azure_connector_id=pulumi.get(__response__, 'oracle_db_azure_connector_id'),
        state=pulumi.get(__response__, 'state')))
