# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDbmulticloudOracleDbGcpKeyRingResult',
    'AwaitableGetDbmulticloudOracleDbGcpKeyRingResult',
    'get_dbmulticloud_oracle_db_gcp_key_ring',
    'get_dbmulticloud_oracle_db_gcp_key_ring_output',
]

@pulumi.output_type
class GetDbmulticloudOracleDbGcpKeyRingResult:
    """
    A collection of values returned by getDbmulticloudOracleDbGcpKeyRing.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, display_name=None, freeform_tags=None, gcp_key_ring_id=None, id=None, lifecycle_state_details=None, location=None, oracle_db_connector_id=None, oracle_db_gcp_key_ring_id=None, properties=None, state=None, system_tags=None, time_created=None, time_updated=None, type=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if gcp_key_ring_id and not isinstance(gcp_key_ring_id, str):
            raise TypeError("Expected argument 'gcp_key_ring_id' to be a str")
        pulumi.set(__self__, "gcp_key_ring_id", gcp_key_ring_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_state_details and not isinstance(lifecycle_state_details, str):
            raise TypeError("Expected argument 'lifecycle_state_details' to be a str")
        pulumi.set(__self__, "lifecycle_state_details", lifecycle_state_details)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if oracle_db_connector_id and not isinstance(oracle_db_connector_id, str):
            raise TypeError("Expected argument 'oracle_db_connector_id' to be a str")
        pulumi.set(__self__, "oracle_db_connector_id", oracle_db_connector_id)
        if oracle_db_gcp_key_ring_id and not isinstance(oracle_db_gcp_key_ring_id, str):
            raise TypeError("Expected argument 'oracle_db_gcp_key_ring_id' to be a str")
        pulumi.set(__self__, "oracle_db_gcp_key_ring_id", oracle_db_gcp_key_ring_id)
        if properties and not isinstance(properties, dict):
            raise TypeError("Expected argument 'properties' to be a dict")
        pulumi.set(__self__, "properties", properties)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) where the Oracle DB GCP Key Ring resource resides.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        Display name of DB GCP Key Ring resource.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="gcpKeyRingId")
    def gcp_key_ring_id(self) -> _builtins.str:
        """
        GCP Key Ring ID.
        """
        return pulumi.get(self, "gcp_key_ring_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB GCP Key Ring resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> _builtins.str:
        """
        Description of the current lifecycle state in more detail.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        Location of the GCP Key Ring resource.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="oracleDbConnectorId")
    def oracle_db_connector_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where the Oracle DB GCP Identity Connector resource resides.
        """
        return pulumi.get(self, "oracle_db_connector_id")

    @_builtins.property
    @pulumi.getter(name="oracleDbGcpKeyRingId")
    def oracle_db_gcp_key_ring_id(self) -> _builtins.str:
        return pulumi.get(self, "oracle_db_gcp_key_ring_id")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Mapping[str, _builtins.str]:
        """
        Oracle DB GCP Key Ring resource's properties.
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The lifecycle state of the Oracle DB GCP Key Ring resource.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        Time when the DB GCP Key Ring resource was created in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-23T21:10:29.600Z'
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        Time when the DB GCP Key Ring resource was last modified, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-23T21:10:29.600Z'
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Oracle DB GCP Key Ring resource Type.
        """
        return pulumi.get(self, "type")


class AwaitableGetDbmulticloudOracleDbGcpKeyRingResult(GetDbmulticloudOracleDbGcpKeyRingResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbmulticloudOracleDbGcpKeyRingResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            gcp_key_ring_id=self.gcp_key_ring_id,
            id=self.id,
            lifecycle_state_details=self.lifecycle_state_details,
            location=self.location,
            oracle_db_connector_id=self.oracle_db_connector_id,
            oracle_db_gcp_key_ring_id=self.oracle_db_gcp_key_ring_id,
            properties=self.properties,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            type=self.type)


def get_dbmulticloud_oracle_db_gcp_key_ring(oracle_db_gcp_key_ring_id: Optional[_builtins.str] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbmulticloudOracleDbGcpKeyRingResult:
    """
    This data source provides details about a specific Oracle Db Gcp Key Ring resource in Oracle Cloud Infrastructure Dbmulticloud service.

    Retrieves the Oracle GCP Key Ring details using a specific Container resource [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oracle_db_gcp_key_ring = oci.oci.get_dbmulticloud_oracle_db_gcp_key_ring(oracle_db_gcp_key_ring_id=test_oracle_db_gcp_key_ring_oci_dbmulticloud_oracle_db_gcp_key_ring["id"])
    ```


    :param _builtins.str oracle_db_gcp_key_ring_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle DB GCP Key-Ring resource.
    """
    __args__ = dict()
    __args__['oracleDbGcpKeyRingId'] = oracle_db_gcp_key_ring_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getDbmulticloudOracleDbGcpKeyRing:getDbmulticloudOracleDbGcpKeyRing', __args__, opts=opts, typ=GetDbmulticloudOracleDbGcpKeyRingResult).value

    return AwaitableGetDbmulticloudOracleDbGcpKeyRingResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        gcp_key_ring_id=pulumi.get(__ret__, 'gcp_key_ring_id'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_state_details=pulumi.get(__ret__, 'lifecycle_state_details'),
        location=pulumi.get(__ret__, 'location'),
        oracle_db_connector_id=pulumi.get(__ret__, 'oracle_db_connector_id'),
        oracle_db_gcp_key_ring_id=pulumi.get(__ret__, 'oracle_db_gcp_key_ring_id'),
        properties=pulumi.get(__ret__, 'properties'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        type=pulumi.get(__ret__, 'type'))
def get_dbmulticloud_oracle_db_gcp_key_ring_output(oracle_db_gcp_key_ring_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDbmulticloudOracleDbGcpKeyRingResult]:
    """
    This data source provides details about a specific Oracle Db Gcp Key Ring resource in Oracle Cloud Infrastructure Dbmulticloud service.

    Retrieves the Oracle GCP Key Ring details using a specific Container resource [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oracle_db_gcp_key_ring = oci.oci.get_dbmulticloud_oracle_db_gcp_key_ring(oracle_db_gcp_key_ring_id=test_oracle_db_gcp_key_ring_oci_dbmulticloud_oracle_db_gcp_key_ring["id"])
    ```


    :param _builtins.str oracle_db_gcp_key_ring_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle DB GCP Key-Ring resource.
    """
    __args__ = dict()
    __args__['oracleDbGcpKeyRingId'] = oracle_db_gcp_key_ring_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getDbmulticloudOracleDbGcpKeyRing:getDbmulticloudOracleDbGcpKeyRing', __args__, opts=opts, typ=GetDbmulticloudOracleDbGcpKeyRingResult)
    return __ret__.apply(lambda __response__: GetDbmulticloudOracleDbGcpKeyRingResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        gcp_key_ring_id=pulumi.get(__response__, 'gcp_key_ring_id'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_state_details=pulumi.get(__response__, 'lifecycle_state_details'),
        location=pulumi.get(__response__, 'location'),
        oracle_db_connector_id=pulumi.get(__response__, 'oracle_db_connector_id'),
        oracle_db_gcp_key_ring_id=pulumi.get(__response__, 'oracle_db_gcp_key_ring_id'),
        properties=pulumi.get(__response__, 'properties'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        type=pulumi.get(__response__, 'type')))
