# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetManagedKafkaKafkaClusterConfigVersionResult',
    'AwaitableGetManagedKafkaKafkaClusterConfigVersionResult',
    'get_managed_kafka_kafka_cluster_config_version',
    'get_managed_kafka_kafka_cluster_config_version_output',
]

@pulumi.output_type
class GetManagedKafkaKafkaClusterConfigVersionResult:
    """
    A collection of values returned by getManagedKafkaKafkaClusterConfigVersion.
    """
    def __init__(__self__, config_id=None, id=None, kafka_cluster_config_id=None, properties=None, time_created=None, version_number=None):
        if config_id and not isinstance(config_id, str):
            raise TypeError("Expected argument 'config_id' to be a str")
        pulumi.set(__self__, "config_id", config_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kafka_cluster_config_id and not isinstance(kafka_cluster_config_id, str):
            raise TypeError("Expected argument 'kafka_cluster_config_id' to be a str")
        pulumi.set(__self__, "kafka_cluster_config_id", kafka_cluster_config_id)
        if properties and not isinstance(properties, dict):
            raise TypeError("Expected argument 'properties' to be a dict")
        pulumi.set(__self__, "properties", properties)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if version_number and not isinstance(version_number, int):
            raise TypeError("Expected argument 'version_number' to be a int")
        pulumi.set(__self__, "version_number", version_number)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> _builtins.str:
        """
        ID cluster configuration
        """
        return pulumi.get(self, "config_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="kafkaClusterConfigId")
    def kafka_cluster_config_id(self) -> _builtins.str:
        return pulumi.get(self, "kafka_cluster_config_id")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Mapping[str, _builtins.str]:
        """
        Cluster configuration key-value pairs
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the KafkaClusterConfigVersion was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="versionNumber")
    def version_number(self) -> _builtins.int:
        """
        Version of the cluster configuration
        """
        return pulumi.get(self, "version_number")


class AwaitableGetManagedKafkaKafkaClusterConfigVersionResult(GetManagedKafkaKafkaClusterConfigVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedKafkaKafkaClusterConfigVersionResult(
            config_id=self.config_id,
            id=self.id,
            kafka_cluster_config_id=self.kafka_cluster_config_id,
            properties=self.properties,
            time_created=self.time_created,
            version_number=self.version_number)


def get_managed_kafka_kafka_cluster_config_version(kafka_cluster_config_id: Optional[_builtins.str] = None,
                                                   version_number: Optional[_builtins.int] = None,
                                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedKafkaKafkaClusterConfigVersionResult:
    """
    This data source provides details about a specific Kafka Cluster Config Version resource in Oracle Cloud Infrastructure Managed Kafka service.

    Gets information about a KafkaClusterConfig version.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_kafka_cluster_config_version = oci.oci.get_managed_kafka_kafka_cluster_config_version(kafka_cluster_config_id=test_kafka_cluster_config["id"],
        version_number=kafka_cluster_config_version_version_number)
    ```


    :param _builtins.str kafka_cluster_config_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KafkaClusterConfig.
    :param _builtins.int version_number: The versionNumber of the KafkaClusterConfig.
    """
    __args__ = dict()
    __args__['kafkaClusterConfigId'] = kafka_cluster_config_id
    __args__['versionNumber'] = version_number
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getManagedKafkaKafkaClusterConfigVersion:getManagedKafkaKafkaClusterConfigVersion', __args__, opts=opts, typ=GetManagedKafkaKafkaClusterConfigVersionResult).value

    return AwaitableGetManagedKafkaKafkaClusterConfigVersionResult(
        config_id=pulumi.get(__ret__, 'config_id'),
        id=pulumi.get(__ret__, 'id'),
        kafka_cluster_config_id=pulumi.get(__ret__, 'kafka_cluster_config_id'),
        properties=pulumi.get(__ret__, 'properties'),
        time_created=pulumi.get(__ret__, 'time_created'),
        version_number=pulumi.get(__ret__, 'version_number'))
def get_managed_kafka_kafka_cluster_config_version_output(kafka_cluster_config_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                          version_number: Optional[pulumi.Input[_builtins.int]] = None,
                                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetManagedKafkaKafkaClusterConfigVersionResult]:
    """
    This data source provides details about a specific Kafka Cluster Config Version resource in Oracle Cloud Infrastructure Managed Kafka service.

    Gets information about a KafkaClusterConfig version.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_kafka_cluster_config_version = oci.oci.get_managed_kafka_kafka_cluster_config_version(kafka_cluster_config_id=test_kafka_cluster_config["id"],
        version_number=kafka_cluster_config_version_version_number)
    ```


    :param _builtins.str kafka_cluster_config_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KafkaClusterConfig.
    :param _builtins.int version_number: The versionNumber of the KafkaClusterConfig.
    """
    __args__ = dict()
    __args__['kafkaClusterConfigId'] = kafka_cluster_config_id
    __args__['versionNumber'] = version_number
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getManagedKafkaKafkaClusterConfigVersion:getManagedKafkaKafkaClusterConfigVersion', __args__, opts=opts, typ=GetManagedKafkaKafkaClusterConfigVersionResult)
    return __ret__.apply(lambda __response__: GetManagedKafkaKafkaClusterConfigVersionResult(
        config_id=pulumi.get(__response__, 'config_id'),
        id=pulumi.get(__response__, 'id'),
        kafka_cluster_config_id=pulumi.get(__response__, 'kafka_cluster_config_id'),
        properties=pulumi.get(__response__, 'properties'),
        time_created=pulumi.get(__response__, 'time_created'),
        version_number=pulumi.get(__response__, 'version_number')))
