# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetWlmsManagedInstanceScanResultsResult',
    'AwaitableGetWlmsManagedInstanceScanResultsResult',
    'get_wlms_managed_instance_scan_results',
    'get_wlms_managed_instance_scan_results_output',
]

@pulumi.output_type
class GetWlmsManagedInstanceScanResultsResult:
    """
    A collection of values returned by getWlmsManagedInstanceScanResults.
    """
    def __init__(__self__, filters=None, id=None, managed_instance_id=None, scan_result_collections=None, server_name=None, wls_domain_id=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_instance_id and not isinstance(managed_instance_id, str):
            raise TypeError("Expected argument 'managed_instance_id' to be a str")
        pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if scan_result_collections and not isinstance(scan_result_collections, list):
            raise TypeError("Expected argument 'scan_result_collections' to be a list")
        pulumi.set(__self__, "scan_result_collections", scan_result_collections)
        if server_name and not isinstance(server_name, str):
            raise TypeError("Expected argument 'server_name' to be a str")
        pulumi.set(__self__, "server_name", server_name)
        if wls_domain_id and not isinstance(wls_domain_id, str):
            raise TypeError("Expected argument 'wls_domain_id' to be a str")
        pulumi.set(__self__, "wls_domain_id", wls_domain_id)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetWlmsManagedInstanceScanResultsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> _builtins.str:
        return pulumi.get(self, "managed_instance_id")

    @_builtins.property
    @pulumi.getter(name="scanResultCollections")
    def scan_result_collections(self) -> Sequence['outputs.GetWlmsManagedInstanceScanResultsScanResultCollectionResult']:
        """
        The list of scan_result_collection.
        """
        return pulumi.get(self, "scan_result_collections")

    @_builtins.property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[_builtins.str]:
        """
        The name of the WebLogic server to which the server check belongs.
        """
        return pulumi.get(self, "server_name")

    @_builtins.property
    @pulumi.getter(name="wlsDomainId")
    def wls_domain_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the WebLogic domain.
        """
        return pulumi.get(self, "wls_domain_id")


class AwaitableGetWlmsManagedInstanceScanResultsResult(GetWlmsManagedInstanceScanResultsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWlmsManagedInstanceScanResultsResult(
            filters=self.filters,
            id=self.id,
            managed_instance_id=self.managed_instance_id,
            scan_result_collections=self.scan_result_collections,
            server_name=self.server_name,
            wls_domain_id=self.wls_domain_id)


def get_wlms_managed_instance_scan_results(filters: Optional[Sequence[Union['GetWlmsManagedInstanceScanResultsFilterArgs', 'GetWlmsManagedInstanceScanResultsFilterArgsDict']]] = None,
                                           managed_instance_id: Optional[_builtins.str] = None,
                                           server_name: Optional[_builtins.str] = None,
                                           wls_domain_id: Optional[_builtins.str] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWlmsManagedInstanceScanResultsResult:
    """
    This data source provides the list of Managed Instance Scan Results in Oracle Cloud Infrastructure Wlms service.

    Gets all the scan results for all WebLogic servers in the managed instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_instance_scan_results = oci.oci.get_wlms_managed_instance_scan_results(managed_instance_id=test_managed_instance["id"],
        server_name=managed_instance_scan_result_server_name,
        wls_domain_id=test_wls_domain["id"])
    ```


    :param _builtins.str managed_instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance.
    :param _builtins.str server_name: The name of the server.
    :param _builtins.str wls_domain_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the WebLogic domain.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['managedInstanceId'] = managed_instance_id
    __args__['serverName'] = server_name
    __args__['wlsDomainId'] = wls_domain_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getWlmsManagedInstanceScanResults:getWlmsManagedInstanceScanResults', __args__, opts=opts, typ=GetWlmsManagedInstanceScanResultsResult).value

    return AwaitableGetWlmsManagedInstanceScanResultsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        managed_instance_id=pulumi.get(__ret__, 'managed_instance_id'),
        scan_result_collections=pulumi.get(__ret__, 'scan_result_collections'),
        server_name=pulumi.get(__ret__, 'server_name'),
        wls_domain_id=pulumi.get(__ret__, 'wls_domain_id'))
def get_wlms_managed_instance_scan_results_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetWlmsManagedInstanceScanResultsFilterArgs', 'GetWlmsManagedInstanceScanResultsFilterArgsDict']]]]] = None,
                                                  managed_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                  server_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                  wls_domain_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWlmsManagedInstanceScanResultsResult]:
    """
    This data source provides the list of Managed Instance Scan Results in Oracle Cloud Infrastructure Wlms service.

    Gets all the scan results for all WebLogic servers in the managed instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_instance_scan_results = oci.oci.get_wlms_managed_instance_scan_results(managed_instance_id=test_managed_instance["id"],
        server_name=managed_instance_scan_result_server_name,
        wls_domain_id=test_wls_domain["id"])
    ```


    :param _builtins.str managed_instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance.
    :param _builtins.str server_name: The name of the server.
    :param _builtins.str wls_domain_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the WebLogic domain.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['managedInstanceId'] = managed_instance_id
    __args__['serverName'] = server_name
    __args__['wlsDomainId'] = wls_domain_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getWlmsManagedInstanceScanResults:getWlmsManagedInstanceScanResults', __args__, opts=opts, typ=GetWlmsManagedInstanceScanResultsResult)
    return __ret__.apply(lambda __response__: GetWlmsManagedInstanceScanResultsResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        managed_instance_id=pulumi.get(__response__, 'managed_instance_id'),
        scan_result_collections=pulumi.get(__response__, 'scan_result_collections'),
        server_name=pulumi.get(__response__, 'server_name'),
        wls_domain_id=pulumi.get(__response__, 'wls_domain_id')))
