# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OpaInstanceArgs', 'OpaInstance']

@pulumi.input_type
class OpaInstanceArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 shape_name: pulumi.Input[_builtins.str],
                 consumption_model: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 idcs_at: Optional[pulumi.Input[_builtins.str]] = None,
                 is_breakglass_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 metering_type: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a OpaInstance resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) Compartment Identifier
        :param pulumi.Input[_builtins.str] display_name: (Updatable) OpaInstance Identifier. User-friendly name for the instance. Avoid entering confidential information. You can change this value anytime.
        :param pulumi.Input[_builtins.str] shape_name: Shape of the instance.
        :param pulumi.Input[_builtins.str] consumption_model: Parameter specifying which entitlement to use for billing purposes
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) Description of the Oracle Process Automation instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] idcs_at: IDCS Authentication token. This is required for all realms with IDCS. This property is optional, as it is not required for non-IDCS realms.
        :param pulumi.Input[_builtins.bool] is_breakglass_enabled: indicates if breakGlass is enabled for the opa instance.
        :param pulumi.Input[_builtins.str] metering_type: MeteringType Identifier
        :param pulumi.Input[_builtins.str] state: (Updatable) The target state for the Opa Instance. Could be set to `ACTIVE` or `INACTIVE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "shape_name", shape_name)
        if consumption_model is not None:
            pulumi.set(__self__, "consumption_model", consumption_model)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if idcs_at is not None:
            pulumi.set(__self__, "idcs_at", idcs_at)
        if is_breakglass_enabled is not None:
            pulumi.set(__self__, "is_breakglass_enabled", is_breakglass_enabled)
        if metering_type is not None:
            pulumi.set(__self__, "metering_type", metering_type)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Compartment Identifier
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) OpaInstance Identifier. User-friendly name for the instance. Avoid entering confidential information. You can change this value anytime.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> pulumi.Input[_builtins.str]:
        """
        Shape of the instance.
        """
        return pulumi.get(self, "shape_name")

    @shape_name.setter
    def shape_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "shape_name", value)

    @_builtins.property
    @pulumi.getter(name="consumptionModel")
    def consumption_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Parameter specifying which entitlement to use for billing purposes
        """
        return pulumi.get(self, "consumption_model")

    @consumption_model.setter
    def consumption_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "consumption_model", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Description of the Oracle Process Automation instance.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="idcsAt")
    def idcs_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IDCS Authentication token. This is required for all realms with IDCS. This property is optional, as it is not required for non-IDCS realms.
        """
        return pulumi.get(self, "idcs_at")

    @idcs_at.setter
    def idcs_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "idcs_at", value)

    @_builtins.property
    @pulumi.getter(name="isBreakglassEnabled")
    def is_breakglass_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        indicates if breakGlass is enabled for the opa instance.
        """
        return pulumi.get(self, "is_breakglass_enabled")

    @is_breakglass_enabled.setter
    def is_breakglass_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_breakglass_enabled", value)

    @_builtins.property
    @pulumi.getter(name="meteringType")
    def metering_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        MeteringType Identifier
        """
        return pulumi.get(self, "metering_type")

    @metering_type.setter
    def metering_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metering_type", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The target state for the Opa Instance. Could be set to `ACTIVE` or `INACTIVE`. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class _OpaInstanceState:
    def __init__(__self__, *,
                 attachments: Optional[pulumi.Input[Sequence[pulumi.Input['OpaInstanceAttachmentArgs']]]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 consumption_model: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 idcs_at: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_app_display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_app_guid: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_app_opc_service_instance_guid: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_domain_url: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_url: Optional[pulumi.Input[_builtins.str]] = None,
                 is_breakglass_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 metering_type: Optional[pulumi.Input[_builtins.str]] = None,
                 shape_name: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OpaInstance resources.
        :param pulumi.Input[Sequence[pulumi.Input['OpaInstanceAttachmentArgs']]] attachments: A list of associated attachments to other services
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) Compartment Identifier
        :param pulumi.Input[_builtins.str] consumption_model: Parameter specifying which entitlement to use for billing purposes
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) Description of the Oracle Process Automation instance.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) OpaInstance Identifier. User-friendly name for the instance. Avoid entering confidential information. You can change this value anytime.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] idcs_at: IDCS Authentication token. This is required for all realms with IDCS. This property is optional, as it is not required for non-IDCS realms.
        :param pulumi.Input[_builtins.str] identity_app_display_name: This property specifies the name of the Identity Application instance OPA has created inside the user-specified identity domain. This identity application instance may be used to host user roll mappings to grant access to this OPA instance for users within the identity domain.
        :param pulumi.Input[_builtins.str] identity_app_guid: This property specifies the GUID of the Identity Application instance OPA has created inside the user-specified identity domain. This identity application instance may be used to host user role mappings to grant access to this OPA instance for users within the identity domain.
        :param pulumi.Input[_builtins.str] identity_app_opc_service_instance_guid: This property specifies the OPC Service Instance GUID of the Identity Application instance OPA has created inside the user-specified identity domain. This identity application instance may be used to host user roll mappings to grant access to this OPA instance for users within the identity domain.
        :param pulumi.Input[_builtins.str] identity_domain_url: This property specifies the domain url of the Identity Application instance OPA has created inside the user-specified identity domain. This identity application instance may be used to host user roll mappings to grant access to this OPA instance for users within the identity domain.
        :param pulumi.Input[_builtins.str] instance_url: OPA Instance URL
        :param pulumi.Input[_builtins.bool] is_breakglass_enabled: indicates if breakGlass is enabled for the opa instance.
        :param pulumi.Input[_builtins.str] metering_type: MeteringType Identifier
        :param pulumi.Input[_builtins.str] shape_name: Shape of the instance.
        :param pulumi.Input[_builtins.str] state: (Updatable) The target state for the Opa Instance. Could be set to `ACTIVE` or `INACTIVE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The time when OpaInstance was created. An RFC3339 formatted datetime string
        :param pulumi.Input[_builtins.str] time_updated: The time the OpaInstance was updated. An RFC3339 formatted datetime string
        """
        if attachments is not None:
            pulumi.set(__self__, "attachments", attachments)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if consumption_model is not None:
            pulumi.set(__self__, "consumption_model", consumption_model)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if idcs_at is not None:
            pulumi.set(__self__, "idcs_at", idcs_at)
        if identity_app_display_name is not None:
            pulumi.set(__self__, "identity_app_display_name", identity_app_display_name)
        if identity_app_guid is not None:
            pulumi.set(__self__, "identity_app_guid", identity_app_guid)
        if identity_app_opc_service_instance_guid is not None:
            pulumi.set(__self__, "identity_app_opc_service_instance_guid", identity_app_opc_service_instance_guid)
        if identity_domain_url is not None:
            pulumi.set(__self__, "identity_domain_url", identity_domain_url)
        if instance_url is not None:
            pulumi.set(__self__, "instance_url", instance_url)
        if is_breakglass_enabled is not None:
            pulumi.set(__self__, "is_breakglass_enabled", is_breakglass_enabled)
        if metering_type is not None:
            pulumi.set(__self__, "metering_type", metering_type)
        if shape_name is not None:
            pulumi.set(__self__, "shape_name", shape_name)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter
    def attachments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OpaInstanceAttachmentArgs']]]]:
        """
        A list of associated attachments to other services
        """
        return pulumi.get(self, "attachments")

    @attachments.setter
    def attachments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OpaInstanceAttachmentArgs']]]]):
        pulumi.set(self, "attachments", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Compartment Identifier
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="consumptionModel")
    def consumption_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Parameter specifying which entitlement to use for billing purposes
        """
        return pulumi.get(self, "consumption_model")

    @consumption_model.setter
    def consumption_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "consumption_model", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Description of the Oracle Process Automation instance.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) OpaInstance Identifier. User-friendly name for the instance. Avoid entering confidential information. You can change this value anytime.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="idcsAt")
    def idcs_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IDCS Authentication token. This is required for all realms with IDCS. This property is optional, as it is not required for non-IDCS realms.
        """
        return pulumi.get(self, "idcs_at")

    @idcs_at.setter
    def idcs_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "idcs_at", value)

    @_builtins.property
    @pulumi.getter(name="identityAppDisplayName")
    def identity_app_display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This property specifies the name of the Identity Application instance OPA has created inside the user-specified identity domain. This identity application instance may be used to host user roll mappings to grant access to this OPA instance for users within the identity domain.
        """
        return pulumi.get(self, "identity_app_display_name")

    @identity_app_display_name.setter
    def identity_app_display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_app_display_name", value)

    @_builtins.property
    @pulumi.getter(name="identityAppGuid")
    def identity_app_guid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This property specifies the GUID of the Identity Application instance OPA has created inside the user-specified identity domain. This identity application instance may be used to host user role mappings to grant access to this OPA instance for users within the identity domain.
        """
        return pulumi.get(self, "identity_app_guid")

    @identity_app_guid.setter
    def identity_app_guid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_app_guid", value)

    @_builtins.property
    @pulumi.getter(name="identityAppOpcServiceInstanceGuid")
    def identity_app_opc_service_instance_guid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This property specifies the OPC Service Instance GUID of the Identity Application instance OPA has created inside the user-specified identity domain. This identity application instance may be used to host user roll mappings to grant access to this OPA instance for users within the identity domain.
        """
        return pulumi.get(self, "identity_app_opc_service_instance_guid")

    @identity_app_opc_service_instance_guid.setter
    def identity_app_opc_service_instance_guid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_app_opc_service_instance_guid", value)

    @_builtins.property
    @pulumi.getter(name="identityDomainUrl")
    def identity_domain_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This property specifies the domain url of the Identity Application instance OPA has created inside the user-specified identity domain. This identity application instance may be used to host user roll mappings to grant access to this OPA instance for users within the identity domain.
        """
        return pulumi.get(self, "identity_domain_url")

    @identity_domain_url.setter
    def identity_domain_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_domain_url", value)

    @_builtins.property
    @pulumi.getter(name="instanceUrl")
    def instance_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OPA Instance URL
        """
        return pulumi.get(self, "instance_url")

    @instance_url.setter
    def instance_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_url", value)

    @_builtins.property
    @pulumi.getter(name="isBreakglassEnabled")
    def is_breakglass_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        indicates if breakGlass is enabled for the opa instance.
        """
        return pulumi.get(self, "is_breakglass_enabled")

    @is_breakglass_enabled.setter
    def is_breakglass_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_breakglass_enabled", value)

    @_builtins.property
    @pulumi.getter(name="meteringType")
    def metering_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        MeteringType Identifier
        """
        return pulumi.get(self, "metering_type")

    @metering_type.setter
    def metering_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metering_type", value)

    @_builtins.property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Shape of the instance.
        """
        return pulumi.get(self, "shape_name")

    @shape_name.setter
    def shape_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shape_name", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The target state for the Opa Instance. Could be set to `ACTIVE` or `INACTIVE`. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when OpaInstance was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the OpaInstance was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:Opa/opaInstance:OpaInstance")
class OpaInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 consumption_model: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 idcs_at: Optional[pulumi.Input[_builtins.str]] = None,
                 is_breakglass_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 metering_type: Optional[pulumi.Input[_builtins.str]] = None,
                 shape_name: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Opa Instance resource in Oracle Cloud Infrastructure Opa service.

        Creates a new OpaInstance.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_opa_instance = oci.opa.OpaInstance("test_opa_instance",
            compartment_id=compartment_id,
            display_name=opa_instance_display_name,
            shape_name=test_shape["name"],
            consumption_model=opa_instance_consumption_model,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=opa_instance_description,
            freeform_tags={
                "bar-key": "value",
            },
            idcs_at=opa_instance_idcs_at,
            is_breakglass_enabled=opa_instance_is_breakglass_enabled,
            metering_type=opa_instance_metering_type)
        ```

        ## Import

        OpaInstances can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Opa/opaInstance:OpaInstance test_opa_instance "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) Compartment Identifier
        :param pulumi.Input[_builtins.str] consumption_model: Parameter specifying which entitlement to use for billing purposes
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) Description of the Oracle Process Automation instance.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) OpaInstance Identifier. User-friendly name for the instance. Avoid entering confidential information. You can change this value anytime.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] idcs_at: IDCS Authentication token. This is required for all realms with IDCS. This property is optional, as it is not required for non-IDCS realms.
        :param pulumi.Input[_builtins.bool] is_breakglass_enabled: indicates if breakGlass is enabled for the opa instance.
        :param pulumi.Input[_builtins.str] metering_type: MeteringType Identifier
        :param pulumi.Input[_builtins.str] shape_name: Shape of the instance.
        :param pulumi.Input[_builtins.str] state: (Updatable) The target state for the Opa Instance. Could be set to `ACTIVE` or `INACTIVE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OpaInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Opa Instance resource in Oracle Cloud Infrastructure Opa service.

        Creates a new OpaInstance.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_opa_instance = oci.opa.OpaInstance("test_opa_instance",
            compartment_id=compartment_id,
            display_name=opa_instance_display_name,
            shape_name=test_shape["name"],
            consumption_model=opa_instance_consumption_model,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=opa_instance_description,
            freeform_tags={
                "bar-key": "value",
            },
            idcs_at=opa_instance_idcs_at,
            is_breakglass_enabled=opa_instance_is_breakglass_enabled,
            metering_type=opa_instance_metering_type)
        ```

        ## Import

        OpaInstances can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Opa/opaInstance:OpaInstance test_opa_instance "id"
        ```

        :param str resource_name: The name of the resource.
        :param OpaInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OpaInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 consumption_model: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 idcs_at: Optional[pulumi.Input[_builtins.str]] = None,
                 is_breakglass_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 metering_type: Optional[pulumi.Input[_builtins.str]] = None,
                 shape_name: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OpaInstanceArgs.__new__(OpaInstanceArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["consumption_model"] = consumption_model
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["idcs_at"] = idcs_at
            __props__.__dict__["is_breakglass_enabled"] = is_breakglass_enabled
            __props__.__dict__["metering_type"] = metering_type
            if shape_name is None and not opts.urn:
                raise TypeError("Missing required property 'shape_name'")
            __props__.__dict__["shape_name"] = shape_name
            __props__.__dict__["state"] = state
            __props__.__dict__["attachments"] = None
            __props__.__dict__["identity_app_display_name"] = None
            __props__.__dict__["identity_app_guid"] = None
            __props__.__dict__["identity_app_opc_service_instance_guid"] = None
            __props__.__dict__["identity_domain_url"] = None
            __props__.__dict__["instance_url"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(OpaInstance, __self__).__init__(
            'oci:Opa/opaInstance:OpaInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attachments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OpaInstanceAttachmentArgs', 'OpaInstanceAttachmentArgsDict']]]]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            consumption_model: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            idcs_at: Optional[pulumi.Input[_builtins.str]] = None,
            identity_app_display_name: Optional[pulumi.Input[_builtins.str]] = None,
            identity_app_guid: Optional[pulumi.Input[_builtins.str]] = None,
            identity_app_opc_service_instance_guid: Optional[pulumi.Input[_builtins.str]] = None,
            identity_domain_url: Optional[pulumi.Input[_builtins.str]] = None,
            instance_url: Optional[pulumi.Input[_builtins.str]] = None,
            is_breakglass_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            metering_type: Optional[pulumi.Input[_builtins.str]] = None,
            shape_name: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'OpaInstance':
        """
        Get an existing OpaInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OpaInstanceAttachmentArgs', 'OpaInstanceAttachmentArgsDict']]]] attachments: A list of associated attachments to other services
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) Compartment Identifier
        :param pulumi.Input[_builtins.str] consumption_model: Parameter specifying which entitlement to use for billing purposes
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) Description of the Oracle Process Automation instance.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) OpaInstance Identifier. User-friendly name for the instance. Avoid entering confidential information. You can change this value anytime.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] idcs_at: IDCS Authentication token. This is required for all realms with IDCS. This property is optional, as it is not required for non-IDCS realms.
        :param pulumi.Input[_builtins.str] identity_app_display_name: This property specifies the name of the Identity Application instance OPA has created inside the user-specified identity domain. This identity application instance may be used to host user roll mappings to grant access to this OPA instance for users within the identity domain.
        :param pulumi.Input[_builtins.str] identity_app_guid: This property specifies the GUID of the Identity Application instance OPA has created inside the user-specified identity domain. This identity application instance may be used to host user role mappings to grant access to this OPA instance for users within the identity domain.
        :param pulumi.Input[_builtins.str] identity_app_opc_service_instance_guid: This property specifies the OPC Service Instance GUID of the Identity Application instance OPA has created inside the user-specified identity domain. This identity application instance may be used to host user roll mappings to grant access to this OPA instance for users within the identity domain.
        :param pulumi.Input[_builtins.str] identity_domain_url: This property specifies the domain url of the Identity Application instance OPA has created inside the user-specified identity domain. This identity application instance may be used to host user roll mappings to grant access to this OPA instance for users within the identity domain.
        :param pulumi.Input[_builtins.str] instance_url: OPA Instance URL
        :param pulumi.Input[_builtins.bool] is_breakglass_enabled: indicates if breakGlass is enabled for the opa instance.
        :param pulumi.Input[_builtins.str] metering_type: MeteringType Identifier
        :param pulumi.Input[_builtins.str] shape_name: Shape of the instance.
        :param pulumi.Input[_builtins.str] state: (Updatable) The target state for the Opa Instance. Could be set to `ACTIVE` or `INACTIVE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The time when OpaInstance was created. An RFC3339 formatted datetime string
        :param pulumi.Input[_builtins.str] time_updated: The time the OpaInstance was updated. An RFC3339 formatted datetime string
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OpaInstanceState.__new__(_OpaInstanceState)

        __props__.__dict__["attachments"] = attachments
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["consumption_model"] = consumption_model
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["idcs_at"] = idcs_at
        __props__.__dict__["identity_app_display_name"] = identity_app_display_name
        __props__.__dict__["identity_app_guid"] = identity_app_guid
        __props__.__dict__["identity_app_opc_service_instance_guid"] = identity_app_opc_service_instance_guid
        __props__.__dict__["identity_domain_url"] = identity_domain_url
        __props__.__dict__["instance_url"] = instance_url
        __props__.__dict__["is_breakglass_enabled"] = is_breakglass_enabled
        __props__.__dict__["metering_type"] = metering_type
        __props__.__dict__["shape_name"] = shape_name
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return OpaInstance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def attachments(self) -> pulumi.Output[Sequence['outputs.OpaInstanceAttachment']]:
        """
        A list of associated attachments to other services
        """
        return pulumi.get(self, "attachments")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Compartment Identifier
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="consumptionModel")
    def consumption_model(self) -> pulumi.Output[_builtins.str]:
        """
        Parameter specifying which entitlement to use for billing purposes
        """
        return pulumi.get(self, "consumption_model")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Description of the Oracle Process Automation instance.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) OpaInstance Identifier. User-friendly name for the instance. Avoid entering confidential information. You can change this value anytime.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="idcsAt")
    def idcs_at(self) -> pulumi.Output[_builtins.str]:
        """
        IDCS Authentication token. This is required for all realms with IDCS. This property is optional, as it is not required for non-IDCS realms.
        """
        return pulumi.get(self, "idcs_at")

    @_builtins.property
    @pulumi.getter(name="identityAppDisplayName")
    def identity_app_display_name(self) -> pulumi.Output[_builtins.str]:
        """
        This property specifies the name of the Identity Application instance OPA has created inside the user-specified identity domain. This identity application instance may be used to host user roll mappings to grant access to this OPA instance for users within the identity domain.
        """
        return pulumi.get(self, "identity_app_display_name")

    @_builtins.property
    @pulumi.getter(name="identityAppGuid")
    def identity_app_guid(self) -> pulumi.Output[_builtins.str]:
        """
        This property specifies the GUID of the Identity Application instance OPA has created inside the user-specified identity domain. This identity application instance may be used to host user role mappings to grant access to this OPA instance for users within the identity domain.
        """
        return pulumi.get(self, "identity_app_guid")

    @_builtins.property
    @pulumi.getter(name="identityAppOpcServiceInstanceGuid")
    def identity_app_opc_service_instance_guid(self) -> pulumi.Output[_builtins.str]:
        """
        This property specifies the OPC Service Instance GUID of the Identity Application instance OPA has created inside the user-specified identity domain. This identity application instance may be used to host user roll mappings to grant access to this OPA instance for users within the identity domain.
        """
        return pulumi.get(self, "identity_app_opc_service_instance_guid")

    @_builtins.property
    @pulumi.getter(name="identityDomainUrl")
    def identity_domain_url(self) -> pulumi.Output[_builtins.str]:
        """
        This property specifies the domain url of the Identity Application instance OPA has created inside the user-specified identity domain. This identity application instance may be used to host user roll mappings to grant access to this OPA instance for users within the identity domain.
        """
        return pulumi.get(self, "identity_domain_url")

    @_builtins.property
    @pulumi.getter(name="instanceUrl")
    def instance_url(self) -> pulumi.Output[_builtins.str]:
        """
        OPA Instance URL
        """
        return pulumi.get(self, "instance_url")

    @_builtins.property
    @pulumi.getter(name="isBreakglassEnabled")
    def is_breakglass_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        indicates if breakGlass is enabled for the opa instance.
        """
        return pulumi.get(self, "is_breakglass_enabled")

    @_builtins.property
    @pulumi.getter(name="meteringType")
    def metering_type(self) -> pulumi.Output[_builtins.str]:
        """
        MeteringType Identifier
        """
        return pulumi.get(self, "metering_type")

    @_builtins.property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> pulumi.Output[_builtins.str]:
        """
        Shape of the instance.
        """
        return pulumi.get(self, "shape_name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The target state for the Opa Instance. Could be set to `ACTIVE` or `INACTIVE`. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The time when OpaInstance was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The time the OpaInstance was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

