# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AwrHubSourceArgs', 'AwrHubSource']

@pulumi.input_type
class AwrHubSourceArgs:
    def __init__(__self__, *,
                 awr_hub_id: pulumi.Input[_builtins.str],
                 compartment_id: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 associated_opsi_id: Optional[pulumi.Input[_builtins.str]] = None,
                 associated_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AwrHubSource resource.
        :param pulumi.Input[_builtins.str] awr_hub_id: AWR Hub OCID
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[_builtins.str] type: (Updatable) source type of the database
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] associated_opsi_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database id.
        :param pulumi.Input[_builtins.str] associated_resource_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database id.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] name: The name of the Awr Hub source database.
        """
        pulumi.set(__self__, "awr_hub_id", awr_hub_id)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "type", type)
        if associated_opsi_id is not None:
            pulumi.set(__self__, "associated_opsi_id", associated_opsi_id)
        if associated_resource_id is not None:
            pulumi.set(__self__, "associated_resource_id", associated_resource_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="awrHubId")
    def awr_hub_id(self) -> pulumi.Input[_builtins.str]:
        """
        AWR Hub OCID
        """
        return pulumi.get(self, "awr_hub_id")

    @awr_hub_id.setter
    def awr_hub_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "awr_hub_id", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) source type of the database


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="associatedOpsiId")
    def associated_opsi_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database id.
        """
        return pulumi.get(self, "associated_opsi_id")

    @associated_opsi_id.setter
    def associated_opsi_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "associated_opsi_id", value)

    @_builtins.property
    @pulumi.getter(name="associatedResourceId")
    def associated_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database id.
        """
        return pulumi.get(self, "associated_resource_id")

    @associated_resource_id.setter
    def associated_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "associated_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Awr Hub source database.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _AwrHubSourceState:
    def __init__(__self__, *,
                 associated_opsi_id: Optional[pulumi.Input[_builtins.str]] = None,
                 associated_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 awr_hub_id: Optional[pulumi.Input[_builtins.str]] = None,
                 awr_hub_opsi_source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 awr_source_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 hours_since_last_import: Optional[pulumi.Input[_builtins.float]] = None,
                 is_registered_with_awr_hub: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_snapshot_identifier: Optional[pulumi.Input[_builtins.float]] = None,
                 min_snapshot_identifier: Optional[pulumi.Input[_builtins.float]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_mail_box_url: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_first_snapshot_generated: Optional[pulumi.Input[_builtins.str]] = None,
                 time_last_snapshot_generated: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AwrHubSource resources.
        :param pulumi.Input[_builtins.str] associated_opsi_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database id.
        :param pulumi.Input[_builtins.str] associated_resource_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database id.
        :param pulumi.Input[_builtins.str] awr_hub_id: AWR Hub OCID
        :param pulumi.Input[_builtins.str] awr_hub_opsi_source_id: The shorted string of the Awr Hub source database identifier.
        :param pulumi.Input[_builtins.str] awr_source_database_id: DatabaseId of the Source database for which AWR Data will be uploaded to AWR Hub.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.float] hours_since_last_import: Number of hours since last AWR snapshots import happened from the Source database.
        :param pulumi.Input[_builtins.bool] is_registered_with_awr_hub: This is `true` if the source databse is registered with a Awr Hub, otherwise `false`
        :param pulumi.Input[_builtins.float] max_snapshot_identifier: The maximum snapshot identifier of the source database for which AWR data is uploaded to AWR Hub.
        :param pulumi.Input[_builtins.float] min_snapshot_identifier: The minimum snapshot identifier of the source database for which AWR data is uploaded to AWR Hub.
        :param pulumi.Input[_builtins.str] name: The name of the Awr Hub source database.
        :param pulumi.Input[_builtins.str] source_mail_box_url: Opsi Mailbox URL based on the Awr Hub and Awr Hub source.
        :param pulumi.Input[_builtins.str] state: the current state of the source database
        :param pulumi.Input[_builtins.str] status: Indicates the status of a source database in Operations Insights
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The time at which the resource was first created. An RFC3339 formatted datetime string
        :param pulumi.Input[_builtins.str] time_first_snapshot_generated: The time at which the earliest snapshot was generated in the source database for which data is uploaded to AWR Hub. An RFC3339 formatted datetime string
        :param pulumi.Input[_builtins.str] time_last_snapshot_generated: The time at which the latest snapshot was generated in the source database for which data is uploaded to AWR Hub. An RFC3339 formatted datetime string
        :param pulumi.Input[_builtins.str] time_updated: The time at which the resource was last updated. An RFC3339 formatted datetime string
        :param pulumi.Input[_builtins.str] type: (Updatable) source type of the database
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if associated_opsi_id is not None:
            pulumi.set(__self__, "associated_opsi_id", associated_opsi_id)
        if associated_resource_id is not None:
            pulumi.set(__self__, "associated_resource_id", associated_resource_id)
        if awr_hub_id is not None:
            pulumi.set(__self__, "awr_hub_id", awr_hub_id)
        if awr_hub_opsi_source_id is not None:
            pulumi.set(__self__, "awr_hub_opsi_source_id", awr_hub_opsi_source_id)
        if awr_source_database_id is not None:
            pulumi.set(__self__, "awr_source_database_id", awr_source_database_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if hours_since_last_import is not None:
            pulumi.set(__self__, "hours_since_last_import", hours_since_last_import)
        if is_registered_with_awr_hub is not None:
            pulumi.set(__self__, "is_registered_with_awr_hub", is_registered_with_awr_hub)
        if max_snapshot_identifier is not None:
            pulumi.set(__self__, "max_snapshot_identifier", max_snapshot_identifier)
        if min_snapshot_identifier is not None:
            pulumi.set(__self__, "min_snapshot_identifier", min_snapshot_identifier)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_mail_box_url is not None:
            pulumi.set(__self__, "source_mail_box_url", source_mail_box_url)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_first_snapshot_generated is not None:
            pulumi.set(__self__, "time_first_snapshot_generated", time_first_snapshot_generated)
        if time_last_snapshot_generated is not None:
            pulumi.set(__self__, "time_last_snapshot_generated", time_last_snapshot_generated)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="associatedOpsiId")
    def associated_opsi_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database id.
        """
        return pulumi.get(self, "associated_opsi_id")

    @associated_opsi_id.setter
    def associated_opsi_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "associated_opsi_id", value)

    @_builtins.property
    @pulumi.getter(name="associatedResourceId")
    def associated_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database id.
        """
        return pulumi.get(self, "associated_resource_id")

    @associated_resource_id.setter
    def associated_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "associated_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="awrHubId")
    def awr_hub_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWR Hub OCID
        """
        return pulumi.get(self, "awr_hub_id")

    @awr_hub_id.setter
    def awr_hub_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "awr_hub_id", value)

    @_builtins.property
    @pulumi.getter(name="awrHubOpsiSourceId")
    def awr_hub_opsi_source_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The shorted string of the Awr Hub source database identifier.
        """
        return pulumi.get(self, "awr_hub_opsi_source_id")

    @awr_hub_opsi_source_id.setter
    def awr_hub_opsi_source_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "awr_hub_opsi_source_id", value)

    @_builtins.property
    @pulumi.getter(name="awrSourceDatabaseId")
    def awr_source_database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        DatabaseId of the Source database for which AWR Data will be uploaded to AWR Hub.
        """
        return pulumi.get(self, "awr_source_database_id")

    @awr_source_database_id.setter
    def awr_source_database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "awr_source_database_id", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="hoursSinceLastImport")
    def hours_since_last_import(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Number of hours since last AWR snapshots import happened from the Source database.
        """
        return pulumi.get(self, "hours_since_last_import")

    @hours_since_last_import.setter
    def hours_since_last_import(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "hours_since_last_import", value)

    @_builtins.property
    @pulumi.getter(name="isRegisteredWithAwrHub")
    def is_registered_with_awr_hub(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This is `true` if the source databse is registered with a Awr Hub, otherwise `false`
        """
        return pulumi.get(self, "is_registered_with_awr_hub")

    @is_registered_with_awr_hub.setter
    def is_registered_with_awr_hub(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_registered_with_awr_hub", value)

    @_builtins.property
    @pulumi.getter(name="maxSnapshotIdentifier")
    def max_snapshot_identifier(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The maximum snapshot identifier of the source database for which AWR data is uploaded to AWR Hub.
        """
        return pulumi.get(self, "max_snapshot_identifier")

    @max_snapshot_identifier.setter
    def max_snapshot_identifier(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "max_snapshot_identifier", value)

    @_builtins.property
    @pulumi.getter(name="minSnapshotIdentifier")
    def min_snapshot_identifier(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The minimum snapshot identifier of the source database for which AWR data is uploaded to AWR Hub.
        """
        return pulumi.get(self, "min_snapshot_identifier")

    @min_snapshot_identifier.setter
    def min_snapshot_identifier(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "min_snapshot_identifier", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Awr Hub source database.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="sourceMailBoxUrl")
    def source_mail_box_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Opsi Mailbox URL based on the Awr Hub and Awr Hub source.
        """
        return pulumi.get(self, "source_mail_box_url")

    @source_mail_box_url.setter
    def source_mail_box_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_mail_box_url", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the current state of the source database
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the status of a source database in Operations Insights
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time at which the resource was first created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeFirstSnapshotGenerated")
    def time_first_snapshot_generated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time at which the earliest snapshot was generated in the source database for which data is uploaded to AWR Hub. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_first_snapshot_generated")

    @time_first_snapshot_generated.setter
    def time_first_snapshot_generated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_first_snapshot_generated", value)

    @_builtins.property
    @pulumi.getter(name="timeLastSnapshotGenerated")
    def time_last_snapshot_generated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time at which the latest snapshot was generated in the source database for which data is uploaded to AWR Hub. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_last_snapshot_generated")

    @time_last_snapshot_generated.setter
    def time_last_snapshot_generated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_last_snapshot_generated", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time at which the resource was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) source type of the database


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("oci:Opsi/awrHubSource:AwrHubSource")
class AwrHubSource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 associated_opsi_id: Optional[pulumi.Input[_builtins.str]] = None,
                 associated_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 awr_hub_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Awr Hub Source resource in Oracle Cloud Infrastructure Opsi service.

        Register Awr Hub source

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_awr_hub_source = oci.opsi.AwrHubSource("test_awr_hub_source",
            awr_hub_id=test_awr_hub["id"],
            compartment_id=compartment_id,
            name=awr_hub_source_name,
            type=awr_hub_source_type,
            associated_opsi_id=test_associated_opsi["id"],
            associated_resource_id=test_resource["id"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            })
        ```

        ## Import

        AwrHubSources can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Opsi/awrHubSource:AwrHubSource test_awr_hub_source "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] associated_opsi_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database id.
        :param pulumi.Input[_builtins.str] associated_resource_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database id.
        :param pulumi.Input[_builtins.str] awr_hub_id: AWR Hub OCID
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] name: The name of the Awr Hub source database.
        :param pulumi.Input[_builtins.str] type: (Updatable) source type of the database
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwrHubSourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Awr Hub Source resource in Oracle Cloud Infrastructure Opsi service.

        Register Awr Hub source

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_awr_hub_source = oci.opsi.AwrHubSource("test_awr_hub_source",
            awr_hub_id=test_awr_hub["id"],
            compartment_id=compartment_id,
            name=awr_hub_source_name,
            type=awr_hub_source_type,
            associated_opsi_id=test_associated_opsi["id"],
            associated_resource_id=test_resource["id"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            })
        ```

        ## Import

        AwrHubSources can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Opsi/awrHubSource:AwrHubSource test_awr_hub_source "id"
        ```

        :param str resource_name: The name of the resource.
        :param AwrHubSourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwrHubSourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 associated_opsi_id: Optional[pulumi.Input[_builtins.str]] = None,
                 associated_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 awr_hub_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwrHubSourceArgs.__new__(AwrHubSourceArgs)

            __props__.__dict__["associated_opsi_id"] = associated_opsi_id
            __props__.__dict__["associated_resource_id"] = associated_resource_id
            if awr_hub_id is None and not opts.urn:
                raise TypeError("Missing required property 'awr_hub_id'")
            __props__.__dict__["awr_hub_id"] = awr_hub_id
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["name"] = name
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["awr_hub_opsi_source_id"] = None
            __props__.__dict__["awr_source_database_id"] = None
            __props__.__dict__["hours_since_last_import"] = None
            __props__.__dict__["is_registered_with_awr_hub"] = None
            __props__.__dict__["max_snapshot_identifier"] = None
            __props__.__dict__["min_snapshot_identifier"] = None
            __props__.__dict__["source_mail_box_url"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_first_snapshot_generated"] = None
            __props__.__dict__["time_last_snapshot_generated"] = None
            __props__.__dict__["time_updated"] = None
        super(AwrHubSource, __self__).__init__(
            'oci:Opsi/awrHubSource:AwrHubSource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            associated_opsi_id: Optional[pulumi.Input[_builtins.str]] = None,
            associated_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            awr_hub_id: Optional[pulumi.Input[_builtins.str]] = None,
            awr_hub_opsi_source_id: Optional[pulumi.Input[_builtins.str]] = None,
            awr_source_database_id: Optional[pulumi.Input[_builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            hours_since_last_import: Optional[pulumi.Input[_builtins.float]] = None,
            is_registered_with_awr_hub: Optional[pulumi.Input[_builtins.bool]] = None,
            max_snapshot_identifier: Optional[pulumi.Input[_builtins.float]] = None,
            min_snapshot_identifier: Optional[pulumi.Input[_builtins.float]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            source_mail_box_url: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_first_snapshot_generated: Optional[pulumi.Input[_builtins.str]] = None,
            time_last_snapshot_generated: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'AwrHubSource':
        """
        Get an existing AwrHubSource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] associated_opsi_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database id.
        :param pulumi.Input[_builtins.str] associated_resource_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database id.
        :param pulumi.Input[_builtins.str] awr_hub_id: AWR Hub OCID
        :param pulumi.Input[_builtins.str] awr_hub_opsi_source_id: The shorted string of the Awr Hub source database identifier.
        :param pulumi.Input[_builtins.str] awr_source_database_id: DatabaseId of the Source database for which AWR Data will be uploaded to AWR Hub.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.float] hours_since_last_import: Number of hours since last AWR snapshots import happened from the Source database.
        :param pulumi.Input[_builtins.bool] is_registered_with_awr_hub: This is `true` if the source databse is registered with a Awr Hub, otherwise `false`
        :param pulumi.Input[_builtins.float] max_snapshot_identifier: The maximum snapshot identifier of the source database for which AWR data is uploaded to AWR Hub.
        :param pulumi.Input[_builtins.float] min_snapshot_identifier: The minimum snapshot identifier of the source database for which AWR data is uploaded to AWR Hub.
        :param pulumi.Input[_builtins.str] name: The name of the Awr Hub source database.
        :param pulumi.Input[_builtins.str] source_mail_box_url: Opsi Mailbox URL based on the Awr Hub and Awr Hub source.
        :param pulumi.Input[_builtins.str] state: the current state of the source database
        :param pulumi.Input[_builtins.str] status: Indicates the status of a source database in Operations Insights
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The time at which the resource was first created. An RFC3339 formatted datetime string
        :param pulumi.Input[_builtins.str] time_first_snapshot_generated: The time at which the earliest snapshot was generated in the source database for which data is uploaded to AWR Hub. An RFC3339 formatted datetime string
        :param pulumi.Input[_builtins.str] time_last_snapshot_generated: The time at which the latest snapshot was generated in the source database for which data is uploaded to AWR Hub. An RFC3339 formatted datetime string
        :param pulumi.Input[_builtins.str] time_updated: The time at which the resource was last updated. An RFC3339 formatted datetime string
        :param pulumi.Input[_builtins.str] type: (Updatable) source type of the database
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwrHubSourceState.__new__(_AwrHubSourceState)

        __props__.__dict__["associated_opsi_id"] = associated_opsi_id
        __props__.__dict__["associated_resource_id"] = associated_resource_id
        __props__.__dict__["awr_hub_id"] = awr_hub_id
        __props__.__dict__["awr_hub_opsi_source_id"] = awr_hub_opsi_source_id
        __props__.__dict__["awr_source_database_id"] = awr_source_database_id
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["hours_since_last_import"] = hours_since_last_import
        __props__.__dict__["is_registered_with_awr_hub"] = is_registered_with_awr_hub
        __props__.__dict__["max_snapshot_identifier"] = max_snapshot_identifier
        __props__.__dict__["min_snapshot_identifier"] = min_snapshot_identifier
        __props__.__dict__["name"] = name
        __props__.__dict__["source_mail_box_url"] = source_mail_box_url
        __props__.__dict__["state"] = state
        __props__.__dict__["status"] = status
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_first_snapshot_generated"] = time_first_snapshot_generated
        __props__.__dict__["time_last_snapshot_generated"] = time_last_snapshot_generated
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["type"] = type
        return AwrHubSource(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="associatedOpsiId")
    def associated_opsi_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database id.
        """
        return pulumi.get(self, "associated_opsi_id")

    @_builtins.property
    @pulumi.getter(name="associatedResourceId")
    def associated_resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database id.
        """
        return pulumi.get(self, "associated_resource_id")

    @_builtins.property
    @pulumi.getter(name="awrHubId")
    def awr_hub_id(self) -> pulumi.Output[_builtins.str]:
        """
        AWR Hub OCID
        """
        return pulumi.get(self, "awr_hub_id")

    @_builtins.property
    @pulumi.getter(name="awrHubOpsiSourceId")
    def awr_hub_opsi_source_id(self) -> pulumi.Output[_builtins.str]:
        """
        The shorted string of the Awr Hub source database identifier.
        """
        return pulumi.get(self, "awr_hub_opsi_source_id")

    @_builtins.property
    @pulumi.getter(name="awrSourceDatabaseId")
    def awr_source_database_id(self) -> pulumi.Output[_builtins.str]:
        """
        DatabaseId of the Source database for which AWR Data will be uploaded to AWR Hub.
        """
        return pulumi.get(self, "awr_source_database_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="hoursSinceLastImport")
    def hours_since_last_import(self) -> pulumi.Output[_builtins.float]:
        """
        Number of hours since last AWR snapshots import happened from the Source database.
        """
        return pulumi.get(self, "hours_since_last_import")

    @_builtins.property
    @pulumi.getter(name="isRegisteredWithAwrHub")
    def is_registered_with_awr_hub(self) -> pulumi.Output[_builtins.bool]:
        """
        This is `true` if the source databse is registered with a Awr Hub, otherwise `false`
        """
        return pulumi.get(self, "is_registered_with_awr_hub")

    @_builtins.property
    @pulumi.getter(name="maxSnapshotIdentifier")
    def max_snapshot_identifier(self) -> pulumi.Output[_builtins.float]:
        """
        The maximum snapshot identifier of the source database for which AWR data is uploaded to AWR Hub.
        """
        return pulumi.get(self, "max_snapshot_identifier")

    @_builtins.property
    @pulumi.getter(name="minSnapshotIdentifier")
    def min_snapshot_identifier(self) -> pulumi.Output[_builtins.float]:
        """
        The minimum snapshot identifier of the source database for which AWR data is uploaded to AWR Hub.
        """
        return pulumi.get(self, "min_snapshot_identifier")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Awr Hub source database.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="sourceMailBoxUrl")
    def source_mail_box_url(self) -> pulumi.Output[_builtins.str]:
        """
        Opsi Mailbox URL based on the Awr Hub and Awr Hub source.
        """
        return pulumi.get(self, "source_mail_box_url")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        the current state of the source database
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the status of a source database in Operations Insights
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The time at which the resource was first created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeFirstSnapshotGenerated")
    def time_first_snapshot_generated(self) -> pulumi.Output[_builtins.str]:
        """
        The time at which the earliest snapshot was generated in the source database for which data is uploaded to AWR Hub. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_first_snapshot_generated")

    @_builtins.property
    @pulumi.getter(name="timeLastSnapshotGenerated")
    def time_last_snapshot_generated(self) -> pulumi.Output[_builtins.str]:
        """
        The time at which the latest snapshot was generated in the source database for which data is uploaded to AWR Hub. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_last_snapshot_generated")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The time at which the resource was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) source type of the database


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

