# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAwrHubSourceResult',
    'AwaitableGetAwrHubSourceResult',
    'get_awr_hub_source',
    'get_awr_hub_source_output',
]

@pulumi.output_type
class GetAwrHubSourceResult:
    """
    A collection of values returned by getAwrHubSource.
    """
    def __init__(__self__, associated_opsi_id=None, associated_resource_id=None, awr_hub_id=None, awr_hub_opsi_source_id=None, awr_hub_source_id=None, awr_source_database_id=None, compartment_id=None, defined_tags=None, freeform_tags=None, hours_since_last_import=None, id=None, is_registered_with_awr_hub=None, max_snapshot_identifier=None, min_snapshot_identifier=None, name=None, source_mail_box_url=None, state=None, status=None, system_tags=None, time_created=None, time_first_snapshot_generated=None, time_last_snapshot_generated=None, time_updated=None, type=None):
        if associated_opsi_id and not isinstance(associated_opsi_id, str):
            raise TypeError("Expected argument 'associated_opsi_id' to be a str")
        pulumi.set(__self__, "associated_opsi_id", associated_opsi_id)
        if associated_resource_id and not isinstance(associated_resource_id, str):
            raise TypeError("Expected argument 'associated_resource_id' to be a str")
        pulumi.set(__self__, "associated_resource_id", associated_resource_id)
        if awr_hub_id and not isinstance(awr_hub_id, str):
            raise TypeError("Expected argument 'awr_hub_id' to be a str")
        pulumi.set(__self__, "awr_hub_id", awr_hub_id)
        if awr_hub_opsi_source_id and not isinstance(awr_hub_opsi_source_id, str):
            raise TypeError("Expected argument 'awr_hub_opsi_source_id' to be a str")
        pulumi.set(__self__, "awr_hub_opsi_source_id", awr_hub_opsi_source_id)
        if awr_hub_source_id and not isinstance(awr_hub_source_id, str):
            raise TypeError("Expected argument 'awr_hub_source_id' to be a str")
        pulumi.set(__self__, "awr_hub_source_id", awr_hub_source_id)
        if awr_source_database_id and not isinstance(awr_source_database_id, str):
            raise TypeError("Expected argument 'awr_source_database_id' to be a str")
        pulumi.set(__self__, "awr_source_database_id", awr_source_database_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if hours_since_last_import and not isinstance(hours_since_last_import, float):
            raise TypeError("Expected argument 'hours_since_last_import' to be a float")
        pulumi.set(__self__, "hours_since_last_import", hours_since_last_import)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_registered_with_awr_hub and not isinstance(is_registered_with_awr_hub, bool):
            raise TypeError("Expected argument 'is_registered_with_awr_hub' to be a bool")
        pulumi.set(__self__, "is_registered_with_awr_hub", is_registered_with_awr_hub)
        if max_snapshot_identifier and not isinstance(max_snapshot_identifier, float):
            raise TypeError("Expected argument 'max_snapshot_identifier' to be a float")
        pulumi.set(__self__, "max_snapshot_identifier", max_snapshot_identifier)
        if min_snapshot_identifier and not isinstance(min_snapshot_identifier, float):
            raise TypeError("Expected argument 'min_snapshot_identifier' to be a float")
        pulumi.set(__self__, "min_snapshot_identifier", min_snapshot_identifier)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if source_mail_box_url and not isinstance(source_mail_box_url, str):
            raise TypeError("Expected argument 'source_mail_box_url' to be a str")
        pulumi.set(__self__, "source_mail_box_url", source_mail_box_url)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_first_snapshot_generated and not isinstance(time_first_snapshot_generated, str):
            raise TypeError("Expected argument 'time_first_snapshot_generated' to be a str")
        pulumi.set(__self__, "time_first_snapshot_generated", time_first_snapshot_generated)
        if time_last_snapshot_generated and not isinstance(time_last_snapshot_generated, str):
            raise TypeError("Expected argument 'time_last_snapshot_generated' to be a str")
        pulumi.set(__self__, "time_last_snapshot_generated", time_last_snapshot_generated)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="associatedOpsiId")
    def associated_opsi_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database id.
        """
        return pulumi.get(self, "associated_opsi_id")

    @_builtins.property
    @pulumi.getter(name="associatedResourceId")
    def associated_resource_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database id.
        """
        return pulumi.get(self, "associated_resource_id")

    @_builtins.property
    @pulumi.getter(name="awrHubId")
    def awr_hub_id(self) -> _builtins.str:
        """
        AWR Hub OCID
        """
        return pulumi.get(self, "awr_hub_id")

    @_builtins.property
    @pulumi.getter(name="awrHubOpsiSourceId")
    def awr_hub_opsi_source_id(self) -> _builtins.str:
        """
        The shorted string of the Awr Hub source database identifier.
        """
        return pulumi.get(self, "awr_hub_opsi_source_id")

    @_builtins.property
    @pulumi.getter(name="awrHubSourceId")
    def awr_hub_source_id(self) -> _builtins.str:
        return pulumi.get(self, "awr_hub_source_id")

    @_builtins.property
    @pulumi.getter(name="awrSourceDatabaseId")
    def awr_source_database_id(self) -> _builtins.str:
        """
        DatabaseId of the Source database for which AWR Data will be uploaded to AWR Hub.
        """
        return pulumi.get(self, "awr_source_database_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="hoursSinceLastImport")
    def hours_since_last_import(self) -> _builtins.float:
        """
        Number of hours since last AWR snapshots import happened from the Source database.
        """
        return pulumi.get(self, "hours_since_last_import")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Awr Hub source database.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isRegisteredWithAwrHub")
    def is_registered_with_awr_hub(self) -> _builtins.bool:
        """
        This is `true` if the source databse is registered with a Awr Hub, otherwise `false`
        """
        return pulumi.get(self, "is_registered_with_awr_hub")

    @_builtins.property
    @pulumi.getter(name="maxSnapshotIdentifier")
    def max_snapshot_identifier(self) -> _builtins.float:
        """
        The maximum snapshot identifier of the source database for which AWR data is uploaded to AWR Hub.
        """
        return pulumi.get(self, "max_snapshot_identifier")

    @_builtins.property
    @pulumi.getter(name="minSnapshotIdentifier")
    def min_snapshot_identifier(self) -> _builtins.float:
        """
        The minimum snapshot identifier of the source database for which AWR data is uploaded to AWR Hub.
        """
        return pulumi.get(self, "min_snapshot_identifier")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Awr Hub source database.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="sourceMailBoxUrl")
    def source_mail_box_url(self) -> _builtins.str:
        """
        Opsi Mailbox URL based on the Awr Hub and Awr Hub source.
        """
        return pulumi.get(self, "source_mail_box_url")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        the current state of the source database
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Indicates the status of a source database in Operations Insights
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time at which the resource was first created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeFirstSnapshotGenerated")
    def time_first_snapshot_generated(self) -> _builtins.str:
        """
        The time at which the earliest snapshot was generated in the source database for which data is uploaded to AWR Hub. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_first_snapshot_generated")

    @_builtins.property
    @pulumi.getter(name="timeLastSnapshotGenerated")
    def time_last_snapshot_generated(self) -> _builtins.str:
        """
        The time at which the latest snapshot was generated in the source database for which data is uploaded to AWR Hub. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_last_snapshot_generated")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time at which the resource was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        source type of the database
        """
        return pulumi.get(self, "type")


class AwaitableGetAwrHubSourceResult(GetAwrHubSourceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAwrHubSourceResult(
            associated_opsi_id=self.associated_opsi_id,
            associated_resource_id=self.associated_resource_id,
            awr_hub_id=self.awr_hub_id,
            awr_hub_opsi_source_id=self.awr_hub_opsi_source_id,
            awr_hub_source_id=self.awr_hub_source_id,
            awr_source_database_id=self.awr_source_database_id,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            freeform_tags=self.freeform_tags,
            hours_since_last_import=self.hours_since_last_import,
            id=self.id,
            is_registered_with_awr_hub=self.is_registered_with_awr_hub,
            max_snapshot_identifier=self.max_snapshot_identifier,
            min_snapshot_identifier=self.min_snapshot_identifier,
            name=self.name,
            source_mail_box_url=self.source_mail_box_url,
            state=self.state,
            status=self.status,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_first_snapshot_generated=self.time_first_snapshot_generated,
            time_last_snapshot_generated=self.time_last_snapshot_generated,
            time_updated=self.time_updated,
            type=self.type)


def get_awr_hub_source(awr_hub_source_id: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAwrHubSourceResult:
    """
    This data source provides details about a specific Awr Hub Source resource in Oracle Cloud Infrastructure Opsi service.

    Gets the Awr Hub source object.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_awr_hub_source = oci.Opsi.get_awr_hub_source(awr_hub_source_id=test_awr_hub_source_oci_opsi_awr_hub_source["id"])
    ```


    :param _builtins.str awr_hub_source_id: Unique Awr Hub Source identifier
    """
    __args__ = dict()
    __args__['awrHubSourceId'] = awr_hub_source_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Opsi/getAwrHubSource:getAwrHubSource', __args__, opts=opts, typ=GetAwrHubSourceResult).value

    return AwaitableGetAwrHubSourceResult(
        associated_opsi_id=pulumi.get(__ret__, 'associated_opsi_id'),
        associated_resource_id=pulumi.get(__ret__, 'associated_resource_id'),
        awr_hub_id=pulumi.get(__ret__, 'awr_hub_id'),
        awr_hub_opsi_source_id=pulumi.get(__ret__, 'awr_hub_opsi_source_id'),
        awr_hub_source_id=pulumi.get(__ret__, 'awr_hub_source_id'),
        awr_source_database_id=pulumi.get(__ret__, 'awr_source_database_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        hours_since_last_import=pulumi.get(__ret__, 'hours_since_last_import'),
        id=pulumi.get(__ret__, 'id'),
        is_registered_with_awr_hub=pulumi.get(__ret__, 'is_registered_with_awr_hub'),
        max_snapshot_identifier=pulumi.get(__ret__, 'max_snapshot_identifier'),
        min_snapshot_identifier=pulumi.get(__ret__, 'min_snapshot_identifier'),
        name=pulumi.get(__ret__, 'name'),
        source_mail_box_url=pulumi.get(__ret__, 'source_mail_box_url'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_first_snapshot_generated=pulumi.get(__ret__, 'time_first_snapshot_generated'),
        time_last_snapshot_generated=pulumi.get(__ret__, 'time_last_snapshot_generated'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        type=pulumi.get(__ret__, 'type'))
def get_awr_hub_source_output(awr_hub_source_id: Optional[pulumi.Input[_builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAwrHubSourceResult]:
    """
    This data source provides details about a specific Awr Hub Source resource in Oracle Cloud Infrastructure Opsi service.

    Gets the Awr Hub source object.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_awr_hub_source = oci.Opsi.get_awr_hub_source(awr_hub_source_id=test_awr_hub_source_oci_opsi_awr_hub_source["id"])
    ```


    :param _builtins.str awr_hub_source_id: Unique Awr Hub Source identifier
    """
    __args__ = dict()
    __args__['awrHubSourceId'] = awr_hub_source_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Opsi/getAwrHubSource:getAwrHubSource', __args__, opts=opts, typ=GetAwrHubSourceResult)
    return __ret__.apply(lambda __response__: GetAwrHubSourceResult(
        associated_opsi_id=pulumi.get(__response__, 'associated_opsi_id'),
        associated_resource_id=pulumi.get(__response__, 'associated_resource_id'),
        awr_hub_id=pulumi.get(__response__, 'awr_hub_id'),
        awr_hub_opsi_source_id=pulumi.get(__response__, 'awr_hub_opsi_source_id'),
        awr_hub_source_id=pulumi.get(__response__, 'awr_hub_source_id'),
        awr_source_database_id=pulumi.get(__response__, 'awr_source_database_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        hours_since_last_import=pulumi.get(__response__, 'hours_since_last_import'),
        id=pulumi.get(__response__, 'id'),
        is_registered_with_awr_hub=pulumi.get(__response__, 'is_registered_with_awr_hub'),
        max_snapshot_identifier=pulumi.get(__response__, 'max_snapshot_identifier'),
        min_snapshot_identifier=pulumi.get(__response__, 'min_snapshot_identifier'),
        name=pulumi.get(__response__, 'name'),
        source_mail_box_url=pulumi.get(__response__, 'source_mail_box_url'),
        state=pulumi.get(__response__, 'state'),
        status=pulumi.get(__response__, 'status'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_first_snapshot_generated=pulumi.get(__response__, 'time_first_snapshot_generated'),
        time_last_snapshot_generated=pulumi.get(__response__, 'time_last_snapshot_generated'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        type=pulumi.get(__response__, 'type')))
