# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetExadataInsightsResult',
    'AwaitableGetExadataInsightsResult',
    'get_exadata_insights',
    'get_exadata_insights_output',
]

@pulumi.output_type
class GetExadataInsightsResult:
    """
    A collection of values returned by getExadataInsights.
    """
    def __init__(__self__, compartment_id=None, compartment_id_in_subtree=None, enterprise_manager_bridge_id=None, exadata_insight_summary_collections=None, exadata_types=None, filters=None, id=None, states=None, statuses=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if enterprise_manager_bridge_id and not isinstance(enterprise_manager_bridge_id, str):
            raise TypeError("Expected argument 'enterprise_manager_bridge_id' to be a str")
        pulumi.set(__self__, "enterprise_manager_bridge_id", enterprise_manager_bridge_id)
        if exadata_insight_summary_collections and not isinstance(exadata_insight_summary_collections, list):
            raise TypeError("Expected argument 'exadata_insight_summary_collections' to be a list")
        pulumi.set(__self__, "exadata_insight_summary_collections", exadata_insight_summary_collections)
        if exadata_types and not isinstance(exadata_types, list):
            raise TypeError("Expected argument 'exadata_types' to be a list")
        pulumi.set(__self__, "exadata_types", exadata_types)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if states and not isinstance(states, list):
            raise TypeError("Expected argument 'states' to be a list")
        pulumi.set(__self__, "states", states)
        if statuses and not isinstance(statuses, list):
            raise TypeError("Expected argument 'statuses' to be a list")
        pulumi.set(__self__, "statuses", statuses)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        """
        Compartment identifier of the Exadata insight resource
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @_builtins.property
    @pulumi.getter(name="enterpriseManagerBridgeId")
    def enterprise_manager_bridge_id(self) -> Optional[_builtins.str]:
        """
        OPSI Enterprise Manager Bridge OCID
        """
        return pulumi.get(self, "enterprise_manager_bridge_id")

    @_builtins.property
    @pulumi.getter(name="exadataInsightSummaryCollections")
    def exadata_insight_summary_collections(self) -> Sequence['outputs.GetExadataInsightsExadataInsightSummaryCollectionResult']:
        """
        The list of exadata_insight_summary_collection.
        """
        return pulumi.get(self, "exadata_insight_summary_collections")

    @_builtins.property
    @pulumi.getter(name="exadataTypes")
    def exadata_types(self) -> Optional[Sequence[_builtins.str]]:
        """
        Operations Insights internal representation of the the Exadata system type.
        """
        return pulumi.get(self, "exadata_types")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetExadataInsightsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Exadata insight identifier
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def states(self) -> Optional[Sequence[_builtins.str]]:
        """
        The current state of the Exadata insight.
        """
        return pulumi.get(self, "states")

    @_builtins.property
    @pulumi.getter
    def statuses(self) -> Optional[Sequence[_builtins.str]]:
        """
        Indicates the status of an Exadata insight in Operations Insights
        """
        return pulumi.get(self, "statuses")


class AwaitableGetExadataInsightsResult(GetExadataInsightsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExadataInsightsResult(
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            enterprise_manager_bridge_id=self.enterprise_manager_bridge_id,
            exadata_insight_summary_collections=self.exadata_insight_summary_collections,
            exadata_types=self.exadata_types,
            filters=self.filters,
            id=self.id,
            states=self.states,
            statuses=self.statuses)


def get_exadata_insights(compartment_id: Optional[_builtins.str] = None,
                         compartment_id_in_subtree: Optional[_builtins.bool] = None,
                         enterprise_manager_bridge_id: Optional[_builtins.str] = None,
                         exadata_types: Optional[Sequence[_builtins.str]] = None,
                         filters: Optional[Sequence[Union['GetExadataInsightsFilterArgs', 'GetExadataInsightsFilterArgsDict']]] = None,
                         id: Optional[_builtins.str] = None,
                         states: Optional[Sequence[_builtins.str]] = None,
                         statuses: Optional[Sequence[_builtins.str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExadataInsightsResult:
    """
    This data source provides the list of Exadata Insights in Oracle Cloud Infrastructure Opsi service.

    Gets a list of Exadata insights based on the query parameters specified. Either compartmentId or id query parameter must be specified.
    When both compartmentId and compartmentIdInSubtree are specified, a list of Exadata insights in that compartment and in all sub-compartments will be returned.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_exadata_insights = oci.Opsi.get_exadata_insights(compartment_id=compartment_id,
        compartment_id_in_subtree=exadata_insight_compartment_id_in_subtree,
        enterprise_manager_bridge_id=test_enterprise_manager_bridge["id"],
        exadata_types=exadata_insight_exadata_type,
        id=exadata_insight_id,
        states=exadata_insight_state,
        statuses=exadata_insight_status)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.bool compartment_id_in_subtree: A flag to search all resources within a given compartment and all sub-compartments.
    :param _builtins.str enterprise_manager_bridge_id: Unique Enterprise Manager bridge identifier
    :param Sequence[_builtins.str] exadata_types: Filter by one or more Exadata types. Possible value are DBMACHINE, EXACS, and EXACC.
    :param _builtins.str id: Optional list of Exadata insight resource [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param Sequence[_builtins.str] states: Lifecycle states
    :param Sequence[_builtins.str] statuses: Resource Status
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['enterpriseManagerBridgeId'] = enterprise_manager_bridge_id
    __args__['exadataTypes'] = exadata_types
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['states'] = states
    __args__['statuses'] = statuses
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Opsi/getExadataInsights:getExadataInsights', __args__, opts=opts, typ=GetExadataInsightsResult).value

    return AwaitableGetExadataInsightsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        enterprise_manager_bridge_id=pulumi.get(__ret__, 'enterprise_manager_bridge_id'),
        exadata_insight_summary_collections=pulumi.get(__ret__, 'exadata_insight_summary_collections'),
        exadata_types=pulumi.get(__ret__, 'exadata_types'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        states=pulumi.get(__ret__, 'states'),
        statuses=pulumi.get(__ret__, 'statuses'))
def get_exadata_insights_output(compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                compartment_id_in_subtree: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                enterprise_manager_bridge_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                exadata_types: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                filters: Optional[pulumi.Input[Optional[Sequence[Union['GetExadataInsightsFilterArgs', 'GetExadataInsightsFilterArgsDict']]]]] = None,
                                id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                states: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                statuses: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetExadataInsightsResult]:
    """
    This data source provides the list of Exadata Insights in Oracle Cloud Infrastructure Opsi service.

    Gets a list of Exadata insights based on the query parameters specified. Either compartmentId or id query parameter must be specified.
    When both compartmentId and compartmentIdInSubtree are specified, a list of Exadata insights in that compartment and in all sub-compartments will be returned.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_exadata_insights = oci.Opsi.get_exadata_insights(compartment_id=compartment_id,
        compartment_id_in_subtree=exadata_insight_compartment_id_in_subtree,
        enterprise_manager_bridge_id=test_enterprise_manager_bridge["id"],
        exadata_types=exadata_insight_exadata_type,
        id=exadata_insight_id,
        states=exadata_insight_state,
        statuses=exadata_insight_status)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.bool compartment_id_in_subtree: A flag to search all resources within a given compartment and all sub-compartments.
    :param _builtins.str enterprise_manager_bridge_id: Unique Enterprise Manager bridge identifier
    :param Sequence[_builtins.str] exadata_types: Filter by one or more Exadata types. Possible value are DBMACHINE, EXACS, and EXACC.
    :param _builtins.str id: Optional list of Exadata insight resource [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param Sequence[_builtins.str] states: Lifecycle states
    :param Sequence[_builtins.str] statuses: Resource Status
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['enterpriseManagerBridgeId'] = enterprise_manager_bridge_id
    __args__['exadataTypes'] = exadata_types
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['states'] = states
    __args__['statuses'] = statuses
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Opsi/getExadataInsights:getExadataInsights', __args__, opts=opts, typ=GetExadataInsightsResult)
    return __ret__.apply(lambda __response__: GetExadataInsightsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        enterprise_manager_bridge_id=pulumi.get(__response__, 'enterprise_manager_bridge_id'),
        exadata_insight_summary_collections=pulumi.get(__response__, 'exadata_insight_summary_collections'),
        exadata_types=pulumi.get(__response__, 'exadata_types'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        states=pulumi.get(__response__, 'states'),
        statuses=pulumi.get(__response__, 'statuses')))
